/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.CfRuleFormulaElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CfRuleElement
extends BasicElement {
    private AbsElement cf;

    CfRuleElement() {
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        String qqname = KmlUtil.getLocalName(qName);
        if ("Formula".equals(qqname)) {
            if (this.cf == null) {
                this.cf = new CfRuleFormulaElement();
            }
            return this.cf;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "cfRule".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            String typeStr = attributes.getValue("Type");
            String operatorStr = attributes.getValue("operator");
            Condition condition = new Condition();
            dataCache.getConditions().add(condition);
            condition.setType(typeStr);
            condition.setQualifier(operatorStr);
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
        List<Condition> conditions = dataCache.getConditions();
        Condition condition = conditions.get(conditions.size() - 1);
        List<String> conditionalParmas = dataCache.getConditionalPrams();
        if (conditionalParmas.size() >= 2) {
            condition.setMinMax(KmlUtil.toBookString(conditionalParmas.get(0)), KmlUtil.toBookString(conditionalParmas.get(1)), dataCache.getCurSheet());
        } else {
            condition.setMinMax(KmlUtil.toBookString(conditionalParmas.get(0)), "", dataCache.getCurSheet());
        }
        dataCache.clearConditionalParams();
    }
}

