/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUID;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;

public class ExprContext
extends Variant
implements IExprNode {
    private static final long serialVersionUID = -1718692131747450117L;
    private Dependents _deps;
    private int _calcUID;
    private ObjectStack _ownerStack;
    private ObjectStack _exprStack;
    private boolean _nestCalc;
    private boolean _excludeHidden = false;

    public ExprContext(Dependents deps) {
        this._deps = deps;
        this._exprStack = deps == null ? null : this._deps.getStack();
        this._calcUID = ExprUID.getUID();
        this._ownerStack = new ObjectStack();
    }

    public ExprContext(ExprContext src) {
        this._deps = src._deps;
        this._exprStack = src._exprStack;
        this._calcUID = src._calcUID;
        this._ownerStack = src._ownerStack;
    }

    public String toString() {
        return "ctx " + this._calcUID;
    }

    public void clear() {
        this._ownerStack.clear();
        if (this._exprStack != null) {
            this._exprStack.clear();
        }
    }

    public Dependents getDeps() {
        return this._deps;
    }

    public int getCalcUID() {
        return this._calcUID;
    }

    public void setCalcUID(int uid) {
        this._calcUID = uid;
    }

    public boolean isNestCalc() {
        return this._nestCalc;
    }

    public void setNestCalc(boolean nestCalc) {
        this._nestCalc = nestCalc;
    }

    public int getOwnerStackSize() {
        return this._ownerStack.size();
    }

    public ObjectArray getObjectArray(int capacity) {
        return this._deps.getObjectArray(capacity);
    }

    public void recycleArray(ObjectArray array) {
        this._deps.recycleArray(array);
    }

    public IntArray getIntArray() {
        return this._deps.getIntArray();
    }

    public void recycleArray(IntArray array) {
        this._deps.recycleArray(array);
    }

    public Variant getVariant() {
        return this._deps.getVariant();
    }

    public void recycleVariant(Variant var) {
        this._deps.recycleVariant(var);
    }

    public ObjectStack getStack() {
        return this._deps.getStack();
    }

    public void recycleStack(ObjectStack stk) {
        this._deps.recycleStack(stk);
    }

    public ObjectStack getCurrentExprStack() {
        return this._exprStack;
    }

    public ObjectStack setCurrentExprStack(ObjectStack stk) {
        ObjectStack old = this._exprStack;
        this._exprStack = stk;
        return old;
    }

    public Variant[] getOneVariantArray(Variant var) {
        return this._deps.getOneVariantArray(var);
    }

    public void recycleArray(Variant[] array) {
        this._deps.recycleArray(array);
    }

    public ICalculable getExprOwner() {
        return (ICalculable)this._ownerStack.getTop();
    }

    public void pushExprOwner(ICalculable owner) {
        this._ownerStack.push(owner);
    }

    public void popExprOwner() {
        this._ownerStack.pop();
    }

    public void popExprOwnerN(int n) {
        this._ownerStack.popN(n);
    }

    @Override
    public int getExprType() {
        return 16384;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        this._ownerStack.push(exprOwner);
        ctx.getCurrentExprStack().push(this);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return "";
    }

    public boolean isExcludeHidden() {
        return this._excludeHidden;
    }

    public void setExcludeHidden(boolean excludeHidden) {
        this._excludeHidden = excludeHidden;
    }
}

