/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.LinkPasteInfo;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertConditionalFormatFurther;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertValidation;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurther;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurtherList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedIntArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SheetAction_Paste
extends SheetAction {
    private URState _sheetState;
    private Sheet[] _srcSheets;
    private Sheet _srcSheet;
    private SortedCellBlockArray _sel;
    private CellBlock _blockInfo;
    private PasteMode _mode;
    private String[] _userKeys;
    private LinkPasteInfo _linkInfo;
    boolean _hasIngnoredCell = false;

    public SheetAction_Paste(Range rg, Book srcBook, SortedCellBlockArray sel, CellBlock blockInfo, PasteMode mode, String[] userKeys, long changedState) {
        super(rg, changedState);
        if (srcBook.isClipBook()) {
            int srcSheetCount = srcBook.getSheetCount();
            this._srcSheets = new Sheet[srcSheetCount];
            for (int i = 0; i < srcSheetCount; ++i) {
                this._srcSheets[i] = srcBook.getSheet(i);
            }
        } else {
            int srcSheetCount = rg._sheets.size();
            this._srcSheets = new Sheet[srcSheetCount];
            for (int i = 0; i < srcSheetCount; ++i) {
                this._srcSheets[i] = srcBook.getSheet(0);
            }
        }
        this._sel = sel;
        this._blockInfo = blockInfo;
        this._mode = mode;
        this._userKeys = userKeys;
        if (mode.touchFlag(PasteMode.Link)) {
            this._linkInfo = new LinkPasteInfo(KDClipboard.getSourceSheets(), KDClipboard.getSourceSelection());
        }
    }

    public SheetAction_Paste(Range rg, Book srcBook, SortedCellBlockArray sel, CellBlock blockInfo, PasteMode mode, String[] userKeys) {
        this(rg, srcBook, sel, blockInfo, mode, userKeys, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style);
    }

    private Sheet getSourceSheet(Sheet dstSheet) {
        SortedSheetArray sheets = this._rg._sheets;
        int size = sheets.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            if (sheets.getSheet(i) != dstSheet) continue;
            index = i;
            break;
        }
        return this._srcSheets[index];
    }

    @Override
    protected void preActionBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
        this._srcSheet = this.getSourceSheet(sheet);
        this._sheetState = this.pasteSheetProps(enableUndo, this._srcSheet, sheet, cb, this._sel, this._blockInfo, this._mode);
    }

    @Override
    protected void preResumeBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
        if (this._sheetState != null) {
            this.resumePasteSheetProps(this._sheetState, sheet, cb);
            this._sheetState = null;
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        int i;
        SortedCellBlockArray coverdMergeBlocks;
        boolean pasteFormat = this._mode.touchFlag(PasteMode.Style);
        MergeBlocks dstMerger = sheet.getMerger(pasteFormat);
        boolean justPasteValue = this._mode == PasteMode.VALUES;
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        if (pasteFormat) {
            this.URStore(state, "BDR", sheet.getBorders().clone());
        }
        SortedCellBlockArray sortedCellBlockArray = coverdMergeBlocks = dstMerger == null ? null : dstMerger.getContainedBlocks(cb);
        if (coverdMergeBlocks != null && !justPasteValue) {
            if (state != null) {
                state.setData("MERGE_BLOCKS", (Object)coverdMergeBlocks);
            }
            dstMerger.remove(coverdMergeBlocks);
        }
        SortedCellBlockArray srcMergeBlocks = this.getPasteMergeInfo(this._srcSheet, this._sel, this._blockInfo, this._mode, this._linkInfo);
        int compactRows = this._blockInfo.getRow2();
        int compactCols = this._blockInfo.getCol2();
        ValidationList srcValidations = this._srcSheet.getValidations();
        if (this._mode.touchFlag(PasteMode.Validation) && srcValidations.size() > 0) {
            ValidationList list = sheet.getValidations();
            ArrayList<Validation> sheetValidation = new ArrayList<Validation>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                sheetValidation.add(list.getValidation(i2).getCloneValidation());
            }
            this.URStore(state, SheetAction_InsertValidation.getURStateKey(sheet), sheetValidation);
            for (int top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    sheet.getValidations().merge(srcValidations, top, left);
                }
            }
        }
        CellBlock srcFirstBlock = this._sel.getBlock(0);
        int srcBlockCount = this._sel.size();
        for (int srcIndex = 0; srcIndex < srcBlockCount; ++srcIndex) {
            CellBlock srcBlock = this._sel.getBlock(srcIndex);
            int offsetX = srcBlock.getCol() - srcFirstBlock.getCol();
            int offsetY = srcBlock.getRow() - srcFirstBlock.getRow();
            int height = srcBlock.getHeight();
            int width = srcBlock.getWidth();
            for (int top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    int r = top + offsetY;
                    int c = left + offsetX;
                    CellBlock dstBlock = CellBlock.getNewCellBlock(r, c, r + height - 1, c + width - 1);
                    this.pasteBlock(state, this._srcSheet, sheet, this._sel, this._mode, this._userKeys, srcIndex, dstBlock, this._linkInfo);
                }
            }
        }
        ConditionalFormatList srcFormats = this._srcSheet.getConditionalFormats();
        if (pasteFormat && srcFormats.size() > 0) {
            ConditionalFormatList formats = sheet.getConditionalFormats();
            ArrayList<ConditionalFormat> list = new ArrayList<ConditionalFormat>();
            for (int i3 = 0; i3 < formats.size(); ++i3) {
                list.add(formats.getConditionalFormat(i3).cloneSelf());
            }
            this.URStore(state, SheetAction_InsertConditionalFormat.getURStateKey(sheet), list);
            for (int top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    sheet.getConditionalFormats().merge(srcFormats, top, left);
                }
            }
        }
        ConditionFormatFurtherList furtherList = this._srcSheet.getConditionFormatFurthers();
        if (pasteFormat && furtherList.size() > 0) {
            ConditionFormatFurtherList list = sheet.getConditionFormatFurthers();
            ArrayList<ConditionFormatFurther> furthers = new ArrayList<ConditionFormatFurther>();
            for (i = 0; i < list.size(); ++i) {
                furthers.add(list.getConditionFormatFurther(i).cloneSelf());
            }
            this.URStore(state, SheetAction_InsertConditionalFormatFurther.getURStateKey(sheet), furthers);
            for (int top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    sheet.getConditionFormatFurthers().merge(sheet, furtherList, top, left);
                }
            }
        }
        if (pasteFormat && srcMergeBlocks.size() > 0) {
            for (int top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    int size = srcMergeBlocks.size();
                    for (i = 0; i < size; ++i) {
                        CellBlock block = CellBlock.getNewCellBlock(srcMergeBlocks.getBlock(i));
                        block.offset(top, left);
                        dstMerger.insert(block);
                        this.clearCoveredCells(sheet, block);
                    }
                }
            }
        }
        this.checkedAutoFilter(sheet, state);
        sheet.getSheetOption().getSelection().changeSelection(this._rg.getBlock(0), 2);
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = CellBlock.getNewCellBlock(autoFilterArea);
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        List sheetValidation;
        List sheetConditionalFormats;
        List furthers;
        Borders bdrs;
        SortedCellBlockArray coverdMergeBlocks;
        MergeBlocks merger;
        int i;
        boolean justLink = this._mode.touchFlag(PasteMode.Link);
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            for (i = clls.size() - 1; i >= 0; --i) {
                Cell props = (Cell)clls.get(i);
                Cell dstCell = sheet.getCell(props.getRow(), props.getCol(), true);
                if (justLink) {
                    dstCell.setVar(values.get(i));
                    continue;
                }
                dstCell.resumeCopyFrom(props, this._mode, this._userKeys);
            }
        }
        if ((merger = sheet.getMerger(false)) != null) {
            merger.remove(merger.getContainedBlocks(cb));
        }
        if ((coverdMergeBlocks = (SortedCellBlockArray)((Object)state.get("MERGE_BLOCKS"))) != null) {
            sheet.getMerger(true).addAll(coverdMergeBlocks);
        }
        if ((bdrs = (Borders)state.get("BDR")) != null) {
            sheet.getBorders().clear();
            sheet.getBorders().set(bdrs);
        }
        if (null != (furthers = (List)state.get(SheetAction_InsertConditionalFormatFurther.getURStateKey(sheet)))) {
            ConditionFormatFurtherList list = sheet.getConditionFormatFurthers();
            list.clearAll();
            for (int i2 = 0; i2 < furthers.size(); ++i2) {
                list.addConditionFormatFurther((ConditionFormatFurther)furthers.get(i2));
            }
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_ConditionFormatFurther_Reset);
        }
        if (null != (sheetConditionalFormats = (List)state.get(SheetAction_InsertConditionalFormat.getURStateKey(sheet)))) {
            ConditionalFormatList formats = sheet.getConditionalFormats();
            formats.clearAll();
            for (i = 0; i < sheetConditionalFormats.size(); ++i) {
                formats.addConditionalFormat((ConditionalFormat)sheetConditionalFormats.get(i));
            }
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Conditionalformat_Reset);
        }
        if (null != (sheetValidation = (List)state.get(SheetAction_InsertValidation.getURStateKey(sheet)))) {
            ValidationList list = sheet.getValidations();
            list.clearAll();
            for (int i3 = 0; i3 < sheetValidation.size(); ++i3) {
                list.addValidation((Validation)sheetValidation.get(i3));
            }
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Validation_Reset);
        }
        this.resumeAutoFilter(sheet, state);
    }

    private SortedCellBlockArray getPasteMergeInfo(Sheet srcSheet, SortedCellBlockArray srcSelect, CellBlock blockInfo, PasteMode mode, LinkPasteInfo linkInfo) {
        boolean justLink = mode.touchFlag(PasteMode.Link);
        MergeBlocks srcMerger = justLink ? linkInfo.getSourceSheet(srcSheet.getSheetName()).getMerger(false) : srcSheet.getMerger(false);
        SortedCellBlockArray srcMergeBlocks = new SortedCellBlockArray();
        if (mode.touchFlag(PasteMode.Style) && !justLink) {
            int blockRows = blockInfo.getRow();
            int blockCols = blockInfo.getCol();
            CellBlock srcFirstBlock = srcSelect.getBlock(0);
            int row = srcFirstBlock.getRow();
            for (int rBlock = 0; rBlock < blockRows; ++rBlock) {
                CellBlock block = null;
                int srcLeftIndex = rBlock * blockCols;
                int col = srcFirstBlock.getCol();
                for (int cBlock = 0; cBlock < blockCols; ++cBlock) {
                    SortedCellBlockArray mergeBlocks;
                    block = srcSelect.getBlock(srcLeftIndex + cBlock);
                    SortedCellBlockArray sortedCellBlockArray = mergeBlocks = srcMerger == null ? null : srcMerger.getContainedBlocks(block);
                    if (mergeBlocks != null) {
                        int offetY = -srcFirstBlock.getRow() + (row - block.getRow());
                        int offetX = -srcFirstBlock.getCol() + (col - block.getCol());
                        int size = mergeBlocks.size();
                        for (int i = 0; i < size; ++i) {
                            CellBlock cb = CellBlock.getNewCellBlock(mergeBlocks.getBlock(i));
                            cb.offset(offetY, offetX);
                            srcMergeBlocks.insert(cb);
                        }
                    }
                    col += block.getWidth();
                }
                if (block == null) continue;
                row += block.getHeight();
            }
        }
        return srcMergeBlocks;
    }

    private void pasteBlock(URState state, Sheet srcSheet, Sheet sheet, SortedCellBlockArray srcSelect, PasteMode mode, String[] userKeys, int srcBlockIndex, CellBlock dstBlock, LinkPasteInfo linkInfo) {
        if (srcSelect.size() == 1 && srcSelect.getBlock(0).isWholeSheet()) {
            int destMaxRow = sheet.getMaxRowIndex();
            int destMaxCol = sheet.getMaxColIndex();
            int srcMaxRow = srcSheet.getMaxRowIndex();
            int srcMaxCol = srcSheet.getMaxColIndex();
            int maxRow = destMaxRow > srcMaxRow ? destMaxRow : srcMaxRow;
            int maxCol = destMaxCol > srcMaxCol ? destMaxCol : srcMaxCol;
            srcSelect.getBlock(0).setRowCol(0, 0, maxRow, maxCol);
            dstBlock.setRowCol(0, 0, maxRow, maxCol);
        }
        if (mode.touchFlag(PasteMode.Link)) {
            this.pasteBlockLink(state, srcSheet, sheet, srcBlockIndex, dstBlock, linkInfo);
        } else {
            int pos;
            StringBuilder sb = new StringBuilder();
            CellBlock srcBlock = srcSelect.getBlock(srcBlockIndex);
            int dstTop = dstBlock.getRow();
            int dstLeft = dstBlock.getCol();
            int dstRight = dstBlock.getCol2();
            int srcTop = srcBlock.getRow();
            int srcLeft = srcBlock.getCol();
            int srcRight = srcBlock.getCol2();
            boolean skipBlank = mode.touchFlag(PasteMode.SkipBlanks);
            boolean pasteFormat = mode.touchFlag(PasteMode.Style);
            SortedIntArray sia = new SortedIntArray();
            SortedRowArray srcRows = srcSheet.getRows();
            int pos2 = srcRows.getProperPos(srcBlock.getRow2(), true);
            for (pos = srcRows.getProperPos(srcTop, false); pos <= pos2; ++pos) {
                sia.insert(srcRows.getAt(pos).getRow() - srcTop);
            }
            SortedRowArray dstRows = sheet.getRows();
            pos2 = dstRows.getProperPos(dstBlock.getRow2(), true);
            for (pos = dstRows.getProperPos(dstTop, false); pos <= pos2; ++pos) {
                sia.insert(dstRows.getAt(pos).getRow() - dstTop);
            }
            if (pasteFormat) {
                int r;
                int end;
                SortedAttributeSpanArray.AttributeSpan span;
                int i;
                SortedAttributeSpanArray sa = srcSheet.getRowSpans().getSpecifiedAttributeSpansClone(srcBlock.getRow(), srcBlock.getRow2());
                int size = sa.size();
                for (i = 0; i < size; ++i) {
                    span = sa.getAttributeSpan(i);
                    end = span.getEnd();
                    for (r = span.getStart(); r <= end; ++r) {
                        if (srcSheet.getRow(r - srcTop, false) == null) continue;
                        sia.insert(r - srcTop);
                    }
                }
                sa = sheet.getRowSpans().getSpecifiedAttributeSpansClone(dstBlock.getRow(), dstBlock.getRow2());
                size = sa.size();
                for (i = 0; i < size; ++i) {
                    span = sa.getAttributeSpan(i);
                    end = span.getEnd();
                    for (r = span.getStart(); r <= end; ++r) {
                        if (srcSheet.getRow(r - srcTop, false) == null) continue;
                        sia.insert(r - dstTop);
                    }
                }
            }
            boolean bState = state != null;
            ObjectArray clls = bState ? (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null) : null;
            int size = sia.size();
            for (int ai = 0; ai < size; ++ai) {
                int r = sia.getAt(ai);
                int dstRow = dstTop + r;
                int srcRow = srcTop + r;
                Row srcRowObj = srcSheet.getRow(srcRow, false);
                int pos3 = 0;
                int pos22 = -1;
                if (srcRowObj != null) {
                    pos3 = srcRowObj.getProperPos(srcLeft, false);
                    pos22 = srcRowObj.getProperPos(srcRight, true);
                }
                if (pos3 <= pos22) {
                    Row dstRowObj = this.getStateRow(state, sheet, dstRow);
                    int srcPos = srcRowObj.getAt(pos3).getCol() - srcLeft;
                    if (srcPos > 0 && !skipBlank) {
                        this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft, dstRow, dstLeft, dstLeft + srcPos - 1);
                    }
                    int dstPos = 0;
                    while (pos3 <= pos22) {
                        srcPos = srcRowObj.getAt(pos3).getCol() - srcLeft;
                        if (dstPos < srcPos) {
                            if (!skipBlank) {
                                this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft + dstPos, dstRow, dstLeft + dstPos, dstLeft + srcPos - 1);
                            }
                            dstPos = srcPos;
                        }
                        Cell srcCell = srcRowObj.getAt(pos3);
                        Cell dstCell = this.getStateCell(state, sheet, dstRowObj, dstLeft + dstPos++);
                        Protection pro = sheet.getSheetOption().getProtection(false);
                        boolean bProtected = pro != null && pro.isProtected();
                        StyleAttributes sa = Styles.getEmptySA();
                        new Range(sheet.getBook(), sheet, CellBlock.getNewCellBlock(dstCell.getRow(), dstCell.getCol())).getStyle(sa);
                        if (sa.get(ShareStyleAttributes.PROTECTION_LOCKED) == ShareStyleAttributes.UNKOWN_VALUE || sa.isLocked() && bProtected) {
                            this._hasIngnoredCell = true;
                        } else {
                            Cell copied = null;
                            if (mode.touchFlag(PasteMode.Values)) {
                                MessagedValidate mv = sheet.getValidations().getValidate(dstCell.getRow(), dstCell.getCol());
                                if (mv == null || mv.isValidated(sheet, srcCell.getValue().toString())) {
                                    copied = null != srcCell.getUserObjects(false) && null == userKeys ? dstCell.copyFrom(srcCell, mode, true, new String[]{"display"}, bProtected) : dstCell.copyFrom(srcCell, mode, true, userKeys, bProtected);
                                } else {
                                    sb.append(dstCell.getName(false, true) + "\uff0c");
                                }
                            } else {
                                copied = dstCell.copyFrom(srcCell, mode, true, userKeys, bProtected);
                            }
                            if (bState && copied != null) {
                                CellActionAfterListener cellActionAfterListener = sheet.getBook().getCellActionAfterListener();
                                if (cellActionAfterListener != null) {
                                    cellActionAfterListener.doAfter(srcCell, dstCell, "Paste");
                                }
                                clls.append((Object)copied);
                            }
                        }
                        ++pos3;
                    }
                    srcPos = srcRowObj.getAt(pos22).getCol() - srcLeft;
                    if (dstLeft + srcPos >= dstRight || skipBlank) continue;
                    this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft + srcPos + 1, dstRow, dstLeft + srcPos + 1, dstRight);
                    continue;
                }
                if (skipBlank) continue;
                this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft, dstRow, dstLeft, dstRight);
            }
            if (sb.length() != 0) {
                sb.append("\u7c98\u8d34\u7684\u503c\u4e0d\u7b26\u5408\u4e0a\u8ff0\u5355\u5143\u683c\u7684\u6709\u6548\u6027\u9a8c\u8bc1\uff0c\u90e8\u5206\u7c98\u8d34\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
                MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText("PasteValueAreInvalid", sb.toString()), (String)MultiLanguageKeys.getLocalText("warning", "\u8b66\u544a"), (int)-1, (int)2);
            }
        }
    }

    public boolean isIgnoredProtectedCell() {
        return this._hasIngnoredCell;
    }

    private void pasteEmptyCells(URState state, Sheet srcSheet, Sheet sheet, PasteMode mode, String[] userKeys, int srcRow, int srcCol, int dstRow, int dstCol, int dstCol2) {
        int pos2;
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean bProtected = pro != null && pro.isProtected();
        StyleAttributes sa = Styles.getEmptySA();
        new Range(sheet.getBook(), sheet, CellBlock.getNewCellBlock(dstRow, dstCol, dstRow, dstCol2)).getStyle(sa);
        if (sa.get(ShareStyleAttributes.PROTECTION_LOCKED) == ShareStyleAttributes.UNKOWN_VALUE || sa.isLocked() && bProtected) {
            return;
        }
        boolean bState = state != null;
        ObjectArray clls = bState ? (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null) : null;
        Row dstRowObj = this.getStateRow(state, sheet, dstRow);
        int pos = dstRowObj.getProperPos(dstCol, false);
        if (pos <= (pos2 = dstRowObj.getProperPos(dstCol2, true))) {
            boolean bFormulas = mode.touchFlag(PasteMode.Formulas);
            boolean bValues = mode.touchFlag(PasteMode.Values);
            boolean bStyles = mode.touchFlag(PasteMode.Formats);
            boolean bComments = mode.touchFlag(PasteMode.Comments);
            while (pos <= pos2) {
                Cell dstCell = dstRowObj.getAt(pos);
                Cell props = dstCell.clear(bFormulas, bValues, bStyles, bComments, userKeys);
                if (props != null) {
                    dstCell.copyStyle(srcSheet.getCellStyle(srcRow, srcCol + (dstCell.getCol() - dstCol)), null, mode, props, bProtected);
                    if (bState) {
                        clls.append((Object)props);
                    }
                }
                ++pos;
            }
            if (dstCol == dstCol2) {
                return;
            }
        }
        for (int col = dstCol; col <= dstCol2; ++col) {
            Style dstStyle;
            Style srcStyle;
            if (dstRowObj.getCell(col, false) == null || (srcStyle = srcSheet.getCellStyle(srcRow, srcCol + (col - dstCol))) == (dstStyle = sheet.getCellStyle(dstRow, col))) continue;
            Cell dstCell = this.getStateCell(state, sheet, dstRowObj, col);
            dstCell.copyStyle(srcStyle, null, mode, null, bProtected);
        }
    }

    private void pasteBlockLink(URState state, Sheet srcSheet, Sheet sheet, int srcBlockIndex, CellBlock dstBlock, LinkPasteInfo linkInfo) {
        String formulaPrefix = "";
        Sheet sheetFrom = linkInfo.getSourceSheet(srcSheet.getSheetName());
        formulaPrefix = sheetFrom == null || sheetFrom.getBook() == sheet.getBook() ? "=" : "=[" + sheetFrom.getBook().getName() + "]";
        if (sheetFrom != null && sheetFrom != sheet) {
            formulaPrefix = formulaPrefix + sheetFrom.getSyntaxName() + "!";
        }
        CellBlock srcBlock = linkInfo.getSourceSelection().getBlock(srcBlockIndex);
        int height = srcBlock.getHeight();
        int width = srcBlock.getWidth();
        int dstTop = dstBlock.getRow();
        int dstLeft = dstBlock.getCol();
        int srcTop = srcBlock.getRow();
        int srcLeft = srcBlock.getCol();
        for (int r = 0; r < height; ++r) {
            Row dstRowObj = this.getStateRow(state, sheet, dstTop + r);
            int srcRow = srcTop + r;
            for (int c = 0; c < width; ++c) {
                Cell dstCell = this.getStateCell(state, sheet, dstRowObj, dstLeft + c);
                if (dstCell.getVar() != Variant.nullVariant) {
                    this.setCellState(state, dstCell, dstCell.getVar(), null);
                }
                String formula = formulaPrefix + SheetBaseMath.getBlockA1Name(srcRow, srcLeft + c, false, false);
                dstCell.setFormula(formula);
            }
        }
    }

    private void clearCoveredCells(Sheet sheet, CellBlock cb) {
        int left = cb.getCol();
        int right = cb.getCol2();
        Row row = sheet.getRow(cb.getRow(), false);
        row.remove(left + 1, right, false, false);
        if (cb.getHeight() > 1) {
            Sheet.RowsIterator ri = sheet.getRowsIterator(cb.getRow() + 1, cb.getRow2(), false);
            while (ri.hasNext()) {
                row = ri.next();
                row.remove(left, right, false, false);
            }
        }
    }

    public void resumePasteSheetProps(URState state, Sheet sheet, CellBlock cb) {
        HashMap spans;
        if (state.isEmpty()) {
            return;
        }
        state.resumeDeleted();
        ShareStyleAttributes sheetSSA = (ShareStyleAttributes)state.get("SHEET_SSA");
        if (sheetSSA != null) {
            sheet.setSSA(sheetSSA);
        }
        if ((spans = (HashMap)state.get("ROW_SSA")) != null) {
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            for (Map.Entry e : spans.entrySet()) {
                rowSpans.clearStyle((Span)e.getKey(), false);
                rowSpans.setSpans((SortedSpanArray)((Object)e.getValue()));
            }
        }
        if ((spans = (HashMap)state.get("COL_SSA")) != null) {
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            for (Map.Entry e : spans.entrySet()) {
                colSpans.clearStyle((Span)e.getKey(), false);
                colSpans.setSpans((SortedSpanArray)((Object)e.getValue()));
            }
        }
        state.resumeCreated();
    }

    @Override
    public boolean isDone() {
        boolean bDone;
        boolean bl = bDone = this._sheetState != null && !this._sheetState.isEmpty();
        if (!bDone) {
            bDone = super.isDone();
        }
        return bDone;
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"paste", AbstractUndoableEdit.class, (String)"\u7c98\u8d34 ") + super.getPresentationName();
    }
}

