/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellFinder;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Size;
import com.kingdee.bos.ctrl.excel.model.struct.SizeWithExclusiveCount;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import java.util.ArrayList;
import java.util.HashMap;

public class SheetAction_Replace
extends SheetAction {
    private HashMap _blocks;
    private CellFinder.ICellReplacer _rpl;
    private SizeWithExclusiveCount _sz = new SizeWithExclusiveCount();

    public SheetAction_Replace(Range rg, SortedObjectArray sa, CellFinder.ICellReplacer rpl) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style);
        this._rpl = rpl;
        this._blocks = new HashMap();
        rg._sheets.clear();
        for (int i = sa.size() - 1; i >= 0; --i) {
            Cell cll = (Cell)sa.get(i);
            Sheet sheet = cll.getSheet();
            ArrayList<Cell> tal = (ArrayList<Cell>)this._blocks.get(sheet);
            if (tal == null) {
                tal = new ArrayList<Cell>();
                this._blocks.put(sheet, tal);
                rg._sheets.insert(sheet);
            }
            tal.add(cll);
        }
    }

    Size getReplaced() {
        return this._sz;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        ArrayList clls = (ArrayList)this._blocks.get(sheet);
        if (clls == null) {
            return;
        }
        Cell cll = (Cell)clls.get(0);
        Cell cll2 = (Cell)clls.get(clls.size() - 1);
        cb = CellBlock.getNewCellBlock(cll.getRow(), cll.getCol(), cll2.getRow(), cll2.getCol());
        boolean bFormula = this._rpl.canReplaceFormula();
        boolean bStyle = this._rpl.canReplaceStyle();
        boolean bUserObject = this._rpl.canReplaceUseObject();
        int count = 0;
        this._sz.setExclusiveCount(clls.size());
        int size = clls.size();
        for (int i = 0; i < size; ++i) {
            UserObject obj;
            UserObject newObj;
            StyleAttributes newSA;
            Protection pro;
            cll = (Cell)clls.get(i);
            if (cll.getStyle().isLocked() && (pro = cll.getSheet().getSheetOption().getProtection(false)) != null && pro.isProtected()) continue;
            Object[] ao = null;
            if (bFormula) {
                String oldFormula = cll.getFormula();
                String newFormula = this._rpl.getFormula(cll);
                if (newFormula != oldFormula) {
                    if (ao == null) {
                        ao = new Object[3];
                    }
                    ao[0] = oldFormula;
                    cll.setFormula(newFormula);
                }
            }
            if (bStyle && (newSA = this._rpl.getSA(cll)) != null) {
                if (ao == null) {
                    ao = new Object[3];
                }
                ao[1] = cll.getSSA();
                this.setCellStyle(state, sheet, cll.getRow(), cll.getCol(), cll, (ShareStyleAttributes)newSA, null, null);
            }
            if (bUserObject && (newObj = this._rpl.getUseObject(cll)) != null && !newObj.equals(obj = cll.getUserObject(newObj.getKey()))) {
                if (ao == null) {
                    ao = new Object[3];
                }
                cll.setUserObject(newObj);
                ao[2] = obj == null ? newObj.getKey() : obj;
            }
            if (ao == null) continue;
            this.setCellState(state, cll, ao, null);
            ++count;
        }
        if (count > 0) {
            this._sz.setXY(this._sz.getX() + count, this._sz.getY() + 1);
            this._sz.setExclusiveCount(clls.size() - count);
        }
        this.checkedAutoFilter(sheet, state);
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = CellBlock.getNewCellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray SSAs = (ObjectArray)state.get("CELL_VALUE");
            int iEnd = clls.size();
            for (int i = 0; i < iEnd; ++i) {
                Cell cll = (Cell)clls.get(i);
                Object[] ao = (Object[])SSAs.get(i);
                if (ao[0] != null) {
                    cll.setFormula((String)ao[0]);
                }
                if (ao[1] != null) {
                    cll.setSSA((ShareStyleAttributes)ao[1]);
                }
                if (ao[2] == null) continue;
                if (ao[2] instanceof String) {
                    cll.removeUserObject((String)ao[2]);
                    continue;
                }
                UserObject uo = (UserObject)ao[2];
                cll.setUserObject(uo);
            }
        }
        this.resumeAutoFilter(sheet, state);
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"replace", AbstractUndoableEdit.class, (String)"\u66ff\u6362 ") + super.getPresentationName();
    }
}

