/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.filter;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AutoFilterDataItemModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.ISheetAutoFilter;
import java.util.ArrayList;

public abstract class AbstractAutoFilter
implements ISheetAutoFilter {
    protected Sheet sheet;
    protected int colIndex;
    protected transient ArrayList<Integer> beforeFilteAreaList;
    protected transient ArrayList<Integer> afterFilteAreaList = new ArrayList();
    protected transient AutoFilterDataItemModel dataItemModel;

    public AbstractAutoFilter(Sheet sheet, int colIndex) {
        this.sheet = sheet;
        this.colIndex = colIndex;
    }

    @Override
    public final void exec() {
        this.afterFilteAreaList.clear();
        this.beforeDoFilter();
        for (int i : this.beforeFilteAreaList) {
            Cell cell = this.sheet.getCell(i, this.colIndex, false);
            CellBlock mergeBlock = this.sheet.getMergeBlock(i, this.colIndex);
            if (mergeBlock != null) {
                cell = this.sheet.getCell(mergeBlock.getRow(), mergeBlock.getCol(), false);
            }
            if (!this.matchFilter(cell)) continue;
            this.afterFilteAreaList.add(i);
        }
        this.afterDoFilter();
    }

    @Override
    public ArrayList<Integer> getAfterFilterArea() {
        return this.afterFilteAreaList;
    }

    @Override
    public void setBeforeFilterArea(ArrayList<Integer> beforeFilteAreaList) {
        this.beforeFilteAreaList = beforeFilteAreaList;
        this.dataItemModel = new AutoFilterDataItemModel(this.sheet, this.colIndex, beforeFilteAreaList);
    }

    @Override
    public AutoFilterDataItemModel getDataItemModel() {
        return this.dataItemModel;
    }

    protected void beforeDoFilter() {
    }

    protected void afterDoFilter() {
    }

    protected abstract boolean matchFilter(Cell var1);

    @Override
    public int getColIndex() {
        return this.colIndex;
    }

    @Override
    public void setColIndex(int newColIndex) {
        this.colIndex = newColIndex;
    }

    @Override
    public abstract int getAutoFilterType();
}

