/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.validate.util;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;

public class Validate {
    private static final String[] Types = new String[]{"Any", "Whole", "Decimal", "Date", "Time", "TextLength", "List", "Custom"};
    public static final String Type_ANY;
    public static final String Type_Whole;
    public static final String Type_Decimal;
    public static final String Type_Date;
    public static final String Type_Time;
    public static final String Type_TextLength;
    public static final String Type_List;
    public static final String Type_Custom;
    private static final String[] Qualifiers;
    public static final String NotBetween;
    public static final String Between;
    public static final String Equal;
    public static final String NotEqual;
    public static final String Greater;
    public static final String Less;
    public static final String GreaterOrEqual;
    public static final String LessOrEqual;
    public static final int Check_Ok = 1;
    public static final int Check_Ok_Value = 2;
    public static final int Check_Error_Syntax = 4;
    public static final int Check_Error_Value = 8;
    public static final int Check_Error_MinMax = 16;
    private String _qualifier = Between;
    private String _min = "";
    private String _max = "";
    private String offsetMin = "";
    private String offsetMax = "";
    private String _type = Type_ANY;
    private boolean _useBlank;
    private boolean _hasCellRangeList;

    public static boolean isOk(int check) {
        return (check & 3) != 0;
    }

    public static boolean isSyntaxError(int check) {
        return (check & 4) != 0;
    }

    public static boolean isValueError(int check) {
        return (check & 8) != 0;
    }

    public static boolean isMinMaxError(int check) {
        return (check & 0x10) != 0;
    }

    public void setCellRangeList(boolean b) {
        this._hasCellRangeList = b;
    }

    public boolean hasCellRangeList() {
        return this._hasCellRangeList;
    }

    public void setUseBlank(boolean b) {
        this._useBlank = b;
    }

    public boolean isUseBlank() {
        return this._useBlank;
    }

    public boolean setType(String type) {
        if (this.checkType(type)) {
            this._type = type;
            return true;
        }
        return false;
    }

    public String getType() {
        return this._type;
    }

    public void setTypeIndex(int index) {
        if (index < 0 || index > 7) {
            return;
        }
        this._type = Types[index];
    }

    public void setQualifierIndex(int index) {
        if (index < 0 || index > 7) {
            return;
        }
        this._qualifier = Qualifiers[index];
    }

    public int getTypeIndex() {
        for (int i = 0; i < Types.length; ++i) {
            if (!Types[i].equals(this._type)) continue;
            return i;
        }
        return 0;
    }

    public int getQualifierIndex() {
        for (int i = 0; i < Qualifiers.length; ++i) {
            if (!Qualifiers[i].equals(this._qualifier)) continue;
            return i;
        }
        return 0;
    }

    public boolean setQualifier(String qualifier) {
        if (this.checkQualifier(qualifier)) {
            this._qualifier = qualifier;
            return true;
        }
        return false;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    public int setMinMax(String min, String max, Sheet owner) {
        if (!Type_Custom.equals(this._type) && !Type_List.equals(this._type) && (NotBetween.equals(this._qualifier) || Between.equals(this._qualifier))) {
            int check2;
            int check;
            if (StringUtil.isEmptyString((String)min) || StringUtil.isEmptyString((String)max)) {
                return 8;
            }
            Variant retVar = new Variant();
            Variant retVar2 = new Variant();
            if (Type_Whole.equals(this._type) || Type_TextLength.equals(this._type)) {
                check = this.checkWhole(owner, min, retVar);
                check2 = this.checkWhole(owner, max, retVar2);
            } else if (Type_Decimal.equals(this._type)) {
                check = this.checkDecimal(owner, min, retVar);
                check2 = this.checkDecimal(owner, max, retVar2);
            } else {
                check = this.checkDateTime(owner, min, retVar);
                check2 = this.checkDateTime(owner, max, retVar2);
            }
            if (!Validate.isOk(check)) {
                return check;
            }
            if (!Validate.isOk(check2)) {
                return check2;
            }
            if (check == 2 && check2 == 2) {
                try {
                    if (retVar.compareTo(retVar2) > 0) {
                        return 16;
                    }
                }
                catch (Exception e) {
                    return 16;
                }
                if (Type_Date.equals(this._type) || Type_Time.equals(this._type)) {
                    this._min = min;
                    this._max = max;
                } else {
                    this._min = retVar.toString();
                    this._max = retVar2.toString();
                }
            } else {
                this._min = min;
                this._max = max;
            }
            return check;
        }
        if (StringUtil.isEmptyString((String)min)) {
            return 8;
        }
        int check = 1;
        if (Type_Custom.equals(this._type)) {
            check = this.checkCustom(owner, min);
            if (Validate.isOk(check)) {
                this._min = min;
            }
            return check;
        }
        if (Type_List.equals(this._type)) {
            check = this.checkList(owner, min);
            if (Validate.isOk(check)) {
                this._min = min;
            }
            return check;
        }
        Variant retVar = new Variant();
        check = Type_Whole.equals(this._type) || Type_TextLength.equals(this._type) ? this.checkWhole(owner, min, retVar) : (Type_Decimal.equals(this._type) ? this.checkDecimal(owner, min, retVar) : this.checkDateTime(owner, min, retVar));
        if (check == 1) {
            this._min = min;
        } else if (check == 2) {
            this._min = Type_Date.equals(this._type) || Type_Time.equals(this._type) ? min : retVar.toString();
        }
        return check;
    }

    public String getMin() {
        return this._min;
    }

    public String getMax() {
        return this._max;
    }

    public void setMin(String min) {
        this._min = min;
    }

    public void setMax(String max) {
        this._max = max;
    }

    private int checkCustom(Sheet sheet, String formula) {
        if (formula.length() > 1 && formula.startsWith("=")) {
            Expr expr = sheet.getExpr(null, formula);
            if (expr.isSyntaxError()) {
                return 4;
            }
            return 1;
        }
        return 4;
    }

    private int checkList(Sheet sheet, String formula) {
        if (formula.length() > 1 && formula.startsWith("=")) {
            Expr expr = sheet.getExpr(null, formula);
            CellBlockNode cb = null;
            if (expr.isSingleCellBlock()) {
                cb = (CellBlockNode)expr.getParameters()[0];
            } else if (expr.isNamedObject()) {
                NamedObjectNode n = (NamedObjectNode)expr.getParameters()[0];
                Expr e = n.getExpr();
                if (null != e && e.getParameters()[0] instanceof CellBlockNode) {
                    cb = (CellBlockNode)e.getParameters()[0];
                }
            } else {
                Variant v = sheet.calcExpr(expr, null);
                if (v.getValue() instanceof CellBlockNode) {
                    cb = (CellBlockNode)v.getValue();
                }
            }
            if (cb != null && (!cb.isSingleCol() && cb.isSingleRow() || cb.isSingleCol() && !cb.isSingleRow() || cb.isSingleCell())) {
                return 1;
            }
            return 4;
        }
        return 2;
    }

    private int checkNumber(Sheet sheet, String formula, Variant retVar) {
        if (formula.length() > 1 && formula.startsWith("=")) {
            Expr expr = sheet.getExpr(null, formula);
            if (expr.isSyntaxError()) {
                return 4;
            }
            return 1;
        }
        Variant var = Format.parseData((String)formula, (boolean)true);
        if (var.isNumber() || var.isDate()) {
            retVar.setObject(var.getValue(), var.getVt());
            return 2;
        }
        return 8;
    }

    private int checkWhole(Sheet sheet, String formula, Variant retVar) {
        int check = this.checkNumber(sheet, formula, retVar);
        if (check == 2) {
            boolean b = false;
            try {
                retVar.setObject((Object)retVar.toBigDecimal(), 10);
                b = this.checkWholeNumber(retVar);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
            if (b) {
                return check;
            }
            return 8;
        }
        return check;
    }

    private int checkDecimal(Sheet sheet, String formula, Variant retVar) {
        int check = this.checkNumber(sheet, formula, retVar);
        if (check == 2) {
            try {
                retVar.setObject((Object)retVar.toBigDecimal(), 10);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        return check;
    }

    private int checkDateTime(Sheet sheet, String formula, Variant retVar) {
        int check = this.checkNumber(sheet, formula, retVar);
        if (check == 2 && retVar.isNumber()) {
            check = 8;
        }
        return check;
    }

    private boolean checkType(String type) {
        return Type_Whole.equals(type) || Type_Decimal.equals(type) || Type_Date.equals(type) || Type_Time.equals(type) || Type_TextLength.equals(type) || Type_List.equals(type) || Type_Custom.equals(type) || LessOrEqual.equals(type);
    }

    private boolean checkQualifier(String qualifier) {
        if (NotBetween.equals(qualifier) || Between.equals(qualifier)) {
            return !Type_Custom.equals(this._type) && !Type_List.equals(this._type);
        }
        return Equal.equals(qualifier) || NotEqual.equals(qualifier) || Greater.equals(qualifier) || Less.equals(qualifier) || GreaterOrEqual.equals(qualifier) || LessOrEqual.equals(qualifier);
    }

    private boolean checkWholeNumber(Variant var) throws SyntaxErrorException {
        if (var.isEmpty()) {
            return true;
        }
        Util.reduceScale((Variant)var);
        Object o = var.getValue();
        if (!(o instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bd = (BigDecimal)o;
        return bd.scale() == 0 || var.toString().indexOf(46) == 0;
    }

    private boolean isCustomValidated(Sheet sheet, String formula) throws SyntaxErrorException {
        return sheet.calcFormula(this.getCalcMin()).booleanValue();
    }

    public String getOffsetMin() {
        return this.offsetMin;
    }

    public void setOffsetMin(String offsetMin) {
        this.offsetMin = offsetMin;
    }

    public String getOffsetMax() {
        return this.offsetMax;
    }

    public void setOffsetMax(String offsetMax) {
        this.offsetMax = offsetMax;
    }

    public TextValuePair[] getListTextValuePair(Sheet sheet) {
        if (!this.getCalcMin().startsWith("=")) {
            String[] strs = this.getCalcMin().split(",");
            TextValuePair[] textValuePair = new TextValuePair[strs.length];
            int size = strs.length;
            for (int i = 0; i < size; ++i) {
                textValuePair[i] = new TextValuePair(strs[i], new Variant((Object)strs[i], 11));
            }
            return textValuePair;
        }
        Expr expr = sheet.getExpr(null, this.getCalcMin());
        CellBlockNode cb = null;
        if (expr.isSingleCellBlock()) {
            cb = (CellBlockNode)expr.getParameters()[0];
        } else if (expr.isNamedObject()) {
            NamedObjectNode n = (NamedObjectNode)expr.getParameters()[0];
            Expr e = n.getExpr();
            if (null != e && e.getParameters()[0] instanceof CellBlockNode) {
                cb = (CellBlockNode)e.getParameters()[0];
            }
        } else {
            Variant v = sheet.calcExpr(expr, null);
            if (v.getValue() instanceof CellBlockNode) {
                cb = (CellBlockNode)v.getValue();
            }
        }
        if (null == cb) {
            return new TextValuePair[0];
        }
        Sheet.ICellsIterator iter = cb.getSheet().getCellsIterator(cb, false, true, false);
        ArrayList<TextValuePair> al = new ArrayList<TextValuePair>();
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell.getValue() == null || cell.getValue().getValue() == null) {
                if (!this.isUseBlank()) continue;
                al.add(new TextValuePair("", Variant.nullVariant));
                continue;
            }
            al.add(new TextValuePair(cell.getText(), cell.getValue()));
        }
        TextValuePair[] textValuePair = new TextValuePair[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            textValuePair[i] = (TextValuePair)al.get(i);
        }
        return textValuePair;
    }

    private boolean isListValidated(Sheet sheet, String formula) throws SyntaxErrorException {
        Variant fvar;
        if (!this._useBlank && StringUtil.isEmptyString((String)formula)) {
            return true;
        }
        String sfvar = formula;
        if (formula.startsWith("=") && !(fvar = sheet.calcFormula(formula)).isError()) {
            sfvar = fvar.toString();
        }
        if (!this.getCalcMin().startsWith("=")) {
            String[] strs = this.getCalcMin().split(",");
            int size = strs.length;
            for (int i = 0; i < size; ++i) {
                if (!StringUtil.equals((String)strs[i], (String)sfvar)) continue;
                return true;
            }
        } else {
            Expr expr = sheet.getExpr(null, this.getCalcMin());
            IExprNode[] nodes = expr.getParameters();
            CellBlockNode cb = (CellBlockNode)nodes[0];
            Sheet.ICellsIterator iter = cb.getSheet().getCellsIterator(cb, false, true, false);
            while (iter.hasNext()) {
                if (!StringUtil.equals((String)iter.next().getText(), (String)sfvar)) continue;
                return true;
            }
        }
        return false;
    }

    private Variant makeNumVariant(Sheet sheet, String formula) {
        Variant var = Format.parseData((String)formula, (boolean)true);
        if (!var.isNumber() && !var.isDate() && formula != null && formula.startsWith("=")) {
            var = sheet.calcFormula(formula);
        }
        return var;
    }

    private Variant makeTextLengthVariant(Sheet sheet, String formula) {
        if (StringUtil.isEmptyString((String)formula)) {
            return new Variant(null, 8192);
        }
        Variant var = this.makeNumVariant(sheet, formula);
        Util.reduceScale((Variant)var);
        var = var.isError() || var.isNumber() && var.toString().length() != formula.length() ? new Variant(formula.length()) : new Variant(var.toString().length());
        return var;
    }

    public String getCalcMin() {
        return StringUtil.isEmptyString((String)this.offsetMin) ? this._min : this.offsetMin;
    }

    public String getCalcMax() {
        return StringUtil.isEmptyString((String)this.offsetMax) ? this._max : this.offsetMax;
    }

    private Variant makeWholeVariant(Sheet sheet, String formula) throws SyntaxErrorException {
        Variant var = this.makeNumVariant(sheet, formula);
        if (var.isString()) {
            return var;
        }
        if (this.checkWholeNumber(var)) {
            return var;
        }
        var.setObject(null, 16);
        return var;
    }

    public boolean isValidated(Sheet sheet, String formula) {
        try {
            if (Type_Custom.equals(this._type)) {
                return this.isCustomValidated(sheet, formula);
            }
            if (Type_List.equals(this._type)) {
                return this.isListValidated(sheet, formula);
            }
            if (Type_ANY.equals(this._type)) {
                return true;
            }
            Variant var = Type_TextLength.equals(this._type) ? this.makeTextLengthVariant(sheet, formula) : (Type_Whole.equals(this._type) ? this.makeWholeVariant(sheet, formula) : this.makeNumVariant(sheet, formula));
            if (!this._useBlank && StringUtil.isEmptyString((String)formula)) {
                return true;
            }
            if (!var.isNumber() && !var.isDate()) {
                return false;
            }
            Variant vmin = this.makeNumVariant(sheet, this.getCalcMin());
            Variant vmax = null;
            if (NotBetween.equals(this._qualifier) || Between.equals(this._qualifier)) {
                vmax = this.makeNumVariant(sheet, this.getCalcMax());
            }
            if (NotBetween.equals(this._qualifier)) {
                return var.compareTo(vmin) < 0 || var.compareTo(vmax) > 0;
            }
            if (Equal.equals(this._qualifier)) {
                return var.compareTo(vmin) == 0;
            }
            if (NotEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) != 0;
            }
            if (Greater.equals(this._qualifier)) {
                return var.compareTo(vmin) > 0;
            }
            if (Less.equals(this._qualifier)) {
                return var.compareTo(vmin) < 0;
            }
            if (GreaterOrEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) >= 0;
            }
            if (LessOrEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) <= 0;
            }
            if (Between.equals(this._qualifier)) {
                return var.compareTo(vmin) >= 0 && var.compareTo(vmax) <= 0;
            }
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Validate) {
            Validate cv = (Validate)o;
            boolean b = StringUtil.equals((String)this._type, (String)cv._type);
            boolean b1 = StringUtil.equals((String)this._qualifier, (String)cv._qualifier);
            boolean b2 = StringUtil.equals((String)this._min, (String)cv._min);
            boolean b3 = StringUtil.equals((String)this._max, (String)cv._max);
            return b && b1 && b2 && b3 && this._useBlank == cv._useBlank && this._hasCellRangeList == cv._hasCellRangeList;
        }
        return false;
    }

    static {
        int i = 0;
        Type_ANY = Types[i++];
        Type_Whole = Types[i++];
        Type_Decimal = Types[i++];
        Type_Date = Types[i++];
        Type_Time = Types[i++];
        Type_TextLength = Types[i++];
        Type_List = Types[i++];
        Type_Custom = Types[i++];
        Qualifiers = new String[]{"NotBetween", "", "Equal", "NotEqual", "Greater", "Less", "GreaterOrEqual", "LessOrEqual"};
        i = 0;
        NotBetween = Qualifiers[i++];
        Between = Qualifiers[i++];
        Equal = Qualifiers[i++];
        NotEqual = Qualifiers[i++];
        Greater = Qualifiers[i++];
        Less = Qualifiers[i++];
        GreaterOrEqual = Qualifiers[i++];
        LessOrEqual = Qualifiers[i++];
    }

    public static class TextValuePair
    implements Comparable<TextValuePair> {
        private String text;
        private Variant value;

        public TextValuePair(String text, Variant value) {
            this.text = text;
            this.value = value;
        }

        public Variant getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        public int hashCode() {
            return Objects.hash(this.text);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextValuePair other = (TextValuePair)obj;
            return Objects.equals(this.text, other.getText());
        }

        @Override
        public int compareTo(TextValuePair o) {
            if (null == o) {
                return 1;
            }
            if (null != this.value) {
                try {
                    return this.value.compareTo(o.getValue());
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            }
            return -1;
        }
    }
}

