/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class KDTMergeManager {
    public static final int NO_MERGE = 0;
    public static final int FREE_ROW_MERGE = 1;
    public static final int FREE_COLUMN_MERGE = 2;
    public static final int FREE_MERGE = 3;
    public static final int SPECIFY_MERGE = 4;
    public static final int GROUP_MERGE = 5;
    public static final int VIEW_AS_MERGE = 0;
    public static final int DATA_ORIGINAL = 0;
    public static final int DATA_KEEPFIRST = 1;
    public static final int DATA_UNIFY = 2;
    public static final int VIEW_AS_INDENTATION = 1;
    private KDTable table;
    private IRows rows;
    private int mergeMode = 0;
    private int viewMode = 0;
    private int dataMode = 0;
    private boolean ignoreHideCol = false;
    private Set mergeBlockList = new HashSet();

    public KDTMergeManager(KDTable table, IRows rows) {
        this.table = table;
        this.rows = rows;
    }

    public int getMergeMode() {
        return this.mergeMode;
    }

    public void setMergeMode(int mergeMode) {
        this.mergeMode = mergeMode;
    }

    boolean mergeFree(int top, int left, int bottom, int right) {
        if (this.mergeMode == 0 || this.mergeMode == 4) {
            return false;
        }
        return this.mergeBlock(top, left, bottom, right, this.mergeMode);
    }

    boolean mergeFreeEx(int top, int left, int bottom, int right) {
        if (this.mergeMode == 0 || this.mergeMode == 4) {
            return false;
        }
        return this.mergeBlockEx(top, left, bottom, right, this.mergeMode);
    }

    public boolean mergeBlock(int top, int left, int bottom, int right, int mergeMode) {
        if (!this.isBlockMergeable(top, left, bottom, right)) {
            return false;
        }
        if (this.table.getUndoManager() != null) {
            this.table.getUndoManager().createSplitBlockEdit(top, left, bottom, right);
        }
        switch (mergeMode) {
            case 2: {
                for (int i = top; i <= bottom; ++i) {
                    this.mergeRow(i, left, right);
                }
                break;
            }
            case 1: {
                for (int i = left; i <= right; ++i) {
                    this.mergeColumn(i, top, bottom);
                }
                break;
            }
            case 3: {
                this.mergeRowCol(top, left, bottom, right);
                break;
            }
            case 4: {
                this.mergeSpecify(top, left, bottom, right);
                break;
            }
        }
        this.table.repaint();
        return true;
    }

    public boolean mergeBlockEx(int top, int left, int bottom, int right, int mergeMode) {
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        boolean b = this.mergeBlock(top, left, bottom, right, mergeMode);
        if (!b || this.getMergeMode() == 2) {
            this.table.setRefresh(refresh);
            return false;
        }
        if (this.getViewMode() == 0) {
            this.mergeBounds(top - 1, top, left, right);
            this.mergeBounds(bottom, bottom + 1, left, right);
        } else {
            this.mergeBounds2(top - 1, top, left, right);
            this.mergeBounds2(bottom, bottom + 1, left, right);
        }
        this.table.setRefresh(refresh);
        this.table.repaint();
        return true;
    }

    public boolean mergeBlock(int top, int left, int bottom, int right) {
        if (!this.isBlockMergeable(top, left, bottom, right)) {
            return false;
        }
        return this.mergeSpecify(top, left, bottom, right);
    }

    public boolean mergeBlock(KDTMergeBlock mb) {
        if (mb == null) {
            return false;
        }
        if (!this.isBlockMergeable(mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight())) {
            return false;
        }
        return this.mergeSpecify(mb);
    }

    public boolean splitBlock(int top, int left, int bottom, int right) {
        return this.splitBlock(top, left, bottom, right, true);
    }

    private boolean splitBlock(int top, int left, int bottom, int right, boolean deleteFromList) {
        if (!this.isBlockMergeable(top, left, bottom, right)) {
            return false;
        }
        if (this.table.getUndoManager() != null) {
            this.table.getUndoManager().createSplitBlockEdit(top, left, bottom, right);
        }
        for (int i = top; i <= bottom; ++i) {
            KDTRow row = this.rows.getRow2(i);
            if (row == null) continue;
            for (int j = left; j <= right; ++j) {
                KDTCell cell = row.getCell(j);
                if (cell == null) continue;
                if (deleteFromList && i == top && j == left) {
                    KDTMergeBlock m = cell.getMergeBlock();
                    this.removeMergeBlock(m);
                }
                cell.setMergeBlock(null);
            }
        }
        this.table.repaint();
        return true;
    }

    private void mergeColumn(int c, int r1, int r2) {
        if (this.rows.getType() != 0 && !this.table.getColumns().getColumn(c).isMergeable()) {
            return;
        }
        KDTMergeBlock mb = null;
        KDTRow row1 = null;
        KDTRow row2 = null;
        boolean status = false;
        for (int i = r1; i < r2; ++i) {
            KDTCell cell2;
            KDTCell cell1;
            if (!status) {
                row1 = this.rows.getRow2(i);
                if (row1 == null || !row1.isMergeable() || (row2 = this.rows.getRow2(i + 1)) == null || !row2.isMergeable() || !this.rows.isCellEquals(cell1 = row1.getCell(c), cell2 = row2.getCell(c))) continue;
                if (this.getViewMode() == 0) {
                    mb = this.createMergeBlock();
                    mb.left = c;
                    mb.right = c;
                    mb.top = i;
                    mb.bottom = i + 1;
                    if (cell1 == null) {
                        cell1 = this.table.createBlankCell(i, c);
                    }
                    if (cell2 == null) {
                        cell2 = this.table.createBlankCell(i + 1, c);
                    }
                    cell1.setMergeBlock(mb);
                    cell2.setMergeBlock(mb);
                } else {
                    cell2.setHide(true);
                }
                status = true;
                row1 = row2;
                row2 = null;
                continue;
            }
            row2 = this.rows.getRow2(i + 1);
            if (row2 != null && row2.isMergeable()) {
                cell1 = row1.getCell(c);
                if (this.rows.isCellEquals(cell1, cell2 = row2.getCell(c))) {
                    if (this.getViewMode() == 0) {
                        mb.bottom = i + 1;
                        if (cell2 == null) {
                            cell2 = this.table.createBlankCell(i + 1, c);
                        }
                        cell2.setMergeBlock(mb);
                    } else {
                        cell2.setHide(true);
                    }
                    row1 = row2;
                    row2 = null;
                    continue;
                }
                status = false;
                row1 = row2;
                mb = null;
                continue;
            }
            status = false;
            mb = null;
            ++i;
        }
    }

    private void mergeRow(int r, int c1, int c2) {
        KDTRow row = this.rows.getRow2(r);
        if (!row.isMergeable()) {
            return;
        }
        KDTColumns columns = this.table.getColumns();
        KDTMergeBlock mb = null;
        KDTCell cell1 = null;
        KDTCell cell2 = null;
        boolean status = false;
        for (int i = c1; i < c2; ++i) {
            if (!status) {
                if (this.rows.getType() != 0 && !columns.getColumn(i).isMergeable() || this.rows.getType() != 0 && !columns.getColumn(i + 1).isMergeable() || !this.rows.isCellEquals(cell1 = row.getCell(i), cell2 = row.getCell(i + 1))) continue;
                mb = this.createMergeBlock();
                mb.top = r;
                mb.bottom = r;
                mb.left = i;
                mb.right = i + 1;
                if (cell1 == null) {
                    cell1 = this.table.createBlankCell(r, i);
                }
                if (cell2 == null) {
                    cell2 = this.table.createBlankCell(r, i + 1);
                }
                cell1.setMergeBlock(mb);
                cell2.setMergeBlock(mb);
                status = true;
                cell1 = cell2;
                cell2 = null;
                continue;
            }
            if (this.rows.getType() == 0 && columns.getColumn(i + 1).isMergeable()) {
                cell2 = row.getCell(i + 1);
                if (this.rows.isCellEquals(cell1, cell2)) {
                    mb.right = i + 1;
                    if (cell2 == null) {
                        cell2 = this.table.createBlankCell(r, i + 1);
                    }
                    cell2.setMergeBlock(mb);
                    cell1 = cell2;
                    cell2 = null;
                    continue;
                }
                status = false;
                cell1 = cell2;
                cell2 = null;
                mb = null;
                continue;
            }
            status = false;
            cell1 = null;
            cell2 = null;
            mb = null;
            ++i;
        }
    }

    public void setIgnoreHideCol(boolean bool) {
        this.ignoreHideCol = bool;
    }

    private void mergeRowCol(int r1, int c1, int r2, int c2) {
        int i;
        if (this.table.isMergeHeadMoveable()) {
            this.ignoreHideCol = true;
        }
        for (i = c1; i <= c2; ++i) {
            this.mergeColumn(i, r1, r2);
        }
        KDTColumns columns = this.table.getColumns();
        for (i = r1; i <= r2; ++i) {
            int k;
            KDTMergeBlock mb1;
            KDTCell cell1;
            int j;
            KDTRow row = this.rows.getRow2(i);
            if (row == null || !row.isMergeable()) continue;
            for (j = c1; j < c2; ++j) {
                if (this.rows.getType() != 0 && (!columns.getColumn(j).isMergeable() || !columns.getColumn(j + 1).isMergeable())) continue;
                int oj = j;
                cell1 = row.getCell(j);
                KDTCell cell2 = row.getCell(++j);
                if (this.ignoreHideCol && this.table.getColumn(j).getStyleAttributes().isHided()) {
                    do {
                        cell2 = row.getCell(++j);
                    } while (this.table.getColumn(j) != null && this.table.getColumn(j).getStyleAttributes().isHided());
                }
                if (cell1 == null || cell2 == null) continue;
                mb1 = cell1.getMergeBlock();
                KDTMergeBlock mb2 = cell2.getMergeBlock();
                if (mb1 == null && mb2 == null) {
                    if (this.rows.isCellEquals(cell1, cell2)) {
                        if (i != 0 && this.ignoreHideCol) {
                            KDTRow preRow = this.rows.getRow2(i - 1);
                            KDTCell preCell1 = preRow.getCell(oj);
                            KDTCell preCell2 = preRow.getCell(j);
                            KDTMergeBlock preMb1 = preCell1.getMergeBlock();
                            KDTMergeBlock preMb2 = preCell2.getMergeBlock();
                            if (preMb1 != null && preMb2 != null && preMb1 == preMb2) {
                                this.mergeCell(i, oj, j, cell1, cell2);
                            }
                        } else {
                            this.mergeCell(i, oj, j, cell1, cell2);
                        }
                    }
                } else if (mb1 == null && mb2 != null) {
                    if (mb2.top == mb2.bottom && this.rows.isCellEquals(cell1, cell2)) {
                        --mb2.left;
                        cell1.setMergeBlock(mb2);
                    }
                } else if (mb1 != null && mb2 == null) {
                    if (mb1.top == mb1.bottom && this.rows.isCellEquals(cell1, cell2)) {
                        mb1.right = j;
                        cell2.setMergeBlock(mb1);
                        if (this.ignoreHideCol) {
                            int dataMode = this.dataMode;
                            this.setDataMode(0);
                            this.mergeSpecify(mb1);
                            this.setDataMode(dataMode);
                        }
                    }
                } else if (mb1.top == i && mb2.top == i && mb1.bottom == mb2.bottom && this.rows.isCellEquals(cell1, cell2)) {
                    mb1.right = mb2.right;
                    for (k = mb1.top; k <= mb1.bottom; ++k) {
                        this.rows.getRow2(k).getCell(j).setMergeBlock(mb1);
                    }
                    if (this.ignoreHideCol) {
                        int dataMode = this.dataMode;
                        this.setDataMode(0);
                        this.mergeSpecify(mb1);
                        this.setDataMode(dataMode);
                    }
                }
                --j;
            }
            if (!this.ignoreHideCol) continue;
            for (j = c1; j < c2; ++j) {
                if (this.table.getColumn(j) == null || !this.table.getColumn(j).getStyleAttributes().isHided() || this.table.getColumn(j + 1) == null || !this.table.getColumn(j + 1).getStyleAttributes().isHided()) continue;
                cell1 = row.getCell(j);
                KDTCell cell3 = row.getCell(j + 1);
                if (cell1 == null || cell3 == null) continue;
                mb1 = cell1.getMergeBlock();
                KDTMergeBlock mb3 = cell3.getMergeBlock();
                if (mb1 == null && mb3 == null) {
                    if (!this.rows.isCellEquals(cell1, cell3)) continue;
                    if (i != 0) {
                        KDTRow preRow = this.rows.getRow2(i - 1);
                        KDTCell preCell1 = preRow.getCell(j);
                        KDTCell preCell2 = preRow.getCell(j + 1);
                        KDTMergeBlock preMb1 = preCell1.getMergeBlock();
                        KDTMergeBlock preMb2 = preCell2.getMergeBlock();
                        if (preMb1 == null || preMb2 == null || preMb1 != preMb2) continue;
                        this.mergeCell(i, j, j + 1, cell1, cell3);
                        continue;
                    }
                    this.mergeCell(i, j, j + 1, cell1, cell3);
                    continue;
                }
                if (mb1 == null && mb3 != null) {
                    if (mb3.top != mb3.bottom || !this.rows.isCellEquals(cell1, cell3)) continue;
                    --mb3.left;
                    cell1.setMergeBlock(mb3);
                    int dataMode = this.dataMode;
                    this.setDataMode(0);
                    this.mergeSpecify(mb3);
                    this.setDataMode(dataMode);
                    continue;
                }
                if (mb1 != null && mb3 == null) {
                    if (mb1.top != mb1.bottom || !this.rows.isCellEquals(cell1, cell3)) continue;
                    ++mb1.right;
                    cell3.setMergeBlock(mb1);
                    int dataMode = this.dataMode;
                    this.setDataMode(0);
                    this.mergeSpecify(mb1);
                    this.setDataMode(dataMode);
                    continue;
                }
                if (mb1.top != i || mb3.top != i || mb1.bottom != mb3.bottom || !this.rows.isCellEquals(cell1, cell3)) continue;
                mb1.right = mb3.right;
                for (k = mb1.top; k <= mb1.bottom; ++k) {
                    this.rows.getRow2(k).getCell(j + 1).setMergeBlock(mb1);
                }
                this.removeMergeBlock(mb3);
                int dataMode = this.dataMode;
                this.setDataMode(0);
                this.mergeSpecify(mb1);
                this.setDataMode(dataMode);
            }
        }
    }

    private void mergeCell(int i, int oj, int j, KDTCell cell1, KDTCell cell2) {
        KDTMergeBlock mb = this.createMergeBlock();
        mb.top = i;
        mb.bottom = i;
        mb.left = oj;
        mb.right = j;
        cell1.setMergeBlock(mb);
        cell2.setMergeBlock(mb);
        if (this.ignoreHideCol) {
            int dataMode = this.dataMode;
            this.setDataMode(0);
            this.mergeSpecify(mb);
            this.setDataMode(dataMode);
        }
    }

    private void mergeBounds(int r1, int r2, int c1, int c2) {
        KDTRow row1 = this.rows.getRow2(r1);
        KDTRow row2 = this.rows.getRow2(r2);
        if (row1 == null || row2 == null) {
            return;
        }
        for (int i = c1; i <= c2; ++i) {
            if (!this.table.getColumns().getColumn(i).isMergeable()) continue;
            KDTCell cell1 = row1.getCell(i);
            KDTCell cell2 = row2.getCell(i);
            if (cell1 == null || cell2 == null) continue;
            KDTMergeBlock mb1 = cell1.getMergeBlock();
            KDTMergeBlock mb2 = cell2.getMergeBlock();
            if (mb1 == null && mb2 == null) {
                if (!this.rows.isCellEquals(cell1, cell2)) continue;
                KDTMergeBlock mb = this.createMergeBlock();
                mb.left = i;
                mb.right = i;
                mb.top = r1;
                mb.bottom = r2;
                cell1.setMergeBlock(mb);
                cell2.setMergeBlock(mb);
                continue;
            }
            if (mb1 == null && mb2 != null) {
                if (mb2.left != mb2.right || !this.rows.isCellEquals(cell1, cell2)) continue;
                --mb2.top;
                cell1.setMergeBlock(mb2);
                continue;
            }
            if (mb1 != null && mb2 == null) {
                if (mb1.left != mb1.right || !this.rows.isCellEquals(cell1, cell2)) continue;
                ++mb1.bottom;
                cell2.setMergeBlock(mb1);
                continue;
            }
            if (mb1.left != i || mb2.left != i || mb1.right != mb2.right || !this.rows.isCellEquals(cell1, cell2)) continue;
            mb1.bottom = mb2.bottom;
            for (int j = mb2.top; j <= mb2.bottom; ++j) {
                KDTRow row = this.rows.getRow2(j);
                for (int k = mb2.left; k <= mb2.right; ++k) {
                    row.getCell(k).setMergeBlock(mb1);
                }
            }
            this.removeMergeBlock(mb2);
        }
    }

    private void mergeBounds2(int r1, int r2, int c1, int c2) {
        KDTRow row1 = this.rows.getRow2(r1);
        KDTRow row2 = this.rows.getRow2(r2);
        if (row1 == null || row2 == null || !row1.isMergeable() || !row2.isMergeable()) {
            return;
        }
        KDTColumns cols = this.table.getColumns();
        for (int i = c1; i <= c2; ++i) {
            if (!cols.getColumn(i).isMergeable()) continue;
            KDTCell cell1 = row1.getCell(i);
            KDTCell cell2 = row2.getCell(i);
            if (cell1 == null || cell2 == null || !this.rows.isCellEquals(cell1, cell2)) continue;
            cell2.setHide(true);
        }
    }

    private boolean mergeSpecify(int top, int left, int bottom, int right) {
        if (top > bottom || left > right) {
            return false;
        }
        KDTMergeBlock mb = new KDTMergeBlock();
        mb.setTop(top);
        mb.setLeft(left);
        mb.setBottom(bottom);
        mb.setRight(right);
        return this.mergeSpecify(mb);
    }

    private boolean mergeSpecify(KDTMergeBlock mb) {
        KDTCell cell;
        int j;
        KDTRow row;
        int i;
        this.mergeBlockList.add(mb);
        int r1 = mb.getTop();
        int r2 = mb.getBottom();
        int c1 = mb.getLeft();
        int c2 = mb.getRight();
        KDTCell cellHaveValue = null;
        for (i = r1; i <= r2; ++i) {
            row = this.rows.getRow2(i);
            if (row == null) {
                return false;
            }
            for (j = c1; j <= c2; ++j) {
                cell = row.getCell(j);
                if (cell == null) {
                    if (this.rows.getType() == 0) {
                        cell = this.table.getHeadRow(i).getCell(j).getKDTCell();
                    } else if (this.rows.getType() == 1) {
                        cell = this.table.getRow(i).getCell(j).getKDTCell();
                    } else if (this.rows.getType() == 6) {
                        cell = this.table.getFootRow(i).getCell(j).getKDTCell();
                    }
                }
                cell.setMergeBlock(mb);
                if (cellHaveValue != null || cell.getValue() == null && cell.getExpressions() == null) continue;
                cellHaveValue = cell;
            }
        }
        if (cellHaveValue != null && cellHaveValue != (cell = this.rows.getRow2(r1).getCell(c1))) {
            cell.setValue(cellHaveValue.getValue());
            cell.setExpressions(cellHaveValue.getExpressions());
            cell.setUserObject(cellHaveValue.getUserObject());
            cell.setSSA(cellHaveValue.getSSA());
            cell.setStyle(cellHaveValue.getStyle());
            this.table.updateCellFormula(r1, c1);
        }
        if (this.getDataMode() == 1 || this.getDataMode() == 2) {
            KDTCell firstCell = this.rows.getRow2(r1).getCell(c1);
            for (i = r1; i <= r2; ++i) {
                row = this.rows.getRow2(i);
                if (row == null) {
                    return false;
                }
                for (j = c1; j <= c2; ++j) {
                    if (i == r1 && j == c1 || (cell = row.getCell(j)) == null) continue;
                    if (this.dataMode == 1) {
                        cell.setValue(null);
                        cell.setSSA(firstCell.getSSA());
                        cell.setStyle(firstCell.getStyle());
                        cell.setExpressions(null);
                        cell.setUserObject(null);
                        this.table.updateCellFormula(i, j);
                        continue;
                    }
                    cell.setValue(firstCell.getValue());
                    cell.setSSA(firstCell.getSSA());
                    cell.setStyle(firstCell.getStyle());
                    cell.setExpressions(firstCell.getExpressions());
                    cell.setUserObject(firstCell.getUserObject());
                    this.table.updateCellFormula(i, j);
                }
            }
        }
        return true;
    }

    private boolean isBlockMergeable(int top, int left, int bottom, int right) {
        KDTColumn col = this.table.getColumns().getColumn(right);
        if (col == null) {
            return false;
        }
        for (int i = top; i <= bottom; ++i) {
            if (i != top && i != bottom) continue;
            KDTRow row = this.rows.getRow(i);
            if (row == null) {
                return false;
            }
            for (int j = left; j <= right; ++j) {
                KDTMergeBlock mb;
                KDTCell cell = row.getCell(j);
                if (cell == null || (mb = cell.getViewBlock()) == null || mb.isContained(top, left, bottom, right)) continue;
                return false;
            }
        }
        return true;
    }

    public KDTMergeBlock getMergeBlockOfCell(int rowIndex, int colIndex) {
        IRow row = this.table.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        KDTCell cell = row.getKDTRow().getCell(colIndex);
        if (cell == null) {
            return null;
        }
        return cell.getMergeBlock();
    }

    public List getMergeBlockList() {
        return new ArrayList(this.mergeBlockList);
    }

    public Set getMergeBlockSet() {
        return this.mergeBlockList;
    }

    void setMergeBlockSet(Set set) {
        this.mergeBlockList = set;
    }

    private KDTMergeBlock createMergeBlock() {
        KDTMergeBlock mb = new KDTMergeBlock();
        this.mergeBlockList.add(mb);
        return mb;
    }

    private void removeMergeBlock(KDTMergeBlock mb) {
        this.mergeBlockList.remove(mb);
        mb = null;
    }

    void adjustInserRow(int index) {
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (index <= mb.getTop()) {
                mb.setTop(mb.getTop() + 1);
                mb.setBottom(mb.getBottom() + 1);
                continue;
            }
            if (index > mb.getBottom()) continue;
            mb.setBottom(mb.getBottom() + 1);
            for (int i = mb.getLeft(); i <= mb.getRight(); ++i) {
                KDTCell cell = this.rows.getType() == 0 ? this.table.getHeadRow(index).getCell(i).getKDTCell() : this.table.getRow(index).getCell(i).getKDTCell();
                cell.setMergeBlock(mb);
            }
        }
    }

    void adjustDeleteRow(int index) {
        Iterator it = this.mergeBlockList.iterator();
        ArrayList<KDTMergeBlock> temp = new ArrayList<KDTMergeBlock>();
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (index < mb.getTop()) {
                mb.setTop(mb.getTop() - 1);
                mb.setBottom(mb.getBottom() - 1);
                continue;
            }
            if (index == mb.getTop() && mb.getTop() == mb.getBottom()) {
                temp.add(mb);
                continue;
            }
            if (index > mb.getBottom()) continue;
            mb.setBottom(mb.getBottom() - 1);
            if (!this.isInvalidMergeBloc(mb)) continue;
            temp.add(mb);
            for (int i = this.table.getColumnCount() - 1; i >= 0; --i) {
                KDTCell kdtc;
                ICell cell;
                IRow row = this.table.getRow(mb.getBottom());
                if (row == null || (cell = row.getCell(i)) == null || (kdtc = cell.getKDTCell()) == null) continue;
                kdtc.setMergeBlock(null);
            }
        }
        it = null;
        this.mergeBlockList.removeAll(temp);
    }

    void adjustInserCol(int index) {
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (index <= mb.getLeft()) {
                mb.setLeft(mb.getLeft() + 1);
                mb.setRight(mb.getRight() + 1);
                continue;
            }
            if (index > mb.getRight()) continue;
            mb.setRight(mb.getRight() + 1);
            for (int i = mb.getTop(); i <= mb.getBottom(); ++i) {
                KDTCell cell = this.rows.getType() == 0 ? this.table.getHeadRow(i).getCell(index).getKDTCell() : this.table.getRow(i).getCell(index).getKDTCell();
                cell.setMergeBlock(mb);
            }
        }
    }

    void adjustDeleteCol(int index) {
        Iterator it = this.mergeBlockList.iterator();
        ArrayList<KDTMergeBlock> temp = new ArrayList<KDTMergeBlock>();
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (index < mb.getLeft()) continue;
            if (mb.getRight() == index && mb.getRight() == mb.getLeft()) {
                temp.add(mb);
                continue;
            }
            if (index > mb.getRight()) continue;
            mb.setRight(mb.getRight() - 1);
            if (!this.isInvalidMergeBloc(mb)) continue;
            temp.add(mb);
        }
        it = null;
        this.mergeBlockList.removeAll(temp);
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (index >= mb.getLeft()) continue;
            mb.setLeft(mb.getLeft() - 1);
            mb.setRight(mb.getRight() - 1);
        }
        it = null;
    }

    void adjustDeleteCol(int from, int to) {
        int col2;
        Iterator it = this.mergeBlockList.iterator();
        ArrayList<KDTMergeBlock> temp = new ArrayList<KDTMergeBlock>();
        int col1 = from > to ? to : from;
        int n = col2 = from > to ? from : to;
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (mb.getRight() >= col2 && mb.getLeft() <= col1 || from < mb.getLeft()) continue;
            if (mb.getRight() == from && mb.getRight() == mb.getLeft()) {
                temp.add(mb);
                continue;
            }
            if (from > mb.getRight()) continue;
            mb.setRight(mb.getRight() - 1);
            if (!this.isInvalidMergeBloc(mb)) continue;
            temp.add(mb);
        }
        it = null;
        this.mergeBlockList.removeAll(temp);
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (mb.getRight() >= col2 && mb.getLeft() <= col1 || from >= mb.getLeft()) continue;
            mb.setLeft(mb.getLeft() - 1);
            mb.setRight(mb.getRight() - 1);
        }
        it = null;
    }

    void adjustInserCol(int from, int to) {
        int col2;
        Iterator it = this.mergeBlockList.iterator();
        int col1 = from > to ? to : from;
        int n = col2 = from > to ? from : to;
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (mb.getRight() >= col2 && mb.getLeft() <= col1) continue;
            if (to <= mb.getLeft()) {
                mb.setLeft(mb.getLeft() + 1);
                mb.setRight(mb.getRight() + 1);
                continue;
            }
            if (to > mb.getRight()) continue;
            mb.setRight(mb.getRight() + 1);
            for (int i = mb.getTop(); i <= mb.getBottom(); ++i) {
                KDTCell cell = this.rows.getType() == 0 ? this.table.getHeadRow(i).getCell(to).getKDTCell() : this.table.getRow(i).getCell(to).getKDTCell();
                cell.setMergeBlock(mb);
            }
        }
    }

    private boolean isInvalidMergeBloc(KDTMergeBlock mb) {
        boolean bool = false;
        if (mb.getLeft() == mb.getRight() && mb.getBottom() == mb.getTop()) {
            bool = true;
        }
        return bool;
    }

    void adjustMoveCol(int from, int to) {
        Iterator it = this.mergeBlockList.iterator();
        ArrayList<KDTMergeBlock> temp = new ArrayList<KDTMergeBlock>();
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (mb.getLeft() != from || mb.getLeft() != mb.getRight()) continue;
            temp.add(mb);
        }
        it = null;
        this.adjustDeleteCol(from, from < to ? to - 1 : to);
        this.adjustInserCol(from, from < to ? to - 1 : to);
        for (KDTMergeBlock mb : temp) {
            if (mb.getLeft() != from || mb.getLeft() != mb.getRight()) continue;
            mb.setLeft(from < to ? to - 1 : to);
            mb.setRight(from < to ? to - 1 : to);
        }
        this.mergeBlockList.addAll(temp);
    }

    void adjustExchangeCol(int from, int to) {
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (mb.getLeft() == from && mb.getLeft() == mb.getRight()) {
                mb.setLeft(to);
                mb.setRight(to);
                continue;
            }
            if (mb.getLeft() != to || mb.getLeft() != mb.getRight()) continue;
            mb.setLeft(from);
            mb.setRight(from);
        }
    }

    public void removeAllMergeBlock() {
        if (this.mergeBlockList != null) {
            for (KDTMergeBlock mb : this.mergeBlockList) {
                this.splitBlock(mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight(), false);
            }
            this.mergeBlockList.clear();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" MergeMode=" + this.mergeMode + "\n");
        for (KDTMergeBlock mb : this.mergeBlockList) {
            sb.append(mb.toString());
        }
        return sb.toString();
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
    }

    public boolean hasMultiColumnMerge(int colIndex) {
        boolean isHas = false;
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if ((mb.getLeft() >= colIndex || mb.getRight() < colIndex) && (mb.getLeft() != colIndex || mb.getRight() <= colIndex)) continue;
            isHas = true;
            break;
        }
        return isHas;
    }

    public boolean hasFirstColumnInMultiColumnMerge(int colIndex) {
        boolean isHas = true;
        for (KDTMergeBlock mb : this.mergeBlockList) {
            if (mb.getLeft() >= colIndex || mb.getRight() < colIndex) continue;
            isHas = false;
            break;
        }
        return isHas;
    }

    public int getDataMode() {
        return this.dataMode;
    }

    public void setDataMode(int dataMode) {
        this.dataMode = dataMode;
    }
}

