/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.KDTHorizon;
import com.kingdee.bos.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.command.ICommand;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import java.awt.Point;
import java.util.ArrayList;

public class KDTViewManager
implements KDTResizeListener {
    KDTable table;
    private ArrayList views;
    private int freezeRowIndex = 0;
    private int freezeColIndex = 0;
    ICommand freezeCommand = new ICommand(){

        @Override
        public void execute() {
            KDTViewManager.this.freeze(KDTViewManager.this.setFreezerowIndex, KDTViewManager.this.setFreezecolIndex);
        }

        @Override
        public void unexecute() {
        }

        @Override
        public boolean isReversible() {
            return false;
        }
    };
    private int setFreezerowIndex = 0;
    private int setFreezecolIndex = 0;

    public KDTViewManager(KDTable table) {
        this.table = table;
        this.views = new ArrayList();
    }

    public int getViewCount() {
        return this.views.size();
    }

    public void addView(int vIndex, int hIndex, BasicView view) {
        int index = this.getIndex(vIndex, hIndex);
        view.setIndex(index);
        this.views.add(index, view);
        this.table.add(view);
        for (int i = index + 1; i < this.views.size(); ++i) {
            ((BasicView)this.views.get(i)).setIndex(i);
        }
    }

    public void setView(int vIndex, int hIndex, BasicView view) {
        int index = this.getIndex(vIndex, hIndex);
        BasicView oldView = (BasicView)this.views.get(index);
        this.table.remove(oldView);
        view.setIndex(index);
        this.views.set(index, view);
        this.table.add(view);
    }

    public void removeView(int vIndex, int hIndex) {
        int index = this.getIndex(vIndex, hIndex);
        BasicView view = (BasicView)this.views.remove(index);
        this.table.remove(view);
        for (int i = index; i < this.views.size(); ++i) {
            ((BasicView)this.views.get(i)).setIndex(i);
        }
        KDTSelectManager sManager = this.table.getSelectManager();
        if (sManager.getActiveViewIndex() > this.getViewCount() - 1) {
            sManager.setActiveViewIndex(this.getDefaultActiveViewIndex());
        }
    }

    public BasicView getView(int index) {
        if (index >= this.views.size()) {
            return (BasicView)this.views.get(this.views.size() - 1);
        }
        return (BasicView)this.views.get(index);
    }

    public BasicView getView(int vIndex, int hIndex) {
        int index = this.getIndex(vIndex, hIndex);
        if (index >= this.views.size()) {
            return (BasicView)this.views.get(this.views.size() - 1);
        }
        return (BasicView)this.views.get(index);
    }

    private int getIndex(int vIndex, int hIndex) {
        return vIndex * this.table.getHorizonCount() + hIndex;
    }

    public int getVerticalIndex(int index) {
        return index / this.table.getHorizonCount();
    }

    public int getHorizonIndex(int index) {
        return index % this.table.getHorizonCount();
    }

    public int getDefaultActiveViewIndex() {
        return 5;
    }

    public boolean splitVertical(int vIndex) {
        KDTVertical info = this.table.getLayoutManager().getVertical(vIndex);
        int position = info.getSpan() / 2;
        return this.splitVertical(vIndex, position);
    }

    public boolean splitVertical(int vIndex, int position) {
        return this.splitVertical(vIndex, position, false);
    }

    boolean splitVertical(int vIndex, int position, boolean scrollLimit) {
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        if (vIndex < 1 || vIndex >= vCount) {
            return false;
        }
        KDTLayoutManager lm = this.table.getLayoutManager();
        KDTVertical info = lm.getVertical(vIndex);
        int oldStart = info.getStart();
        int oldSpan = info.getSpan();
        int newStart = oldStart + position;
        int newSpan = oldSpan - position;
        if (position <= 0 || position >= oldSpan) {
            return false;
        }
        for (int i = 0; i < hCount; ++i) {
            BasicView view = this.getView(vIndex, i);
            view = view instanceof KDTIndexColumnView ? (BasicView)((KDTIndexColumnView)view).clone() : (BasicView)view.clone();
            this.addView(vIndex + 1, i, view);
        }
        KDTVertical vertical = (KDTVertical)((KDTLayoutInfo)info).clone();
        lm.addVertical(vIndex, vertical);
        vertical.setStart(oldStart);
        vertical.setSpan(position);
        if (scrollLimit) {
            vertical.first = info.getFirst();
            vertical.calculateLast();
            vertical.setLastInAll(vertical.last);
        }
        vertical.setFirst(info.getFirst());
        vertical.setSplitType(1);
        info.setStart(newStart);
        info.setSpan(newSpan);
        if (scrollLimit) {
            info.setFirstInAll(vertical.getLast2());
        }
        info.setFirst(vertical.getLast2());
        this.table.setVerticalCount(vCount + 1);
        this.resizeVertical(vIndex, vertical.getSpan());
        this.table.reLayoutAndPaint();
        return true;
    }

    public boolean splitHorizon(int hIndex) {
        KDTHorizon info = this.table.getLayoutManager().getHorizon(hIndex);
        int position = info.getSpan() / 2;
        return this.splitHorizon(hIndex, position);
    }

    public boolean splitHorizon(int hIndex, int position) {
        return this.splitHorizon(hIndex, position, false);
    }

    boolean splitHorizon(int hIndex, int position, boolean scrollLimit) {
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        if (hIndex < 2 || hIndex >= hCount) {
            return false;
        }
        KDTLayoutManager lm = this.table.getLayoutManager();
        KDTHorizon info = lm.getHorizon(hIndex);
        int oldStart = info.getStart();
        int oldSpan = info.getSpan();
        int newStart = oldStart + position;
        int newSpan = oldSpan - position;
        if (position <= 0 || position >= oldSpan) {
            return false;
        }
        for (int i = vCount - 1; i >= 0; --i) {
            BasicView view = this.getView(i, hIndex);
            view = view instanceof KDTIndexColumnView ? (BasicView)((KDTIndexColumnView)view).clone() : (BasicView)view.clone();
            this.addView(i, hIndex + 1, view);
        }
        KDTHorizon horizon = (KDTHorizon)((KDTLayoutInfo)info).clone();
        lm.addHorizon(hIndex, horizon);
        horizon.setStart(oldStart);
        horizon.setSpan(position);
        if (scrollLimit) {
            horizon.first = info.getFirst();
            horizon.calculateLast();
            horizon.setLastInAll(horizon.last);
        }
        horizon.setFirst(info.getFirst());
        horizon.setSplitType(1);
        info.setStart(newStart);
        info.setSpan(newSpan);
        if (scrollLimit) {
            info.setFirstInAll(horizon.getLast2());
        }
        this.table.setHorizonCount(hCount + 1);
        info.setFirst(horizon.getLast2());
        this.resizeHorizon(hIndex, horizon.getSpan());
        this.table.reLayoutAndPaint();
        return true;
    }

    public boolean mergeVertical(int vIndex) {
        return this.mergeVertical(vIndex, true);
    }

    boolean mergeVertical(int vIndex, boolean scrollLimit) {
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        if (vIndex < 1 || vIndex >= vCount) {
            return false;
        }
        if (vIndex != vCount - 1) {
            KDTVertical currInfo = this.table.getLayoutManager().getVertical(vIndex);
            KDTVertical nextInfo = this.table.getLayoutManager().getVertical(vIndex + 1);
            int newStart = currInfo.getStart();
            int newSpan = nextInfo.getStart() - newStart + nextInfo.getSpan();
            nextInfo.setStart(newStart);
            nextInfo.setSpan(newSpan);
            if (scrollLimit) {
                nextInfo.setFirstInAll(((KDTLayoutInfo)currInfo).getFirstInAll());
                nextInfo.setFirst(currInfo.getFirst());
            }
            this.table.getLayoutManager().removeVertical(vIndex);
            for (int i = hCount - 1; i >= 0; --i) {
                this.removeView(vIndex, i);
            }
            this.table.setVerticalCount(vCount - 1);
            this.table.reLayoutAndPaint();
            this.table.getDataRequestManager().doMemoryCallback(0);
        }
        return true;
    }

    public boolean mergeHorizon(int hIndex) {
        return this.mergeHorizon(hIndex, true);
    }

    boolean mergeHorizon(int hIndex, boolean scrollLimit) {
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        if (hIndex < 2 || hIndex >= hCount) {
            return false;
        }
        if (hIndex != hCount - 1) {
            KDTHorizon currInfo = this.table.getLayoutManager().getHorizon(hIndex);
            KDTHorizon nextInfo = this.table.getLayoutManager().getHorizon(hIndex + 1);
            int newStart = currInfo.getStart();
            int newSpan = nextInfo.getStart() - newStart + nextInfo.getSpan();
            nextInfo.setStart(newStart);
            nextInfo.setSpan(newSpan);
            if (scrollLimit) {
                nextInfo.setFirstInAll(((KDTLayoutInfo)currInfo).getFirstInAll());
                nextInfo.setFirst(currInfo.getFirst());
            }
            this.table.getLayoutManager().removeHorizon(hIndex);
            for (int i = vCount - 1; i >= 0; --i) {
                this.removeView(i, hIndex);
            }
            this.table.setHorizonCount(hCount - 1);
            this.table.reLayoutAndPaint();
        }
        return true;
    }

    public boolean resizeVertical(int vIndex, int position) {
        int delta;
        if (!this.isVerticalResizeable(vIndex, position)) {
            return false;
        }
        KDTVertical currInfo = this.table.getLayoutManager().getVertical(vIndex);
        KDTVertical nextInfo = this.table.getLayoutManager().getVertical(vIndex + 1);
        if ((delta = --position - currInfo.getSpan()) == 0) {
            return true;
        }
        currInfo.setSpan(currInfo.getSpan() + delta);
        nextInfo.setStart(nextInfo.getStart() + delta);
        nextInfo.setSpan(nextInfo.getSpan() - delta);
        this.table.reLayoutAndPaint();
        return true;
    }

    public boolean resizeHorizon(int hIndex, int position) {
        int delta;
        if (!this.isHorizonResizeable(hIndex, position)) {
            return false;
        }
        KDTHorizon currInfo = this.table.getLayoutManager().getHorizon(hIndex);
        KDTHorizon nextInfo = this.table.getLayoutManager().getHorizon(hIndex + 1);
        if ((delta = --position - currInfo.getSpan()) == 0) {
            return true;
        }
        currInfo.setSpan(currInfo.getSpan() + delta);
        nextInfo.setStart(nextInfo.getStart() + delta);
        nextInfo.setSpan(nextInfo.getSpan() - delta);
        this.table.reLayoutAndPaint();
        return true;
    }

    public void freezeView(int vIndex, int hIndex) {
        KDTLayoutInfo info;
        if (vIndex == 1) {
            this.table.getLayoutManager().setVSplitButtonVisible(false);
        }
        if (hIndex == 2) {
            this.table.getLayoutManager().setHSplitButtonVisible(false);
        }
        if ((info = this.table.getLayoutManager().getVertical(vIndex)).getSplitType() == 1) {
            info.setSplitType(2);
        }
        int vCount = this.table.getVerticalCount();
        int n = vCount = this.table.isHasFoot() ? vCount - 2 : vCount - 1;
        if (vIndex < vCount) {
            info.getScrollBar().setEnabled(false);
        }
        if ((info = this.table.getLayoutManager().getVertical(vIndex - 1)).getSplitType() == 1) {
            info.setSplitType(2);
        }
        if ((info = this.table.getLayoutManager().getHorizon(hIndex)).getSplitType() == 1) {
            info.setSplitType(2);
        }
        if (hIndex < this.table.getHorizonCount() - 1) {
            info.getScrollBar().setEnabled(false);
        }
        if ((info = this.table.getLayoutManager().getHorizon(hIndex - 1)).getSplitType() == 1) {
            info.setSplitType(2);
        }
    }

    public void unFreezeView(int vIndex, int hIndex) {
        KDTLayoutInfo info;
        if (vIndex == 1) {
            this.table.getLayoutManager().setVSplitButtonVisible(true);
        }
        if (hIndex == this.table.getHorizonCount() - 1) {
            this.table.getLayoutManager().setHSplitButtonVisible(true);
        }
        if ((info = this.table.getLayoutManager().getVertical(vIndex)).getSplitType() == 2) {
            info.setSplitType(1);
        }
        info.getScrollBar().setEnabled(true);
        info = this.table.getLayoutManager().getVertical(vIndex - 1);
        if (info.getSplitType() == 2) {
            info.setSplitType(1);
        }
        if ((info = this.table.getLayoutManager().getHorizon(hIndex)).getSplitType() == 2) {
            info.setSplitType(1);
        }
        info.getScrollBar().setEnabled(true);
        info = this.table.getLayoutManager().getHorizon(hIndex - 1);
        if (info.getSplitType() == 2) {
            info.setSplitType(1);
        }
        this.table.reLayoutAndPaint();
        this.table.getDataRequestManager().doMemoryCallback(0);
    }

    public void freezeCell(int rowIndex, int colIndex) {
        if (rowIndex > this.table.getRowCount3() || colIndex > this.table.getColumnCount()) {
            return;
        }
        this.freeze(rowIndex, colIndex);
    }

    public void freezeRow(int rowIndex) {
        if (rowIndex > this.table.getRowCount()) {
            return;
        }
        this.freeze(rowIndex, -1);
    }

    public void freezeColumn(int colIndex) {
        if (colIndex > this.table.getColumnCount()) {
            return;
        }
        this.freeze(-1, colIndex);
    }

    public boolean isFreeze() {
        return this.freezeRowIndex != 0 || this.freezeColIndex != 0;
    }

    public int getFreezeRow() {
        return this.freezeRowIndex == 0 ? this.setFreezerowIndex : this.freezeRowIndex;
    }

    public int getFreezeCol() {
        return this.freezeColIndex == 0 ? this.setFreezecolIndex : this.freezeColIndex;
    }

    public void setFreezeView(int rowIndex, int colIndex) {
        this.setFreezerowIndex = rowIndex;
        this.setFreezecolIndex = colIndex;
        this.table.getLayoutManager().addCommand(this.freezeCommand);
    }

    public boolean freeze(int rowIndex, int colIndex) {
        KDTLayoutInfo info2;
        int last;
        int first;
        KDTLayoutInfo info;
        this.unFreeze();
        --colIndex;
        boolean bFreeze = false;
        if (--rowIndex >= 0) {
            info = this.table.getLayoutManager().getVertical(1);
            first = info.getFirst();
            last = info.getLast();
            if (rowIndex < first && rowIndex < last) {
                this.table.getLayoutManager().scrollRowToShow(0);
                info = this.table.getLayoutManager().getVertical(1);
                first = info.getFirst();
                last = info.getLast();
            }
            if (rowIndex >= first && rowIndex < last) {
                int posRow = this.table.getBody().getHeight(first, rowIndex);
                this.splitVertical(1, posRow, true);
                bFreeze = true;
                this.freezeRowIndex = rowIndex + 1;
                info2 = this.table.getLayoutManager().getVertical(1);
                info2.setLock(true);
                this.table.addKDTResizeListener(this);
            }
        }
        if (colIndex >= 0) {
            int posCol;
            info = this.table.getLayoutManager().getHorizon(2);
            first = info.getFirst();
            for (last = info.getLast(); last > first && this.table.getColumn(last).getStyleAttributes().isHided(); --last) {
            }
            if (colIndex < first && colIndex < last) {
                this.table.getLayoutManager().scrollColToShow(0);
                info = this.table.getLayoutManager().getHorizon(2);
                first = info.getFirst();
                last = info.getLast();
            }
            if (colIndex >= first && colIndex < last && (posCol = this.table.getColumns().getWidth(first, colIndex)) > 0) {
                this.splitHorizon(2, posCol, true);
                bFreeze = true;
                this.freezeColIndex = colIndex + 1;
                info2 = this.table.getLayoutManager().getHorizon(2);
                info2.setLock(true);
                this.table.addKDTResizeListener(this);
            }
        }
        if (bFreeze) {
            this.freezeView(1, 2);
        }
        this.table.setRefresh(true);
        this.table.reLayoutAndPaint();
        return bFreeze;
    }

    public boolean unFreeze() {
        boolean bUnfreeze = false;
        KDTLayoutManager lm = this.table.getLayoutManager();
        this.table.getLayoutManager().getVertical(1).setLock(false);
        this.table.getLayoutManager().getHorizon(2).setLock(false);
        if (!lm.getVertical(1).isEnable()) {
            this.mergeVertical(1, true);
            bUnfreeze = true;
        }
        if (!lm.getHorizon(2).isEnable()) {
            this.mergeHorizon(2, true);
            bUnfreeze = true;
        }
        if (bUnfreeze) {
            this.unFreezeView(1, 2);
            this.freezeRowIndex = 0;
            this.freezeColIndex = 0;
            this.setFreezerowIndex = 0;
            this.setFreezecolIndex = 0;
            this.table.removeKDTResizeListener(this);
        }
        this.freezeRowIndex = 0;
        this.freezeColIndex = 0;
        this.setFreezerowIndex = 0;
        this.setFreezecolIndex = 0;
        this.table.getSelectManager().setActiveViewIndex(5);
        return bUnfreeze;
    }

    public void unFreezeRow(int rowIndex) {
        if (rowIndex > this.table.getRowCount()) {
            return;
        }
        KDTVertical info = this.table.getLayoutManager().getVertical(1);
        int first = info.getFirst();
        int last = ((KDTLayoutInfo)info).getLast();
        if (--rowIndex < first || rowIndex >= last) {
            return;
        }
        this.mergeVertical(1);
        this.unFreezeView(1, 2);
    }

    public void unFreezeColumn(int colIndex) {
        if (colIndex > this.table.getColumnCount()) {
            return;
        }
        KDTHorizon info = this.table.getLayoutManager().getHorizon(2);
        int first = info.getFirst();
        int last = ((KDTLayoutInfo)info).getLast();
        if (--colIndex < first || colIndex >= last) {
            return;
        }
        this.mergeHorizon(2);
        this.unFreezeView(1, 2);
    }

    boolean isVerticalResizeable(int vIndex, int position) {
        int vCount = this.table.getVerticalCount();
        if (vIndex < 1 || vIndex >= vCount - 1) {
            return false;
        }
        int min = this.getVerticalMin(vIndex);
        int max = this.getVerticalMax(vIndex + 1);
        int maxSpan = max - min;
        return position > 0 && position < maxSpan;
    }

    boolean isHorizonResizeable(int hIndex, int position) {
        int hCount = this.table.getHorizonCount();
        if (hIndex < 2 || hIndex >= hCount - 1) {
            return false;
        }
        int min = this.getHorizonMin(hIndex);
        int max = this.getHorizonMax(hIndex + 1);
        int maxSpan = max - min;
        return position > 0 && position < maxSpan;
    }

    Point getVerticalResizeRange(int vIndex) {
        int vLast = this.table.getVerticalCount() - 1;
        if (vIndex >= 1 && vIndex < vLast) {
            KDTVertical currInfo = this.table.getLayoutManager().getVertical(vIndex);
            KDTVertical nextInfo = this.table.getLayoutManager().getVertical(vIndex + 1);
            Point p = new Point();
            p.x = currInfo.getStart();
            p.y = p.x + nextInfo.getStart() - currInfo.getStart() + nextInfo.getSpan();
            return p;
        }
        return null;
    }

    int getVerticalMin(int vIndex) {
        KDTVertical currInfo = this.table.getLayoutManager().getVertical(vIndex);
        return currInfo.getStart();
    }

    int getVerticalMax(int vIndex) {
        KDTVertical currInfo = this.table.getLayoutManager().getVertical(vIndex);
        return currInfo.getStart() + currInfo.getSpan() - 6;
    }

    int getHorizonMin(int hIndex) {
        KDTHorizon currInfo = this.table.getLayoutManager().getHorizon(hIndex);
        return currInfo.getStart();
    }

    int getHorizonMax(int hIndex) {
        KDTHorizon currInfo = this.table.getLayoutManager().getHorizon(hIndex);
        return currInfo.getStart() + currInfo.getSpan() - 6;
    }

    @Override
    public void tableColumnResize(KDTResizeEvent e) {
        int index = e.getIndex();
        if (index > this.freezeColIndex - 1) {
            return;
        }
        this.updateColumnFreeze();
    }

    @Override
    public void tableRowResize(KDTResizeEvent e) {
        int index = e.getIndex();
        if (index > this.freezeRowIndex - 1 && e.getType() != 0) {
            return;
        }
        this.updateRowFreeze();
    }

    public void updateRowFreeze() {
        int yy = this.table.getBody().getHeight(0, this.freezeRowIndex - 1);
        this.table.getViewManager().resizeVertical(1, yy);
    }

    public void updateColumnFreeze() {
        KDTHorizon info = this.table.getLayoutManager().getHorizon(2);
        int first = info.getFirst();
        int yy = this.table.getColumns().getWidth(first, this.freezeColIndex - 1);
        this.table.getViewManager().resizeHorizon(2, yy);
    }

    public void updateBounds() {
        if (!this.table.enableRepaint) {
            return;
        }
        for (int i = 0; i < this.getViewCount(); ++i) {
            BasicView view = this.getView(i);
            view.updateBounds();
        }
        this.updateRowFreeze();
        this.updateColumnFreeze();
    }

    public int getWidth() {
        int width = 0;
        int hCount = this.table.getHorizonCount();
        for (int i = 0; i < hCount; ++i) {
            BasicView view = this.getView(1, i);
            width += view.getActiveWidth();
        }
        return width;
    }

    public int getHeight() {
        this.updateBounds();
        int height = 0;
        int vCount = this.table.getVerticalCount();
        for (int i = 0; i < vCount; ++i) {
            BasicView view = this.getView(i, 2);
            height += view.getActiveHeight();
        }
        return height;
    }
}

