/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDataStyle;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class KDTableXmlTrans
implements IXmlTrans {
    private KDTable table;
    private KDFXmlReader reader;
    protected static final Namespace NS_TABLE;
    protected static final Namespace NS_COMMON;
    private Element nodeDSS;
    private Hashtable dssCache;
    private int styleID = 0;
    private KDF kdf;
    private TableRelations tableRelations;
    public static String TABLEPRINTS_NODENAME;
    public static String TABLEPRINT_NODENAME;
    public static String TABLEPRINT_NODESERVICENAME;
    public static String TABLEPRINT_NODETABLESETUP;
    public static String TABLEPRINT_NODEATTRIBUTESET;

    public KDTableXmlTrans() {
        long b = System.currentTimeMillis();
        this.dssCache = new Hashtable();
        long e = System.currentTimeMillis() - b;
        KDTable.printDebugInfo("coustruct:" + e);
    }

    public Element writeToNode(Object obj, KDF kdf) {
        if (obj instanceof KDTable) {
            this.table = (KDTable)obj;
            return this.out(kdf);
        }
        throw new IllegalArgumentException("KDTable\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7KDTable\u7c7b\u578b\u7684\u53c2\u6570");
    }

    public Object readFromNode(Element ele, KDF kdf) {
        this.kdf = kdf;
        if ("Table".equals(ele.getName())) {
            return this.readFromNode(ele, kdf.getReader());
        }
        return null;
    }

    private Object readFromNode(Element ele, KDFXmlReader reader) {
        this.reader = reader;
        this.table = new KDTable();
        this.table.getScriptManager().setRelationsObject(this.getTableRelations());
        this.parse(ele);
        return this.table;
    }

    public void readDefaultTableFromFile(KDTable table, KDF kdf) {
        this.kdf = kdf;
        this.reader = kdf.getReader();
        this.table = table;
        this.parse((Element)this.reader.getTableNodes().get(0));
    }

    Element out(KDF kdf) {
        if (null == kdf) {
            throw new IllegalArgumentException("KDTable\u5e8f\u5217\u5316\u65b9\u6cd5\u9700\u8981\u975e\u7a7a\u7684\u53c2\u6570\uff1akdf");
        }
        this.kdf = kdf;
        Element nodeKDTable = new Element("Table", kdf.getReader().getRoot().getNamespace());
        if (this.isEmptyString(this.table.getID())) {
            this.table.setID(KDF.getDefaultID());
        }
        this.setNodeAttribute(nodeKDTable, "id", this.table.getID());
        Element nodeDataStyles = new Element("DataStyles", NS_TABLE);
        nodeKDTable.addContent((Content)nodeDataStyles);
        this.nodeDSS = nodeDataStyles;
        Element nodeSheet = new Element("Sheet", NS_TABLE);
        nodeKDTable.addContent((Content)nodeSheet);
        this.buildSheet(nodeSheet);
        return nodeKDTable;
    }

    private String setDataStyles(KDTDataStyle ds) {
        if (null == ds) {
            return null;
        }
        if (this.dssCache.containsKey(ds)) {
            return (String)this.dssCache.get(ds);
        }
        Element nodeDataStyle = new Element("DataStyle", NS_TABLE);
        String dsID = "ds" + String.valueOf(this.styleID);
        ++this.styleID;
        this.dssCache.put(ds, dsID);
        this.setNodeAttribute(nodeDataStyle, "id", dsID);
        Element nodeRenderer = new Element("Renderer", NS_TABLE);
        nodeDataStyle.addContent((Content)nodeRenderer);
        Element nodeEditor = new Element("Editor", NS_TABLE);
        nodeDataStyle.addContent((Content)nodeEditor);
        this.nodeDSS.addContent((Content)nodeDataStyle);
        return dsID;
    }

    private void buildSheet(Element nodeSheet) {
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion", NS_TABLE);
        Element nodeTable = new Element("Table", NS_TABLE);
        this.buildTable(nodeTable);
        nodeSheet.addContent((Content)nodeTable);
        Element nodeOptions = new Element("SheetOptions", NS_TABLE);
        this.buildSheetOptions(nodeOptions);
        nodeSheet.addContent((Content)nodeOptions);
    }

    private void buildSheetOptions(Element nodeOptions) {
        Element nodeGridLine = new Element("GridLine", NS_TABLE);
        this.setNodeAttribute(nodeGridLine, "headVertical", this.table.isVerticalHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "headHorizon", this.table.isHorizonHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyVertical", this.table.isVerticalGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyHorizon", this.table.isHorizonGridLineVisible() ? "true" : "false");
        nodeOptions.addContent((Content)nodeGridLine);
        Element nodePrintInfo = new Element("PrintInfo", NS_TABLE);
        nodeOptions.addContent((Content)nodePrintInfo);
        this.table.getPrintManager().doNothing();
        if (this.isFormatOnly()) {
            return;
        }
        Element nodeSelections = new Element("Selections", NS_TABLE);
        nodeOptions.addContent((Content)nodeSelections);
        this.setNodeAttribute(nodeSelections, "selectMode", String.valueOf(this.table.getSelectManager().getSelectMode()));
        this.buildSelectionsNode(nodeSelections, this.table.getSelectManager().getBlocks().toArray());
        Element nodeActiveCell = new Element("ActiveCell", NS_TABLE);
        this.setNodeAttribute(nodeActiveCell, "row", String.valueOf(this.table.getSelectManager().getActiveRowIndex()));
        this.setNodeAttribute(nodeActiveCell, "column", String.valueOf(this.table.getSelectManager().getActiveColumnIndex()));
        nodeOptions.addContent((Content)nodeActiveCell);
        Element nodeMergeBlocks = new Element("MergeBlocks", NS_TABLE);
        this.buildMergeBlocks(nodeMergeBlocks, this.table.getMergeManager().getMergeBlockList().toArray(), this.table.getHeadMergeManager().getMergeBlockList().toArray());
        nodeOptions.addContent((Content)nodeMergeBlocks);
        Element nodeIndexColumn = new Element("IndexColumn", NS_TABLE);
        this.setNodeAttribute(nodeIndexColumn, "styleID", this.kdf.addSSA(this.table.getIndexColumn().getSsa()));
        this.setNodeAttribute(nodeIndexColumn, "width", String.valueOf(this.table.getIndexColumn().getRealWidth()));
        this.setNodeAttribute(nodeIndexColumn, "widthMode", String.valueOf(this.table.getIndexColumn().getWidthAdjustMode()));
        nodeOptions.addContent((Content)nodeIndexColumn);
        Element nodeExcelStyleHead = new Element("ExcelStyleHead", NS_TABLE);
        this.setNodeAttribute(nodeExcelStyleHead, "mode", String.valueOf(this.table.getHeadDisplayMode()));
        nodeOptions.addContent((Content)nodeExcelStyleHead);
    }

    private void buildSelectionsNode(Element nodeSelections, Object[] blocks) {
        KDTSelectBlock block = null;
        for (int i = 0; i < blocks.length; ++i) {
            Element nodeBlock = new Element("Block", NS_TABLE);
            block = (KDTSelectBlock)blocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            this.setNodeAttribute(nodeBlock, "mode", String.valueOf(block.getMode()));
            nodeSelections.addContent((Content)nodeBlock);
        }
    }

    private void buildMergeBlocks(Element nodeBlocks, Object[] blocks, Object[] headBlocks) {
        KDTMergeBlock block = null;
        Element nodeBlock = null;
        Element nodeHead = new Element("Head", NS_TABLE);
        for (int i = 0; i < headBlocks.length; ++i) {
            nodeBlock = new Element("Block", NS_TABLE);
            block = (KDTMergeBlock)headBlocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            nodeHead.addContent((Content)nodeBlock);
        }
        nodeBlocks.addContent((Content)nodeHead);
        Element nodeBody = new Element("Body", NS_TABLE);
        for (int i = 0; i < blocks.length; ++i) {
            nodeBlock = new Element("Block", NS_TABLE);
            block = (KDTMergeBlock)blocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            nodeBody.addContent((Content)nodeBlock);
        }
        nodeBlocks.addContent((Content)nodeBody);
    }

    private void buildTable(Element nodeTable) {
        String value;
        this.setTableAttributes(nodeTable);
        int rowCount = this.table.getIOManager().getTableRowCount();
        int colCount = this.table.getIOManager().getTableColumnCount();
        int headRowCount = this.table.getHeadRowCount();
        Element nodeColGroup = new Element("ColumnGroup", NS_TABLE);
        this.buildNodeColGroup(nodeColGroup, colCount);
        nodeTable.addContent((Content)nodeColGroup);
        Element nodeHead = new Element("Head", NS_TABLE);
        this.buildNodeHead(nodeHead, this.table.getHead(), headRowCount, colCount);
        nodeTable.addContent((Content)nodeHead);
        if (this.isFormatOnly()) {
            return;
        }
        Element nodeBody = new Element("Body", NS_TABLE);
        this.buildNodeBody(nodeBody, this.table.getBody(), rowCount, colCount);
        nodeTable.addContent((Content)nodeBody);
        Object uo = this.table.getUserObject();
        if (uo != null && (value = ObjectUtil.objectToString((Object)uo)) != null) {
            Element nodeUO = new Element("UserObject", NS_TABLE);
            nodeUO.setText(value);
            nodeTable.addContent((Content)nodeUO);
        }
    }

    private void setTableAttributes(Element nodeTable) {
        this.setNodeAttribute(nodeTable, "rowHeight", String.valueOf(this.table.getDefaultRowHeight()));
        this.setNodeAttribute(nodeTable, "headRowHeight", String.valueOf(this.table.getDefaultHeadRowHeight()));
        this.setNodeAttribute(nodeTable, "columnWidth", String.valueOf(this.table.getDefaultColumnWidth()));
        this.setNodeAttribute(nodeTable, "selectMode", String.valueOf(this.table.getSelectManager().getSelectMode()));
        this.setNodeAttribute(nodeTable, "mergeMode", String.valueOf(this.table.getMergeManager().getMergeMode()));
        this.setNodeAttribute(nodeTable, "dataRequestMode", String.valueOf(this.table.getDataRequestManager().getDataRequestMode()));
        this.setNodeAttribute(nodeTable, "pageRowCount", String.valueOf(this.table.getDataRequestManager().getPageRowCount()));
        this.setNodeAttribute(nodeTable, "name", this.table.getName());
        this.setNodeAttribute(nodeTable, "styleID", this.kdf.addSSA(this.table.getSSA()));
        this.setNodeAttribute(nodeTable, "headStyleID", this.kdf.addSSA(this.table.getHeadSSA()));
    }

    private void buildNodeColGroup(Element nodeColGroup, int colCount) {
        for (int i = 0; i < colCount; ++i) {
            IColumn col = this.table.getColumn(i);
            Element nodeCol = new Element("Column", NS_TABLE);
            this.buildColumn(nodeCol, col);
            nodeColGroup.addContent((Content)nodeCol);
        }
    }

    private void buildColumn(Element nodeCol, IColumn col) {
        String str;
        this.setNodeAttribute(nodeCol, "width", String.valueOf(col.getKDTColumn().getWidth()));
        this.setNodeAttribute(nodeCol, "key", col.getKey());
        this.setNodeAttribute(nodeCol, "objectName", col.getDataSourceName());
        this.setNodeAttribute(nodeCol, "fieldName", col.getFieldName());
        this.setNodeAttribute(nodeCol, "mergeable", String.valueOf(col.isMergeable()));
        this.setNodeAttribute(nodeCol, "group", String.valueOf(col.isGroup()));
        this.setNodeAttribute(nodeCol, "resizeable", String.valueOf(col.isResizeable()));
        this.setNodeAttribute(nodeCol, "moveable", String.valueOf(col.isMoveable()));
        this.setNodeAttribute(nodeCol, "dataStyleID", this.setDataStyles(col.getKDTColumn().getDataStyle()));
        this.setNodeAttribute(nodeCol, "styleID", this.kdf.addSSA(col.getKDTColumn().getSSA()));
        Object obj = col.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            Element nodeUO = new Element("UserObject", NS_TABLE);
            nodeUO.setText(str);
            nodeCol.addContent((Content)nodeUO);
        }
    }

    private void setNodeAttribute(Element node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        node.setAttribute(attrName, value, NS_TABLE);
    }

    private void buildNodeHead(Element nodeHead, IRows rows, int rowCount, int colCount) {
        this.buildRowsNode(nodeHead, rows, rowCount, colCount);
    }

    private void buildRowsNode(Element nodeRows, IRows rows, int rowCount, int colCount) {
        KDTRow row;
        for (int i = 0; i < rowCount && (row = rows.getRow(i)) != null; ++i) {
            Element nodeRow = new Element("Row", nodeRows.getNamespace());
            this.buildRow(nodeRow, row, colCount);
            nodeRows.addContent((Content)nodeRow);
        }
    }

    private void buildRow(Element nodeRow, KDTRow row, int colCount) {
        String str;
        this.setNodeAttribute(nodeRow, "mergeable", String.valueOf(row.isMergeable()));
        this.setNodeAttribute(nodeRow, "resizeable", String.valueOf(row.isResizeable()));
        this.setNodeAttribute(nodeRow, "height", String.valueOf(row.getHeight()));
        this.setNodeAttribute(nodeRow, "styleID", this.kdf.addSSA(row.getSSA()));
        boolean isNeedCellIndex = false;
        for (int i = 0; i < colCount; ++i) {
            KDTCell cell = row.getCell(i);
            if (cell == null || cell.isEmpty()) {
                isNeedCellIndex = true;
                continue;
            }
            Element nodeCell = new Element("Cell", NS_TABLE);
            if (isNeedCellIndex) {
                nodeCell.setAttribute("index", String.valueOf(i), NS_TABLE);
                isNeedCellIndex = false;
            }
            this.buildCell(nodeCell, row.getCell(i));
            nodeRow.addContent((Content)nodeCell);
        }
        Object obj = row.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            Element nodeUO = new Element("UserObject", NS_TABLE);
            nodeUO.setText(str);
            nodeRow.addContent((Content)nodeUO);
        }
    }

    private void buildCell(Element nodeCell, KDTCell cell) {
        ShareStyleAttributes ssa;
        String value;
        Element node;
        if (null == cell || cell.isEmpty()) {
            return;
        }
        Object obj = cell.getValue();
        if (obj instanceof String) {
            node = new Element("Value", NS_TABLE);
            node.setAttribute("type", "string", NS_TABLE);
            node.setText((String)obj);
            nodeCell.addContent((Content)node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = new Element("Value", NS_TABLE);
                node.setText(value);
                nodeCell.addContent((Content)node);
            }
        }
        obj = cell.getFormattedValue();
        if (obj instanceof String) {
            node = new Element("FormattedValue", NS_TABLE);
            node.setAttribute("type", "string", NS_TABLE);
            node.setText((String)obj);
            nodeCell.addContent((Content)node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = new Element("FormattedValue", NS_TABLE);
                node.setText(value);
                nodeCell.addContent((Content)node);
            }
        }
        obj = cell.getUserObject();
        if (obj instanceof String) {
            node = new Element("UserObject", NS_TABLE);
            node.setAttribute("type", "string", NS_TABLE);
            node.setText((String)obj);
            nodeCell.addContent((Content)node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = new Element("UserObject", NS_TABLE);
                node.setText(value);
                nodeCell.addContent((Content)node);
            }
        }
        value = cell.getExpressions();
        if (!this.isEmptyString(value)) {
            node = new Element("Expression", NS_TABLE);
            node.setText(value);
            nodeCell.addContent((Content)node);
        }
        if ((ssa = cell.getSSA()) != null) {
            this.setNodeAttribute(nodeCell, "styleID", this.kdf.addSSA(ssa));
        }
        if ((ssa = cell.getFormattedSSA()) != null) {
            this.setNodeAttribute(nodeCell, "formattedStyleID", this.kdf.addSSA(ssa));
        }
    }

    private void buildNodeBody(Element nodeBody, IRows rows, int rowCount, int colCount) {
        this.buildRowsNode(nodeBody, rows, rowCount, colCount);
    }

    void parse(Element nodeKDTable) {
        boolean autoRun = this.table.isScriptAutoRun();
        boolean autoAdjust = this.table.isScriptAutoAdjust();
        this.table.setScriptAutoRun(false);
        this.table.setScriptAutoAdjust(false);
        String id = nodeKDTable.getAttributeValue("id", NS_TABLE);
        if (!this.isEmptyString(id)) {
            this.table.setID(id);
        }
        Element nodeTable = null;
        try {
            nodeTable = nodeKDTable.getChild("Sheet", NS_TABLE).getChild("Table", NS_TABLE);
        }
        catch (Exception e) {
            return;
        }
        if (nodeTable == null) {
            return;
        }
        this.fillTable(nodeTable);
        Element nodeSheetOptions = nodeKDTable.getChild("Sheet", NS_TABLE).getChild("SheetOptions", NS_TABLE);
        if (null != nodeSheetOptions) {
            this.fillSheetOptions(nodeSheetOptions);
        }
        this.table.reLayoutAndPaint();
        this.table.setScriptAutoRun(autoRun);
        this.table.setScriptAutoAdjust(autoAdjust);
    }

    private void fillSheetOptions(Element nodeSheetOptions) {
        Element nodeESH;
        String value;
        Element nodePrintInfo = nodeSheetOptions.getChild("PrintInfo", NS_TABLE);
        this.parsePrintInfo(nodePrintInfo);
        Element nodeGridLine = nodeSheetOptions.getChild("GridLine", NS_TABLE);
        this.parseGridLine(nodeGridLine);
        Element nodeActiveCell = nodeSheetOptions.getChild("ActiveCell", NS_TABLE);
        this.parseActiveCellIndex(nodeActiveCell);
        Element nodeSelections = nodeSheetOptions.getChild("Selections", NS_TABLE);
        this.parseSelections(nodeSelections);
        Element nodeMerges = nodeSheetOptions.getChild("MergeBlocks", NS_TABLE);
        this.parseMergeBlocks(nodeMerges);
        Element nodeIndexColumn = nodeSheetOptions.getChild("IndexColumn", NS_TABLE);
        if (null != nodeIndexColumn) {
            value = nodeIndexColumn.getAttributeValue("styleID", NS_TABLE);
            if (!this.isEmptyString(value)) {
                ShareStyleAttributes ssa = this.getStyleAttributes(value);
                this.table.getIndexColumn().setSsa(ssa);
            }
            if (!this.isEmptyString(value = nodeIndexColumn.getAttributeValue("width", NS_TABLE))) {
                this.table.getIndexColumn().setRealWidth(Integer.valueOf(value));
            }
            if (!this.isEmptyString(value = nodeIndexColumn.getAttributeValue("widthMode", NS_TABLE))) {
                this.table.getIndexColumn().setWidthAdjustMode(Short.valueOf(value));
            }
        }
        if (null != (nodeESH = nodeSheetOptions.getChild("ExcelStyleHead", NS_TABLE)) && !this.isEmptyString(value = nodeESH.getAttributeValue("mode", NS_TABLE))) {
            this.table.setHeadDisplayMode(Integer.valueOf(value));
        }
    }

    private void parseMergeBlocks(Element nodeMerges) {
        if (null == nodeMerges) {
            return;
        }
        Element nodeHead = nodeMerges.getChild("Head", NS_TABLE);
        Element nodeBody = nodeMerges.getChild("Body", NS_TABLE);
        if (nodeHead != null) {
            this.parseMergePart(nodeHead, this.table.getHeadMergeManager());
        }
        if (nodeBody != null) {
            this.parseMergePart(nodeBody, this.table.getMergeManager());
        }
    }

    private void parseMergePart(Element blocksNode, KDTMergeManager merMan) {
        List nodeBlockList = blocksNode.getChildren("Block", NS_TABLE);
        Iterator iter = nodeBlockList.iterator();
        while (iter.hasNext()) {
            KDTMergeBlock block = this.parseMergeBlock((Element)iter.next());
            if (null == block) continue;
            merMan.mergeBlock(block);
        }
    }

    private KDTMergeBlock parseMergeBlock(Element nodeBlock) {
        if (null == nodeBlock) {
            return null;
        }
        KDTMergeBlock block = new KDTMergeBlock();
        try {
            String top = nodeBlock.getAttributeValue("top", NS_TABLE);
            String right = nodeBlock.getAttributeValue("right", NS_TABLE);
            String left = nodeBlock.getAttributeValue("left", NS_TABLE);
            String bottom = nodeBlock.getAttributeValue("bottom", NS_TABLE);
            if (this.isEmptyString(top) || this.isEmptyString(right) || this.isEmptyString(left) || this.isEmptyString(bottom)) {
                throw new IllegalArgumentException("\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            return block;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private void parsePrintInfo(Element nodePrintInfo) {
        if (null == nodePrintInfo) {
            return;
        }
        this.table.getPrintManager().doNothing();
    }

    private void parseGridLine(Element nodeGridLine) {
        if (null == nodeGridLine) {
            return;
        }
        String sVal = nodeGridLine.getAttributeValue("headVertical", NS_TABLE);
        this.table.setVerticalHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("headHorizon", NS_TABLE);
        this.table.setHorizonHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("bodyVertical", NS_TABLE);
        this.table.setVerticalGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttributeValue("bodyHorizon", NS_TABLE);
        this.table.setHorizonGridLineVisible(this.getBooleanFromString(sVal));
    }

    private void parseActiveCellIndex(Element nodeActiveCell) {
        if (null == nodeActiveCell) {
            return;
        }
        String rowIndex = nodeActiveCell.getAttributeValue("row", NS_TABLE);
        String colIndex = nodeActiveCell.getAttributeValue("column", NS_TABLE);
        try {
            if (!this.isEmptyString(rowIndex)) {
                this.table.getSelectManager().setActiveRowIndex(Integer.parseInt(rowIndex));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.table.getSelectManager().setActiveRowIndex(0);
        }
        try {
            if (!this.isEmptyString(colIndex)) {
                this.table.getSelectManager().setActiveColumnIndex(Integer.parseInt(colIndex));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.table.getSelectManager().setActiveColumnIndex(0);
        }
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private boolean getBooleanFromString(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    private void parseSelections(Element nodeSelections) {
        if (null == nodeSelections) {
            return;
        }
        KDTSelectManager selMan = this.table.getSelectManager();
        List nodeBlockList = nodeSelections.getChildren("Block", NS_TABLE);
        for (Element nodeBlock : nodeBlockList) {
            KDTSelectBlock block = this.parseSelectBlock(nodeBlock);
            if (null == block) continue;
            selMan.add(block);
        }
    }

    private KDTSelectBlock parseSelectBlock(Element nodeBlock) {
        if (null == nodeBlock) {
            return null;
        }
        KDTSelectBlock block = new KDTSelectBlock();
        try {
            String top = nodeBlock.getAttributeValue("top", NS_TABLE);
            String right = nodeBlock.getAttributeValue("right", NS_TABLE);
            String left = nodeBlock.getAttributeValue("left", NS_TABLE);
            String bottom = nodeBlock.getAttributeValue("bottom", NS_TABLE);
            String mode = nodeBlock.getAttributeValue("mode", NS_TABLE);
            if (this.isEmptyString(top) || this.isEmptyString(right) || this.isEmptyString(left) || this.isEmptyString(bottom)) {
                throw new IllegalArgumentException("\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            block.setMode(Integer.parseInt(mode));
            return block;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private void fillTable(Element nodeTable) {
        Object uo;
        this.fillTableAttributes(this.table, nodeTable);
        Element e = nodeTable.getChild("ColumnGroup", NS_TABLE);
        if (e != null) {
            this.fillColumns(e);
        }
        if (this.isFormatOnly()) {
            return;
        }
        e = nodeTable.getChild("Head", NS_TABLE);
        if (e != null) {
            this.fillHead(e);
        }
        if ((e = nodeTable.getChild("Body", NS_TABLE)) != null) {
            this.fillBody(e);
        }
        if ((e = nodeTable.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            this.table.setUserObject(uo);
        }
    }

    private void fillColumns(Element e) {
        List list1 = e.getChildren("Column", NS_TABLE);
        for (int i = 0; i < list1.size(); ++i) {
            Element colNode = (Element)list1.get(i);
            this.fillColAttributes(i, colNode);
        }
    }

    private void fillHead(Element e) {
        int i;
        ShareStyleAttributes ssa = this.table.getHeadSSA();
        List list1 = e.getChildren("Row", NS_TABLE);
        IRow[] rows = new IRow[list1.size()];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.table.addHeadRow(i);
        }
        StyleAttributes sa = Styles.getEmptySA();
        for (i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            Element rowNode = (Element)list1.get(i);
            this.fillRowAttributes(row, rowNode, ssa);
            List list2 = rowNode.getChildren("Cell", NS_TABLE);
            for (int j = 0; j < list2.size(); ++j) {
                ICell cell;
                Element cellNode = (Element)list2.get(j);
                int cellIndex = j;
                String value = cellNode.getAttributeValue("index", NS_TABLE);
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) == null) continue;
                this.fillCellAttributes(cell, cellNode, ssa, (ShareStyleAttributes)row.getStyleAttributes(), (ShareStyleAttributes)sa);
            }
        }
    }

    private void fillBody(Element e) {
        List list1 = e.getChildren("Row", NS_TABLE);
        ShareStyleAttributes ssa = this.table.getSSA();
        for (int i = 0; i < list1.size(); ++i) {
            IRow row = this.table.addRow(i);
            Element rowNode = (Element)list1.get(i);
            this.fillRowAttributes(row, rowNode, ssa);
            List list2 = rowNode.getChildren("Cell", NS_TABLE);
            int j = 0;
            int cellIndex = 0;
            while (j < list2.size()) {
                ICell cell;
                Element cellNode = (Element)list2.get(j);
                String value = cellNode.getAttributeValue("index", NS_TABLE);
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) != null) {
                    this.fillCellAttributes(cell, cellNode, ssa, row.getKDTRow().getSSA(), this.table.getColumn(cellIndex).getKDTColumn().getSSA());
                }
                ++j;
                ++cellIndex;
            }
        }
    }

    private void fillTableAttributes(KDTable objTable, Element objXml) {
        StyleAttributes sa;
        ShareStyleAttributes ssa;
        String attVal = objXml.getAttributeValue("columnWidth", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            objTable.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("headRowHeight", NS_TABLE))) {
            objTable.setDefaultHeadRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("rowHeight", NS_TABLE))) {
            objTable.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("selectMode", NS_TABLE))) {
            objTable.getSelectManager().setSelectMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("mergeMode", NS_TABLE))) {
            objTable.getMergeManager().setMergeMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("dataRequestMode", NS_TABLE))) {
            objTable.getDataRequestManager().setDataRequestMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("name", NS_TABLE))) {
            objTable.setName(attVal);
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("styleID", NS_TABLE))) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            this.table.setSSA(ssa);
            this.table.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("headStyleID", NS_TABLE))) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            this.table.setHeadSSA(ssa);
            this.table.setHeadStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
    }

    private ShareStyleAttributes getStyleAttributes(String id) {
        if (this.kdf != null) {
            return this.kdf.getSSA(id);
        }
        return Styles.getEmptySSA();
    }

    private void fillColAttributes(int colIndex, Element objXml) {
        Object uo;
        Element e;
        IColumn col = this.isFormatOnly() ? this.table.getColumn(colIndex) : this.table.addColumn(colIndex);
        if (col == null) {
            return;
        }
        String attVal = objXml.getAttributeValue("width", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            col.setWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("key", NS_TABLE))) {
            col.setKey(attVal);
        }
        attVal = objXml.getAttributeValue("objectName", NS_TABLE);
        String attVal2 = objXml.getAttributeValue("fieldName", NS_TABLE);
        if (!this.isEmptyString(attVal) && !this.isEmptyString(attVal2)) {
            this.table.getDataRequestManager().putBindContents(colIndex, attVal, attVal2);
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("mergeable", NS_TABLE))) {
            col.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("resizeable", NS_TABLE))) {
            col.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("moveable", NS_TABLE))) {
            col.setMoveable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("group", NS_TABLE))) {
            col.setGroup(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("styleID", NS_TABLE))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            if (this.isFormatOnly()) {
                col.setStyleAttributes(sa);
            } else {
                col.getKDTColumn().setSSA(ssa);
                col.getKDTColumn().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.table.getSSA()}));
            }
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("required", NS_TABLE)) && this.getBooleanFromString(attVal)) {
            col.setRequired(true);
        }
        if ((e = objXml.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            col.setUserObject(uo);
        }
    }

    private void fillRowAttributes(IRow objTable, Element objXml, ShareStyleAttributes fatherSSA) {
        Object uo;
        Element e;
        String attVal = objXml.getAttributeValue("height", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("mergeable", NS_TABLE))) {
            objTable.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("resizeable", NS_TABLE))) {
            objTable.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("styleID", NS_TABLE))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objTable.getKDTRow().setSSA(ssa);
            objTable.getKDTRow().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, fatherSSA}));
        }
        if ((e = objXml.getChild("UserObject", NS_TABLE)) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private void fillCellAttributes(ICell objCell, Element objXml, ShareStyleAttributes tableSSA, ShareStyleAttributes rowSSA, ShareStyleAttributes colSSA) {
        Object obj;
        String type;
        StyleAttributes sa;
        ShareStyleAttributes ssa = null;
        ShareStyleAttributes fssa = null;
        String attVal = objXml.getAttributeValue("styleID", NS_TABLE);
        if (!this.isEmptyString(attVal)) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objCell.getKDTCell().setSSA(ssa);
        }
        if (!this.isEmptyString(attVal = objXml.getAttributeValue("formattedStyleID", NS_TABLE))) {
            fssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objCell.getKDTCell().setFormattedSSA(ssa);
        }
        if (ssa != null) {
            if (fssa != null) {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{fssa, ssa, rowSSA, colSSA, tableSSA}));
            } else {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, rowSSA, colSSA, tableSSA}));
            }
        }
        if (objXml.getChildren().size() == 0) {
            attVal = objXml.getText();
            if (attVal != null) {
                objCell.setValue(attVal);
            }
            return;
        }
        Element node = objXml.getChild("FormattedValue", NS_TABLE);
        if (node != null) {
            attVal = node.getText();
            type = node.getAttributeValue("type", NS_TABLE);
            if ("string".equalsIgnoreCase(type)) {
                if (attVal != null) {
                    objCell.getKDTCell().setFormattedValue(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    objCell.getKDTCell().setFormattedValue(obj);
                }
            }
        }
        if ((node = objXml.getChild("UserObject", NS_TABLE)) != null) {
            attVal = node.getText();
            type = node.getAttributeValue("type", NS_TABLE);
            if ("string".equalsIgnoreCase(type)) {
                if (attVal != null) {
                    objCell.getKDTCell().setUserObject(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    objCell.getKDTCell().setUserObject(obj);
                }
            }
        }
        if ((node = objXml.getChild("Expression", NS_TABLE)) != null && !this.isEmptyString(attVal = node.getText())) {
            objCell.setExpressions(attVal);
        }
        if ((node = objXml.getChild("Value", NS_TABLE)) != null) {
            attVal = node.getText();
            type = node.getAttributeValue("type", NS_TABLE);
            if ("string".equalsIgnoreCase(type)) {
                if (StringUtil.isEmptyString((String)attVal)) {
                    objCell.getKDTCell().setValue(null);
                } else {
                    objCell.getKDTCell().setValue(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    if (obj instanceof String && StringUtil.isEmptyString((String)((String)obj))) {
                        objCell.getKDTCell().setValue(null);
                    } else {
                        objCell.getKDTCell().setValue(obj);
                    }
                } else if (attVal != null) {
                    if (attVal instanceof String && StringUtil.isEmptyString((String)attVal)) {
                        objCell.getKDTCell().setValue(null);
                    } else {
                        objCell.getKDTCell().setValue(attVal);
                    }
                }
            }
        }
    }

    public boolean isFormatOnly() {
        return this.table.getIOManager().isFormatOnly();
    }

    private TableRelations getTableRelations() {
        if (this.tableRelations == null) {
            this.tableRelations = new TableRelations();
        }
        return this.tableRelations;
    }

    static {
        TABLEPRINTS_NODENAME = "TablePrintSets";
        TABLEPRINT_NODENAME = "TablePrintSet";
        TABLEPRINT_NODESERVICENAME = "printerName";
        TABLEPRINT_NODETABLESETUP = "tableSetup";
        TABLEPRINT_NODEATTRIBUTESET = "attributeSet";
        NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
        NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    }
}

