/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.util.Iterator;
import java.util.List;

public class Kds2Kdt {
    public static final int DEFAULT_HEAD_ROW_COUNT = 1;
    protected static final String ERR_MSG_SPLIT_MERGE = "\u6307\u5b9a\u7684\u8868\u5934\u884c\u6570\u6709\u95ee\u9898\uff0c\u5b83\u5bfc\u81f4\u4e86\u81f3\u5c11\u4e00\u4e2a\u878d\u5408\u5757\u88ab\u5206\u5272";
    protected static final String ERR_MSG_SHEET_NULL = "\u4fe1\u606f\u6e90KDSSheet\u5bf9\u8c61\u4e0d\u80fd\u4e3anull\uff0c\u5e76\u4e14\u81f3\u5c11\u5177\u6709\u4e00\u884c\u5185\u5bb9";
    protected static final String ERR_MSG_SIZE_OVER = "\u7ed9\u5b9a\u7684\u8868\u5934\u884c\u6570\u5728\u5408\u6cd5\u8303\u56f4\u4e4b\u5916\uff0c\u5408\u6cd5\u8303\u56f4\u662f\u4ece0\u5230\u6e90KDS\u7684\u6700\u5927\u884c\u6570";

    public void parse(KDTable table, KDSSheet sheet) {
        this.parse(table, sheet, 1);
    }

    public void parse(KDTable table, KDSSheet sheet, int headRowCount) {
        this.parse(table, sheet, headRowCount, true);
    }

    public void parse(KDTable table, KDSSheet sheet, int headRowCount, boolean overwrite) {
        this.parse(table, sheet, headRowCount, overwrite, 15);
    }

    public void parse(KDTable table, KDSSheet sheet, int headRowCount, boolean overwrite, int mark) {
        if (sheet == null) {
            throw new IllegalArgumentException(ERR_MSG_SHEET_NULL);
        }
        int sheetRowCount = sheet.getExpandedRows() + 1;
        if (sheetRowCount < 0) {
            throw new IllegalArgumentException(ERR_MSG_SHEET_NULL);
        }
        if (headRowCount < 0 || headRowCount > sheetRowCount) {
            throw new IllegalArgumentException(ERR_MSG_SIZE_OVER);
        }
        if (this.splitMergeBlock(table, sheet, headRowCount)) {
            throw new IllegalArgumentException(ERR_MSG_SPLIT_MERGE);
        }
        if (table == null) {
            table = new KDTable();
            table.setName(sheet.getName());
        } else if (overwrite) {
            boolean refresh = table.isRefresh();
            table.setRefresh(false);
            table.removeColumns();
            table.setRowCount(-1);
            table.setRefresh(refresh);
        }
        sheet.getSheetStyleAttributes().setLocked(false);
        int rows = sheet.getExpandedRows();
        int cols = sheet.getExpandedColumns();
        ICells cells = sheet.getCells();
        for (int i = 0; i <= rows; ++i) {
            for (int j = 0; j <= cols; ++j) {
                cells.getCellStyleAttributes(i, j).setLocked(false);
            }
        }
        if (KDTIOManager.isStyle(mark)) {
            table.setSSA(sheet.getSSA());
            table.setStyle(sheet.getSheetStyle());
        }
        int preMode = table.getFormulaMode();
        table.setFormulaMode(1);
        this.fillColumn(table, sheet, mark);
        this.fillHead(table, sheet, headRowCount, mark);
        this.fillBody(table, sheet, headRowCount, mark);
        this.setMergeBlock(table, sheet, headRowCount, mark);
        table.setFormulaMode(preMode);
    }

    private boolean splitMergeBlock(KDTable table, KDSSheet sheet, int headRowCount) {
        KDSMergeBlock block;
        boolean result = false;
        Iterator iter = sheet.getMerges().iterator();
        while (iter.hasNext() && !this.split(block = (KDSMergeBlock)iter.next(), headRowCount)) {
        }
        return result;
    }

    private boolean split(KDSMergeBlock block, int rowIndex) {
        return block.row < rowIndex && block.getRow2() >= rowIndex;
    }

    private void setMergeBlock(KDTable table, KDSSheet sheet, int headRowCount, int mark) {
        if (!KDTIOManager.isStyle(mark)) {
            return;
        }
        for (KDSMergeBlock block : sheet.getMerges()) {
            if (block.row < headRowCount) {
                table.getHeadMergeManager().mergeBlock(block.row, block.col, block.getRow2(), block.getCol2());
                continue;
            }
            table.getMergeManager().mergeBlock(block.row - headRowCount, block.col, block.getRow2() - headRowCount, block.getCol2());
        }
    }

    private void fillColumn(KDTable table, KDSSheet sheet, int mark) {
        KDTColumns cols = table.getColumns();
        int colCount = sheet.getExpandedColumns();
        for (int i = 0; i <= colCount; ++i) {
            float width;
            KDTColumn col = cols.getColumn(i);
            if (col == null) {
                col = table.createColumn();
                cols.addColumn(i, col);
            }
            if ((width = sheet.getColumnWidth(i)) >= 0.0f) {
                col.setWidth((int)UnitConverter.mmToPx((double)width));
            }
            if (!KDTIOManager.isStyle(mark)) continue;
            col.setSSA(sheet.getColumnShareStyleAttributes(i));
            col.setStyle(sheet.getColumnStyle(i));
        }
    }

    private void fillHead(KDTable table, KDSSheet sheet, int headRowCount, int mark) {
        for (int i = 0; i < headRowCount; ++i) {
            IRow row = table.getHeadRow(i);
            if (row == null) {
                row = table.addHeadRow(i);
            }
            this.fillRow(row, sheet, i, mark);
        }
        int colCount = table.getColumnCount();
        for (int i = 0; i < headRowCount; ++i) {
            IRow row = table.getHeadRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(j);
                cell.getStyleAttributes().setBackground(table.getHeadStyle().getBackground());
            }
        }
    }

    private void fillBody(KDTable table, KDSSheet sheet, int headRowCount, int mark) {
        int size = sheet.getExpandedRows();
        List rows = table.getBody().getRows();
        for (int i = headRowCount; i <= size; ++i) {
            int rowIndex = i - headRowCount;
            IRow row = table.getRow(rowIndex);
            if (row == null) {
                KDTRow trow = table.createRow(rowIndex);
                rows.add(rowIndex, trow);
                row = table.getRow(rowIndex);
            }
            this.fillRow(row, sheet, i, mark);
        }
    }

    private void fillRow(IRow row, KDSSheet sheet, int sourceRowIndex, int mark) {
        KDSRow sourceRow = sheet.getRow(sourceRowIndex, false);
        if (sourceRow != null) {
            row.setHeight((int)UnitConverter.mmToPx((double)sourceRow.getHeight()));
            if (KDTIOManager.isStyle(mark)) {
                row.getKDTRow().setSSA(sourceRow.getSSA());
                row.getKDTRow().setStyle(sourceRow.getStyle());
            }
            int colCount = sheet.getExpandedColumns() + 1;
            for (int i = 0; i < colCount; ++i) {
                KDSCell sourceCell = sheet.getCell(sourceRowIndex, i, true);
                if (sourceCell == null) continue;
                ICell cell = row.getCell(i);
                this.fillCell(cell, sourceCell, mark);
            }
        }
    }

    private void fillCell(ICell cell, KDSCell sourceCell, int mark) {
        String formula;
        Object value;
        if (KDTIOManager.isStyle(mark)) {
            cell.getKDTCell().setSSA(sourceCell.getSSA());
            cell.getKDTCell().setStyle(sourceCell.getStyle());
        }
        if (KDTIOManager.isValue(mark) && (value = sourceCell.getValue()) != null) {
            if (value instanceof String && !((String)value).equals("")) {
                cell.setValue(value);
            } else {
                cell.setValue(value);
            }
        }
        if (KDTIOManager.isFormula(mark) && !StringUtil.isEmptyString((String)(formula = sourceCell.getFormula()))) {
            if (formula.charAt(0) != '=') {
                formula = "=" + formula;
            }
            cell.setExpressions(formula);
        }
    }
}

