/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.render.icon.TreeIcon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class CellTreeRender2
extends AbstractBasicRender {
    protected Icon cbIcon = new TreeIcon();
    private TextRender render_Text = new TextRender();

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof CellTreeNode) {
            CellTreeNode cell = (CellTreeNode)object;
            String text = cell.getValue() != null ? cell.getValue().toString() : "";
            int level = cell.getTreeLevel();
            Rectangle rect = clip.getBounds();
            int x = rect.x + level * 8;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            graphics.setColor(Color.BLACK);
            if (cell.isHasChildren()) {
                Styles.HorizontalAlignment hAlign = cellStyle.getHorizontalAlign();
                if (hAlign == Styles.HorizontalAlignment.CENTER && cell.getTreeType() != 0) {
                    Graphics2D g2d = (Graphics2D)graphics;
                    KDFont font = cellStyle.getKDFont();
                    Rectangle2D fontRect = font.getStringBounds(text, g2d.getFontRenderContext());
                    int fontWidth = (int)fontRect.getWidth();
                    if (rect.width > fontWidth) {
                        x = rect.x + level * 8 + this.cbIcon.getWidth() + (rect.width - level * 8 - this.cbIcon.getWidth() - fontWidth) / 2;
                        x -= this.cbIcon.getWidth() * 2;
                    } else {
                        x = rect.x + level * 8;
                    }
                }
                cell.setIconPosition(x, y, this.cbIcon.getWidth());
                if (cell.isCollapse()) {
                    this.cbIcon.paint((Object)new Integer(1), graphics, x, y);
                } else {
                    this.cbIcon.paint((Object)new Integer(2), graphics, x, y);
                }
            } else {
                this.cbIcon.paint((Object)new Integer(0), graphics, x, y);
            }
            if (cell.getTreeType() == 0) {
                int space = level * 8 + this.cbIcon.getWidth();
                rect.setRect(x + this.cbIcon.getWidth() + 8, rect.y, rect.getWidth() - (double)space, rect.getHeight());
                this.render_Text.draw(graphics, (Shape)rect, text, cellStyle);
            } else {
                int space = level * 8 + this.cbIcon.getWidth();
                x = cell.isHasChildren() ? rect.x + space : rect.x;
                rect.setRect(x, rect.y, rect.getWidth() - (double)space, rect.getHeight());
                this.render_Text.draw(graphics, (Shape)rect, text, cellStyle);
            }
        }
    }

    public float getPreferredWidth(Graphics g, Shape clip, String text, Style style, Object extObj) {
        if (extObj instanceof CellTreeNode) {
            CellTreeNode cell = (CellTreeNode)extObj;
            text = cell.getValue() == null ? null : cell.getValue().toString();
            return super.getPreferredWidth(g, clip, text, style, null) + (float)((cell.getTreeLevel() + 1) * 8) + (float)this.cbIcon.getWidth();
        }
        return super.getPreferredWidth(g, clip, text, style, null);
    }
}

