/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaLoader;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.ConnectionImpl;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public final class Driver {
    public static Logger logger = CommonLogger.getLogger(Driver.class);
    private static boolean useRolap = false;

    public Driver() {
        String str = System.getProperty("rolap");
        if (str != null && str.equalsIgnoreCase("true")) {
            useRolap = true;
        }
    }

    public static Connection openConnection(InputStream schemaDefInputStream, Map param) throws OLAPException {
        return Driver.openConnection(schemaDefInputStream, param, useRolap);
    }

    public static Connection openConnection(InputStream schemaDefInputStream, Map param, boolean useRolap) throws OLAPException {
        return Driver.openConnection(SchemaLoader.load(schemaDefInputStream), param, useRolap);
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param) throws OLAPException {
        return Driver.openConnection(schemaDef, param, useRolap);
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param, boolean rolap) throws OLAPException {
        try {
            if (rolap) {
                return Driver.openRolapConnection(schemaDef, param);
            }
            return Driver.openConnection(OLAPEngine.build(schemaDef, param));
        }
        catch (SQLException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Can't open olap connection.", (Throwable)e);
            }
            throw new OLAPException(e);
        }
    }

    public static Connection openConnection(OLAPDatabase db) {
        return new ConnectionImpl(db);
    }

    public static Connection openRolapConnection(InputStream schemaDef, Map params) throws OLAPException {
        return new RelConnectionImpl(SchemaLoader.load(schemaDef), params);
    }

    public static Connection openRolapConnection(SchemaDef schemaDef, Map params) throws OLAPException {
        return new RelConnectionImpl(schemaDef, params);
    }

    public static Connection openRolapConnection(SchemaDef schemaDef, Map param, java.sql.Connection jdbcConnection) throws OLAPException {
        return new RelConnectionImpl(schemaDef, param, jdbcConnection);
    }

    public static Connection openRolapConnection(SchemaDef schemaDef, Map param, DataSource dataSource) throws OLAPException {
        return new RelConnectionImpl(schemaDef, param, dataSource);
    }

    public static Connection openRemoteConnection(RemoteInvoke remoteInvoke) throws OLAPException {
        return new RemoteConnection(remoteInvoke);
    }
}

