/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.collection;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.collection.ArrayList;
import com.kingdee.bos.olap.collection.CacheableListWrapper;
import com.kingdee.bos.olap.collection.CacheableMemberListWrapper;
import com.kingdee.bos.olap.collection.IInnerList;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.collection.IStorageManager;
import com.kingdee.bos.olap.collection.JoinList;
import com.kingdee.bos.olap.collection.ListStorageManager;
import com.kingdee.bos.olap.collection.ListWrapper;
import com.kingdee.bos.olap.collection.UnionList;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.SchemaReader;

public class CacheableListFactory
implements IListFactory {
    IStorageManager storageManager;

    public CacheableListFactory(MdxQuery query) {
        SchemaReader schemaReader = query.getSchemaReader();
        Cube cube = query.getCube();
        this.storageManager = new ListStorageManager(schemaReader, cube);
    }

    public CacheableListFactory(SchemaReader schemaReader, Cube cube) {
        this.storageManager = new ListStorageManager(schemaReader, cube);
    }

    @Override
    public IList createArrayList(int capacity) {
        return new CacheableListWrapper(new ArrayList(capacity), this.storageManager);
    }

    @Override
    public IList createArrayList() {
        return new CacheableListWrapper(new ArrayList(), this.storageManager);
    }

    @Override
    public IList createArrayList(Object[] array) {
        if (array == null) {
            return IList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new CacheableListWrapper(list, this.storageManager);
    }

    @Override
    public IMemberList createMemberList(int capacity) {
        return new CacheableMemberListWrapper(new ArrayList(capacity), this.storageManager);
    }

    @Override
    public IMemberList createMemberList() {
        return new CacheableMemberListWrapper(new ArrayList(), this.storageManager);
    }

    @Override
    public IMemberList createMemberList(Member[] array) {
        if (array == null) {
            return IMemberList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new CacheableMemberListWrapper(list, this.storageManager);
    }

    @Override
    public IList createJoinList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new CacheableListWrapper(new JoinList(innerList1, innerList2), this.storageManager);
    }

    @Override
    public IList createUnionList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new CacheableListWrapper(new UnionList(innerList1, innerList2), this.storageManager);
    }

    @Override
    public void release() {
        if (this.storageManager != null) {
            this.storageManager.release();
        }
    }
}

