/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.collection;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.ArrayList;
import com.kingdee.bos.olap.collection.IStorageManager;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mem.storage.Bucket;
import com.kingdee.bos.olap.mem.storage.BucketStorageManager;
import com.kingdee.bos.olap.mem.storage.PropertySet;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ListStorageManager
implements IStorageManager {
    private static Logger logger = CommonLogger.getLogger(ListStorageManager.class);
    private BucketStorageManager bsm;
    HashMap index = new HashMap();
    private PropertySet ps;
    OutputStreamAgent[] agents;
    int poolSize = 5;
    SchemaReader schemaReader;
    Cube cube;
    int id = 0;

    public ListStorageManager(SchemaReader schemaReader, Cube cube) {
        this(PropertySet.getSystemPropertySet(), schemaReader, cube);
    }

    public ListStorageManager(PropertySet ps, SchemaReader schemaReader, Cube cube) {
        this.ps = ps;
        this.schemaReader = schemaReader;
        this.cube = cube;
    }

    private void initBSM() throws IOException {
        this.bsm = new BucketStorageManager(this.ps);
        logger.debug((Object)("Init storage manager.file name is:" + this.bsm.getFileName()));
        this.agents = new OutputStreamAgent[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            this.agents[i] = new OutputStreamAgent();
        }
    }

    private synchronized int makeId() {
        return this.id++;
    }

    private synchronized OutputStreamAgent getOutputStreamAgent() {
        for (int i = 0; i < this.poolSize; ++i) {
            if (this.agents[i].used) continue;
            if (this.agents[i].boas == null) {
                this.agents[i].init();
            }
            this.agents[i].used = true;
            return this.agents[i];
        }
        OutputStreamAgent agent = new OutputStreamAgent();
        agent.init();
        return agent;
    }

    @Override
    public int saveArrayList(ArrayList list) throws IOException {
        int i;
        if (this.bsm == null) {
            this.initBSM();
        }
        OutputStreamAgent agent = this.getOutputStreamAgent();
        ByteArrayOutputStream baos = agent.boas;
        int size = list.size();
        baos.writeInt(size);
        int card = -1;
        Object first = list.getFirst();
        int type = 0;
        if (first instanceof Member) {
            type = 0;
            card = 1;
        } else if (first instanceof Member[]) {
            type = 1;
            card = ((Member[])first).length;
        } else if (first instanceof Object[]) {
            Object[] objects = (Object[])first;
            if (!(objects[0] instanceof Member)) {
                throw new IllegalArgumentException("Unsupported object type to save:" + objects[0].getClass().toString());
            }
            type = 2;
            card = objects.length;
        }
        baos.writeInt(type);
        baos.writeInt(card);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (type == 0) {
                Member member = (Member)o;
                ListStorageManager.writeString(member.getUniqueName(), baos);
                continue;
            }
            Object[] objects = (Object[])o;
            for (int i2 = 0; i2 < card; ++i2) {
                Member member = (Member)objects[i2];
                ListStorageManager.writeString(member.getUniqueName(), baos);
            }
        }
        baos.flush();
        byte[] bs = baos.toByteArray();
        baos.reset();
        agent.used = false;
        int length = bs.length;
        int bucketLength = this.bsm.canUseBucketSize();
        int count = (length += 4) / bucketLength;
        int residue = length % bucketLength;
        if (residue > 0) {
            ++count;
        }
        Bucket[] buckets = this.bsm.allocBucket(count);
        int[] bucketIds = new int[count];
        for (i = 0; i < count; ++i) {
            bucketIds[i] = buckets[i].id;
        }
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                buckets[i].writeInt(length);
                if (count == 1 && residue > 0) {
                    buckets[i].writeBytes(bs, 0, residue - 4);
                } else {
                    buckets[i].writeBytes(bs, 0, bucketLength - 4);
                }
            } else if (i == count - 1 && residue > 0) {
                buckets[i].writeBytes(bs, i * bucketLength - 4, residue);
            } else {
                buckets[i].writeBytes(bs, i * bucketLength - 4, bucketLength);
            }
            buckets[i].flush();
        }
        int id = this.makeId();
        this.index.put(new Integer(id), bucketIds);
        logger.debug((Object)("Save arraylist of id:" + id));
        return id;
    }

    @Override
    public ArrayList getArrayList(int cacheId) throws IOException, OLAPException {
        int[] bucketIds = null;
        bucketIds = (int[])this.index.get(new Integer(cacheId));
        if (bucketIds == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bsm.canUseBucketSize() * bucketIds.length);
        for (int i = 0; i < bucketIds.length; ++i) {
            Bucket bucket = this.bsm.getBucket(bucketIds[i]);
            bucket.readFully();
            baos.write(bucket.toByteArray());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        bais.readInt();
        int size = bais.readInt();
        ArrayList list = new ArrayList(size);
        int type = bais.readInt();
        int card = bais.readInt();
        for (int i = 0; i < size; ++i) {
            String uniqueName;
            Object[] members;
            if (type == 0) {
                String uniqueName2 = ListStorageManager.readString(bais);
                Member member = this.schemaReader.getMemberByUniqueName(this.cube, uniqueName2);
                list.innerAdd(member);
                continue;
            }
            if (type == 1) {
                members = new Member[card];
                for (int j = 0; j < card; ++j) {
                    uniqueName = ListStorageManager.readString(bais);
                    members[j] = this.schemaReader.getMemberByUniqueName(this.cube, uniqueName);
                }
                list.innerAdd(members);
                continue;
            }
            members = new Object[card];
            for (int j = 0; j < card; ++j) {
                uniqueName = ListStorageManager.readString(bais);
                members[j] = this.schemaReader.getMemberByUniqueName(this.cube, uniqueName);
            }
            list.innerAdd(members);
        }
        return list;
    }

    @Override
    public void remove(int id) throws IOException {
        logger.debug((Object)("remove cache id:" + id));
        int[] bucketIds = (int[])this.index.get(new Integer(id));
        if (bucketIds != null) {
            this.bsm.deleteBucket(bucketIds);
        }
    }

    private static String readString(ByteArrayInputStream bais) throws IOException {
        int length = bais.readInt();
        byte[] bytes = new byte[length];
        bais.readFully(bytes);
        return new String(bytes, "UTF-8");
    }

    private static void writeString(String str, ByteArrayOutputStream baos) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        baos.writeInt(bytes.length);
        baos.write(bytes);
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ListStorageManager.writeString("[aaa].[\u4e2d\u56fd]", baos);
        ListStorageManager.writeString("[aaa].[555\u56fd]", baos);
        ListStorageManager.writeString("[aaa].[333\u56fd]", baos);
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        String str = ListStorageManager.readString(bais);
        System.out.println(str);
        str = ListStorageManager.readString(bais);
        System.out.println(str);
        str = ListStorageManager.readString(bais);
        System.out.println(str);
    }

    @Override
    public void release() {
        if (this.bsm != null) {
            this.bsm.release();
        }
    }

    class OutputStreamAgent {
        ByteArrayOutputStream boas;
        boolean used = false;

        OutputStreamAgent() {
        }

        void init() {
            this.boas = new ByteArrayOutputStream(16384);
        }
    }
}

