/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.dbsource;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.Table;
import java.util.Hashtable;

public class ArrayTable
implements Table {
    private Object[][] values;
    private String[] columnNames;
    private int[] columnTypes;
    private int colCount;
    private int rowCount;
    private int cursor = -1;
    private Hashtable columns = new Hashtable();

    public ArrayTable(Object[][] values, String[] columnNames, int[] columnTypes) {
        this.values = values;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.colCount = columnNames.length;
        this.rowCount = values.length;
        for (int i = 0; i < this.colCount; ++i) {
            this.columns.put(columnNames[i].toLowerCase(), new Integer(i));
        }
    }

    @Override
    public int getColumnCount() throws OLAPException {
        return this.colCount;
    }

    @Override
    public int getColumnType(int index) throws OLAPException {
        if (index < 0 || index >= this.colCount) {
            throw new OLAPException("Index " + index + " is illegal.");
        }
        return this.columnTypes[index];
    }

    @Override
    public int getColumnIndex(String name) throws OLAPException {
        Integer index = (Integer)this.columns.get(name.toLowerCase());
        if (index == null) {
            throw new OLAPException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public String[] getColumnNames() throws OLAPException {
        return this.columnNames;
    }

    @Override
    public boolean next() throws OLAPException {
        ++this.cursor;
        return this.cursor < this.rowCount;
    }

    @Override
    public Object getValue(int index) throws OLAPException {
        if (index < 0 || index >= this.colCount) {
            throw new OLAPException("Index " + index + " is illegal.");
        }
        return this.values[this.cursor][index];
    }

    @Override
    public Object[] getValues() throws OLAPException {
        return this.values[this.cursor];
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.cursor = -1;
    }
}

