/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.def;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaParser;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class SchemaLoader {
    private static Logger logger = CommonLogger.getLogger(SchemaLoader.class);

    public static SchemaDef load(InputStream in) throws OLAPException {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Bad schema document.", (Throwable)e);
            }
            throw new OLAPException("Bad schema document.", e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open the schema input stream.", (Throwable)e);
            }
            throw new OLAPException("Unable to open the schema input stream.", e);
        }
        return SchemaParser.parse(doc);
    }
}

