/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.DimensionUsageInfo;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.SlicerCompoundMember;
import com.kingdee.bos.olap.base.EvaluatorImpl;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.DelegatingSchemaReader;
import com.kingdee.bos.olap.mdx.DimensionProperty;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.MemberProperty;
import com.kingdee.bos.olap.mdx.QueryAxis;
import com.kingdee.bos.olap.mdx.QueryObject;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Set;
import com.kingdee.bos.olap.mdx.StackExpResolver;
import com.kingdee.bos.olap.mdx.calc.BooleanCalc;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.ListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.BetterScalarExpCompiler;
import com.kingdee.bos.olap.mdx.type.SetType;
import com.kingdee.bos.olap.mdx.type.TupleType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.impl.ConnectionImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.rel.RelCellReaderImpl;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.Walkable;
import com.kingdee.bos.olap.util.Walker;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MdxQuery
extends QueryObject
implements Serializable {
    static Logger logger = CommonLogger.getLogger(MdxQuery.class);
    List formulas = new ArrayList();
    Map paraMap = new Hashtable();
    ArrayList axisDef = null;
    String cubeName;
    transient Connection connection;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = null;
    private Calc[] axisCalcs = null;
    private Calc slicerCalc = null;
    private List cellCalculations = null;
    private HashMap slicerCompoundMembers;
    QuerySchemaReader schemaReader = null;
    IListFactory listFactory = null;

    public void afterParse(Connection cn) throws OLAPException {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.connection = cn;
        this.resolve();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ExpResolver createExpResolver() throws OLAPException {
        Cube cube = this.connection.getSchemaReader().getCube(this.cubeName);
        if (cube == null) {
            throw new OLAPException("Cube named " + this.cubeName + " not found.");
        }
        StackExpResolver resolver = new StackExpResolver(this);
        return resolver;
    }

    private ExpCompiler createCompiler(ExpResolver resolver) {
        BetterScalarExpCompiler compiler = new BetterScalarExpCompiler(resolver);
        return compiler;
    }

    public void resolve() throws OLAPException {
        ExpResolver resolver = this.createExpResolver();
        this.resolve(resolver);
        if (this.getConnection() instanceof RemoteConnection) {
            return;
        }
        ExpCompiler compiler = this.createCompiler(resolver);
        this.compile(compiler);
    }

    public void resolve(ExpResolver resolver) throws OLAPException {
        Cube cube;
        if (this.formulas != null) {
            Formula formula;
            int i;
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = (Formula)this.formulas.get(i);
                formula.createElement(resolver.getQuery());
            }
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = (Formula)this.formulas.get(i);
                resolver.resolve(formula);
            }
        }
        if ((cube = this.getCube()).getCalculatedMembers() != null) {
            CalculatedMember[] members = cube.getCalculatedMembers();
            for (int i = 0; i < members.length; ++i) {
                resolver.resolve(members[i].getFormula());
            }
        }
        if (this.axes != null) {
            for (int i = 0; i < this.axes.length; ++i) {
                resolver.resolve(this.axes[i]);
            }
        }
        if (this.slicer != null) {
            this.slicer = this.slicer.resolve(resolver);
        }
    }

    public Calc compileExpression(Exp exp, boolean scalar) throws OLAPException {
        ExpResolver resolver = this.createExpResolver();
        ExpCompiler compiler = this.createCompiler(resolver);
        Calc calc = scalar ? compiler.compileScalar(exp, false) : exp.compile(compiler);
        return calc;
    }

    public Calc getCellCalculation(Evaluator evaluator) throws OLAPException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        Member[] context = evaluator.getCurrentMembers();
        for (int i = this.cellCalculations.size() - 1; i >= 0; --i) {
            CellCalculationInfo info = (CellCalculationInfo)this.cellCalculations.get(i);
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                if (!Util.tupleContains(context, members)) continue;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
        }
        return null;
    }

    private void compile(ExpCompiler compiler) throws OLAPException {
        if (this.formulas != null && !this.formulas.isEmpty()) {
            for (Formula formula : this.formulas) {
                if (!formula.isCellCalculation()) continue;
                ListCalc listCalc = compiler.compileList(formula.scope);
                Calc calc = compiler.compileScalar(formula.exp, true);
                Exp condition = formula.getCondition();
                BooleanCalc conditionCalc = null;
                if (condition != null) {
                    try {
                        conditionCalc = compiler.compileBoolean(condition);
                    }
                    catch (ClassCastException e) {
                        throw new OLAPException("Cell Calculation Condition must be Boolean,but " + condition.toMdx() + " is not.");
                    }
                }
                if (this.cellCalculations == null) {
                    this.cellCalculations = new ArrayList();
                }
                this.cellCalculations.add(new CellCalculationInfo(listCalc, calc, conditionCalc));
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler);
            }
        }
        if (this.slicer != null) {
            this.slicerCalc = compiler.compile(this.slicer);
        }
    }

    public SlicerCompoundMember getSlicerCompoundMember(String uniqueName) {
        if (this.slicerCompoundMembers == null) {
            return null;
        }
        return (SlicerCompoundMember)this.slicerCompoundMembers.get(uniqueName);
    }

    public SlicerCompoundMember addSlicerCompoundMember(Hierarchy hier, Member[] members) {
        if (this.slicerCompoundMembers == null) {
            this.slicerCompoundMembers = new HashMap(5);
        }
        SlicerCompoundMember m = (SlicerCompoundMember)hier.createSlicerCompoundMember(this.slicerCompoundMembers.size(), members);
        this.slicerCompoundMembers.put(m.getUniqueName(), m);
        return m;
    }

    public SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = new QuerySchemaReader(this.connection.getSchemaReader());
        }
        return this.schemaReader;
    }

    List getDefinedMembers() {
        ArrayList<OLAPElement> definedMembers = new ArrayList<OLAPElement>();
        for (int i = 0; i < this.formulas.size(); ++i) {
            Formula formula = (Formula)this.formulas.get(i);
            if (!formula.isMember() || formula.getElement() == null) continue;
            definedMembers.add(formula.getElement());
        }
        return definedMembers;
    }

    public Member lookupMemberFromDefined(String s) {
        for (Member mdxMember : this.getDefinedMembers()) {
            if (!mdxMember.getUniqueName().equalsIgnoreCase(s)) continue;
            return mdxMember;
        }
        return null;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public Cube getCube() {
        return this.connection.getSchemaReader().getCube(this.cubeName);
    }

    public String getCubeName() {
        if (this.cubeName.charAt(0) == '[' && this.cubeName.charAt(this.cubeName.length() - 1) == ']') {
            return this.cubeName.substring(1, this.cubeName.length() - 1);
        }
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    public boolean hasFormulas() {
        return this.formulas.size() > 0;
    }

    public String toString() {
        try {
            this.resolve();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.toMdx();
    }

    @Override
    public String toMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cubeName);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        return mdx.toString();
    }

    public Object clone() {
        MdxQuery cloned = new MdxQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Object> clonedFormulas = new ArrayList<Object>();
            for (Formula form : this.formulas) {
                clonedFormulas.add(form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            for (int i = 0; i < clonedAxes.length; ++i) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCubeName("[" + this.getCubeName() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    public Map getParaMap() {
        return this.paraMap;
    }

    public Formula addFormula(String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        Formula newFormula = new Formula(names, exp, memberProperties, cacheType);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public void removeFormula(Formula formula) {
        this.formulas.remove(formula);
    }

    public Formula addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public Formula addFormula(String[] names, Exp scope, Exp exp, MemberProperty[] memberProperties) {
        Formula formula = new Formula(names, scope, exp, memberProperties);
        this.formulas.add(formula);
        return formula;
    }

    public void removeFormula(String uniqueName) {
        Iterator iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = (Formula)iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getExp();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            DimensionProperty[] dimProps0 = this.axes[0].getResolvedProps();
            DimensionProperty[] dimProps1 = this.axes[1].getResolvedProps();
            Exp e1 = this.axes[1].getExp();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setExp(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[1].setResolvedProps(dimProps0);
            this.axes[0].setExp(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
            this.axes[0].setResolvedProps(dimProps1);
        }
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        return this.collectHierarchies(axis == -1 ? this.slicer : this.axes[axis].getExp());
    }

    private Hierarchy[] collectHierarchies(Exp queryPart) {
        Type type = queryPart.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            Type[] types = ((TupleType)type).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < types.length; ++i) {
                Hierarchy hierarchy = types[i].getHierarchy();
                hierarchyList.add(hierarchy);
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{type.getHierarchy()};
    }

    public Evaluator createEvalutor(MdxQuery query) throws OLAPException {
        if (query.getConnection().isRolap()) {
            RelCubeImpl cube = (RelCubeImpl)query.getCube();
            RelConnectionImpl cn = (RelConnectionImpl)query.getConnection();
            RelCellReaderImpl cellReader = new RelCellReaderImpl(cube);
            EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
            return evaluator;
        }
        CubeImpl cube = (CubeImpl)query.getCube();
        ConnectionImpl cn = (ConnectionImpl)query.getConnection();
        CellReader cellReader = cn.getCellReader(cube);
        EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
        return evaluator;
    }

    public Calc[] getAxisCalcs() {
        return this.axisCalcs;
    }

    public Calc getSlicerCalc() {
        return this.slicerCalc;
    }

    public void setAxisCalcs(Calc[] axisCalcs) {
        this.axisCalcs = axisCalcs;
    }

    public void setSlicerCalc(Calc slicerCalc) {
        this.slicerCalc = slicerCalc;
    }

    public Member[] getCalculatedMembers() throws OLAPException {
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        return this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName));
    }

    public Member[] getCalculatedMembersInQueryAxis(QueryAxis queryAxis) {
        List definedMembers;
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        if ((definedMembers = this.getDefinedMembers()).size() == 0) {
            return null;
        }
        String mdx = queryAxis.getExp().toMdx();
        Hierarchy[] hiers = this.collectHierarchies(queryAxis.getExp());
        ArrayList<Member> list = new ArrayList<Member>();
        for (int i = 0; i < hiers.length; ++i) {
            Member[] members = this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName), hiers[i]);
            for (int j = 0; j < members.length; ++j) {
                if (mdx.indexOf(members[j].getUniqueName()) <= -1) continue;
                list.add(members[j]);
            }
        }
        return list.toArray(new Member[0]);
    }

    public IListFactory getListFactory() {
        if (this.listFactory == null) {
            this.listFactory = DefaultListFactory.instance;
        }
        return this.listFactory;
    }

    public synchronized void release() {
        if (this.listFactory != null) {
            this.listFactory.release();
            this.listFactory = null;
        }
    }

    public String getDataDrillSql(Cell cell) throws OLAPException {
        if (!this.connection.isRolap()) {
            return null;
        }
        RelConnectionImpl rcon = (RelConnectionImpl)this.connection;
        String factTableName = rcon.getFactTableName();
        String factSql = rcon.getTableDef((String)factTableName).sql;
        DimensionUsageInfo[] duis = rcon.getDimensionUsageInfos();
        ArrayList<Member> list = new ArrayList<Member>();
        ArrayList<Member> excluded = new ArrayList<Member>();
        HashMap<Dimension, Member> mapMember = new HashMap<Dimension, Member>();
        HashMap<Dimension, DimensionUsageInfo> mapUsageInfo = new HashMap<Dimension, DimensionUsageInfo>();
        HashMap<Dimension, SharedDimensionDef> mapDimDef = new HashMap<Dimension, SharedDimensionDef>();
        HashMap<Dimension, LevelDef> mapLevelDef = new HashMap<Dimension, LevelDef>();
        SchemaDef schemaDef = rcon.getSchemaDef();
        Member[] memberContext = cell.getMemberContext();
        for (int i = 0; i < memberContext.length; ++i) {
            Member m = memberContext[i];
            if (m.isMeasure()) continue;
            if (m.isCalculated()) {
                return null;
            }
            mapMember.put(m.getDimension(), m);
            SharedDimensionDef dimDef = schemaDef.getDimensionDef(m.getDimension().getName());
            mapDimDef.put(m.getDimension(), dimDef);
            LevelDef levelDef = m.getLevel().getLevelDef();
            mapLevelDef.put(m.getDimension(), levelDef);
            for (int j = 0; j < duis.length; ++j) {
                if (!duis[j].dimName.equals(m.getDimension().getName())) continue;
                mapUsageInfo.put(m.getDimension(), duis[j]);
            }
            list.add(m);
            if (!m.isInner() && !m.isAll()) continue;
            excluded.add(m);
        }
        java.sql.Connection jdbcConnection = null;
        try {
            String sql;
            jdbcConnection = rcon.getJdbcConnection();
            SqlQuery sqlquery = new SqlQuery(jdbcConnection.getMetaData());
            sqlquery.addFromQuery(factSql, "drillFact");
            for (int i = 0; i < list.size(); ++i) {
                LevelDef levelDef;
                SharedDimensionDef dimDef;
                Member m = (Member)list.get(i);
                DimensionUsageInfo dui = (DimensionUsageInfo)mapUsageInfo.get(m.getDimension());
                String dimAlias = "drillDim_" + dui.dimName;
                sqlquery.addFromQuery(rcon.getTableDef((String)dui.dimTable).sql, dimAlias);
                sqlquery.addWhere("drillFact." + dui.dimForeignKey, "=", dimAlias + "." + dui.dimPrimaryKey);
                if (m.getDimension().isTimeDimension()) {
                    ArrayList<String> timeSelection = new ArrayList<String>();
                    ArrayList<String> timeAliasSelection = new ArrayList<String>();
                    if (excluded.contains(m)) {
                        dimDef = schemaDef.getDimensionDef(m.getDimension().getName());
                        LevelDef[] levelDefs = dimDef.hierarchies[0].levels;
                        boolean isDateTimeColumn = "true".equalsIgnoreCase(levelDefs[0].isDateTimeColumn);
                        for (int j = 0; j < levelDefs.length; ++j) {
                            String q = isDateTimeColumn ? sqlquery.getDateColumnFormater(rcon.getDBType()).formatDateColumn(Util.getLevelType(levelDefs[j].type), dimAlias + "." + levelDefs[j].column) : dimAlias + "." + levelDefs[j].column;
                            sqlquery.addSelect(q, Util.getTimeLevelCaption(levelDefs[j]));
                        }
                        continue;
                    }
                    LevelDef levelDef2 = m.getLevel().getLevelDef();
                    boolean isDateTimeColumn = "true".equalsIgnoreCase(levelDef2.isDateTimeColumn);
                    String q = isDateTimeColumn ? sqlquery.getDateColumnFormater(rcon.getDBType()).formatDateColumn(Util.getLevelType(levelDef2.type), dimAlias + "." + levelDef2.column) : dimAlias + "." + levelDef2.column;
                    sqlquery.addWhere(q, "=", this.makeSqlValue(sqlquery, m.getKey()));
                    timeSelection.add(q);
                    timeAliasSelection.add(Util.getTimeLevelCaption(m.getLevel()));
                    while (m.getParentMember() != null && !m.getParentMember().isAll()) {
                        m = m.getParentMember();
                        levelDef2 = m.getLevel().getLevelDef();
                        q = isDateTimeColumn ? sqlquery.getDateColumnFormater(rcon.getDBType()).formatDateColumn(Util.getLevelType(levelDef2.type), dimAlias + "." + levelDef2.column) : dimAlias + "." + levelDef2.column;
                        sqlquery.addWhere(q, "=", this.makeSqlValue(sqlquery, m.getKey()));
                        timeSelection.add(q);
                        timeAliasSelection.add(Util.getTimeLevelCaption(m.getLevel()));
                    }
                    for (int k = timeSelection.size() - 1; k >= 0; --k) {
                        sqlquery.addSelect((String)timeSelection.get(k), (String)timeAliasSelection.get(k));
                    }
                    continue;
                }
                if (!excluded.contains(m)) {
                    levelDef = m.getLevel().getLevelDef();
                    String q = levelDef.column;
                    if (m.getDimension().isParentChildrenDimension() && m.getDimension().getHierarchy().isAggregate()) {
                        if (m.isLeaf()) {
                            sqlquery.addWhere(dimAlias + "." + q, "=", this.makeSqlValue(sqlquery, m.getKey()));
                        } else {
                            sqlquery.addWhere(dimAlias + "." + q, "", this.makeSqlInValue(sqlquery, m));
                        }
                    } else {
                        sqlquery.addWhere(dimAlias + "." + q, "=", this.makeSqlValue(sqlquery, m.getKey()));
                    }
                    dimDef = schemaDef.getDimensionDef(m.getDimension().getName());
                    levelDef = m.getDimension().isParentChildrenDimension() ? dimDef.hierarchies[0].levels[0] : dimDef.hierarchies[0].levels[dimDef.hierarchies[0].levels.length - 1];
                    q = Util.getLevelCaptionColumn(levelDef);
                    sqlquery.addSelect(dimAlias + "." + q, m.getDimension().getCaption());
                    continue;
                }
                SharedDimensionDef dimDef2 = schemaDef.getDimensionDef(m.getDimension().getName());
                levelDef = m.getDimension().isParentChildrenDimension() ? dimDef2.hierarchies[0].levels[0] : dimDef2.hierarchies[0].levels[dimDef2.hierarchies[0].levels.length - 1];
                String q = levelDef.column;
                q = Util.getLevelCaptionColumn(levelDef);
                sqlquery.addSelect(dimAlias + "." + q, m.getDimension().getCaption());
            }
            CubeDef cubeDef = schemaDef.cubes[0];
            for (int i = 0; i < cubeDef.measures.length; ++i) {
                String caption = cubeDef.measures[i].caption;
                if (caption == null) {
                    caption = cubeDef.measures[i].name;
                }
                sqlquery.addSelect("drillFact." + cubeDef.measures[i].column, caption);
            }
            String string = sql = sqlquery.toString();
            return string;
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String makeSqlValue(SqlQuery sqlQuery, Object value) {
        if (value instanceof String) {
            return "'" + value.toString() + "'";
        }
        return value.toString();
    }

    private String makeSqlInValue(SqlQuery sqlQuery, Member m) {
        StringBuffer sb = new StringBuffer(" in (");
        Walker walker = new Walker(new MemberWalkable(m));
        int i = 0;
        while (walker.hasMoreElements()) {
            MemberWalkable w = (MemberWalkable)walker.nextElement();
            if (w.member == m || !w.member.isLeaf()) continue;
            Object value = w.member.getKey();
            if (value instanceof String) {
                sb.append("'" + value.toString() + "'");
            } else {
                sb.append(value.toString());
            }
            sb.append(",");
            if (++i != 1000) continue;
            i = 0;
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") or in (");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    class MemberWalkable
    implements Walkable {
        Member member;
        MemberWalkable[] children;

        MemberWalkable(Member member) {
            this.member = member;
            Member[] members = (Member[])member.getChildren();
            if (members != null) {
                this.children = new MemberWalkable[members.length];
                for (int i = 0; i < members.length; ++i) {
                    this.children[i] = new MemberWalkable(members[i]);
                }
            }
        }

        MemberWalkable(Member[] members) {
            this.member = null;
            if (members != null) {
                this.children = new MemberWalkable[members.length];
                for (int i = 0; i < members.length; ++i) {
                    this.children[i] = new MemberWalkable(members[i]);
                }
            }
        }

        @Override
        public Object[] getChildren() {
            return this.children;
        }
    }

    private class CellCalculationInfo {
        ListCalc listCalc;
        Calc calc;
        BooleanCalc conditionCalc;
        IList list;

        public CellCalculationInfo(ListCalc listCalc, Calc calc, BooleanCalc conditionCalc) {
            this.listCalc = listCalc;
            this.calc = calc;
            this.conditionCalc = conditionCalc;
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OLAPException {
            Member member = this.getCalculatedMember(cube, uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member getCalculatedMember(Cube cube, String uniqueName) {
            Member member = MdxQuery.this.lookupMemberFromDefined(uniqueName);
            if (member == null) {
                member = this.schemaReader.getCalculatedMember(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
            List definedMembers = MdxQuery.this.getDefinedMembers();
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                if (!member.getHierarchy().equals(hierarchy)) continue;
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube, hierarchy);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube) throws OLAPException {
            List definedMembers = MdxQuery.this.getDefinedMembers();
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        public Set getSet(String name) {
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = (Formula)MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(name)) continue;
                return formula.getSet();
            }
            return null;
        }

        @Override
        public OLAPElement getElementChild(OLAPElement parent, String s) throws OLAPException {
            OLAPElement mdxElement = this.schemaReader.getElementChild(parent, s);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = (Formula)MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(s)) continue;
                return formula.getSet();
            }
            return mdxElement;
        }

        @Override
        public OLAPElement lookupCompound(OLAPElement parent, String[] names, int category) throws OLAPException {
            switch (category) {
                case 0: 
                case 6: {
                    Set set;
                    if (parent != this.getCube(MdxQuery.this.cubeName)) break;
                    String uniqueName = Util.implode(names);
                    Member calculatedMember = this.getCalculatedMember(this.getCube(MdxQuery.this.cubeName), uniqueName);
                    if (calculatedMember != null) {
                        return calculatedMember;
                    }
                    if (names.length != 1 || (set = this.getSet(names[0])) == null) break;
                    return set;
                }
            }
            OLAPElement olapElement = super.lookupCompound(parent, names, category);
            return olapElement;
        }
    }
}

