/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxQuery;
import java.io.Serializable;

public interface MdxResult
extends Serializable {
    public MdxQuery getQuery();

    public MdxAxis[] getAxes();

    public MdxAxis getSlicerAxis();

    public Cell getCell(int[] var1);

    public void close();

    public ResultOverflowInfo getOverflowInfo();

    public static class ResultOverflowInfo
    implements Serializable {
        private static final long serialVersionUID = -7128326287136616325L;
        boolean rowOverflow;
        boolean columnOverflow;
        int rowCount;
        int columnCount;
        int rowReturnCount;
        int columnReturnCount;

        public void setRowOverflow(int count, int returnCount) {
            this.rowOverflow = true;
            this.rowCount = count;
            this.rowReturnCount = returnCount;
        }

        public void setColumnOverflow(int count, int returnCount) {
            this.columnOverflow = true;
            this.columnCount = count;
            this.columnReturnCount = returnCount;
        }

        public boolean isOverflow() {
            return this.rowOverflow || this.columnOverflow;
        }

        public boolean isRowOverflow() {
            return this.rowOverflow;
        }

        public boolean isColumnOverflow() {
            return this.columnOverflow;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowReturnCount() {
            return this.rowReturnCount;
        }

        public int getColumnReturnCount() {
            return this.columnReturnCount;
        }

        public String toString() {
            if (!this.rowOverflow && !this.columnOverflow) {
                return "no overflow";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Overflow:\n");
            if (this.rowOverflow) {
                sb.append("Row overflow,all row count is ").append(this.rowCount).append(" rows,but return ").append(this.rowReturnCount).append(" rows.\n");
            }
            if (this.columnOverflow) {
                sb.append("Column overflow,all column count is ").append(this.columnCount).append(" columns,but return ").append(this.columnReturnCount).append(" columns");
            }
            return sb.toString();
        }
    }
}

