/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.LevelCalc;
import com.kingdee.bos.olap.mdx.calc.Scope;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.LevelFactMembersCalc;

public class LevelMembersCalc
extends AbstractListCalc {
    LevelCalc levelCalc;

    public LevelMembersCalc(Exp exp, LevelCalc levelCalc) {
        super(exp, new Calc[]{levelCalc});
        this.levelCalc = levelCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OLAPException {
        if (scope.isNeedNonEmpty()) {
            Level level = this.levelCalc.evaluateLevel(null);
            int count = evaluator.getSchemaReader().getLevelMemberCount(level);
            if (count > 2000) {
                boolean pc = level.getDimension().isParentChildrenDimension();
                boolean isTime = level.getDimension().isTimeDimension();
                boolean isMeasure = level.getDimension().isMeasureDimension();
                if (!(pc || isTime || isMeasure)) {
                    return new LevelFactMembersCalc(this.exp, this.levelCalc);
                }
            }
        }
        return super.optimize(scope, evaluator);
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OLAPException {
        Level level = this.levelCalc.evaluateLevel(evaluator);
        return evaluator.getSchemaReader().getLevelMembers(level);
    }
}

