/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.elementexp;

import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpBase;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.olap.mdx.type.HierarchyType;
import com.kingdee.bos.olap.mdx.type.Type;

public class HierarchyExpr
extends ExpBase
implements Exp {
    private final Hierarchy hierarchy;

    public HierarchyExpr(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String toString() {
        return this.hierarchy.getUniqueName();
    }

    @Override
    public Type getType() {
        return HierarchyType.forHierarchy(this.hierarchy);
    }

    @Override
    public Object clone() {
        return new HierarchyExpr(this.hierarchy);
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OLAPException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OLAPException {
        return this.hierarchy;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantHierarchy(this.hierarchy);
    }
}

