/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.DimensionCalc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractMemberCalc;

public class DimensionCurrentMemberFunDef
extends FunDefBase {
    static final DimensionCurrentMemberFunDef instance = new DimensionCurrentMemberFunDef();

    private DimensionCurrentMemberFunDef() {
        super("CurrentMember", "<Dimension>.CurrentMember", "Returns the current member along a dimension during an iteration.", "pmd");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
        return new CalcImpl((Exp)call, dimensionCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final DimensionCalc dimensionCalc;

        public CalcImpl(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) throws OLAPException {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            if (evaluator == null) {
                return dimension.getDefaultHierarchy().getDefaultMember();
            }
            return evaluator.getContext(dimension);
        }

        public boolean dependsOn(Dimension dimension) {
            return this.dimensionCalc.getType().usesDimension(dimension);
        }
    }
}

