/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDef;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.FuncResolver;
import com.kingdee.bos.olap.mdx.MultiFuncResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.DoubleCalc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.ListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.TopBottomPercentSumCalc;

class TopBottomPercentSumFunDef
extends FunDefBase {
    final boolean top;
    final boolean percent;
    static final ResolverImpl TopPercentResolver = new ResolverImpl("TopPercent", "TopPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, true, true);
    static final ResolverImpl BottomPercentResolver = new ResolverImpl("BottomPercent", "BottomPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}, false, true);
    static final ResolverImpl TopSumResolver = new ResolverImpl("TopSum", "TopSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, true, false);
    static final ResolverImpl BottomSumResolver = new ResolverImpl("BottomSum", "BottomSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}, false, false);

    public TopBottomPercentSumFunDef(FuncResolver funResolver, int returnCategory, int[] argCategorys, boolean top, boolean percent) {
        super(funResolver, returnCategory, argCategorys);
        this.top = top;
        this.percent = percent;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        DoubleCalc doubleCalc = compiler.compileDouble(call.getArg(1));
        Calc calc = compiler.compileScalar(call.getArg(2), true);
        return new TopBottomPercentSumCalc(call, listCalc, doubleCalc, calc, this.top, this.percent);
    }

    private static class ResolverImpl
    extends MultiFuncResolver {
        private final boolean top;
        private final boolean percent;

        public ResolverImpl(String name, String signature, String description, String[] signatures, boolean top, boolean percent) {
            super(name, signature, description, signatures);
            this.top = top;
            this.percent = percent;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnCategory, int[] argCategorys) throws OLAPException {
            return new TopBottomPercentSumFunDef(this, returnCategory, argCategorys, this.top, this.percent);
        }
    }
}

