/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.mem.impl.DimensionFetch;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyFetch;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import java.util.LinkedList;
import java.util.List;

class PrivateDimensionFetch
implements DimensionFetch {
    MemberImpl[] values;
    int hieCount;
    HierarchyFetch[] hies;
    DimensionImpl dim;
    private List listValues = new LinkedList();

    PrivateDimensionFetch(DimensionImpl dim, CubeDimensionDef def) {
        this.dim = dim;
        this.hieCount = def.hierarchies.length;
        this.hies = new HierarchyFetch[this.hieCount];
        for (int i = 0; i < this.hieCount; ++i) {
            this.hies[i] = new HierarchyFetch(def.hierarchies[i], dim.hies[i]);
        }
    }

    void preCalculate(Table table) throws OLAPException {
        this.values = new MemberImpl[this.hieCount];
        for (int i = 0; i < this.hieCount; ++i) {
            this.values[i] = this.hies[i].fetch(table);
            if (this.values != null) continue;
        }
        this.listValues.add(this.values);
    }

    void preFinish() throws OLAPException {
        int globalOrder = 0;
        for (int i = 0; i < this.hieCount; ++i) {
            this.hies[i].globalOrder = globalOrder;
            this.hies[i].finish();
            globalOrder = this.hies[i].globalOrder;
        }
        this.dim.memberCount = globalOrder;
        this.reset();
    }

    void reset() {
    }

    @Override
    public MemberImpl[] fetch(Table table) throws OLAPException {
        return (MemberImpl[])this.listValues.remove(0);
    }

    @Override
    public void finish() throws OLAPException {
        this.listValues = null;
    }
}

