/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mem.impl.CalculatedMemberImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class SchemaReaderImpl
implements SchemaReader,
Serializable {
    private static final long serialVersionUID = 3477544633511420007L;
    SchemaImpl schema;

    public SchemaReaderImpl(SchemaImpl schema) {
        this.schema = schema;
    }

    @Override
    public Cube[] getCubes() {
        return this.schema.getCubes();
    }

    @Override
    public Cube getCube(String cubeName) {
        return this.schema.getCube(Util.trimBracketsAround(cubeName));
    }

    @Override
    public OLAPElement getElementChild(OLAPElement parent, String name) throws OLAPException {
        return parent.lookupChild(this, name);
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        return hierarchy.getDefaultMember();
    }

    public Level[] getHierarchyLevels(Hierarchy hierarchy) {
        return hierarchy.getLevels();
    }

    @Override
    public IMemberList getHierarchyRootMembers(Hierarchy hierarchy) {
        return hierarchy.getMembers();
    }

    @Override
    public Member getLeadMember(Member member, int n) throws OLAPException {
        Member nr = member.getHierarchy().getNullMember();
        if (member == null || member == nr) {
            return nr;
        }
        Member parent = member.getParentMember();
        int index = member.getOrdinal() + n;
        if (parent == null) {
            if (index < 0) {
                return nr;
            }
            IMemberList ms = this.getLevelMembers(member.getLevel());
            if (index >= ms.size()) {
                return nr;
            }
            return (Member)ms.get(index);
        }
        while (true) {
            if (index >= 0) {
                IMemberList ms = parent.getChildMembers();
                if (index >= ms.size()) {
                    if ((parent = this.getLeadMember(parent, 1)).isNull()) break;
                    index -= ms.size();
                    continue;
                }
                return (Member)ms.get(index);
            }
            if ((parent = this.getLeadMember(parent, -1)).isNull()) break;
            index = parent.getChildMembers().size() - index;
        }
        return nr;
    }

    @Override
    public IMemberList getLevelMembers(Level level) {
        return ((HierarchyImpl)level.getHierarchy()).getLevelMembers((LevelImpl)level);
    }

    @Override
    public int getLevelMemberCount(Level level) {
        IMemberList list = this.getLevelMembers(level);
        return list.size();
    }

    @Override
    public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OLAPException {
        String[] nameParts = Util.explode(uniqueName);
        Member member = (Member)this.lookupCompound(cube, nameParts, 6);
        return member;
    }

    @Override
    public IMemberList getMemberChildren(Member member) {
        return member.getChildMembers();
    }

    @Override
    public IMemberList getMemberChildren(IMemberList members) {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            list.addList(this.getMemberChildren((Member)iter.next()));
        }
        return list;
    }

    @Override
    public int getMemberDepth(Member member) {
        return member.getLevel().getDepth();
    }

    @Override
    public Member getMemberParent(Member member) {
        return member.getParentMember();
    }

    @Override
    public void getMemberRange(Level level, Member startMember, Member endMember, IMemberList list) throws OLAPException {
        list.add(startMember);
        if (!startMember.equals(endMember)) {
            IMemberList ms = startMember.getParentMember() != null ? this.getMemberChildren(startMember.getParentMember()) : this.getLevelMembers(startMember.getLevel());
            boolean notstart = true;
            Iterator iter = ms.iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (notstart) {
                    if (!m.equals(startMember)) continue;
                    notstart = false;
                    continue;
                }
                list.add(m);
                if (!m.equals(endMember)) continue;
                break;
            }
        }
    }

    @Override
    public OLAPElement lookupCompound(OLAPElement parent, String[] names, int category) throws OLAPException {
        return SchemaLookup.lookupCompound(this, parent, names, category);
    }

    @Override
    public Member getCalculatedMember(Cube cube, String uniqueName) {
        CubeImpl cubeX = (CubeImpl)cube;
        CalculatedMemberImpl[] members = cubeX.calculatedMembers;
        if (members != null && members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                if (!uniqueName.equalsIgnoreCase(members[i].getUniqueName())) continue;
                return members[i];
            }
        }
        return null;
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
        CubeImpl cubeX = (CubeImpl)cube;
        CalculatedMemberImpl[] members = cubeX.calculatedMembers;
        ArrayList<CalculatedMemberImpl> jlist = new ArrayList<CalculatedMemberImpl>();
        if (members != null && members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getHierarchy().equals(hierarchy)) continue;
                jlist.add(members[i]);
            }
        }
        return jlist.toArray(new Member[0]);
    }

    @Override
    public boolean isDrillable(Member member) {
        return !member.isLeaf();
    }

    @Override
    public void getMemberDescendants(Member member, IMemberList result, Level level, boolean before, boolean self, boolean after) {
        byte levelDepth = level.getDepth();
        IMemberList members = DefaultListFactory.instance.createMemberList();
        members.add(member);
        IMemberList fertileMembers = DefaultListFactory.instance.createMemberList();
        do {
            fertileMembers = DefaultListFactory.instance.createMemberList();
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                member = (Member)iter.next();
                byte currentDepth = member.getLevel().getDepth();
                if (currentDepth == levelDepth) {
                    if (self) {
                        result.add(member);
                    }
                    if (!after) continue;
                    fertileMembers.add(member);
                    continue;
                }
                if (currentDepth < levelDepth) {
                    if (before) {
                        result.add(member);
                    }
                    fertileMembers.add(member);
                    continue;
                }
                if (!after) continue;
                result.add(member);
                fertileMembers.add(member);
            }
            members = DefaultListFactory.instance.createMemberList();
            iter = fertileMembers.iterator();
            while (iter.hasNext()) {
                member = (Member)iter.next();
                IMemberList ms = this.getMemberChildren(member);
                members.addList(ms);
            }
        } while (members.size() > 0);
    }

    @Override
    public int getMemberCount(Hierarchy hierarchy) throws OLAPException {
        return this.getHierarchyMembers(hierarchy, false).size();
    }

    @Override
    public IMemberList getHierarchyMembers(Hierarchy hierarchy, boolean hierarchize) throws OLAPException {
        IMemberList members = DefaultListFactory.instance.createMemberList();
        IMemberList ms = this.getHierarchyRootMembers(hierarchy);
        members = this.getHierarchizeMembers(members, ms);
        return members;
    }

    private IMemberList getHierarchizeMembers(IMemberList members, IMemberList ms) throws OLAPException {
        if (ms.isEmpty()) {
            return members;
        }
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            Member m = (Member)iter.next();
            members.add(m);
            members = this.getHierarchizeMembers(members, this.getMemberChildren(m));
        }
        return members;
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube) throws OLAPException {
        return ((CubeImpl)cube).getCalculatedMembers();
    }
}

