/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.rel.Star;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class FactMemberTupleReader {
    RelConnectionImpl conn;
    Star star;

    public FactMemberTupleReader(RelConnectionImpl conn, Star star) {
        this.conn = conn;
        this.star = star;
    }

    public IList factMembers(RelLevelImpl level) throws OLAPException {
        Connection jdbcConnection = null;
        ResultSet rs = null;
        rs = null;
        try {
            jdbcConnection = this.conn.getJdbcConnection();
            SqlQuery sqlQuery = new SqlQuery(jdbcConnection.getMetaData());
            sqlQuery.setDistinct(true);
            Star.Table factTable = this.star.getFactTable();
            factTable.addToFrom(sqlQuery);
            IList moresel = this.conn.getListFactory().createArrayList();
            Star.Table table = this.star.getDimensionTable(level.getDimension());
            if (level.getDimension().isParentChildrenDimension()) {
                table.addToFromByOrigin(sqlQuery);
            } else {
                table.addToFrom(sqlQuery);
            }
            table.addConstraint(sqlQuery);
            LevelDef levelDef = level.def;
            String levelNameColumn = RelUtil.getLevelNameColumn(levelDef);
            if (levelNameColumn == null) {
                levelNameColumn = levelDef.column;
            }
            levelNameColumn = RelUtil.prixTableName(table.getName()) + "." + levelNameColumn;
            sqlQuery.addSelect(levelNameColumn);
            if (levelDef.orderBy != null) {
                String str = levelDef.orderBy;
                str = RelUtil.prixTableName(table.getName()) + "." + str;
                if (!str.equalsIgnoreCase(levelNameColumn)) {
                    moresel.add(str);
                }
                if (levelDef.orderMethod != null) {
                    str = str + " " + levelDef.orderMethod;
                }
                sqlQuery.addOrderBy(str);
            } else {
                sqlQuery.addOrderBy(levelNameColumn);
            }
            Iterator iter = moresel.iterator();
            while (iter.hasNext()) {
                sqlQuery.addSelect((String)iter.next());
            }
            rs = RelUtil.executeQuery(jdbcConnection, sqlQuery.toString(), "FactMemberTuperReader.factMembers");
            IList tuples = this.conn.getListFactory().createArrayList();
            while (rs.next()) {
                boolean fail = false;
                String name = rs.getString(1);
                Member member = SchemaLookup.lookupLevelMember(this.conn.getSchemaReader(), level, name);
                if (member == null) {
                    fail = true;
                    break;
                }
                if (!fail) {
                    tuples.add(member);
                }
                FuncUtil2.warmTooManyMember(tuples.size());
            }
            IList iList = tuples;
            return iList;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new OLAPException(sqle.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (jdbcConnection != null) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public IList factMembers(RelHierarchyImpl[] hies, boolean withAll, boolean withAncestor, int limit) throws OLAPException {
        IList iList;
        if (withAncestor) {
            int pcIndex = -1;
            for (int i = 0; i < hies.length; ++i) {
                if (!hies[i].dim.isParentChildrenDimension()) continue;
                pcIndex = i;
                break;
            }
            if (pcIndex > -1) {
                return this.factMembersWithAncestor(hies, withAll, limit);
            }
        }
        Connection jdbcConnection = this.conn.getJdbcConnection();
        ResultSet rs = null;
        rs = null;
        try {
            SqlQuery sqlQuery = new SqlQuery(jdbcConnection.getMetaData());
            sqlQuery.setDistinct(true);
            Star.Table factTable = this.star.getFactTable();
            factTable.addToFrom(sqlQuery);
            IList moresel = this.conn.getListFactory().createArrayList();
            for (int i = 0; i < hies.length; ++i) {
                Star.Table table = this.star.getDimensionTable(hies[i].dim);
                if (hies[i].dim.isParentChildrenDimension()) {
                    table.addToFromByOrigin(sqlQuery);
                } else {
                    table.addToFrom(sqlQuery);
                }
                table.addConstraint(sqlQuery);
                LevelDef[] levelDefs = hies[i].def.levels;
                LevelDef levelDef = levelDefs[levelDefs.length - 1];
                String levelNameColumn = RelUtil.getLevelNameColumn(levelDef);
                if (levelNameColumn == null) {
                    levelNameColumn = levelDef.column;
                }
                levelNameColumn = RelUtil.prixTableName(table.getName()) + "." + levelNameColumn;
                sqlQuery.addSelect(levelNameColumn);
                if (levelDef.orderBy != null) {
                    String str = levelDef.orderBy;
                    str = RelUtil.prixTableName(table.getName()) + "." + str;
                    if (!str.equalsIgnoreCase(levelNameColumn)) {
                        moresel.add(str);
                    }
                    if (levelDef.orderMethod != null) {
                        str = str + " " + levelDef.orderMethod;
                    }
                    sqlQuery.addOrderBy(str);
                    continue;
                }
                sqlQuery.addOrderBy(levelNameColumn);
            }
            Iterator iter = moresel.iterator();
            while (iter.hasNext()) {
                sqlQuery.addSelect((String)iter.next());
            }
            rs = RelUtil.executeQuery(jdbcConnection, sqlQuery.toString(), "FactMemberTuperReader.factMembers");
            int arity = hies.length;
            boolean hasData = false;
            Member[] lastMembers = new Member[arity];
            IList tuples = this.conn.getListFactory().createArrayList();
            int index = 0;
            while (rs.next()) {
                int i;
                hasData = true;
                Member[] members = new Member[arity];
                boolean fail = false;
                for (i = 0; i < arity; ++i) {
                    String name = rs.getString(i + 1);
                    members[i] = hies[i].lookupLeafMember(this.conn.getSchemaReader(), name);
                    if (members[i] != null) continue;
                    fail = true;
                    break;
                }
                if (!fail) {
                    if (withAll) {
                        Member[] add = lastMembers;
                        boolean b = false;
                        IList temp = this.conn.getListFactory().createArrayList();
                        for (int i2 = 0; i2 < arity - 1; ++i2) {
                            if (b) {
                                add = (Member[])lastMembers.clone();
                                for (int j = i2 + 1; j < arity; ++j) {
                                    add[j] = hies[j].getInnerAllMember();
                                }
                                temp.addFirst(add);
                                continue;
                            }
                            if (lastMembers[i2] == null || lastMembers[i2] == members[i2]) continue;
                            b = true;
                            --i2;
                        }
                        tuples.addList(temp);
                    }
                    tuples.add(members);
                    for (i = 0; i < arity; ++i) {
                        lastMembers[i] = members[i];
                    }
                }
                if (limit <= 0 || ++index % 50 != 0 || tuples.size() <= limit) continue;
                IList iList2 = tuples = tuples.subList(0, limit);
                return iList2;
            }
            if (withAll && hasData) {
                Member[] add = lastMembers;
                for (int i = arity - 1; i >= 0; --i) {
                    add = (Member[])add.clone();
                    add[i] = hies[i].getInnerAllMember();
                    tuples.add(add);
                }
            }
            if (limit > 0 && tuples.size() > limit) {
                tuples = tuples.subList(0, limit);
            }
            if (hies.length == 1) {
                tuples = this.changeTupleArrayToMemberArray(tuples);
            }
            iList = tuples;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new OLAPException(sqle.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (jdbcConnection != null) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return iList;
    }

    public IList factMembersWithAncestor(RelHierarchyImpl[] hies, boolean withAll, int limit) throws OLAPException {
        IList iList;
        Connection jdbcConnection = this.conn.getJdbcConnection();
        ResultSet rs = null;
        try {
            SqlQuery sqlQuery = new SqlQuery(jdbcConnection.getMetaData());
            sqlQuery.setDistinct(true);
            int pcIndex = -1;
            for (int i = 0; i < hies.length; ++i) {
                if (!hies[i].dim.isParentChildrenDimension()) continue;
                pcIndex = i;
                break;
            }
            if (pcIndex == -1) {
                throw new OLAPException("factMembersWithAncestor require one parent/children dimension.");
            }
            Star.Table factTable = this.star.getFactTable();
            factTable.addToFrom(sqlQuery);
            IList moresel = this.conn.getListFactory().createArrayList();
            for (int i = 0; i < hies.length; ++i) {
                Star.Table table = this.star.getDimensionTable(hies[i].dim);
                if (i != pcIndex && hies[i].dim.isParentChildrenDimension()) {
                    table.addToFromByOrigin(sqlQuery);
                } else {
                    table.addToFrom(sqlQuery);
                }
                table.addConstraint(sqlQuery);
                LevelDef[] levelDefs = hies[i].def.levels;
                LevelDef levelDef = levelDefs[levelDefs.length - 1];
                String levelNameColumn = RelUtil.getLevelNameColumn(levelDef);
                if (levelNameColumn == null) {
                    levelNameColumn = levelDef.column;
                }
                levelNameColumn = RelUtil.prixTableName(table.getName()) + "." + levelNameColumn;
                sqlQuery.addSelect(levelNameColumn);
                if (i == pcIndex) {
                    RelLevelImpl level = RelUtil.getDefineLevel(hies[i]);
                    while (level != null) {
                        String n = RelUtil.genLevelColumnName(level.depth);
                        n = RelUtil.prixTableName(table.getName()) + "." + n;
                        sqlQuery.addOrderBy(n);
                        moresel.add(n);
                        level = level.child;
                    }
                }
                if (levelDef.orderBy != null) {
                    String str = levelDef.orderBy;
                    str = RelUtil.prixTableName(table.getName()) + "." + str;
                    if (!str.equalsIgnoreCase(levelNameColumn)) {
                        moresel.add(str);
                    }
                    if (levelDef.orderMethod != null) {
                        str = str + " " + levelDef.orderMethod;
                    }
                    sqlQuery.addOrderBy(str);
                    continue;
                }
                sqlQuery.addOrderBy(levelNameColumn);
            }
            Iterator iter = moresel.iterator();
            while (iter.hasNext()) {
                sqlQuery.addSelect((String)iter.next());
            }
            rs = RelUtil.executeQuery(jdbcConnection, sqlQuery.toString(), "FactMemberTuperReader.listMembers");
            int arity = hies.length;
            boolean hasData = false;
            Member[] lastMembers = new Member[arity];
            IList tuples = this.conn.getListFactory().createArrayList();
            int index = 0;
            while (rs.next()) {
                hasData = true;
                Member[] members = new Member[arity];
                boolean fail = false;
                for (int i = 0; i < arity; ++i) {
                    String name = rs.getString(i + 1);
                    members[i] = hies[i].lookupLeafMember(this.conn.getSchemaReader(), name);
                    if (members[i] != null) continue;
                    fail = true;
                    break;
                }
                if (!fail) {
                    int i;
                    IList temp = this.conn.getListFactory().createArrayList();
                    if (pcIndex > -1) {
                        boolean inSameParent = true;
                        for (int i2 = 0; i2 < pcIndex; ++i2) {
                            if (lastMembers[i2] == null || lastMembers[i2] == members[i2]) continue;
                            inSameParent = false;
                            break;
                        }
                        if (!inSameParent || lastMembers[pcIndex] != members[pcIndex]) {
                            Member[] add;
                            if (inSameParent) {
                                if (lastMembers[pcIndex] == null) {
                                    Member parent = members[pcIndex];
                                    while ((parent = parent.getParentMember()) != null) {
                                        add = (Member[])members.clone();
                                        add[pcIndex] = parent;
                                        for (i = pcIndex + 1; i < arity; ++i) {
                                            add[i] = hies[i].getInnerAllMember();
                                        }
                                        temp.addFirst(add);
                                    }
                                } else {
                                    int i3;
                                    Member[] add2;
                                    Member last = lastMembers[pcIndex];
                                    Member now = members[pcIndex];
                                    int d = lastMembers[pcIndex].getDepth() - members[pcIndex].getDepth();
                                    if (d == 0) {
                                        last = last.getParentMember();
                                        for (now = now.getParentMember(); last != null && last != now; last = last.getParentMember(), now = now.getParentMember()) {
                                            add2 = (Member[])members.clone();
                                            add2[pcIndex] = now;
                                            for (i3 = pcIndex + 1; i3 < arity; ++i3) {
                                                add2[i3] = hies[i3].getInnerAllMember();
                                            }
                                            temp.addFirst(add2);
                                        }
                                    }
                                    if (d > 0) {
                                        while (d-- > 0) {
                                            last = last.getParentMember();
                                        }
                                        last = last.getParentMember();
                                        for (now = now.getParentMember(); last != null && last != now; last = last.getParentMember(), now = now.getParentMember()) {
                                            add2 = (Member[])members.clone();
                                            add2[pcIndex] = now;
                                            for (i3 = pcIndex + 1; i3 < arity; ++i3) {
                                                add2[i3] = hies[i3].getInnerAllMember();
                                            }
                                            temp.addFirst(add2);
                                        }
                                    } else if (d < 0) {
                                        while (d++ < -1) {
                                            now = now.getParentMember();
                                            add2 = (Member[])members.clone();
                                            add2[pcIndex] = now;
                                            for (i3 = pcIndex + 1; i3 < arity; ++i3) {
                                                add2[i3] = hies[i3].getInnerAllMember();
                                            }
                                            temp.addFirst(add2);
                                        }
                                        for (now = now.getParentMember(); last != null && last != now; last = last.getParentMember(), now = now.getParentMember()) {
                                            add2 = (Member[])members.clone();
                                            add2[pcIndex] = now;
                                            for (i3 = pcIndex + 1; i3 < arity; ++i3) {
                                                add2[i3] = hies[i3].getInnerAllMember();
                                            }
                                            temp.addFirst(add2);
                                        }
                                    }
                                }
                            } else {
                                Member parent = members[pcIndex];
                                while ((parent = parent.getParentMember()) != null) {
                                    add = (Member[])members.clone();
                                    add[pcIndex] = parent;
                                    for (i = pcIndex + 1; i < arity; ++i) {
                                        add[i] = hies[i].getInnerAllMember();
                                    }
                                    temp.addFirst(add);
                                }
                            }
                        }
                    }
                    if (withAll) {
                        Member[] add = lastMembers;
                        boolean b = false;
                        IList temp2 = this.conn.getListFactory().createArrayList();
                        for (i = 0; i < arity - 1; ++i) {
                            if (b) {
                                add = (Member[])lastMembers.clone();
                                for (int j = i + 1; j < arity; ++j) {
                                    add[j] = hies[j].getInnerAllMember();
                                }
                                temp2.addFirst(add);
                                continue;
                            }
                            if (lastMembers[i] == null || lastMembers[i] == members[i]) continue;
                            b = true;
                            --i;
                        }
                        tuples.addList(temp2);
                    }
                    tuples.addList(temp);
                    tuples.add(members);
                    for (int i4 = 0; i4 < arity; ++i4) {
                        lastMembers[i4] = members[i4];
                    }
                }
                if (limit <= 0 || ++index % 50 != 0 || tuples.size() <= limit) continue;
                IList iList2 = tuples = tuples.subList(0, limit);
                return iList2;
            }
            if (withAll && hasData) {
                Member[] add = lastMembers;
                for (int i = arity - 1; i >= 0; --i) {
                    add = (Member[])add.clone();
                    add[i] = hies[i].getInnerAllMember();
                    tuples.add(add);
                }
            }
            if (limit > 0 && tuples.size() > limit) {
                tuples = tuples.subList(0, limit);
            }
            if (hies.length == 1) {
                tuples = this.changeTupleArrayToMemberArray(tuples);
            }
            iList = tuples;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new OLAPException(sqle.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (jdbcConnection != null) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return iList;
    }

    private IList changeTupleArrayToMemberArray(IList tuples) {
        IList tuplesNew = this.conn.getListFactory().createArrayList();
        Iterator it = tuples.iterator();
        while (it.hasNext()) {
            Member[] members = (Member[])it.next();
            tuplesNew.add(members[0]);
        }
        return tuplesNew;
    }
}

