/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.rel.MemberCache;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMeasureImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelUtil;

public class MeasureMemberReader
implements MemberReader {
    RelMeasureImpl[] measures;
    IMemberList list;

    MeasureMemberReader(RelMeasureImpl[] measures) {
        this.measures = measures;
        this.list = DefaultListFactory.instance.createMemberList(measures);
    }

    @Override
    public IMemberList getMembersInLevel(RelLevelImpl level) throws OLAPException {
        return this.list;
    }

    @Override
    public void getMemberChildren(RelMemberImpl parentMember, IMemberList children) throws OLAPException {
    }

    @Override
    public void getMemberChildren(IMemberList parentMembers, IMemberList children) throws OLAPException {
    }

    @Override
    public void getMemberDescendants(RelMemberImpl member, IMemberList result, RelLevelImpl level, boolean before, boolean self, boolean after) throws OLAPException {
    }

    @Override
    public IMemberList getRootMembers() throws OLAPException {
        return this.getMembers();
    }

    @Override
    public IMemberList getMembers() throws OLAPException {
        return this.list;
    }

    @Override
    public IMemberList getHierarchizeMembers() throws OLAPException {
        return this.getMembers();
    }

    @Override
    public RelMemberImpl lookupMember(String[] uniqueNameParts) throws OLAPException {
        return RelUtil.lookupMember(this, uniqueNameParts);
    }

    @Override
    public void getMemberRange(RelLevelImpl level, RelMemberImpl startMember, RelMemberImpl endMember, IMemberList list) throws OLAPException {
        for (int i = startMember.getOrdinal(); i <= endMember.getOrdinal(); ++i) {
            list.add(this.measures[i]);
        }
    }

    @Override
    public RelMemberImpl getLeadMember(RelMemberImpl member, int n) throws OLAPException {
        int ordinal = member.getOrdinal();
        if (ordinal - n < 0 || ordinal - n > this.measures.length - 1) {
            return (RelMemberImpl)member.getHierarchy().getNullMember();
        }
        return this.measures[ordinal - n];
    }

    @Override
    public RelHierarchyImpl getHierarchy() {
        return (RelHierarchyImpl)this.measures[0].getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public int getMemberCount() throws OLAPException {
        return this.measures.length;
    }

    @Override
    public int getLevelMemberCount(RelLevelImpl level) throws OLAPException {
        return this.measures.length;
    }

    @Override
    public RelMemberImpl getAllMember() throws OLAPException {
        return null;
    }

    @Override
    public void init() throws OLAPException {
    }

    @Override
    public IListFactory getListFactory() {
        return DefaultListFactory.instance;
    }
}

