/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.rel.MemberReaderBase;
import com.kingdee.bos.olap.rel.RelHierarchyFetch;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.Walkable;
import com.kingdee.bos.olap.util.Walker;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PCMemberReaderImpl
extends MemberReaderBase {
    private static Logger logger = CommonLogger.getLogger(PCMemberReaderImpl.class);
    RelMemberImpl[] rootMembers;
    HashMap mapMemberToChildren = new HashMap();
    int memberCount;
    private String strKeySqlType;
    private int keySqlType;
    private boolean builded = false;
    private static final Object _lock = new Object();
    private static long counter = 0L;

    public PCMemberReaderImpl(RelSchemaImpl schema, RelHierarchyImpl hie) {
        super(schema, hie);
    }

    public synchronized void putChildrenCache(RelMemberImpl member, RelMemberImpl[] children) {
        this.mapMemberToChildren.put(member, children);
    }

    public synchronized RelMemberImpl[] getChildrenCache(RelMemberImpl member) {
        return (RelMemberImpl[])this.mapMemberToChildren.get(member);
    }

    private void addSelect(SqlQuery query, HashSet columnSet, String column) {
        if (column == null) {
            return;
        }
        if (!columnSet.contains(column = column.toUpperCase())) {
            columnSet.add(column);
            query.addSelect(column, null);
        }
    }

    protected String makeKeysSql(Connection jdbcConnection) throws OLAPException {
        HashSet columnSet = new HashSet();
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, "while generating query to retrieve members of " + this.hie);
        sqlQuery.setDistinct(true);
        this.hie.dim.addToSqlQuery(sqlQuery);
        RelLevelImpl level = RelUtil.getDefineLevel(this.hie);
        this.addSelect(sqlQuery, columnSet, level.def.column);
        this.addSelect(sqlQuery, columnSet, level.def.parentColumn);
        this.addSelect(sqlQuery, columnSet, level.def.childColumn);
        PropertyDef[] properties = level.def.properties;
        for (int j = 0; j < properties.length; ++j) {
            PropertyDef property = properties[j];
            this.addSelect(sqlQuery, columnSet, property.column);
        }
        if (level.def.orderBy != null) {
            String str = level.def.orderBy;
            this.addSelect(sqlQuery, columnSet, str);
            if (level.def.orderMethod != null) {
                str = str + " " + level.def.orderMethod;
            }
            sqlQuery.addOrderBy(str);
        } else {
            String column = RelUtil.getLevelNameColumn(level);
            if (column != null) {
                sqlQuery.addOrderBy(column);
            } else {
                column = (String)level.getProperty("column");
                sqlQuery.addOrderBy(column);
            }
        }
        return sqlQuery.toString();
    }

    private void decideDataType(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (int i = 1; i < count + 1; ++i) {
            nameIndex.put(rsmd.getColumnName(i).toUpperCase(), new Integer(i));
        }
        RelLevelImpl level = RelUtil.getDefineLevel(this.hie);
        String column = level.def.column.toUpperCase();
        int index = (Integer)nameIndex.get(column);
        this.keySqlType = rsmd.getColumnType(index);
        this.strKeySqlType = RelUtil.getSqlType(this.schema.conn.dbType, rsmd, index);
    }

    private void buildParentChildren() throws OLAPException {
        Connection jdbcConnection = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = this.schema.conn.getJdbcConnection();
            String sql = this.makeKeysSql(jdbcConnection);
            resultSet = RelUtil.executeQuery(jdbcConnection, sql, "PCMemberReaderImpl.buildParentChidren");
            this.decideDataType(resultSet);
            RelHierarchyFetch fetch = new RelHierarchyFetch(this);
            while (resultSet.next()) {
                fetch.fetch(resultSet);
            }
            fetch.finish();
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public IMemberList getMembersInLevel(RelLevelImpl level) throws OLAPException {
        this.build();
        IMemberList list = this.schema.conn.getListFactory().createMemberList();
        Walker walker = new Walker(new MemberWalkable(this.rootMembers));
        while (walker.hasMoreElements()) {
            MemberWalkable w = (MemberWalkable)walker.nextElement();
            if (w.member == null || w.member.level != level) continue;
            list.add(w.member);
            walker.prune();
        }
        return list;
    }

    @Override
    public void getMemberChildren(RelMemberImpl parentMember, IMemberList children) throws OLAPException {
        this.build();
        Object[] members = this.getChildrenCache(parentMember);
        if (members != null) {
            children.addArray(members);
        }
    }

    @Override
    public IMemberList getRootMembers() throws OLAPException {
        this.build();
        if (this.rootMembers == null) {
            return IMemberList.EMPTY;
        }
        return this.schema.conn.getListFactory().createMemberList(this.rootMembers);
    }

    @Override
    public IMemberList getHierarchizeMembers() throws OLAPException {
        return this.getMembers();
    }

    @Override
    public IMemberList getMembers() throws OLAPException {
        this.build();
        IMemberList members = this.schema.conn.getListFactory().createMemberList();
        return this.getHierarchizeMembers(members, this.rootMembers);
    }

    private IMemberList getHierarchizeMembers(IMemberList members, Member[] ms) throws OLAPException {
        if (ms == null) {
            return members;
        }
        for (int i = 0; i < ms.length; ++i) {
            members.add(ms[i]);
            members = this.getHierarchizeMembers(members, this.getChildrenCache((RelMemberImpl)ms[i]));
        }
        return members;
    }

    @Override
    public int getMemberCount() throws OLAPException {
        this.build();
        return this.memberCount;
    }

    private synchronized void build() throws OLAPException {
        if (!this.builded) {
            try {
                this.buildParentChildren();
                this.builded = true;
                if (this.hie.isAggregate()) {
                    this.createExtendTable();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OLAPException(e);
            }
            finally {
                this.builded = true;
            }
        }
    }

    private String genMemberInsertSql(String table, String primaryKey, boolean hasAll) {
        StringBuffer sb = new StringBuffer("insert into ");
        sb.append(table).append("(").append(primaryKey);
        sb.append(",").append(RelUtil.getIsLeafColumnName()).append(",").append(RelUtil.getDepthColumnName());
        StringBuffer sb2 = new StringBuffer(" values(");
        sb2.append("?");
        RelLevelImpl level = null;
        level = hasAll ? this.hie.levels[1] : this.hie.levels[0];
        while (level != null && !level.isAll()) {
            String levelName = RelUtil.genLevelColumnName(level.depth);
            sb.append(",").append(levelName);
            sb2.append(",?");
            level = level.child;
        }
        sb2.append(",?,?");
        sb.append(")");
        sb2.append(")");
        sb.append(sb2.toString());
        return sb.toString();
    }

    private void setPreparedValue(RelMemberImpl member, PreparedStatement ps) throws SQLException {
        int i;
        int index = 1;
        RelUtil.setValue(index++, member.getKey(), ps, this.keySqlType);
        ps.setInt(index++, member.isLeaf() ? 1 : 0);
        ps.setInt(index++, member.getDepth());
        int b = index;
        RelLevelImpl level = RelUtil.getDefineLevel(this.hie);
        RelMemberImpl m2 = member;
        ArrayList<RelMemberImpl> list = new ArrayList<RelMemberImpl>();
        while (m2 != null && !m2.isAll()) {
            list.add(m2);
            m2 = (RelMemberImpl)m2.parent;
        }
        for (i = list.size() - 1; i >= 0; --i) {
            m2 = (RelMemberImpl)list.get(i);
            RelUtil.setValue(index++, m2.getKey(), ps, this.keySqlType);
        }
        b = index - b;
        i = 0;
        while (level != null) {
            if (i >= b) {
                ps.setNull(index++, this.keySqlType);
            }
            level = level.child;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSystemCurrentTimeMillis() {
        Object object = _lock;
        synchronized (object) {
            if (++counter >= 100L) {
                counter = 0L;
            }
            return System.currentTimeMillis() + Long.toString(counter);
        }
    }

    private String genCreateTableSql(String table, boolean hasAll) {
        RelLevelImpl level = RelUtil.getDefineLevel(this.hie);
        StringBuffer sb = new StringBuffer("create table ");
        sb.append(table).append("(").append(RelUtil.getKeyColumnName()).append(" ").append(this.strKeySqlType);
        sb.append(" not null,").append(RelUtil.getIsLeafColumnName()).append(" int,").append(RelUtil.getDepthColumnName()).append(" int");
        while (level != null) {
            String levelName = RelUtil.genLevelColumnName(level.depth);
            sb.append(",").append(levelName).append(" ").append(this.strKeySqlType);
            level = level.child;
        }
        sb.append(",constraint pk_" + this.getSystemCurrentTimeMillis() + " primary key (" + RelUtil.getKeyColumnName() + ")");
        sb.append(")");
        return sb.toString();
    }

    private void createExtendTable() throws OLAPException, SQLException {
        boolean hasAll = this.hie.hasAll();
        Connection connection = null;
        connection = this.hie.dim.cube.schema.conn.getJdbcConnection();
        Statement ps = null;
        try {
            String table = this.schema.conn.getTemporaryTableName("OLAP for dimension " + this.hie.getName());
            String sql = this.genCreateTableSql(table, hasAll);
            this.schema.conn.createTempTable(sql);
            String insertSql = this.genMemberInsertSql(table, RelUtil.getKeyColumnName(), hasAll);
            logger.debug((Object)("prepareStatement:" + insertSql));
            ps = connection.prepareStatement(insertSql);
            Walker walker = new Walker(new MemberWalkable(this.rootMembers));
            while (walker.hasMoreElements()) {
                MemberWalkable w = (MemberWalkable)walker.nextElement();
                if (w.member == null || w.member.isAll()) continue;
                RelMemberImpl member = w.member;
                this.setPreparedValue(member, (PreparedStatement)ps);
                ps.addBatch();
            }
            ps.executeBatch();
            this.updateMetadata(this.hie.dim.cube.getStar(), table);
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void updateMetadata(Star star, String tableName) throws OLAPException {
        Map map = star.getMapLevelToColumn();
        RelLevelImpl level = RelUtil.getDefineLevel(this.hie);
        String keyColumn = level.def.column;
        if (level.def.childColumn != null) {
            // empty if block
        }
        Star.Column column = (Star.Column)map.get(level);
        column.name = RelUtil.genLevelColumnName(level.depth);
        Star.Table table = column.table;
        level = level.child;
        while (level != null) {
            column = new Star.Column(table, RelUtil.genLevelColumnName(level.depth), level);
            map.put(level, column);
            map.put(column, level);
            level = level.child;
        }
        TableDef extend = new TableDef();
        TableDef btd = table.tableDef;
        if (btd instanceof TableDef) {
            TableDef tableDef = btd;
            extend.name = tableDef.name;
            table.originTableDef = tableDef;
            table.tableDef = extend;
            StringBuffer sql = new StringBuffer();
            String t1 = "Olap_oo00aa";
            String t2 = "Olap_oo11bb";
            if (tableDef.sql != null) {
                String tableSql = Util.trim(tableDef.sql);
                StringTokenizer st = new StringTokenizer(tableSql, " ");
                if (st.countTokens() == 4) {
                    if (st.nextToken().equalsIgnoreCase("select") && st.nextToken().equalsIgnoreCase("*") && st.nextToken().equalsIgnoreCase("from")) {
                        tableSql = st.nextToken();
                    }
                } else if (!tableSql.startsWith("(")) {
                    tableSql = "(" + tableSql + ")";
                }
                sql.append("select * from ").append(tableSql).append(" ").append(t1).append(" , ").append(tableName).append(" ").append(t2).append(" where ").append(t1).append(".").append(keyColumn).append("=").append(t2).append(".").append(RelUtil.getKeyColumnName()).append(" and ").append(t2).append(".").append(RelUtil.getIsLeafColumnName()).append("=1");
                extend.sql = sql.toString();
            } else {
                sql.append("select * from ").append(tableDef.name).append(" ").append(t1).append(" , ").append(tableName).append(" ").append(t2).append(" where ").append(t1).append(".").append(keyColumn).append("=").append(t2).append(".").append(RelUtil.getKeyColumnName()).append(" and ").append(t2).append(".").append(RelUtil.getIsLeafColumnName()).append("=1");
                extend.sql = sql.toString();
            }
        } else {
            throw new OLAPException("todo");
        }
    }

    @Override
    public int getLevelMemberCount(RelLevelImpl level) throws OLAPException {
        this.build();
        int count = 0;
        Walker walker = new Walker(new MemberWalkable(this.rootMembers));
        while (walker.hasMoreElements()) {
            MemberWalkable w = (MemberWalkable)walker.nextElement();
            if (w.member == null || w.member.level != level) continue;
            ++count;
            walker.prune();
        }
        return count;
    }

    @Override
    public RelMemberImpl getAllMember() throws OLAPException {
        if (!this.hie.hasAll()) {
            return null;
        }
        this.build();
        return this.rootMembers[0];
    }

    @Override
    public void init() throws OLAPException {
        this.build();
    }

    class MemberWalkable
    implements Walkable {
        RelMemberImpl member;
        MemberWalkable[] children;

        MemberWalkable(RelMemberImpl member) {
            this.member = member;
            RelMemberImpl[] members = PCMemberReaderImpl.this.getChildrenCache(member);
            if (members != null) {
                this.children = new MemberWalkable[members.length];
                for (int i = 0; i < members.length; ++i) {
                    this.children[i] = new MemberWalkable(members[i]);
                }
            }
        }

        MemberWalkable(RelMemberImpl[] members) {
            this.member = null;
            if (members != null) {
                this.children = new MemberWalkable[members.length];
                for (int i = 0; i < members.length; ++i) {
                    this.children[i] = new MemberWalkable(members[i]);
                }
            }
        }

        @Override
        public Object[] getChildren() {
            return this.children;
        }
    }
}

