/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Formatter;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.CellImpl;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.base.CellValues;
import com.kingdee.bos.olap.base.EvaluatorImpl;
import com.kingdee.bos.olap.base.MdxResultBase;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.exception.MeasuresNotVisibleException;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.mdx.MdxPosition;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.QueryAxis;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.rel.RelCellReaderImpl;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.ValueNotReady;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RelResultImpl2
extends MdxResultBase {
    private static final long serialVersionUID = 4657182417239214838L;
    private static Logger logger = CommonLogger.getLogger(RelResultImpl2.class);
    private CellValues cellValues;
    private transient CellKey point;
    private transient Map axisPositionList;
    private boolean x = false;
    private HashMap axis0PositionMap;
    private transient HashMap formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelResultImpl2(MdxQuery query) throws OLAPException {
        super(query, new MdxAxis[query.getAxes().length]);
        this.point = new CellKey(new int[query.getAxes().length]);
        RelCubeImpl cube = (RelCubeImpl)query.getCube();
        RelConnectionImpl cn = (RelConnectionImpl)query.getConnection();
        RelCellReaderImpl cellReader = new RelCellReaderImpl(cube);
        EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
        this.cellValues = new CellValues();
        this.formats = new HashMap();
        this.axisPositionList = new HashMap();
        boolean allNonEmpty = false;
        QueryAxis[] queryAxes = query.getAxes();
        if (queryAxes[0].isNonEmpty() && !queryAxes[1].isNonEmpty()) {
            this.x = true;
        }
        if (queryAxes[0].isNonEmpty() && queryAxes[1].isNonEmpty()) {
            allNonEmpty = true;
        }
        try {
            long startTime = System.currentTimeMillis();
            this.executeSliceAxis(evaluator.push(), query.getSlicerCalc());
            IList slicerPositions = (IList)this.axisPositionList.get(null);
            Member[] slicerPosition = (Member[])slicerPositions.get(0);
            evaluator.setContext(slicerPosition);
            evaluator.setSlicerMember(slicerPosition);
            for (int i = 0; i < this.axes.length; ++i) {
                QueryAxis axis = query.getAxes()[i];
                Calc calc = query.getAxisCalcs()[i];
                IList list = null;
                int attempt = 0;
                while (axis != null) {
                    list = this.executeAxis(cellReader, evaluator.push(), axis, calc);
                    if (cellReader.isBatchEmpty()) break;
                    evaluator.clearExpResultCache(false);
                    cellReader.loadAggregations();
                    if (attempt++ < RelUtil.MAX_AGGREGATION_PASS_COUNT) continue;
                    throw Util.newInternal("Failed to load all aggregations after " + RelUtil.MAX_AGGREGATION_PASS_COUNT + "passes; there's probably a cycle");
                }
                list = this.permissionControl(list);
                this.axisPositionList.put(axis, list);
                evaluator.clearExpResultCache(false);
                if (i != -1) continue;
                MdxPosition position = (MdxPosition)list.get(0);
                for (int j = 0; j < position.getMembers().length; ++j) {
                    evaluator.setContext(position.getMembers()[j]);
                }
            }
            if (allNonEmpty) {
                QueryAxis axis = query.getAxes()[0];
                IList list0 = (IList)this.axisPositionList.get(axis);
                axis = query.getAxes()[1];
                IList list1 = (IList)this.axisPositionList.get(axis);
                if (list0.size() > 1000 && list1.size() > 1000) {
                    throw new OLAPException("Too much query axis,both two query axis exceed 1000 positions,please reduce one query axis range.");
                }
                if (list0.size() > list1.size()) {
                    this.x = true;
                }
            }
            startTime = System.currentTimeMillis();
            this.executeBody(cellReader, evaluator, query);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mdx Result executeBody cost " + (System.currentTimeMillis() - startTime) + "ms."));
            }
            startTime = System.currentTimeMillis();
            IList positions2 = null;
            if (allNonEmpty) {
                int axisIndex = this.getAxisIndex(0);
                IList positions = (IList)this.axisPositionList.get(query.getAxes()[axisIndex]);
                positions2 = query.getListFactory().createArrayList();
                int index = 0;
                int[] pos = new int[2];
                int i = 0;
                this.axis0PositionMap = new HashMap();
                Iterator iter = positions.iterator();
                while (iter.hasNext()) {
                    Member[] position = (Member[])iter.next();
                    if (!this.isEmpty(pos, i, axisIndex)) {
                        this.axis0PositionMap.put(new Integer(index), new Integer(i));
                        positions2.add(position);
                        ++index;
                    }
                    ++i;
                }
            }
            for (int i = -1; i < this.axes.length; ++i) {
                IList list;
                QueryAxis axis = i == -1 ? null : query.getAxes()[i];
                if (this.axis0PositionMap != null && this.getAxisIndex(0) == i) {
                    list = positions2;
                    this.axisPositionList.remove(axis);
                } else {
                    list = (IList)this.axisPositionList.remove(axis);
                }
                if (list == null) continue;
                int returnCount = list.size();
                if (axis != null && axis.isRow() && list.size() > RelUtil.RESULT_MAX_ROWCOUNT) {
                    this.getOverflowInfo().setRowOverflow(list.size(), RelUtil.RESULT_MAX_ROWCOUNT);
                    returnCount = RelUtil.RESULT_MAX_ROWCOUNT;
                } else if (axis != null && axis.isColumn() && list.size() > RelUtil.RESULT_MAX_ROWCOUNT) {
                    this.getOverflowInfo().setColumnOverflow(list.size(), RelUtil.RESULT_MAX_COLUMNCOUNT);
                    returnCount = RelUtil.RESULT_MAX_COLUMNCOUNT;
                }
                MdxPosition[] positions = new MdxPosition[returnCount];
                Iterator iter = list.iterator();
                for (int index = 0; iter.hasNext() && index < returnCount; ++index) {
                    positions[index] = new MdxPosition((Member[])iter.next());
                }
                MdxAxis mdxAxis = new MdxAxis(axis == null ? "" : axis.getName(), positions);
                if (i == -1) {
                    this.slicerAxis = mdxAxis;
                    continue;
                }
                this.axes[i] = mdxAxis;
            }
        }
        finally {
            this.axisPositionList = null;
            this.formats = null;
            evaluator.clearExpResultCache(true);
        }
    }

    private Member[] toMemberArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Member[]) {
            return (Member[])o;
        }
        if (o instanceof Member) {
            return new Member[]{(Member)o};
        }
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            Member[] ms = new Member[os.length];
            System.arraycopy(os, 0, ms, 0, os.length);
            return ms;
        }
        throw new ClassCastException();
    }

    private IList permissionControl(IList list) throws OLAPException {
        if (list.isEmpty()) {
            return list;
        }
        Member[] members = this.toMemberArray(list.getFirst());
        IList result = this.query.getListFactory().createArrayList();
        int indexMeasures = -1;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isMeasure()) continue;
            indexMeasures = i;
            break;
        }
        if (indexMeasures > -1) {
            HashSet<String> notVisibleMeasureCaptions = new HashSet<String>();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Member[] ms = this.toMemberArray(iter.next());
                if (!ms[indexMeasures].isVisible()) {
                    notVisibleMeasureCaptions.add(ms[indexMeasures].getCaption());
                    continue;
                }
                result.add(ms);
            }
            if (result.isEmpty()) {
                String[] measureCaptions = new String[notVisibleMeasureCaptions.size()];
                notVisibleMeasureCaptions.toArray(measureCaptions);
                throw new MeasuresNotVisibleException(measureCaptions);
            }
            return result;
        }
        return list;
    }

    private boolean isEmpty(int[] pos, int offset, int fixedAxis) {
        int axisCount = this.getAxes().length;
        pos[fixedAxis] = offset;
        return this.isEmptyRecurse(pos, fixedAxis, axisCount - 1);
    }

    private boolean isEmptyRecurse(int[] pos, int fixedAxis, int axis) {
        if (axis < 0) {
            Object value = this.cellValues.get(new CellKey(pos));
            return value == null;
        }
        if (axis == fixedAxis) {
            return this.isEmptyRecurse(pos, fixedAxis, axis - 1);
        }
        IList positions = (IList)this.axisPositionList.get(this.query.getAxes()[axis]);
        int i = 0;
        int count = positions.size();
        while (i < count) {
            pos[axis] = i++;
            if (this.isEmptyRecurse(pos, fixedAxis, axis - 1)) continue;
            return false;
        }
        return true;
    }

    private int getAxisIndex(int index) {
        return this.x ? (index + 1) % 2 : index;
    }

    private QueryAxis getAxis(int index) {
        return this.query.getAxes()[this.getAxisIndex(index)];
    }

    private IList executeSliceAxis(Evaluator evaluator, Calc calc) throws OLAPException {
        IList positions = this.query.getListFactory().createArrayList();
        if (calc == null) {
            Member[] members = new Member[]{};
            positions.add(members);
        } else {
            IList list;
            Object value = calc.evaluate(evaluator);
            if (value instanceof Member || value instanceof Member[]) {
                list = this.query.getListFactory().createArrayList();
                list.add(value);
                value = list;
            }
            list = (IList)value;
            Object o = list.getFirst();
            IList members = this.query.getListFactory().createArrayList();
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    HashMap<Hierarchy, IList> map = new HashMap<Hierarchy, IList>(3);
                    for (int j = 0; j < a.length; ++j) {
                        if (a[j] == null) continue;
                        Member tm = (Member)a[j];
                        members.add(tm);
                        o = map.get(tm.getHierarchy());
                        if (o != null) {
                            ((IList)o).add(tm);
                            continue;
                        }
                        IList l = this.query.getListFactory().createArrayList();
                        l.add(tm);
                        map.put(tm.getHierarchy(), l);
                    }
                    if (map.size() != members.size()) {
                        for (Map.Entry entry : map.entrySet()) {
                            RelHierarchyImpl hier = (RelHierarchyImpl)entry.getKey();
                            IList memberList = (IList)entry.getValue();
                            if (memberList.size() == 1) {
                                members.add(memberList.get(0));
                                continue;
                            }
                            members.add(evaluator.getQuery().addSlicerCompoundMember(hier, (Member[])memberList.toArray(new Member[0])));
                        }
                    }
                } else {
                    members.add(o);
                }
            }
            positions.add((Member[])members.toArray(new Member[0]));
        }
        this.axisPositionList.put(null, positions);
        return positions;
    }

    private IList executeAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws OLAPException {
        boolean nonEmpty = axis.isNonEmpty();
        evaluator.setNonEmpty(nonEmpty);
        boolean nonFactEmpty = axis.isNonFactEmpty();
        evaluator.setNonFactEmpty(nonFactEmpty);
        Object value = calc.evaluate(evaluator);
        evaluator.setNonEmpty(false);
        evaluator.setNonFactEmpty(false);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        IList list = (IList)value;
        return list;
    }

    private void executeBody(CellReader cellReader, EvaluatorImpl evaluator, MdxQuery query) throws OLAPException {
        block2: {
            int count = 0;
            QueryAxis queryAxis0 = this.getAxis(0);
            QueryAxis queryAxis1 = this.getAxis(1);
            IList positions0 = (IList)this.axisPositionList.get(queryAxis0);
            IList positions1 = (IList)this.axisPositionList.get(queryAxis1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before calculate,rows count is " + positions1.size() + ",columns count is " + positions0.size()));
            }
            do {
                this.cellValues.clear();
                this.point = new CellKey(new int[query.getAxes().length]);
                this.executeStripe(1, (EvaluatorImpl)evaluator.push());
                if (((RelCellReaderImpl)cellReader).isBatchEmpty()) break block2;
                evaluator.clearExpResultCache(false);
                ((RelCellReaderImpl)cellReader).loadAggregations();
            } while (++count < RelUtil.MAX_AGGREGATION_PASS_COUNT);
            throw Util.newInternal("Query required more than " + count + " iterations");
        }
    }

    private StripeResult executeStripe(int axis, EvaluatorImpl evaluator) throws OLAPException {
        if (axis < 0) {
            Member[] context = null;
            Object o = null;
            try {
                context = (Member[])evaluator.getCurrentMembers().clone();
                o = evaluator.evaluateCurrent();
            }
            catch (OLAPException e) {
                logger.debug((Object)e);
                o = e;
            }
            if (o == ValueNotReady.instance) {
                return new StripeResult(null, false, true);
            }
            if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
                String fmtStr = null;
                Member solveMember = evaluator.getMaxSolveMember();
                if (solveMember != null) {
                    fmtStr = (String)solveMember.getProperty("formatString");
                }
                if (fmtStr == null) {
                    Member measure = evaluator.getContext(evaluator.getCube().getMeasureDimension());
                    fmtStr = (String)measure.getProperty("formatString");
                }
                if (fmtStr != null) {
                    fmtStr = this.resolveFomatString(evaluator, fmtStr);
                }
                CellImpl cell = new CellImpl(context, o, this.getFormatter(fmtStr));
                return new StripeResult(cell, false, false);
            }
            return new StripeResult(null, false, false);
        }
        QueryAxis queryAxis = this.getAxis(axis);
        boolean nonempty = queryAxis.isNonEmpty();
        IList positions = (IList)this.axisPositionList.get(queryAxis);
        IList positions2 = this.query.getListFactory().createArrayList();
        int i = 0;
        boolean allNull = true;
        boolean valueNotReader = false;
        int count = 0;
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            block17: {
                Member[] members;
                block18: {
                    StripeResult sr;
                    block16: {
                        members = this.toMemberArray(iter.next());
                        for (int j = 0; j < members.length; ++j) {
                            evaluator.setContext(members[j]);
                        }
                        sr = this.executeStripe(axis - 1, evaluator);
                        if (sr.valueNotReader) {
                            valueNotReader = true;
                        }
                        if (axis != 1) break block16;
                        if (nonempty && !sr.valueNotReader && sr.allNull) break block17;
                        this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                        break block18;
                    }
                    boolean nonfactempty = this.getAxis(1).isNonFactEmpty();
                    this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                    if (sr.cell != null) {
                        CellKey key = this.point.copy();
                        this.cellValues.put(key, sr.cell);
                        if (allNull) {
                            if (nonfactempty) {
                                Member[] ms = sr.cell.getMemberContext();
                                Member measureMember = ms[ms.length - 1];
                                if (!measureMember.isCalculated()) {
                                    allNull = false;
                                }
                            } else {
                                allNull = false;
                            }
                        }
                    }
                }
                positions2.add(members);
            }
            ++count;
        }
        this.axisPositionList.put(queryAxis, positions2);
        return new StripeResult(null, allNull, valueNotReader);
    }

    private String resolveFomatString(EvaluatorImpl evaluator, String fmtStr) throws OLAPException {
        if (fmtStr.toLowerCase(Locale.ENGLISH).startsWith("mdx:")) {
            fmtStr = fmtStr.substring(4);
            ExpResolver resolver = evaluator.getQuery().createExpResolver();
            Exp exp = evaluator.getQuery().getConnection().parseExpression(fmtStr);
            exp = resolver.resolve(exp);
            Calc calc = evaluator.getQuery().compileExpression(exp, false);
            Object o = calc.evaluate(evaluator.push());
            if (!(o instanceof String)) {
                throw new OLAPException("formatString expression must return String.");
            }
            String formatExp = (String)o;
            return formatExp;
        }
        return fmtStr;
    }

    @Override
    public Cell getCell(int[] pos) {
        Object value;
        int[] pos2 = (int[])pos.clone();
        if (this.axis0PositionMap != null) {
            int index = this.getAxisIndex(0);
            pos2[index] = (Integer)this.axis0PositionMap.get(new Integer(pos[index]));
        }
        if ((value = this.cellValues.get(new CellKey(pos2))) == null) {
            return new CellImpl(this.getMdxMembers(pos));
        }
        return (Cell)value;
    }

    public MdxMember[] getMdxMembers(int[] pos) {
        ArrayList<MdxMember> list = new ArrayList<MdxMember>();
        for (int i = -1; i < this.axes.length; ++i) {
            MdxAxis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            MdxPosition position = axis.positions[index];
            MdxMember[] mdxMembers = position.getMdxMembers();
            for (int j = 0; j < mdxMembers.length; ++j) {
                list.add(mdxMembers[j]);
            }
        }
        MdxMember[] ms = new MdxMember[list.size()];
        list.toArray(ms);
        return ms;
    }

    private Formatter getFormatter(String formatString) {
        if (formatString == null) {
            return null;
        }
        Formatter f = (Formatter)this.formats.get(formatString);
        if (f == null) {
            f = new Formatter(formatString);
            this.formats.put(formatString, f);
        }
        return f;
    }

    private class StripeResult {
        Cell cell;
        boolean allNull;
        boolean valueNotReader;

        public StripeResult(Cell cell, boolean allNull, boolean valueNotReader) {
            this.cell = cell;
            this.allNull = allNull;
            this.valueNotReader = valueNotReader;
        }
    }
}

