/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.rel.MemberCache;
import com.kingdee.bos.olap.rel.MemberKey;
import com.kingdee.bos.olap.rel.MemberReader;
import com.kingdee.bos.olap.rel.PCMemberReaderImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.util.Util;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SmartMemberReader
implements MemberReader,
MemberCache {
    private final MemberReader source;
    private final Map mapMemberToChildren;
    private final Map mapUniqueNameToMember;
    private IMemberList rootMembers;
    private final Map mapLevelToMembers;
    int memberCount = -1;

    SmartMemberReader(MemberReader source) {
        this.source = source;
        source.setCache(this);
        this.mapLevelToMembers = new HashMap();
        this.mapUniqueNameToMember = new HashMap();
        this.mapMemberToChildren = new HashMap();
    }

    @Override
    public RelHierarchyImpl getHierarchy() {
        return this.source.getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public Object makeKey(RelMemberImpl parent, Object key) {
        return new MemberKey(parent, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelMemberImpl getMember(String uniqueName) {
        Map map = this.mapUniqueNameToMember;
        synchronized (map) {
            SoftReference ref = (SoftReference)this.mapUniqueNameToMember.get(uniqueName);
            if (ref == null) {
                return null;
            }
            RelMemberImpl member = (RelMemberImpl)ref.get();
            if (member == null) {
                this.mapUniqueNameToMember.remove(uniqueName);
            }
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMember(String uniqueName, RelMemberImpl member) {
        Map map = this.mapUniqueNameToMember;
        synchronized (map) {
            this.mapUniqueNameToMember.put(uniqueName, new SoftReference<RelMemberImpl>(member));
        }
    }

    @Override
    public IMemberList getHierarchizeMembers() throws OLAPException {
        IMemberList members = this.getMembers();
        FuncUtil2.hierarchize(members, false);
        return members;
    }

    @Override
    public IMemberList getMembers() throws OLAPException {
        RelHierarchyImpl hie = this.source.getHierarchy();
        if (hie.levels.length == 1) {
            IMemberList list = this.source.getListFactory().createMemberList();
            list.addList(this.getMembersInLevel(hie.levels[0]));
            return list;
        }
        if (hie.hasAll() && hie.levels.length == 2) {
            IMemberList list = this.source.getListFactory().createMemberList();
            list.addList(this.getMembersInLevel(hie.levels[0]));
            list.addList(this.getMembersInLevel(hie.levels[1]));
            return list;
        }
        if (this.mapLevelToMembers.size() != 0) {
            IMemberList list = this.source.getListFactory().createMemberList();
            for (int i = 0; i < hie.levels.length; ++i) {
                list.addList(this.getMembersInLevel(hie.levels[i]));
            }
            return list;
        }
        IMemberList list = this.source.getMembers();
        IMemberList[] levelMembers = new IMemberList[hie.levels.length];
        for (int i = 0; i < levelMembers.length; ++i) {
            levelMembers[i] = this.source.getListFactory().createMemberList();
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            RelMemberImpl member = (RelMemberImpl)iter.next();
            levelMembers[member.level.depth].add(member);
        }
        for (int i = 0; i < levelMembers.length; ++i) {
            SoftReference<IMemberList> ref = new SoftReference<IMemberList>(levelMembers[i]);
            this.mapLevelToMembers.put(hie.levels[i], ref);
        }
        return list;
    }

    @Override
    public IMemberList getRootMembers() throws OLAPException {
        if (this.rootMembers == null) {
            this.rootMembers = this.source.getRootMembers();
        }
        return this.rootMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemberList getMembersInLevel(RelLevelImpl level) throws OLAPException {
        Map map = this.mapLevelToMembers;
        synchronized (map) {
            IMemberList members;
            SoftReference<IMemberList> ref = (SoftReference<IMemberList>)this.mapLevelToMembers.get(level);
            if (ref != null) {
                members = (IMemberList)ref.get();
                if (members != null) {
                    IMemberList result = this.source.getListFactory().createMemberList();
                    result.addList(members);
                    return result;
                }
                this.mapLevelToMembers.remove(level);
            }
            members = this.source.getMembersInLevel(level);
            ref = new SoftReference<IMemberList>(members);
            this.mapLevelToMembers.put(level, ref);
            return members;
        }
    }

    @Override
    public void getMemberChildren(RelMemberImpl parentMember, IMemberList children) throws OLAPException {
        if (parentMember.isLeaf()) {
            return;
        }
        IMemberList parentMembers = this.source.getListFactory().createMemberList();
        parentMembers.add(parentMember);
        this.getMemberChildren(parentMembers, children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMemberChildren(IMemberList parentMembers, IMemberList children) throws OLAPException {
        if (this.source instanceof PCMemberReaderImpl) {
            this.source.getMemberChildren(parentMembers, children);
            return;
        }
        Map map = this.mapMemberToChildren;
        synchronized (map) {
            IMemberList missed = this.source.getListFactory().createMemberList();
            Iterator it = parentMembers.iterator();
            while (it.hasNext()) {
                RelMemberImpl parent = (RelMemberImpl)it.next();
                String uniqueName = parent.getUniqueName();
                SoftReference ref = (SoftReference)this.mapMemberToChildren.get(uniqueName);
                if (ref == null) {
                    missed.add(parent);
                    continue;
                }
                IMemberList v = (IMemberList)ref.get();
                if (v == null) {
                    this.mapMemberToChildren.remove(uniqueName);
                    missed.add(parent);
                    continue;
                }
                children.addList(v);
            }
            if (missed.size() > 0) {
                children = this.readMemberChildren(missed, children);
            }
        }
    }

    @Override
    public RelMemberImpl lookupMember(String[] uniqueNameParts) throws OLAPException {
        String uniqueName = Util.implode(uniqueNameParts);
        RelMemberImpl o = this.getMember(uniqueName);
        if (o != null) {
            return o;
        }
        RelMemberImpl member = RelUtil.lookupMember(this, uniqueNameParts);
        this.putMember(uniqueName, member);
        return member;
    }

    private IMemberList readMemberChildren(IMemberList members, IMemberList result) throws OLAPException {
        IMemberList list;
        IMemberList children = this.source.getListFactory().createMemberList();
        this.source.getMemberChildren(members, children);
        HashMap tempMap = new HashMap();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            tempMap.put(iter.next(), this.source.getListFactory().createMemberList());
        }
        iter = children.iterator();
        while (iter.hasNext()) {
            RelMemberImpl child = (RelMemberImpl)iter.next();
            list = (IMemberList)tempMap.get(child.getParentMember());
            list.add(child);
            result.add(child);
        }
        for (RelMemberImpl member : tempMap.keySet()) {
            list = (IMemberList)tempMap.get(member);
            if (this.hasChildren(member)) continue;
            this.putChildren(member, list);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren(RelMemberImpl member) {
        Map map = this.mapMemberToChildren;
        synchronized (map) {
            return this.mapMemberToChildren.get(member.getUniqueName()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putChildren(RelMemberImpl member, IMemberList children) {
        Map map = this.mapMemberToChildren;
        synchronized (map) {
            SoftReference<IMemberList> ref = new SoftReference<IMemberList>(children);
            this.mapMemberToChildren.put(member.getUniqueName(), ref);
        }
    }

    @Override
    public int getMemberCount() throws OLAPException {
        if (this.memberCount == -1) {
            this.memberCount = this.source.getMemberCount();
        }
        return this.memberCount;
    }

    @Override
    public int getLevelMemberCount(RelLevelImpl level) throws OLAPException {
        return this.source.getLevelMemberCount(level);
    }

    @Override
    public void getMemberDescendants(RelMemberImpl member, IMemberList result, RelLevelImpl level, boolean before, boolean self, boolean after) throws OLAPException {
        RelUtil.getMemberDescendants(this, member, level, result, before, self, after);
    }

    @Override
    public void getMemberRange(RelLevelImpl level, RelMemberImpl startMember, RelMemberImpl endMember, IMemberList list) throws OLAPException {
        RelUtil.getMemberRange(this, level, startMember, endMember, list);
    }

    @Override
    public RelMemberImpl getLeadMember(RelMemberImpl member, int n) throws OLAPException {
        return RelUtil.getLeadMember(this, member, n);
    }

    @Override
    public RelMemberImpl getAllMember() throws OLAPException {
        return this.source.getAllMember();
    }

    @Override
    public void init() throws OLAPException {
    }

    @Override
    public IListFactory getListFactory() {
        return this.source.getListFactory();
    }
}

