/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.rel.Aggregation;
import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.RelAggregator;
import com.kingdee.bos.olap.rel.Segment;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.util.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;

public class SqlGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String generateSQL(Aggregation aggregation, Segment[] segments) throws SQLException, OLAPException {
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(segments);
        Connection jdbcConnection = null;
        jdbcConnection = aggregation.getStar().getSchema().conn.getJdbcConnection();
        try {
            Dimension[] useDims;
            boolean hasMeasureProperty = spec.hasMeasureProperty();
            if (!hasMeasureProperty) {
                String string = SqlGenerator.generateSql_1(aggregation, spec, jdbcConnection);
                return string;
            }
            Dimension[] dims = aggregation.getStar().getCube().getDimensions();
            if (dims.length > (useDims = SqlGenerator.getDimensions(aggregation, spec)).length) {
                String string = SqlGenerator.generateSql_2(aggregation, spec, jdbcConnection);
                return string;
            }
            if (!aggregation.getStar().hasPCDimension()) {
                if (!aggregation.isDetail()) {
                    String string = SqlGenerator.generateSql_3_1(aggregation, spec, jdbcConnection);
                    return string;
                }
                String string = SqlGenerator.generateSql_3_2(aggregation, spec, jdbcConnection);
                return string;
            }
            if (!aggregation.isDetailExcludePC()) {
                String string = SqlGenerator.generateSql_4_1(aggregation, spec, jdbcConnection);
                return string;
            }
            String string = SqlGenerator.generateSql_4_2(aggregation, spec, jdbcConnection);
            return string;
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static SqlQuery generateSql_pre(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = new SqlQuery(jdbcConnection.getMetaData());
        Star.Column[] columns = aggregation.getColumns();
        int arity = columns.length;
        HashSet<Star.Table> tableSet = new HashSet<Star.Table>();
        for (int i = 0; i < arity; ++i) {
            Star.Column column = columns[i];
            Star.Table table = column.getTable();
            if (!tableSet.contains(table)) {
                table.addToFrom(sqlQuery);
                table.addConstraint(sqlQuery);
                tableSet.add(table);
            }
            String expr = column.getExpression(sqlQuery);
            ColumnConstraint[] constraints = spec.getConstraints(i);
            if (constraints != null) {
                sqlQuery.addWhere(column.createInExpr(expr, constraints));
            }
            sqlQuery.addSelect(expr, spec.getColumnAlias(i));
            sqlQuery.addGroupBy(expr);
        }
        return sqlQuery;
    }

    private static String generateSql_1(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = SqlGenerator.generateSql_pre(aggregation, spec, jdbcConnection);
        Star star = aggregation.getStar();
        Star.Table factTable = star.getFactTable();
        factTable.addToFrom(sqlQuery);
        int measureCount = spec.getMeasureCount();
        for (int i = 0; i < measureCount; ++i) {
            Star.Column measure = spec.getMeasure(i);
            Util.assertTrue(measure.getTable() == star.getFactTable());
            Util.assertPrecondition(measure instanceof Star.Measure);
            String expr = measure.getExpression(null);
            expr = ((Star.Measure)measure).getAggregator().getExpression(expr);
            sqlQuery.addSelect(expr, spec.getMeasureAlias(i));
        }
        return sqlQuery.toString();
    }

    private static String generateSql_2(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = SqlGenerator.generateSql_pre(aggregation, spec, jdbcConnection);
        Star star = aggregation.getStar();
        Star.Table factTable = star.getFactTable();
        factTable.addToFrom(sqlQuery);
        int measureCount = spec.getMeasureCount();
        for (int i = 0; i < measureCount; ++i) {
            String expr;
            Star.Column measure = spec.getMeasure(i);
            Util.assertTrue(measure.getTable() == star.getFactTable());
            if (measure instanceof Star.Measure) {
                expr = measure.getExpression(null);
                expr = ((Star.Measure)measure).getAggregator().getExpression(expr);
            } else {
                expr = "null";
            }
            sqlQuery.addSelect(expr, spec.getMeasureAlias(i));
        }
        return sqlQuery.toString();
    }

    private static String generateSql_3_1(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        return SqlGenerator.generateSql_2(aggregation, spec, jdbcConnection);
    }

    private static String generateSql_3_2(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = SqlGenerator.generateSql_pre(aggregation, spec, jdbcConnection);
        Star star = aggregation.getStar();
        Star.Table factTable = star.getFactTable();
        factTable.addToFrom(sqlQuery);
        int measureCount = spec.getMeasureCount();
        for (int i = 0; i < measureCount; ++i) {
            String expr;
            Star.Column measure = spec.getMeasure(i);
            Util.assertTrue(measure.getTable() == star.getFactTable());
            if (measure instanceof Star.Measure) {
                expr = measure.getExpression(null);
                expr = ((Star.Measure)measure).getAggregator().getExpression(expr);
            } else {
                expr = measure.getExpression(null);
                expr = RelAggregator.Max.getExpression(expr);
            }
            sqlQuery.addSelect(expr, spec.getMeasureAlias(i));
        }
        return sqlQuery.toString();
    }

    private static String generateSql_4_1(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        return SqlGenerator.generateSql_3_1(aggregation, spec, jdbcConnection);
    }

    private static String generateSql_4_2(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        String left = SqlGenerator.generateSql_4_2_left(aggregation, spec, jdbcConnection);
        String right = SqlGenerator.generateSql_4_2_right(aggregation, spec, jdbcConnection);
        return "(" + left + ") union (" + right + ")";
    }

    private static String generateSql_4_2_left(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = SqlGenerator.generateSql_pre(aggregation, spec, jdbcConnection);
        Star star = aggregation.getStar();
        Star.Table factTable = star.getFactTable();
        factTable.addToFrom(sqlQuery);
        int measureCount = spec.getMeasureCount();
        for (int i = 0; i < measureCount; ++i) {
            String expr;
            Star.Column measure = spec.getMeasure(i);
            Util.assertTrue(measure.getTable() == star.getFactTable());
            if (measure instanceof Star.Measure) {
                expr = measure.getExpression(null);
                expr = ((Star.Measure)measure).getAggregator().getExpression(expr);
            } else {
                expr = "null";
            }
            sqlQuery.addSelect(expr, spec.getMeasureAlias(i));
        }
        return sqlQuery.toString();
    }

    private static String generateSql_4_2_right(Aggregation aggregation, QuerySpec spec, Connection jdbcConnection) throws OLAPException, SQLException {
        SqlQuery sqlQuery = SqlGenerator.generateSql_pre(aggregation, spec, jdbcConnection);
        Star star = aggregation.getStar();
        Star.Table factTable = star.getFactTable();
        factTable.addToFrom(sqlQuery);
        int measureCount = spec.getMeasureCount();
        for (int i = 0; i < measureCount; ++i) {
            String expr;
            Star.Column measure = spec.getMeasure(i);
            Util.assertTrue(measure.getTable() == star.getFactTable());
            if (measure instanceof Star.Measure) {
                expr = measure.getExpression(null);
                expr = ((Star.Measure)measure).getAggregator().getExpression(expr);
            } else {
                expr = measure.getExpression(null);
                expr = RelAggregator.Max.getExpression(expr);
            }
            sqlQuery.addSelect(expr, spec.getMeasureAlias(i));
        }
        Star.Column[] columns = SqlGenerator.getPCColumns(aggregation, spec);
        HashSet<Star.Table> tableSet = new HashSet<Star.Table>();
        for (int i = 0; i < columns.length; ++i) {
            Star.Column column = columns[i];
            Star.Table table = column.getTable();
            if (tableSet.contains(table)) continue;
            table.addIsLeafConstraint(sqlQuery, column);
            tableSet.add(table);
        }
        return sqlQuery.toString();
    }

    private static Dimension[] getDimensions(Aggregation aggregation, QuerySpec spec) {
        Star.Column[] columns = aggregation.getColumns();
        HashSet<Dimension> set = new HashSet<Dimension>();
        for (int i = 0; i < columns.length; ++i) {
            set.add(columns[i].getLevel().getDimension());
        }
        Dimension[] dims = new Dimension[set.size()];
        set.toArray(dims);
        return dims;
    }

    private static Star.Column[] getPCColumns(Aggregation aggregation, QuerySpec spec) {
        Star.Column[] columns = aggregation.getColumns();
        ArrayList<Star.Column> list = new ArrayList<Star.Column>();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getLevel().getDimension().isParentChildrenDimension()) continue;
            list.add(columns[i]);
        }
        columns = new Star.Column[list.size()];
        list.toArray(columns);
        return columns;
    }

    private static class SegmentArrayQuerySpec
    implements QuerySpec {
        final Segment[] segments;

        SegmentArrayQuerySpec(Segment[] segments) {
            this.segments = segments;
        }

        @Override
        public int getMeasureCount() {
            return this.segments.length;
        }

        @Override
        public Star.Column getMeasure(int i) {
            return this.segments[i].measure;
        }

        @Override
        public String getMeasureAlias(int i) {
            return "m" + Integer.toString(i);
        }

        @Override
        public boolean hasMeasureProperty() {
            for (int i = 0; i < this.segments.length; ++i) {
                if (!(this.getMeasure(i) instanceof Star.MeasureProperty)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getColumnAlias(int i) {
            return "c" + Integer.toString(i);
        }

        @Override
        public ColumnConstraint[] getConstraints(int i) {
            return this.segments[0].axes[i].constraints;
        }
    }

    private static interface QuerySpec {
        public int getMeasureCount();

        public Star.Column getMeasure(int var1);

        public String getMeasureAlias(int var1);

        public String getColumnAlias(int var1);

        public boolean hasMeasureProperty();

        public ColumnConstraint[] getConstraints(int var1);
    }
}

