/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.server;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaParser;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.server.Instance;
import com.kingdee.bos.olap.server.meta.DimensionMeta;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class Database {
    private Instance instance;
    private String name;
    private String path;
    private String databaseFileName = "database.xml";
    private String schemaFileName = "schema.xml";
    private boolean open;
    RelConnectionImpl connection;
    SchemaDef schemaDef;
    private HashMap statementCache = new HashMap();
    private int statementCacheCount = 10;

    public Database(Instance instance, String name) {
        this.instance = instance;
        this.name = name;
        this.path = name;
        this.databaseFileName = this.path + File.separator + this.databaseFileName;
        this.schemaFileName = this.path + File.separator + this.schemaFileName;
    }

    public String getName() {
        return this.name;
    }

    public int getDimensionCount() throws OLAPException {
        this.openDatabase();
        return this.schemaDef.dimensions.length;
    }

    public DimensionMeta getDimensionMeta(String dimName) throws OLAPException {
        this.openDatabase();
        for (int i = 0; i < this.schemaDef.dimensions.length; ++i) {
            if (!this.schemaDef.dimensions[i].name.equals(dimName)) continue;
            return new DimensionMeta(this, this.schemaDef.dimensions[i]);
        }
        return null;
    }

    public SchemaDef getSchemaDef() throws OLAPException {
        try {
            return SchemaParser.parse(new SAXBuilder().build(new File(this.schemaFileName)));
        }
        catch (JDOMException e) {
            throw new OLAPException(e);
        }
        catch (IOException e) {
            throw new OLAPException(e);
        }
    }

    public void saveSchemaDef(SchemaDef schemaDef) {
    }

    public void processDimension(String dimensionName) {
    }

    public void processionCube(String cubeName) {
    }

    private void openDatabase() throws OLAPException {
        if (this.open) {
            return;
        }
        HashMap params = new HashMap();
        this.schemaDef = this.getSchemaDef();
        this.connection = new RelConnectionImpl(this.schemaDef, params);
        this.open = true;
    }

    private void closeDatabase() throws OLAPException {
        if (!this.open) {
            return;
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public MdxResult executeMdxQuery(String mdx) throws OLAPException {
        this.openDatabase();
        MdxQuery query = null;
        query = (MdxQuery)this.statementCache.get(mdx);
        if (query == null) {
            query = this.connection.parseQuery(mdx);
            if (this.statementCache.size() > this.statementCacheCount) {
                this.statementCache.clear();
            }
            this.statementCache.put(mdx, query);
        }
        return this.connection.executeMdxQuery(query);
    }
}

