/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.helper.KDHelperBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class BarPartArea
extends JPanel {
    private static final long serialVersionUID = 4052278451308399561L;
    public static final int EAST = 3;
    public static final int SOUTH = 5;
    public static final int WEST = 7;
    public static final int NORTH = 1;
    public static final String PARALLEL_MOTION = "parallel";
    public static final String INSERT_MOTION = "insert";
    private static final Dimension BarDefault_PreferredSize = new Dimension(0, 0);
    private int areaOrientation = 1;
    private Hashtable hash = null;
    public static final String KDSTATUSBAR_IDENTIFY = "kdstatusbar";
    public static final String KDMENUBAR_IDENTIFY = "kdmenubar";
    public static final String KDTOOLBAR_IDENTIFY = "jtoolbars";
    public static final String KDHELPERBAR_IDENTIFY = "kdhelperbar";
    private boolean isHasStatusBar = false;
    private boolean isHasMenuBar = false;
    private ArrayList toolBarRowContainers = new ArrayList();
    private int rowCount = 0;
    private static final boolean DEBUG = false;
    private boolean helperBarExists = false;

    public BarPartArea(int orientation) {
        if (!this.isLegalOrientation(orientation)) {
            throw new IllegalArgumentException("orientation is legal.");
        }
        this.areaOrientation = orientation;
        this.setPreferredSize(BarDefault_PreferredSize);
        this.setLayout(new PartAreaLayout(this.areaOrientation));
        this.setOpaque(false);
    }

    public void addSanBar(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof KDHelperBar) {
            this.setKDHelperBar((KDHelperBar)comp);
        } else if (comp instanceof KDStatusBar) {
            this.setKDStatusBar((KDStatusBar)comp);
        } else if (comp instanceof JMenuBar) {
            this.setJMenuBar((JMenuBar)comp);
        } else if (comp instanceof JToolBar) {
            this.addJToolBar((JToolBar)comp);
        }
    }

    public void removeSanBar(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof KDHelperBar) {
            this.removeKDHelperBar((KDHelperBar)comp);
        } else if (comp instanceof KDStatusBar) {
            this.removeKDStatusBar((KDStatusBar)comp);
        } else if (comp instanceof JMenuBar) {
            this.removeJMenuBar((JMenuBar)comp);
        } else if (comp instanceof JToolBar) {
            this.removeJToolBar((JToolBar)comp);
        }
    }

    public void addJToolBar(JToolBar toolBar) {
        this.addJToolBar(toolBar, 0);
    }

    public void addJToolBar(JToolBar toolBar, int columnIndex) {
        if (toolBar != null) {
            KDToolBarRowContainer lineContainer;
            for (int i = 0; i < this.toolBarRowContainers.size(); ++i) {
                KDToolBarRowContainer rowContainer = (KDToolBarRowContainer)this.toolBarRowContainers.get(i);
                Component[] comps = rowContainer.getComponents();
                for (int j = 0; j < comps.length; ++j) {
                    if (comps[j] != toolBar) continue;
                    return;
                }
            }
            if (((KDToolBar)toolBar).getRowID() == 0) {
                KDToolBar[] toolBars = this.getToolBars();
                this.removeAllJToolBar();
                ((KDToolBar)toolBar).setRowID(((KDToolBar)toolBar).getRowID() + 1);
                this.addJToolBar(toolBar);
                for (int i = 0; i < toolBars.length; ++i) {
                    toolBars[i].setRowID(toolBars[i].getRowID() + 1);
                    this.addJToolBar(toolBars[i]);
                }
                return;
            }
            if (((KDToolBar)toolBar).getRowID() > this.rowCount + 1) {
                ((KDToolBar)toolBar).setRowID(this.rowCount + 1);
            }
            if (((KDToolBar)toolBar).getRowID() == -1) {
                ((KDToolBar)toolBar).setRowID(this.rowCount + 1);
            }
            int ori = toolBar.getOrientation();
            if (this.areaOrientation == 1 || this.areaOrientation == 5) {
                if (ori != 0) {
                    toolBar.setOrientation(0);
                }
            } else if (ori != 1) {
                toolBar.setOrientation(1);
            }
            for (int i = 0; i < this.toolBarRowContainers.size(); ++i) {
                KDToolBarRowContainer lineContainer2 = (KDToolBarRowContainer)this.toolBarRowContainers.get(i);
                if (lineContainer2.getRowID() != ((KDToolBar)toolBar).getRowID()) continue;
                if (columnIndex == 0) {
                    lineContainer2.add(toolBar);
                } else {
                    lineContainer2.add((Component)toolBar, columnIndex);
                }
                lineContainer2.validate();
                lineContainer2.repaint();
                return;
            }
            if (this.areaOrientation == 1 || this.areaOrientation == 5) {
                ++this.rowCount;
                lineContainer = new KDToolBarRowContainer(((KDToolBar)toolBar).getRowID());
            } else {
                ++this.rowCount;
                lineContainer = new KDToolBarRowContainer(((KDToolBar)toolBar).getRowID());
            }
            this.add((Component)lineContainer, KDTOOLBAR_IDENTIFY);
            if (columnIndex == 0) {
                lineContainer.add(toolBar);
            } else {
                lineContainer.add((Component)toolBar, columnIndex);
            }
            this.toolBarRowContainers.add(lineContainer);
            lineContainer.validate();
            this.repaint();
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof KDHelperBar) {
            constraints = KDHELPERBAR_IDENTIFY;
        } else if (comp instanceof JToolBar) {
            constraints = KDTOOLBAR_IDENTIFY;
        } else if (comp instanceof JMenuBar) {
            constraints = KDMENUBAR_IDENTIFY;
        } else if (comp instanceof KDStatusBar) {
            constraints = KDSTATUSBAR_IDENTIFY;
        }
        super.addImpl(comp, constraints, index);
    }

    public void removeJToolBar(JToolBar toolBar) {
        if (toolBar != null) {
            int i;
            int count = this.getComponentCount();
            KDToolBarRowContainer[] rowContainers = new KDToolBarRowContainer[count];
            int iIndex = 0;
            for (i = 0; i < count; ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof KDToolBarRowContainer)) continue;
                rowContainers[iIndex] = (KDToolBarRowContainer)comp;
                ++iIndex;
            }
            count = 0;
            for (i = 0; i < rowContainers.length && rowContainers[i] != null; ++i) {
                for (int j = 0; j < rowContainers[i].getComponentCount(); ++j) {
                    if (rowContainers[i].getComponent(j) != toolBar) continue;
                    if (rowContainers[i].getComponentCount() > 1) {
                        rowContainers[i].remove(toolBar);
                        rowContainers[i].revalidate();
                        rowContainers[i].repaint();
                        continue;
                    }
                    for (int m = i + 1; m < this.rowCount; ++m) {
                        rowContainers[m].setRowID(rowContainers[m].getRowID() - 1);
                    }
                    this.toolBarRowContainers.remove(rowContainers[i]);
                    this.remove(rowContainers[i]);
                    --this.rowCount;
                    this.revalidate();
                    this.repaint();
                }
            }
        }
    }

    public void removeKDHelperBar(KDHelperBar helperBar) {
        if (helperBar != null) {
            this.remove(helperBar);
            this.helperBarExists = false;
        }
    }

    public void removeKDStatusBar(KDStatusBar statusBar) {
        if (statusBar != null) {
            this.remove(statusBar);
            this.getHash().remove(KDSTATUSBAR_IDENTIFY);
            this.isHasStatusBar = false;
        }
    }

    public void removeAllKDStatusBar() {
        Object obj = this.getHash().get(KDSTATUSBAR_IDENTIFY);
        if (obj != null && obj instanceof KDStatusBar) {
            this.removeKDStatusBar((KDStatusBar)obj);
        }
    }

    public void removeJMenuBar(JMenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        this.remove(menuBar);
        this.getHash().remove(KDMENUBAR_IDENTIFY);
        this.isHasMenuBar = false;
    }

    public void removeAllJToolBar() {
        this.rowCount = 0;
        this.toolBarRowContainers.clear();
        int count = this.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof KDToolBarRowContainer)) continue;
            this.remove(comp);
        }
        this.revalidate();
        this.repaint();
    }

    public void setKDHelperBar(KDHelperBar helperBar) {
        if (helperBar != null) {
            this.add((Component)helperBar, KDHELPERBAR_IDENTIFY);
            int ori = helperBar.getOrientation();
            if (this.areaOrientation == 1 || this.areaOrientation == 5) {
                if (ori != 0) {
                    helperBar.setOrientation(0);
                }
            } else if (ori != 1) {
                helperBar.setOrientation(1);
            }
            this.helperBarExists = true;
        }
    }

    public void setKDStatusBar(KDStatusBar statusBar) {
        if (statusBar != null) {
            this.add((Component)statusBar, KDSTATUSBAR_IDENTIFY);
            this.getHash().put(KDSTATUSBAR_IDENTIFY, statusBar);
            this.isHasStatusBar = true;
        }
    }

    public void setJMenuBar(JMenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        JMenuBar oldMenuBar = this.getJMenuBar();
        if (oldMenuBar != menuBar) {
            try {
                if (oldMenuBar != null) {
                    this.remove(oldMenuBar);
                    this.getHash().remove(KDMENUBAR_IDENTIFY);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.add((Component)menuBar, KDMENUBAR_IDENTIFY);
            this.getHash().put(KDMENUBAR_IDENTIFY, menuBar);
            this.isHasMenuBar = true;
            this.validate();
            this.repaint();
        }
    }

    public KDStatusBar getKDStatusBar() {
        if (!this.isHasStatusBar) {
            return null;
        }
        Object obj = this.getHash().get(KDSTATUSBAR_IDENTIFY);
        if (obj != null && obj instanceof KDStatusBar) {
            return (KDStatusBar)obj;
        }
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof KDStatusBar)) continue;
            this.getHash().put(KDSTATUSBAR_IDENTIFY, comp);
            return (KDStatusBar)comp;
        }
        return null;
    }

    public JToolBar getJToolBar(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        KDToolBar[] tbrs = this.getToolBars();
        if (tbrs != null && tbrs.length > 0) {
            int len = tbrs.length;
            if (index < len) {
                return tbrs[index];
            }
            return null;
        }
        return null;
    }

    public KDToolBar[] getToolBars() {
        int i;
        KDToolBar[] comps = new KDToolBar[]{};
        if (!(this.isHasMenuBar || this.isHasStatusBar || this.helperBarExists)) {
            int i2;
            Component[] lineContainers = this.getComponents();
            int count = 0;
            for (i2 = 0; i2 < lineContainers.length; ++i2) {
                count += ((KDToolBarRowContainer)lineContainers[i2]).getComponentCount();
            }
            comps = new KDToolBar[count];
            count = 0;
            for (i2 = 0; i2 < lineContainers.length; ++i2) {
                KDToolBarRowContainer lineContainer = (KDToolBarRowContainer)lineContainers[i2];
                for (int j = 0; j < lineContainer.getComponentCount(); ++j) {
                    comps[count] = (KDToolBar)lineContainer.getComponent(j);
                    ++count;
                }
            }
            return comps;
        }
        int count = this.getComponentCount();
        Component[] lineContainers = new Component[count];
        int iIndex = 0;
        for (i = 0; i < count; ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof KDToolBarRowContainer)) continue;
            lineContainers[iIndex] = comp;
            ++iIndex;
        }
        if (iIndex == 0) {
            return comps;
        }
        count = 0;
        for (i = 0; i < lineContainers.length && lineContainers[i] != null; ++i) {
            count += ((KDToolBarRowContainer)lineContainers[i]).getComponentCount();
        }
        comps = new KDToolBar[count];
        count = 0;
        for (i = 0; i < lineContainers.length && lineContainers[i] != null; ++i) {
            KDToolBarRowContainer lineContainer = (KDToolBarRowContainer)lineContainers[i];
            for (int j = 0; j < lineContainer.getComponentCount(); ++j) {
                comps[count] = (KDToolBar)lineContainer.getComponent(j);
                ++count;
            }
        }
        return comps;
    }

    public int getToolBarRowCount() {
        return this.rowCount;
    }

    public JMenuBar getJMenuBar() {
        if (!this.isHasMenuBar) {
            return null;
        }
        Object obj = this.getHash().get(KDMENUBAR_IDENTIFY);
        if (obj != null && obj instanceof JMenuBar) {
            return (JMenuBar)obj;
        }
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof JMenuBar)) continue;
            return (JMenuBar)comp;
        }
        return null;
    }

    public int getAreaOrientation() {
        return this.areaOrientation;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        this.logs("setSize --- ");
    }

    private boolean isLegalOrientation(int orientation) {
        switch (orientation) {
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private Hashtable getHash() {
        if (this.hash == null) {
            this.hash = new Hashtable(0);
        }
        return this.hash;
    }

    private void logs(String info) {
    }

    public boolean isHelperBarExist() {
        return this.helperBarExists;
    }

    public class KDToolBarRowContainer
    extends KDPanel {
        public static final int SHADOW_HORIZONTAL = 1;
        public static final int SHADOW_VERTICAL = 2;
        private int rowID;

        public KDToolBarRowContainer(int rowID) {
            this.setLayout(new KDToolBarRowContainerLayoutManager());
            this.rowID = rowID;
        }

        public void setRowID(int rowID) {
            this.rowID = rowID;
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                ((KDToolBar)comps[i]).setRowID(rowID);
            }
        }

        public int getRowID() {
            return this.rowID;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int shadowOrientation;
            Color fifthsShadowColor;
            Color fourthShadowColor;
            Color thirdShadowColor;
            Color secondShadowColor;
            Color firstShadowColor;
            super.paintComponent(g);
            Insets ins = this.getInsets();
            int height = this.getHeight();
            int width = this.getWidth();
            ins = ins != null ? ins : new Insets(2, 0, 2, 0);
            Color topColor = UIManager.getColor("ToolBar.topColor");
            if (topColor == null) {
                topColor = Color.decode("#B6C8D8");
            }
            if ((firstShadowColor = UIManager.getColor("ToolBar.firstShadowColor")) == null) {
                firstShadowColor = Color.decode("#CEDBE7");
            }
            if ((secondShadowColor = UIManager.getColor("ToolBar.secondShadowColor")) == null) {
                secondShadowColor = Color.decode("#C6D6E4");
            }
            if ((thirdShadowColor = UIManager.getColor("ToolBar.thirdShadowColor")) == null) {
                thirdShadowColor = Color.decode("#B7CDDE");
            }
            if ((fourthShadowColor = UIManager.getColor("ToolBar.fourthShadowColor")) == null) {
                fourthShadowColor = Color.decode("#A9C3D9");
            }
            if ((fifthsShadowColor = UIManager.getColor("ToolBar.fifthsShadowColor")) == null) {
                fifthsShadowColor = Color.decode("#9EBCD5");
            }
            if ((shadowOrientation = UIManager.getInt("ToolBar.shadowOrientationWhenHorizontal")) == 1) {
                if (BarPartArea.this.areaOrientation == 1 || BarPartArea.this.areaOrientation == 5) {
                    int perWidth = width / 4;
                    float x0 = 0.0f;
                    float y0 = 1.0f;
                    float x1 = x0 + (float)perWidth;
                    float y1 = y0;
                    float x2 = x1 + (float)perWidth;
                    float y2 = y1;
                    float x3 = x2 + (float)perWidth;
                    float y3 = y2;
                    float x4 = x3 + (float)perWidth;
                    float y4 = y3;
                    Graphics2D g2d = (Graphics2D)g;
                    Paint oldPaint = g2d.getPaint();
                    g2d.setColor(topColor);
                    g2d.fillRect(0, 0, this.getWidth(), 1);
                    Rectangle rect = this.getBounds();
                    GradientPaint gradient = new GradientPaint(x0, y0, firstShadowColor, x1, y1, secondShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x0, (int)y0, perWidth, rect.height - 1);
                    gradient = new GradientPaint(x1, y1, secondShadowColor, x2, y2, thirdShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x1, (int)y1, perWidth, rect.height - 1);
                    gradient = new GradientPaint(x2, y2, thirdShadowColor, x3, y3, fourthShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x2, (int)y2, perWidth, rect.height - 1);
                    gradient = new GradientPaint(x3, y3, fourthShadowColor, x4, y4, fifthsShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height - 1);
                    g2d.setPaint(oldPaint);
                } else {
                    int perHeight = height / 4;
                    float x0 = 1.0f;
                    float y0 = 0.0f;
                    float x1 = x0;
                    float y1 = y0 + (float)perHeight;
                    float x2 = x1;
                    float y2 = y1 + (float)perHeight;
                    float x3 = x2;
                    float y3 = y2 + (float)perHeight;
                    float x4 = x3;
                    float y4 = y3 + (float)perHeight;
                    Graphics2D g2d = (Graphics2D)g;
                    Paint oldPaint = g2d.getPaint();
                    g2d.setColor(topColor);
                    g2d.fillRect(0, 0, 1, this.getHeight());
                    Rectangle rect = this.getBounds();
                    GradientPaint gradient = new GradientPaint(x0, y0, firstShadowColor, x1, y1, secondShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x0, (int)y0, rect.width - 1, perHeight);
                    gradient = new GradientPaint(x1, y1, secondShadowColor, x2, y2, thirdShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x1, (int)y1, rect.width - 1, perHeight);
                    gradient = new GradientPaint(x2, y2, thirdShadowColor, x3, y3, fourthShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x2, (int)y2, rect.width - 1, perHeight);
                    gradient = new GradientPaint(x3, y3, fourthShadowColor, x4, y4, fifthsShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x3, (int)y3, rect.width - 1, height - (int)y3);
                    g2d.setPaint(oldPaint);
                }
            } else if (shadowOrientation == 2) {
                if (BarPartArea.this.areaOrientation == 1 || BarPartArea.this.areaOrientation == 5) {
                    int perHeight = height / 4;
                    float x0 = 0.0f;
                    float y0 = 1.0f;
                    float x1 = 0.0f;
                    float y1 = y0 + (float)perHeight;
                    float x2 = 0.0f;
                    float y2 = y1 + (float)perHeight;
                    float x3 = 0.0f;
                    float y3 = y2 + (float)perHeight;
                    float x4 = 0.0f;
                    float y4 = y3 + (float)perHeight;
                    Graphics2D g2d = (Graphics2D)g;
                    Paint oldPaint = g2d.getPaint();
                    g2d.setColor(topColor);
                    g2d.fillRect(0, 0, this.getWidth(), 1);
                    GradientPaint gradient = new GradientPaint(x0, y0, firstShadowColor, x1, y1, secondShadowColor);
                    Rectangle rect = this.getBounds();
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x0, (int)y0, rect.width, perHeight);
                    gradient = new GradientPaint(x1, y1, secondShadowColor, x2, y2, thirdShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x1, (int)y1, rect.width, perHeight);
                    gradient = new GradientPaint(x2, y2, thirdShadowColor, x3, y3, fourthShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x2, (int)y2, rect.width, perHeight);
                    gradient = new GradientPaint(x3, y3, fourthShadowColor, x4, y4, fifthsShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
                    g2d.setPaint(oldPaint);
                } else {
                    int perwidth = width / 4;
                    float x0 = 1.0f;
                    float y0 = 0.0f;
                    float x1 = x0 + (float)perwidth;
                    float y1 = y0;
                    float x2 = x1 + (float)perwidth;
                    float y2 = y1;
                    float x3 = x2 + (float)perwidth;
                    float y3 = y2;
                    float x4 = x3 + (float)perwidth;
                    float y4 = y3;
                    Graphics2D g2d = (Graphics2D)g;
                    Paint oldPaint = g2d.getPaint();
                    g2d.setColor(topColor);
                    g2d.fillRect(0, 0, 1, this.getHeight());
                    GradientPaint gradient = new GradientPaint(x0, y0, firstShadowColor, x1, y1, secondShadowColor);
                    Rectangle rect = this.getBounds();
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x0, (int)y0, perwidth, rect.height);
                    gradient = new GradientPaint(x1, y1, secondShadowColor, x2, y2, thirdShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x1, (int)y1, perwidth, rect.height);
                    gradient = new GradientPaint(x2, y2, thirdShadowColor, x3, y3, fourthShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x2, (int)y2, perwidth, rect.height);
                    gradient = new GradientPaint(x3, y3, fourthShadowColor, x4, y4, fifthsShadowColor);
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height);
                    g2d.setPaint(oldPaint);
                }
            }
        }

        private class KDToolBarRowContainerLayoutManager
        implements LayoutManager {
            private int minimumLength = 80;

            private KDToolBarRowContainerLayoutManager() {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layoutContainer(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    if (BarPartArea.this.areaOrientation == 1 || BarPartArea.this.areaOrientation == 5) {
                        if (KDToolBarRowContainer.this.getClientProperty("motion") == null || KDToolBarRowContainer.this.getClientProperty("motion") == BarPartArea.INSERT_MOTION) {
                            this.layoutArithmeticForHorizontalInit();
                            KDToolBarRowContainer.this.putClientProperty("motion", null);
                        } else if (KDToolBarRowContainer.this.getClientProperty("motion") == BarPartArea.PARALLEL_MOTION) {
                            this.layoutArithmeticForHorizontalParallel();
                            KDToolBarRowContainer.this.putClientProperty("motion", null);
                        }
                    } else if (BarPartArea.this.areaOrientation == 7 || BarPartArea.this.areaOrientation == 3) {
                        if (KDToolBarRowContainer.this.getClientProperty("motion") == null || KDToolBarRowContainer.this.getClientProperty("motion") == BarPartArea.INSERT_MOTION) {
                            this.layoutArithmeticForVerticalInit();
                            KDToolBarRowContainer.this.putClientProperty("motion", null);
                        } else if (KDToolBarRowContainer.this.getClientProperty("motion") == BarPartArea.PARALLEL_MOTION) {
                            this.layoutArithmeticForVerticalParallel();
                            KDToolBarRowContainer.this.putClientProperty("motion", null);
                        }
                    } else {
                        throw new IllegalArgumentException("areaOrientation of BarPartArea is illegal.");
                    }
                }
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    BarPartArea barPartArea = (BarPartArea)parent.getParent();
                    Dimension lineContainerDim = null;
                    int componentCount = parent.getComponentCount();
                    if (BarPartArea.this.areaOrientation == 1 || BarPartArea.this.areaOrientation == 5) {
                        int width = barPartArea.getWidth();
                        int height = (Integer)UIManager.get("ToolBar.preHeight");
                        for (int i = 0; i < componentCount; ++i) {
                            int temp = parent.getComponent((int)i).getPreferredSize().height;
                            height = temp > height ? temp : height;
                        }
                        lineContainerDim = new Dimension(width, height);
                    } else if (BarPartArea.this.areaOrientation == 7 || BarPartArea.this.areaOrientation == 3) {
                        int width = (Integer)UIManager.get("ToolBar.preWidth");
                        int height = barPartArea.getHeight();
                        for (int i = 0; i < componentCount; ++i) {
                            int temp = parent.getComponent((int)i).getPreferredSize().width;
                            width = temp > width ? temp : width;
                        }
                        lineContainerDim = new Dimension(width, height);
                    } else {
                        throw new IllegalArgumentException("areaOrientation of BarPartArea is illegal.");
                    }
                    return lineContainerDim;
                }
            }

            private void layoutArithmeticForHorizontalInit() {
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                if (comps.length == 0) {
                    return;
                }
                int containerWidth = KDToolBarRowContainer.this.getWidth();
                int containerHeight = KDToolBarRowContainer.this.getHeight();
                int[] remainders = new int[comps.length];
                int modValue = containerWidth % comps.length;
                int avgWidth = (containerWidth - modValue) / comps.length;
                for (int i = 0; i < comps.length; ++i) {
                    remainders[i] = avgWidth - (int)comps[i].getPreferredSize().getWidth();
                }
                int[] afterAdjust = (int[])remainders.clone();
                remainders[0] = remainders[0] - modValue;
                for (int i = 0; i < comps.length; ++i) {
                    if (afterAdjust[i] <= 0) continue;
                    for (int j = 0; j < comps.length; ++j) {
                        if (afterAdjust[j] >= 0) continue;
                        int temp = afterAdjust[i] + afterAdjust[j];
                        if (temp <= 0) {
                            afterAdjust[i] = 0;
                            afterAdjust[j] = temp;
                            break;
                        }
                        afterAdjust[i] = temp;
                        afterAdjust[j] = 0;
                    }
                    if (afterAdjust[i] > 0) break;
                }
                int x = 0;
                for (int i = 0; i < comps.length; ++i) {
                    int width;
                    if (afterAdjust[i] <= 0) {
                        width = avgWidth + afterAdjust[i] - remainders[i];
                        comps[i].setBounds(x, 0, width, containerHeight);
                        x += width;
                        continue;
                    }
                    width = avgWidth - remainders[i];
                    comps[i].setBounds(x, 0, width, containerHeight);
                    x += width;
                }
            }

            private void layoutArithmeticForVerticalInit() {
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                if (comps.length == 0) {
                    return;
                }
                int containerWidth = KDToolBarRowContainer.this.getWidth();
                int containerHeight = KDToolBarRowContainer.this.getHeight();
                int[] remainders = new int[comps.length];
                int modValue = containerHeight % comps.length;
                int avgHeight = (containerHeight - modValue) / comps.length;
                for (int i = 0; i < comps.length; ++i) {
                    remainders[i] = avgHeight - (int)comps[i].getPreferredSize().getHeight();
                }
                int[] afterAdjust = (int[])remainders.clone();
                remainders[0] = remainders[0] - modValue;
                for (int i = 0; i < comps.length; ++i) {
                    if (afterAdjust[i] <= 0) continue;
                    for (int j = 0; j < comps.length; ++j) {
                        if (afterAdjust[j] >= 0) continue;
                        int temp = afterAdjust[i] + afterAdjust[j];
                        if (temp <= 0) {
                            afterAdjust[i] = 0;
                            afterAdjust[j] = temp;
                            break;
                        }
                        afterAdjust[i] = temp;
                        afterAdjust[j] = 0;
                    }
                    if (afterAdjust[i] > 0) break;
                }
                int y = 0;
                for (int i = 0; i < comps.length; ++i) {
                    int height;
                    if (afterAdjust[i] <= 0) {
                        height = avgHeight + afterAdjust[i] - remainders[i];
                        comps[i].setBounds(0, y, containerWidth, height);
                        y += height;
                        continue;
                    }
                    height = avgHeight - remainders[i];
                    comps[i].setBounds(0, y, containerWidth, height);
                    y += height;
                }
            }

            private void layoutArithmeticForHorizontalParallel() {
                int upperLimit;
                int lowerLimit;
                int preferredWidth;
                int i;
                int frontToolBarsFlexility;
                int blankWidth;
                int i2;
                int i3;
                int draggedToolBarIndex;
                KDToolBar draggedToolBar = (KDToolBar)KDToolBarRowContainer.this.getClientProperty("source");
                Point targetPoint = (Point)KDToolBarRowContainer.this.getClientProperty("point");
                int adjustValue = (int)(draggedToolBar.getLocation().getX() - targetPoint.getX());
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                for (draggedToolBarIndex = 0; draggedToolBarIndex < comps.length && comps[draggedToolBarIndex] != draggedToolBar; ++draggedToolBarIndex) {
                }
                if (adjustValue < 0) {
                    boolean frontToolBarsAllFull = true;
                    for (i3 = 0; i3 < draggedToolBarIndex; ++i3) {
                        if (!((double)comps[i3].getWidth() < comps[i3].getPreferredSize().getWidth())) continue;
                        frontToolBarsAllFull = false;
                    }
                    if (frontToolBarsAllFull) {
                        return;
                    }
                    boolean backToolBarsAllHungry = true;
                    for (i2 = draggedToolBarIndex; i2 < comps.length; ++i2) {
                        if (comps[i2].getWidth() <= this.minimumLength) continue;
                        backToolBarsAllHungry = false;
                    }
                    if (backToolBarsAllHungry) {
                        return;
                    }
                } else if (adjustValue > 0) {
                    boolean frontToolBarsAllHungry = true;
                    for (i3 = 0; i3 < draggedToolBarIndex; ++i3) {
                        if (comps[i3].getWidth() <= this.minimumLength) continue;
                        frontToolBarsAllHungry = false;
                    }
                    if (frontToolBarsAllHungry) {
                        return;
                    }
                } else {
                    return;
                }
                int n = blankWidth = (blankWidth = BarPartArea.this.getWidth() - (int)(comps[comps.length - 1].getLocation().getX() + (double)comps[comps.length - 1].getWidth())) < 0 ? 0 : blankWidth;
                if (adjustValue < 0) {
                    frontToolBarsFlexility = 0;
                    for (i2 = 0; i2 < draggedToolBarIndex; ++i2) {
                        frontToolBarsFlexility = (int)((double)frontToolBarsFlexility + (comps[i2].getPreferredSize().getWidth() - (double)comps[i2].getWidth()));
                    }
                    int backToolBarsFlexility = 0;
                    for (int j = draggedToolBarIndex; j < comps.length; ++j) {
                        backToolBarsFlexility += this.minimumLength - comps[j].getWidth();
                    }
                    int adjust = frontToolBarsFlexility < (backToolBarsFlexility = blankWidth - backToolBarsFlexility) ? frontToolBarsFlexility : backToolBarsFlexility;
                    adjustValue = -(-adjustValue < adjust ? -adjustValue : adjust);
                }
                if (adjustValue > 0) {
                    frontToolBarsFlexility = 0;
                    for (i2 = 0; i2 < draggedToolBarIndex; ++i2) {
                        frontToolBarsFlexility += comps[i2].getWidth() - this.minimumLength;
                    }
                    adjustValue = adjustValue < frontToolBarsFlexility ? adjustValue : frontToolBarsFlexility;
                }
                int x = 0;
                int adjustCache = adjustValue;
                for (i = 0; i < draggedToolBarIndex; ++i) {
                    preferredWidth = (int)comps[i].getPreferredSize().getWidth();
                    lowerLimit = this.minimumLength - comps[i].getWidth();
                    upperLimit = preferredWidth - comps[i].getWidth();
                    if (adjustValue < 0) {
                        if ((adjustCache += upperLimit) < 0) {
                            comps[i].setBounds(x, 0, preferredWidth, KDToolBarRowContainer.this.getHeight());
                            x += preferredWidth;
                            continue;
                        }
                        if (adjustCache == 0) {
                            comps[i].setBounds(x, 0, preferredWidth, KDToolBarRowContainer.this.getHeight());
                            x += preferredWidth;
                            x = this.layoutWithOriginalWidth(x, i + 1, draggedToolBarIndex);
                            break;
                        }
                        comps[i].setBounds(x, 0, preferredWidth - adjustCache, KDToolBarRowContainer.this.getHeight());
                        x += preferredWidth - adjustCache;
                        x = this.layoutWithOriginalWidth(x, i + 1, draggedToolBarIndex);
                        break;
                    }
                    if ((adjustCache += lowerLimit) > 0) {
                        comps[i].setBounds(x, 0, this.minimumLength, KDToolBarRowContainer.this.getHeight());
                        x += this.minimumLength;
                        continue;
                    }
                    if (adjustCache == 0) {
                        comps[i].setBounds(x, 0, this.minimumLength, KDToolBarRowContainer.this.getHeight());
                        x += this.minimumLength;
                        x = this.layoutWithOriginalWidth(x, i + 1, draggedToolBarIndex);
                        break;
                    }
                    comps[i].setBounds(x, 0, this.minimumLength - adjustCache, KDToolBarRowContainer.this.getHeight());
                    x += this.minimumLength - adjustCache;
                    x = this.layoutWithOriginalWidth(x, i + 1, draggedToolBarIndex);
                    break;
                }
                adjustCache = adjustValue;
                for (i = draggedToolBarIndex; i < comps.length; ++i) {
                    preferredWidth = (int)comps[i].getPreferredSize().getWidth();
                    lowerLimit = this.minimumLength - comps[i].getWidth();
                    upperLimit = preferredWidth - comps[i].getWidth();
                    if (adjustValue < 0) {
                        if (-adjustCache <= blankWidth) {
                            this.layoutWithOriginalWidth(x, i, comps.length);
                            return;
                        }
                        x += blankWidth;
                        adjustCache += blankWidth;
                        if ((adjustCache -= lowerLimit) < 0) {
                            comps[i].setBounds(x, 0, this.minimumLength, KDToolBarRowContainer.this.getHeight());
                            x += this.minimumLength;
                            continue;
                        }
                        if (adjustCache == 0) {
                            comps[i].setBounds(x, 0, this.minimumLength, KDToolBarRowContainer.this.getHeight());
                            x += this.minimumLength;
                            x = this.layoutWithOriginalWidth(x, i + 1, comps.length);
                            break;
                        }
                        comps[i].setBounds(x, 0, this.minimumLength + adjustCache, KDToolBarRowContainer.this.getHeight());
                        x += this.minimumLength + adjustCache;
                        x = this.layoutWithOriginalWidth(x, i + 1, comps.length);
                        break;
                    }
                    if (blankWidth > 0) {
                        this.layoutWithOriginalWidth(x, i, comps.length);
                        return;
                    }
                    if ((adjustCache -= upperLimit) > 0) {
                        comps[i].setBounds(x, 0, preferredWidth, KDToolBarRowContainer.this.getHeight());
                        x += preferredWidth;
                        continue;
                    }
                    if (adjustCache == 0) {
                        comps[i].setBounds(x, 0, preferredWidth, KDToolBarRowContainer.this.getHeight());
                        x += preferredWidth;
                        x = this.layoutWithOriginalWidth(x, i + 1, comps.length);
                        break;
                    }
                    comps[i].setBounds(x, 0, preferredWidth + adjustCache, KDToolBarRowContainer.this.getHeight());
                    x += preferredWidth + adjustCache;
                    x = this.layoutWithOriginalWidth(x, i + 1, comps.length);
                    break;
                }
            }

            private void layoutArithmeticForVerticalParallel() {
                int upperLimit;
                int lowerLimit;
                int preferredHeight;
                int i;
                int frontToolBarsFlexility;
                int blankWidth;
                int i2;
                int i3;
                int draggedToolBarIndex;
                KDToolBar draggedToolBar = (KDToolBar)KDToolBarRowContainer.this.getClientProperty("source");
                Point targetPoint = (Point)KDToolBarRowContainer.this.getClientProperty("point");
                int adjustValue = (int)(draggedToolBar.getLocation().getY() - targetPoint.getY());
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                for (draggedToolBarIndex = 0; draggedToolBarIndex < comps.length && comps[draggedToolBarIndex] != draggedToolBar; ++draggedToolBarIndex) {
                }
                if (adjustValue < 0) {
                    boolean frontToolBarsAllFull = true;
                    for (i3 = 0; i3 < draggedToolBarIndex; ++i3) {
                        if (!((double)comps[i3].getHeight() < comps[i3].getPreferredSize().getHeight())) continue;
                        frontToolBarsAllFull = false;
                    }
                    if (frontToolBarsAllFull) {
                        return;
                    }
                    boolean backToolBarsAllHungry = true;
                    for (i2 = draggedToolBarIndex; i2 < comps.length; ++i2) {
                        if (comps[i2].getHeight() <= this.minimumLength) continue;
                        backToolBarsAllHungry = false;
                    }
                    if (backToolBarsAllHungry) {
                        return;
                    }
                } else if (adjustValue > 0) {
                    boolean frontToolBarsAllHungry = true;
                    for (i3 = 0; i3 < draggedToolBarIndex; ++i3) {
                        if (comps[i3].getHeight() <= this.minimumLength) continue;
                        frontToolBarsAllHungry = false;
                    }
                    if (frontToolBarsAllHungry) {
                        return;
                    }
                } else {
                    return;
                }
                int n = blankWidth = (blankWidth = BarPartArea.this.getHeight() - (int)(comps[comps.length - 1].getLocation().getY() + (double)comps[comps.length - 1].getHeight())) < 0 ? 0 : blankWidth;
                if (adjustValue < 0) {
                    frontToolBarsFlexility = 0;
                    for (i2 = 0; i2 < draggedToolBarIndex; ++i2) {
                        frontToolBarsFlexility = (int)((double)frontToolBarsFlexility + (comps[i2].getPreferredSize().getHeight() - (double)comps[i2].getHeight()));
                    }
                    int backToolBarsFlexility = 0;
                    for (int j = draggedToolBarIndex; j < comps.length; ++j) {
                        backToolBarsFlexility += this.minimumLength - comps[j].getHeight();
                    }
                    int adjust = frontToolBarsFlexility < (backToolBarsFlexility = blankWidth - backToolBarsFlexility) ? frontToolBarsFlexility : backToolBarsFlexility;
                    adjustValue = -(-adjustValue < adjust ? -adjustValue : adjust);
                }
                if (adjustValue > 0) {
                    frontToolBarsFlexility = 0;
                    for (i2 = 0; i2 < draggedToolBarIndex; ++i2) {
                        frontToolBarsFlexility += comps[i2].getHeight() - this.minimumLength;
                    }
                    adjustValue = adjustValue < frontToolBarsFlexility ? adjustValue : frontToolBarsFlexility;
                }
                int y = 0;
                int adjustCache = adjustValue;
                for (i = 0; i < draggedToolBarIndex; ++i) {
                    preferredHeight = (int)comps[i].getPreferredSize().getHeight();
                    lowerLimit = this.minimumLength - comps[i].getHeight();
                    upperLimit = preferredHeight - comps[i].getHeight();
                    if (adjustValue < 0) {
                        if ((adjustCache += upperLimit) < 0) {
                            comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight);
                            y += preferredHeight;
                            continue;
                        }
                        if (adjustCache == 0) {
                            comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight);
                            y += preferredHeight;
                            y = this.layoutWithOriginalHeight(y, i + 1, draggedToolBarIndex);
                            break;
                        }
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight - adjustCache);
                        y += preferredHeight - adjustCache;
                        y = this.layoutWithOriginalHeight(y, i + 1, draggedToolBarIndex);
                        break;
                    }
                    if ((adjustCache += lowerLimit) > 0) {
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength);
                        y += this.minimumLength;
                        continue;
                    }
                    if (adjustCache == 0) {
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength);
                        y += this.minimumLength;
                        y = this.layoutWithOriginalHeight(y, i + 1, draggedToolBarIndex);
                        break;
                    }
                    comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength - adjustCache);
                    y += this.minimumLength - adjustCache;
                    y = this.layoutWithOriginalHeight(y, i + 1, draggedToolBarIndex);
                    break;
                }
                adjustCache = adjustValue;
                for (i = draggedToolBarIndex; i < comps.length; ++i) {
                    preferredHeight = (int)comps[i].getPreferredSize().getHeight();
                    lowerLimit = this.minimumLength - comps[i].getHeight();
                    upperLimit = preferredHeight - comps[i].getHeight();
                    if (adjustValue < 0) {
                        if (-adjustCache <= blankWidth) {
                            this.layoutWithOriginalHeight(y, i, comps.length);
                            return;
                        }
                        y += blankWidth;
                        adjustCache += blankWidth;
                        if ((adjustCache -= lowerLimit) < 0) {
                            comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength);
                            y += this.minimumLength;
                            continue;
                        }
                        if (adjustCache == 0) {
                            comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength);
                            y += this.minimumLength;
                            y = this.layoutWithOriginalHeight(y, i + 1, comps.length);
                            break;
                        }
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), this.minimumLength + adjustCache);
                        y += this.minimumLength + adjustCache;
                        y = this.layoutWithOriginalHeight(y, i + 1, comps.length);
                        break;
                    }
                    if (blankWidth > 0) {
                        this.layoutWithOriginalHeight(y, i, comps.length);
                        return;
                    }
                    if ((adjustCache -= upperLimit) > 0) {
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight);
                        y += preferredHeight;
                        continue;
                    }
                    if (adjustCache == 0) {
                        comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight);
                        y += preferredHeight;
                        y = this.layoutWithOriginalHeight(y, i + 1, comps.length);
                        break;
                    }
                    comps[i].setBounds(0, y, KDToolBarRowContainer.this.getWidth(), preferredHeight + adjustCache);
                    y += preferredHeight + adjustCache;
                    y = this.layoutWithOriginalHeight(y, i + 1, comps.length);
                    break;
                }
            }

            private int layoutWithOriginalWidth(int xCoordinate, int startIndex, int endIndex) {
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                int height = KDToolBarRowContainer.this.getHeight();
                for (int m = startIndex; m < endIndex; ++m) {
                    comps[m].setBounds(xCoordinate, 0, comps[m].getWidth(), height);
                    xCoordinate += comps[m].getWidth();
                }
                return xCoordinate;
            }

            private int layoutWithOriginalHeight(int yCoordinate, int startIndex, int endIndex) {
                Component[] comps = KDToolBarRowContainer.this.getComponents();
                int width = KDToolBarRowContainer.this.getWidth();
                for (int m = startIndex; m < endIndex; ++m) {
                    comps[m].setBounds(0, yCoordinate, width, comps[m].getHeight());
                    yCoordinate += comps[m].getHeight();
                }
                return yCoordinate;
            }
        }
    }

    public class PartAreaLayout
    implements LayoutManager2 {
        private JMenuBar iMenuBar = null;
        private KDStatusBar iStatusBar = null;
        private KDHelperBar helperBar = null;
        private int orientationType = 1;
        private boolean isHasToolBar = false;
        private int hgrp = 0;
        private int vgrp = 0;

        public PartAreaLayout(int t) {
            this.orientationType = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            Object object = comp.getTreeLock();
            synchronized (object) {
                if (constraints.equals(BarPartArea.KDMENUBAR_IDENTIFY)) {
                    this.iMenuBar = (JMenuBar)comp;
                } else if (constraints.equals(BarPartArea.KDSTATUSBAR_IDENTIFY)) {
                    this.iStatusBar = (KDStatusBar)comp;
                } else if (constraints.equals(BarPartArea.KDHELPERBAR_IDENTIFY)) {
                    this.helperBar = (KDHelperBar)comp;
                } else if (constraints.equals(BarPartArea.KDTOOLBAR_IDENTIFY)) {
                    this.isHasToolBar = true;
                }
            }
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Rectangle rect = parent.getBounds();
                int poX = insets.left;
                int poY = insets.top;
                int rW = rect.width - insets.left - insets.right;
                if (this.orientationType == 1 || this.orientationType == 5) {
                    Dimension helperBarDim;
                    if (this.orientationType == 5 && this.helperBar != null && this.helperBar.isVisible()) {
                        int width = BarPartArea.this.getWidth();
                        helperBarDim = this.helperBar.getPreferredSize();
                        this.helperBar.setBounds(poX, poY, width, helperBarDim.height);
                        poY += helperBarDim.height;
                    }
                    if (this.iMenuBar != null && this.iMenuBar.isVisible()) {
                        Dimension menuBarDim = this.iMenuBar.getPreferredSize();
                        this.iMenuBar.setBounds(poX, poY, rW, menuBarDim.height);
                        poY += menuBarDim.height;
                    }
                    if (this.isHasToolBar) {
                        int count = parent.getComponentCount();
                        for (int i = 0; i < count; ++i) {
                            Component cmp = parent.getComponent(i);
                            if (!(cmp instanceof KDToolBarRowContainer)) continue;
                            Dimension toolBarContainerDim = ((KDToolBarRowContainer)cmp).getPreferredSize();
                            int width = BarPartArea.this.getWidth();
                            ((KDToolBarRowContainer)cmp).setBounds(poX, poY += this.hgrp, width, toolBarContainerDim.height);
                            poY += toolBarContainerDim.height;
                        }
                    }
                    if (this.iStatusBar != null && this.iStatusBar.isVisible()) {
                        Dimension statusDim = this.iStatusBar.getPreferredSize();
                        int tempPoy = rect.height - insets.bottom - statusDim.height;
                        if ((poY += this.hgrp) != tempPoy) {
                            BarPartArea.this.logs("statusBar'poY has some warning.[poY " + poY + "!= tempPoy " + tempPoy);
                        }
                        this.iStatusBar.setBounds(poX, tempPoy, rW, statusDim.height);
                    }
                    if (this.orientationType == 1 && this.helperBar != null && this.helperBar.isVisible()) {
                        int width = BarPartArea.this.getWidth();
                        helperBarDim = this.helperBar.getPreferredSize();
                        this.helperBar.setBounds(poX, poY, width, helperBarDim.height);
                        poY += helperBarDim.height;
                    }
                } else if (this.orientationType == 3 || this.orientationType == 7) {
                    int height;
                    if (this.orientationType == 3 && this.helperBar != null && this.helperBar.isVisible()) {
                        height = BarPartArea.this.getHeight();
                        Dimension helperBarDim = this.helperBar.getPreferredSize();
                        this.helperBar.setBounds(poX, poY, helperBarDim.width, height);
                        poX += helperBarDim.width;
                    }
                    if (this.isHasToolBar) {
                        int count = parent.getComponentCount();
                        for (int i = 0; i < count; ++i) {
                            Component cmp = parent.getComponent(i);
                            if (!(cmp instanceof KDToolBarRowContainer)) continue;
                            Dimension toolBarContainerDim = ((KDToolBarRowContainer)cmp).getPreferredSize();
                            int height2 = BarPartArea.this.getHeight();
                            ((KDToolBarRowContainer)cmp).setBounds(poX += this.vgrp, poY, toolBarContainerDim.width, height2);
                            poX += toolBarContainerDim.width;
                        }
                    }
                    if (this.orientationType == 7 && this.helperBar != null && this.helperBar.isVisible()) {
                        height = BarPartArea.this.getHeight();
                        Dimension helperBarDim = this.helperBar.getPreferredSize();
                        this.helperBar.setBounds(poX, poY, helperBarDim.width, height);
                        poX += helperBarDim.width;
                    }
                } else {
                    throw new IllegalArgumentException("orientationType of BarPartArea is illegal.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = BarDefault_PreferredSize;
                Insets insets = parent.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                if (this.iMenuBar != null && this.iMenuBar.isVisible()) {
                    dim = this.iMenuBar.getPreferredSize();
                    return dim;
                }
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                Insets insets = parent.getInsets();
                dim.height += insets.bottom + insets.top;
                dim.width = insets.left + insets.right;
                Rectangle rect = parent.getBounds();
                if (this.orientationType == 1 || this.orientationType == 5) {
                    if (this.helperBar != null && this.helperBar.isVisible()) {
                        Dimension helperDim = this.helperBar.getPreferredSize();
                        dim.width = Math.max(dim.width, helperDim.width);
                        dim.height += helperDim.height + this.hgrp;
                    }
                    if (this.iStatusBar != null && this.iStatusBar.isVisible()) {
                        Dimension statusDim = this.iStatusBar.getPreferredSize();
                        dim.width = Math.max(dim.width, statusDim.width);
                        dim.height += statusDim.height + this.hgrp;
                    }
                    if (this.iMenuBar != null && this.iMenuBar.isVisible()) {
                        Dimension menuBarDim = this.iMenuBar.getPreferredSize();
                        dim.width = Math.max(dim.width, menuBarDim.width);
                        dim.width = Math.max(dim.width, menuBarDim.width);
                        dim.height += menuBarDim.height + this.hgrp;
                    }
                    if (this.isHasToolBar) {
                        int count = parent.getComponentCount();
                        for (int i = 0; i < count; ++i) {
                            Component cp = parent.getComponent(i);
                            if (!(cp instanceof KDToolBarRowContainer) || !cp.isVisible()) continue;
                            Dimension toolBarContainerDim = ((KDToolBarRowContainer)cp).getPreferredSize();
                            dim.width = Math.max(dim.width, toolBarContainerDim.width);
                            dim.height += toolBarContainerDim.height + this.hgrp;
                        }
                    }
                    dim.width = Math.max(dim.width, rect.width);
                } else if (this.orientationType == 7 || this.orientationType == 3) {
                    if (this.helperBar != null && this.helperBar.isVisible()) {
                        Dimension helperDim = this.helperBar.getPreferredSize();
                        dim.width += helperDim.width + this.vgrp;
                        dim.height = Math.max(dim.height, helperDim.height);
                    }
                    if (this.isHasToolBar) {
                        int count = parent.getComponentCount();
                        for (int i = 0; i < count; ++i) {
                            Component cp = parent.getComponent(i);
                            if (!(cp instanceof KDToolBarRowContainer) || !cp.isVisible()) continue;
                            Dimension toolBarContainerDim = ((KDToolBarRowContainer)cp).getPreferredSize();
                            dim.width += toolBarContainerDim.width + this.vgrp;
                            dim.height = Math.max(dim.height, toolBarContainerDim.height);
                        }
                    }
                    dim.height = Math.max(dim.height, rect.height);
                } else {
                    throw new IllegalArgumentException("orientationType of BarPartArea is illegal.");
                }
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLayoutComponent(Component comp) {
            Object object = comp.getTreeLock();
            synchronized (object) {
                if (comp == this.iMenuBar) {
                    this.iMenuBar = null;
                } else if (comp == this.iStatusBar) {
                    this.iStatusBar = null;
                } else if (comp == this.helperBar) {
                    this.helperBar = null;
                }
            }
        }
    }
}

