/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IAutoToolTipText;
import com.kingdee.bos.ctrl.swing.ITextLengthLimit;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LimitedLengthDocument;
import com.kingdee.bos.ctrl.swing.TextLengthVerifier;
import com.kingdee.bos.ctrl.swing.ToolTipGenerator;
import com.kingdee.bos.ctrl.swing.util.JVM;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import javax.swing.ToolTipManager;
import javax.swing.text.Document;

public class DefaultTextField
extends KDTextField
implements IAutoToolTipText,
ITextLengthLimit {
    private static final long serialVersionUID = -4365345499167187426L;
    private boolean autoToolTipText = false;
    protected TextLengthVerifier verifier = null;

    public DefaultTextField() {
    }

    public DefaultTextField(String text) {
        super(text);
    }

    public DefaultTextField(int columns) {
        super(columns);
    }

    public DefaultTextField(String text, int columns) {
        super(text, columns);
    }

    public DefaultTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    @Override
    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    @Override
    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String str = null;
        str = this.isAutoToolTipText() ? ToolTipGenerator.generate(this) : super.getToolTipText(event);
        return str;
    }

    @Override
    public String getToolTipText() {
        String str = null;
        str = this.isAutoToolTipText() ? ToolTipGenerator.generate(this) : super.getToolTipText();
        return str;
    }

    private LimitedLengthDocument getLimitedLengthDocument() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedLengthDocument) {
            return (LimitedLengthDocument)doc;
        }
        return null;
    }

    @Override
    protected TextLengthVerifier getTextLengthVerifier() {
        if (this.verifier == null) {
            this.verifier = new TextLengthVerifier();
            this.setInputVerifier(this.verifier);
        }
        return this.verifier;
    }

    @Override
    public void setMaxLength(int len) {
        if (len < -1) {
            return;
        }
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMaxLength(len);
        }
        this.getTextLengthVerifier().setMaxLength(len);
    }

    @Override
    public int getMaxLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMaxLength();
        }
        return -1;
    }

    @Override
    public void setMinLength(int len) {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMinLength(len);
        }
        this.getTextLengthVerifier().setMinLength(len);
    }

    @Override
    public int getMinLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMinLength();
        }
        return 0;
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitedLengthDocument();
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.setCaretPosition(0);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (JVM.current().isOverOneDotFive()) {
            return super.getInputMethodRequests();
        }
        return null;
    }
}

