/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeSplitPaneUI;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class KDSplitPane
extends JSplitPane
implements IKDComponent {
    private static final long serialVersionUID = 5916719225184705676L;
    protected Object userObject = null;
    private boolean dividerOpaque = false;
    private boolean hasDividerPointer = true;
    private Insets customInsets;
    public static final int ARROW_ALL = 0;
    public static final int ARROW_LEFT = 1;
    public static final int ARROW_RIGHT = 2;
    public static final int ARROW_UP = 3;
    public static final int ARROW_DOWN = 4;
    private int arrowType = 0;

    public KDSplitPane() {
        this.defaultInit();
    }

    public KDSplitPane(int newOrientation) {
        super(newOrientation);
        this.defaultInit();
    }

    public KDSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.defaultInit();
    }

    public KDSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.defaultInit();
    }

    public KDSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.defaultInit();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        ((BasicSplitPaneUI)this.getUI()).getDivider().setEnabled(enabled);
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    private void defaultInit() {
        this.setDividerSize(8);
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 2));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 1));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 3));
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setHasDividerPointer(boolean newVal) {
        boolean old = this.hasDividerPointer;
        if (newVal != old) {
            this.hasDividerPointer = newVal;
            this.firePropertyChange("hasDividerPointer", (Object)old, (Object)this.hasDividerPointer);
        }
    }

    public boolean hasDividerPointer() {
        return this.hasDividerPointer;
    }

    public void setDividerOpaque(boolean b) {
        if (b != this.dividerOpaque) {
            this.dividerOpaque = b;
            this.firePropertyChange("dividerOpaque", (Object)(!b ? 1 : 0), (Object)this.dividerOpaque);
        }
    }

    public boolean isDividerOpaque() {
        return this.dividerOpaque;
    }

    public Component getSplitPaneDivider() {
        return this.getComponent(2);
    }

    public void setDividerBackground(Color newValue) {
        if (this.getSplitPaneDivider() != null && newValue != null) {
            this.getSplitPaneDivider().setBackground(newValue);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new KingdeeSplitPaneUI());
    }

    public void setArrowType(int t) {
        if (!this.isOneTouchExpandable()) {
            this.setOneTouchExpandable(true);
        }
        int orientation = this.getOrientation();
        switch (t) {
            case 0: {
                this.arrowType = 0;
                break;
            }
            case 1: {
                if (orientation == 1) {
                    this.arrowType = 1;
                    break;
                }
                this.arrowType = 3;
                break;
            }
            case 2: {
                if (orientation == 1) {
                    this.arrowType = 2;
                    break;
                }
                this.arrowType = 4;
                break;
            }
            case 3: {
                if (orientation == 0) {
                    this.arrowType = 3;
                    break;
                }
                this.arrowType = 1;
                break;
            }
            case 4: {
                if (orientation == 0) {
                    this.arrowType = 4;
                    break;
                }
                this.arrowType = 2;
                break;
            }
            default: {
                this.arrowType = 0;
            }
        }
        this.revalidate();
    }

    public int getArrowType() {
        return this.arrowType;
    }
}

