/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.IAutoToolTipText;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.ITextLengthLimit;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextFieldAssistor;
import com.kingdee.bos.ctrl.swing.LimitedLengthDocument;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.TextLengthVerifier;
import com.kingdee.bos.ctrl.swing.ToolTipGenerator;
import com.kingdee.bos.ctrl.swing.desensitization.DesensitizationRule;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTextFieldUI;
import com.kingdee.bos.ctrl.swing.util.JVM;
import com.kingdee.bos.ctrl.swing.util.TextComponentUtilities;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class KDTextField
extends JTextField
implements IKDComponent,
IBoundLabelControl,
IAutoToolTipText,
ITextLengthLimit,
IKDTextComponent {
    private static final long serialVersionUID = -3914397363276008885L;
    protected boolean isEnablePopup = false;
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private Insets customInsets;
    private boolean selectAllOnFocus = true;
    public static final String undoAction = "undo-textfield";
    public static final String redoAction = "redo-textfield";
    public UndoManager manager = null;
    public boolean required = false;
    private KDTextFieldAssistor assistor;
    private boolean assistorEnabled;
    private Color customForegroundColor;
    private Color customBackgroundColor;
    private String filedsSplit;
    private String defaultSplit = ";";
    private boolean isNeedInputMethodRequest = true;
    protected TextLengthVerifier verifier = null;
    private boolean autoToolTipText = true;
    private boolean bySetText = false;
    private String desensitizationBefore;
    private boolean dirty = false;
    private DesensitizationRule desensitizationRule;
    private boolean isDesensitization = true;

    public KDTextField() {
        this.setAutoToolTipText(true);
        this.init();
    }

    public KDTextField(String text) {
        super(text);
        this.setAutoToolTipText(true);
        this.init();
    }

    public KDTextField(int columns) {
        super(columns);
        this.setAutoToolTipText(true);
        this.init();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (!this.isNeedInputMethodRequest) {
            return null;
        }
        if (JVM.current().isOverOneDotFive()) {
            return super.getInputMethodRequests();
        }
        return null;
    }

    public KDTextField(String text, int columns) {
        super(text, columns);
        this.setAutoToolTipText(true);
        this.init();
    }

    public KDTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setAutoToolTipText(true);
        this.init();
    }

    private void init() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        TextComponentUtilities.storeOriginalData(this);
        this.filedsSplit = this.defaultSplit;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setEnabledPopup(boolean enabled) {
        this.isEnablePopup = !this.isAssistorEnabled() ? enabled : false;
    }

    public boolean isEnabledPopup() {
        return this.isEnablePopup;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setCustomForegroundColor(Color newColor) {
        Color oldColor = this.customForegroundColor;
        this.customForegroundColor = newColor;
        this.firePropertyChange("customForegroundColorChanged", oldColor, newColor);
    }

    public Color getCustomForegroundColor() {
        return this.customForegroundColor;
    }

    public void setCustomBackgroundColor(Color newColor) {
        Color oldColor = this.customBackgroundColor;
        this.customBackgroundColor = newColor;
        this.firePropertyChange("customBackgroundColorChanged", oldColor, newColor);
    }

    public Color getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeTextFieldUI.createUI(this));
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        if (TextComponentUtilities.setEditable(this, editable)) {
            super.setEditable(editable);
        }
    }

    @Override
    public String getText() {
        if (this.getAccessAuthority() == 2) {
            return (String)TextComponentUtilities.getData(this);
        }
        return super.getText();
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    private LimitedLengthDocument getLimitedLengthDocument() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedLengthDocument) {
            return (LimitedLengthDocument)doc;
        }
        return null;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.isSelectAllOnFocus()) {
            this.selectAllfromTheEnd();
        }
    }

    protected TextLengthVerifier getTextLengthVerifier() {
        if (this.verifier == null) {
            this.verifier = new TextLengthVerifier();
            this.setInputVerifier(this.verifier);
        }
        return this.verifier;
    }

    @Override
    public void setMaxLength(int len) {
        if (len < -1) {
            return;
        }
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMaxLength(len);
        }
        this.getTextLengthVerifier().setMaxLength(len);
    }

    @Override
    public int getMaxLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMaxLength();
        }
        return -1;
    }

    @Override
    public void setMinLength(int len) {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMinLength(len);
        }
        this.getTextLengthVerifier().setMinLength(len);
    }

    @Override
    public int getMinLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMinLength();
        }
        return 0;
    }

    public void memorizeAssistorInfo() {
        if (!this.assistorEnabled) {
            return;
        }
        this.assistor.memorizeAssistorInfo();
    }

    public void setAssistorEnabled(boolean assistorEnabled) {
        if (this.assistorEnabled == assistorEnabled) {
            return;
        }
        this.assistorEnabled = assistorEnabled;
        if (assistorEnabled && this.assistor == null) {
            this.assistor = new KDTextFieldAssistor(this);
        }
        if (assistorEnabled) {
            if (this.isEnabledPopup()) {
                this.setEnabledPopup(false);
            }
            this.assistor.installListeners();
        } else {
            this.assistor.uninstallListeners();
        }
    }

    public boolean isAssistorEnabled() {
        return this.assistorEnabled;
    }

    public boolean isAssistorShowing() {
        if (this.isAssistorEnabled()) {
            return this.assistor.isShowing();
        }
        return false;
    }

    public void setAssistorShowing(boolean show) {
        if (this.assistor != null) {
            this.assistor.setShowing(show);
        }
    }

    public void setAssistorMaximumRowCount(int count) {
        if (!this.assistorEnabled) {
            return;
        }
        this.assistor.setAssistorMaximumRowCount(count);
    }

    public void setRecordName(String name) {
        if (this.assistor != null) {
            this.assistor.setRecordName(name);
        }
    }

    public KDTextFieldAssistor getInputAssistor() {
        return this.assistor;
    }

    @Override
    protected Document createDefaultModel() {
        LimitedLengthDocument doc = new LimitedLengthDocument();
        doc.addDocumentListener(new DirtyListener());
        return doc;
    }

    @Override
    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    @Override
    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }

    public boolean isBySetText() {
        return this.bySetText;
    }

    public void setBySetText(boolean b) {
        this.bySetText = b;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String str = super.getToolTipText();
        if (StringUtils.isEmpty(str) && this.isAutoToolTipText()) {
            str = ToolTipGenerator.generate(this);
        }
        return str;
    }

    @Override
    public String getToolTipText() {
        String str = super.getToolTipText();
        if (StringUtils.isEmpty(str) && this.isAutoToolTipText()) {
            str = ToolTipGenerator.generate(this);
        }
        return str;
    }

    @Override
    public void setText(String t) {
        this.desensitizationBefore = t;
        if (this.isDesensitization && this.desensitizationRule != null) {
            t = DesensitizationRule.desensitization(t, this.desensitizationRule);
        }
        this.bySetText = true;
        if (TextComponentUtilities.setData(this, t)) {
            super.setText(t);
            this.setCaretPosition(0);
            if (t == null) {
                this.setDirty(false);
            } else {
                this.setDirty(true);
            }
        }
        this.bySetText = false;
    }

    public void setText(String t, boolean fireListenner) {
        if (fireListenner) {
            this.setText(t);
        } else {
            DocumentListener[] savedDocumentListeners = ((AbstractDocument)this.getDocument()).getDocumentListeners();
            if (savedDocumentListeners != null) {
                int i;
                for (i = 0; i < savedDocumentListeners.length; ++i) {
                    this.getDocument().removeDocumentListener(savedDocumentListeners[i]);
                }
                this.setText(t);
                for (i = 0; i < savedDocumentListeners.length; ++i) {
                    this.getDocument().addDocumentListener(savedDocumentListeners[i]);
                }
                this.repaint();
            } else {
                this.setText(t);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public void setStringValue(String str) {
        this.setText(str);
    }

    public String getStringValue() {
        String str = this.getText();
        if (StringUtil.isEmptyString((String)str)) {
            if (this.isDirty()) {
                return "";
            }
            return null;
        }
        return str;
    }

    public void selectAllfromTheEnd() {
        Document doc = this.getDocument();
        if (doc != null) {
            this.setCaretPosition(doc.getLength());
            this.moveCaretPosition(0);
        }
    }

    public void memorizeAssistorInfo(String editValue) {
        if (!this.assistorEnabled) {
            return;
        }
        this.assistor.memorizeAssistorInfo(editValue);
    }

    public void setFiledsSplit(String split) {
        this.filedsSplit = split;
    }

    @Override
    public void replaceSelection(String content) {
        String separator = "\n";
        if (null != content) {
            int len = content.length();
            if (separator.equals(content.substring(len - separator.length(), len))) {
                content = content.substring(0, content.length() - 1);
            }
            if (content.indexOf(separator) >= 0) {
                content = content.replaceAll(separator, this.filedsSplit);
            }
        }
        super.replaceSelection(content);
    }

    public void setNeetInputMethodRequest(boolean isNeedInputMethodRequest) {
        String osname = System.getProperty("os.name");
        if (osname != null && osname.startsWith("Mac OS")) {
            return;
        }
        this.isNeedInputMethodRequest = isNeedInputMethodRequest;
    }

    public void setDesensitizationRule(DesensitizationRule desensitizationRule) {
        this.desensitizationRule = desensitizationRule;
    }

    public DesensitizationRule getDesensitizationRule() {
        return this.desensitizationRule;
    }

    public boolean getIsDesensitization() {
        return this.isDesensitization;
    }

    public void setIsDesensitization(boolean isDesensitization) {
        this.isDesensitization = isDesensitization;
    }

    public void desensitization(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("open".equalsIgnoreCase(actionCommand)) {
            this.isDesensitization = true;
        } else if ("close".equalsIgnoreCase(actionCommand)) {
            this.isDesensitization = false;
        }
        this.setText(this.desensitizationBefore);
    }

    public boolean isComposedTextDocumentEvent(DocumentEvent e) {
        if (this.isNeedInputMethodRequest && e != null) {
            return e.toString().contains("ElementEdit");
        }
        return false;
    }

    private class DirtyListener
    implements DocumentListener {
        private DirtyListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            KDTextField.this.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            KDTextField.this.setDirty(true);
        }
    }
}

