/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.helper.plaf;

import com.kingdee.bos.ctrl.swing.BarPartArea;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDSkinRootPane;
import com.kingdee.bos.ctrl.swing.helper.KDHelperBar;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeToolBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class KingdeeHelperBarUI
extends KingdeeToolBarUI {
    static final int dragAreaSize = 25;

    @Override
    protected void paintSelfShadow(Graphics g, JComponent c) {
        g.clearRect(0, 0, c.getWidth(), c.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        KDHelperBar helper = (KDHelperBar)c;
        int middleLine = 12;
        int width = helper.getWidth();
        int height = helper.getHeight();
        Color gradientColor1 = UIManager.getColor("HelperBar.gradientColor1");
        Color gradientColor2 = UIManager.getColor("HelperBar.gradientColor2");
        Color gradientColor3 = UIManager.getColor("HelperBar.gradientColor3");
        Color gradientColor4 = UIManager.getColor("HelperBar.gradientColor4");
        Color borderColor = UIManager.getColor("HelperBar.borderColor");
        if (helper.getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, gradientColor1, middleLine, 0.0f, gradientColor2));
            g2d.fillRect(0, 0, middleLine, height);
            g2d.setPaint(new GradientPaint(middleLine, 0.0f, gradientColor3, 25.0f, 0.0f, gradientColor4));
            g2d.fillRect(middleLine, 0, middleLine + 1, height);
            g2d.setColor(borderColor);
            g2d.drawLine(0, 0, width, 0);
            g2d.drawLine(0, height - 1, width, height - 1);
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, gradientColor1, 0.0f, middleLine, gradientColor2));
            g2d.fillRect(0, 0, width, middleLine);
            g2d.setPaint(new GradientPaint(0.0f, middleLine, gradientColor3, 0.0f, 25.0f, gradientColor4));
            g2d.fillRect(0, middleLine, width, middleLine + 1);
            g2d.setColor(borderColor);
            g2d.drawLine(0, 0, 0, height);
            g2d.drawLine(width - 1, 0, width - 1, height);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        KDHelperBar bar = (KDHelperBar)c;
        if (bar.isAlignToTabbedPane() && bar.getOrientation() == 1 && !this.floating) {
            g.setColor(UIManager.getColor("ToolBar.fifthsShadowColor"));
            g.fillRect(0, 0, c.getWidth(), 5);
            g.translate(0, 5);
            super.paint(g, c);
            g.translate(0, -5);
        } else {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintPoint(Graphics g, JComponent c) {
        Color old = g.getColor();
        if (this.toolBar.getOrientation() == 0) {
            g.setColor(this.dotColor);
            g.fillRect(7, 9, 2, 2);
            g.fillRect(11, 9, 2, 2);
            g.fillRect(15, 9, 2, 2);
            g.fillRect(19, 9, 2, 2);
            g.setColor(this.shadowDotColor);
            g.fillRect(6, 8, 2, 2);
            g.fillRect(10, 8, 2, 2);
            g.fillRect(14, 8, 2, 2);
            g.fillRect(18, 8, 2, 2);
        } else {
            g.setColor(this.dotColor);
            g.fillRect(9, 7, 2, 2);
            g.fillRect(9, 11, 2, 2);
            g.fillRect(9, 15, 2, 2);
            g.fillRect(9, 19, 2, 2);
            g.setColor(this.shadowDotColor);
            g.fillRect(8, 6, 2, 2);
            g.fillRect(8, 10, 2, 2);
            g.fillRect(8, 14, 2, 2);
            g.fillRect(8, 18, 2, 2);
        }
        g.setColor(old);
    }

    @Override
    protected void dragTo(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                int areaOrientation;
                Point offset;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((offset = this.dragWindow.getOffset()) == null) {
                    Dimension size = this.toolBar.getPreferredSize();
                    offset = new Point(30, 30);
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if ((areaOrientation = this.getDockingAreaOrientation(global)) == 0) {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                } else {
                    KDSkinRootPane skinRootPane = (KDSkinRootPane)((RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(this.dockingSource))).getRootPane();
                    BarPartArea targetBarPartArea = skinRootPane.getBarPartAreaOfOrientation(areaOrientation);
                    if (!(this.dockingSource != targetBarPartArea || this.floatingToolBar != null && ((Window)((Object)this.floatingToolBar)).isVisible())) {
                        this.dragWindow.setBackground(this.getFloatingColor());
                        this.dragWindow.setBorderColor(this.floatingBorderColor);
                    } else {
                        this.floatAt(position, origin);
                        ((KingdeeToolBarUI.DockingListener)this.dockingListener).cleanUpOrigin();
                        return;
                    }
                }
                this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow.isVisible()) {
                    Dimension size = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(size.width, size.height);
                    this.dragWindow.setVisible(true);
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void setFloating(int areaOrientation) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            if (areaOrientation == 0) {
                this.floating = true;
                Point l = new Point();
                this.toolBar.getLocation(l);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                ((BarPartArea)this.dockingSource).removeKDHelperBar((KDHelperBar)this.toolBar);
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(1);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(true);
                }
                this.toolBar.getComponent(1).setVisible(false);
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                if (!this.floating) {
                    ((BarPartArea)this.dockingSource).removeKDHelperBar((KDHelperBar)this.toolBar);
                }
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                KDSkinRootPane skinRootPane = (KDSkinRootPane)((RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(this.dockingSource))).getRootPane();
                BarPartArea targetBarPartArea = skinRootPane.getBarPartAreaOfOrientation(areaOrientation);
                int orientation = this.mapAreaOrientationToOrientation(areaOrientation);
                if (this.toolBar.getOrientation() != orientation) {
                    this.setOrientation(orientation);
                }
                targetBarPartArea.setKDHelperBar((KDHelperBar)this.toolBar);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                if (this.toolBar instanceof KDHelperBar) {
                    this.toolBar.getComponent(1).setVisible(((KDHelperBar)this.toolBar).isCloseButtonVisible());
                }
                this.dockingSource = targetBarPartArea;
                this.floating = false;
            }
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                ((JComponent)dockingSourceParent).revalidate();
            }
            this.dockingSource.repaint();
        }
    }

    @Override
    protected MouseMotionListener createLocalDragListener() {
        return new BarPartAreaLocalDragListener();
    }

    @Override
    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    private class FrameListener
    extends WindowAdapter {
        private FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (KingdeeHelperBarUI.this.toolBar.isFloatable()) {
                BarPartArea barPartArea;
                int areaOrientation;
                if (KingdeeHelperBarUI.this.dragWindow != null) {
                    KingdeeHelperBarUI.this.dragWindow.setVisible(false);
                }
                KingdeeHelperBarUI.this.floating = false;
                if (KingdeeHelperBarUI.this.floatingToolBar == null) {
                    KingdeeHelperBarUI.this.floatingToolBar = KingdeeHelperBarUI.this.createFloatingWindow(KingdeeHelperBarUI.this.toolBar);
                }
                if (KingdeeHelperBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)KingdeeHelperBarUI.this.floatingToolBar)).setVisible(false);
                }
                KingdeeHelperBarUI.this.floatingToolBar.getContentPane().remove(KingdeeHelperBarUI.this.toolBar);
                if (KingdeeHelperBarUI.this.dockingSource == null) {
                    KingdeeHelperBarUI.this.dockingSource = KingdeeHelperBarUI.this.toolBar.getParent();
                }
                if (KingdeeHelperBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(KingdeeHelperBarUI.this.propertyListener);
                }
                if ((areaOrientation = (barPartArea = (BarPartArea)KingdeeHelperBarUI.this.dockingSource).getAreaOrientation()) == 1 || areaOrientation == 5) {
                    ((KDHelperBar)KingdeeHelperBarUI.this.toolBar).setOrientation(0);
                } else if (areaOrientation == 7 || areaOrientation == 3) {
                    ((KDHelperBar)KingdeeHelperBarUI.this.toolBar).setOrientation(1);
                }
                ((BarPartArea)KingdeeHelperBarUI.this.dockingSource).setKDHelperBar((KDHelperBar)KingdeeHelperBarUI.this.toolBar);
                KingdeeHelperBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = KingdeeHelperBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    ((JComponent)dockingSourceParent).revalidate();
                }
                KingdeeHelperBarUI.this.dockingSource.repaint();
                if (KingdeeHelperBarUI.this.toolBar instanceof KDHelperBar) {
                    KingdeeHelperBarUI.this.toolBar.getComponent(1).setVisible(((KDHelperBar)KingdeeHelperBarUI.this.toolBar).isCloseButtonVisible());
                }
            }
        }
    }

    private class BarPartAreaLocalDragListener
    implements MouseMotionListener {
        private BarPartAreaLocalDragListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JRootPane rp;
            Window w = SwingUtilities.getWindowAncestor(KingdeeHelperBarUI.this.toolBar);
            if (w instanceof KDFrame && (rp = ((KDFrame)w).getRootPane()) instanceof KDSkinRootPane) {
                BarPartArea bpa1 = ((KDSkinRootPane)rp).getBarPartAreaOfOrientation(1);
                BarPartArea bpa2 = ((KDSkinRootPane)rp).getBarPartAreaOfOrientation(5);
                BarPartArea bpa3 = ((KDSkinRootPane)rp).getBarPartAreaOfOrientation(7);
                BarPartArea bpa4 = ((KDSkinRootPane)rp).getBarPartAreaOfOrientation(3);
                Point p = e.getPoint();
                if (KingdeeHelperBarUI.this.dragWindow != null && (bpa1.contains(SwingUtilities.convertPoint(KingdeeHelperBarUI.this.dragArea, p, bpa1)) || bpa2.contains(SwingUtilities.convertPoint(KingdeeHelperBarUI.this.dragArea, p, bpa2)) || bpa3.contains(SwingUtilities.convertPoint(KingdeeHelperBarUI.this.dragArea, p, bpa3)) || bpa4.contains(SwingUtilities.convertPoint(KingdeeHelperBarUI.this.dragArea, p, bpa4)))) {
                    KingdeeHelperBarUI.this.dragWindow.setVisible(false);
                    e.consume();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

