/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.ComboColorDownList;
import com.kingdee.bos.ctrl.swing.KDArrowButton;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.event.ComboColorPopupClosedEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorPopupClosedListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorWillPopupEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorWillPopupListener;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;

public class KingdeeComboColorUI
extends ComponentUI {
    private KDComboColor kdcbc;
    private PropertyChangeListener propetyChangeListener = new PropertyChangeHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private ComboColorDownList comboColorDownList;
    private KDPopupMenu popup;
    private boolean isPopping = false;
    private KDArrowButton arrowButton = new KDArrowButton(100);
    private JPanel panelColor = new JPanel();
    private JLabel labelColor = new JLabel();
    private JLabel labelPicture = new JLabel();
    private boolean isShowedBorderInViewPic = false;
    private ExtendedLineBorder border = new ExtendedLineBorder(Color.blue);
    private ViewPicColorBorder viewPicColorBorder = new ViewPicColorBorder();
    private DownListMouseHandler downListMouseHandler = new DownListMouseHandler();
    private DownListKeyHandler downListKeyHandler = new DownListKeyHandler();
    private KeyEventDispatcher keyDelegate = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                if (e.getKeyCode() == 37) {
                    KingdeeComboColorUI.this.kdcbc.getComboColorDownList().getUI().moveLeft();
                    return true;
                }
                if (e.getKeyCode() == 39) {
                    KingdeeComboColorUI.this.kdcbc.getComboColorDownList().getUI().moveRight();
                    return true;
                }
                if (e.getKeyCode() == 38) {
                    KingdeeComboColorUI.this.kdcbc.getComboColorDownList().getUI().moveUp();
                    return true;
                }
                if (e.getKeyCode() == 40) {
                    KingdeeComboColorUI.this.kdcbc.getComboColorDownList().getUI().moveDown();
                    return true;
                }
                if (e.getKeyCode() == 10) {
                    KingdeeComboColorUI.this.kdcbc.getComboColorDownList().getUI().pressEnter();
                    KingdeeComboColorUI.this.clearBorderForViewPic();
                    KingdeeComboColorUI.this.setPopupVisible(false);
                    return true;
                }
            }
            return false;
        }
    };

    public void closePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.kdcbc = (KDComboColor)c;
        this.installDefault(this.kdcbc);
        this.installComponents(this.kdcbc);
        this.installListeners(this.kdcbc);
        this.installKeyboardActions(this.kdcbc);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(this.kdcbc);
        this.uninstallKeyboardActions(this.kdcbc);
        this.uninstallComponents(this.kdcbc);
    }

    protected void installDefault(KDComboColor c) {
        this.panelColor.setBackground(c.getBackground());
        this.labelColor.setOpaque(true);
        this.setDisplayColor();
        c.setLayout(new ComboColorLayout());
        this.panelColor.setLayout(new ColorPanelLayout());
    }

    private void setDisplayColor() {
        if (KDComboColor.TRANSPARENTCOLOR.equals(this.kdcbc.getColor()) || this.kdcbc.getColor() == null) {
            this.labelColor.setOpaque(false);
        } else {
            this.labelColor.setOpaque(true);
            this.labelColor.setBackground(this.kdcbc.getColor());
        }
    }

    protected void installComponents(KDComboColor c) {
        this.installWithDifferentView(c);
        c.add(this.panelColor);
        c.add(this.arrowButton);
        this.comboColorDownList = this.createComboColorDownList();
    }

    protected void installWithDifferentView(KDComboColor c) {
        this.panelColor.removeAll();
        if (c.getViewType() == 2) {
            c.setBorder(this.border);
            this.labelColor.setBorder(this.viewPicColorBorder);
            this.initViewPicIcon(c);
            this.labelPicture.setHorizontalAlignment(0);
            this.panelColor.add(this.labelPicture);
            this.panelColor.add(this.labelColor);
            this.arrowButton.setDirection(100);
        } else if (c.getViewType() == 1) {
            c.setBorder(BorderFactory.createLoweredBevelBorder());
            this.labelColor.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.panelColor.add(this.labelColor);
            this.arrowButton.setDirection(5);
        }
    }

    private void initViewPicIcon(KDComboColor c) {
        ImageIcon icon = c.getPictureForViewPic();
        if (icon == null) {
            this.labelPicture.setIcon(new ImageIcon(KDResourceManager.getImageOfRapid("2label_icon_1.gif")));
        } else {
            this.labelPicture.setIcon(icon);
            this.labelPicture.setDisabledIcon(CtrlImageUtilities.createDisableIcon(icon));
        }
    }

    protected void uninstallComponents(KDComboColor c) {
        c.remove(this.panelColor);
        c.remove(this.arrowButton);
        this.kdcbc = null;
        this.comboColorDownList = null;
    }

    protected void installListeners(KDComboColor c) {
        c.addPropertyChangeListener(this.propetyChangeListener);
        c.addMouseListener(this.mouseHandler);
        this.arrowButton.addMouseListener(this.mouseHandler);
        this.comboColorDownList.addChooseMouseListener(this.downListMouseHandler);
        this.comboColorDownList.addChooseKeyListener(this.downListKeyHandler);
    }

    protected void uninstallListeners(KDComboColor c) {
        c.removePropertyChangeListener(this.propetyChangeListener);
        c.removeMouseListener(this.mouseHandler);
        this.arrowButton.removeMouseListener(this.mouseHandler);
        this.comboColorDownList.removeChooseMouseListener(this.downListMouseHandler);
        this.comboColorDownList.removeChooseKeyListener(this.downListKeyHandler);
    }

    protected void installKeyboardActions(KDComboColor c) {
        KeyStroke ks_down = KeyStroke.getKeyStroke(40, 0);
        InputMap inputMap = c.getInputMap(1);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(ks_down, "Along_down");
        actionMap.put(inputMap.get(ks_down), new KeyDownAction());
    }

    protected void uninstallKeyboardActions(KDComboColor c) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeComboColorUI();
    }

    public void setPopupVisible(boolean v) {
        if (!this.isPopping && v) {
            this.popDownList();
        } else if (this.isPopping && !v) {
            this.popDownList();
        }
    }

    public boolean isPopupVisible() {
        return this.isPopping;
    }

    protected void popDownList() {
        boolean bl = this.isPopping = !this.isPopping;
        if (this.isPopping) {
            this.fireWillPopup();
            Point lp = this.kdcbc.getLocation();
            try {
                lp = this.kdcbc.getLocationOnScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            int downListWidth = this.comboColorDownList.getPreferredSize().width;
            int downListHeight = this.comboColorDownList.getPreferredSize().height;
            int x = lp.x;
            int rightX = x + downListWidth;
            x = rightX > screenWidth ? x + this.kdcbc.getWidth() - downListWidth : x;
            int y = lp.y + this.kdcbc.getPreferredSize().height - 1;
            int bottomY = y + downListHeight;
            y = bottomY > screenHeight ? lp.y - downListHeight : y;
            this.popup = new KDPopupMenu(){

                @Override
                public void setVisible(boolean b) {
                    if (!b) {
                        KingdeeComboColorUI.this.isPopping = false;
                        KingdeeComboColorUI.this.clearBorderForViewPic();
                        KingdeeComboColorUI.this.kdcbc.repaint();
                        KingdeeComboColorUI.this.popup = null;
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(KingdeeComboColorUI.this.keyDelegate);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(KingdeeComboColorUI.this.keyDelegate);
                    }
                    super.setVisible(b);
                }
            };
            this.popup.setFocusable(false);
            this.popup.add(this.comboColorDownList);
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            Point p = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p, this.kdcbc);
            this.popup.show(this.kdcbc, p.x, p.y);
            this.showBorderForViewPic();
        } else {
            this.clearBorderForViewPic();
            this.kdcbc.repaint();
            this.popup.setVisible(false);
            this.popup = null;
            this.firePopupClosed();
        }
    }

    protected ComboColorDownList createComboColorDownList() {
        return this.kdcbc.getComboColorDownList();
    }

    private void showBorderForViewPic() {
        if (this.kdcbc.getViewType() == 2 && !this.isShowedBorderInViewPic) {
            this.kdcbc.putClientProperty("backgroundColor", this.kdcbc.getBackground());
            this.kdcbc.setBackground(Color.WHITE);
            this.border.setPaintTrigger(true);
            this.viewPicColorBorder.setPaintTrigger(true);
            this.isShowedBorderInViewPic = true;
            this.kdcbc.repaint();
        }
    }

    private void clearBorderForViewPic() {
        if (this.kdcbc.getViewType() == 2 && this.isShowedBorderInViewPic) {
            this.kdcbc.setBackground((Color)this.kdcbc.getClientProperty("backgroundColor"));
            this.border.setPaintTrigger(false);
            this.viewPicColorBorder.setPaintTrigger(false);
            this.isShowedBorderInViewPic = false;
            this.kdcbc.repaint();
        }
    }

    private void fireWillPopup() {
        EventListener[] listeners = this.kdcbc.getListeners(ComboColorWillPopupListener.class);
        ComboColorWillPopupEvent event = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (null == event) {
                event = new ComboColorWillPopupEvent(this.kdcbc);
            }
            ((ComboColorWillPopupListener)listeners[i]).willPopup(event);
        }
    }

    private void firePopupClosed() {
        EventListener[] listeners = this.kdcbc.getListeners(ComboColorPopupClosedListener.class);
        ComboColorPopupClosedEvent event = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (null == event) {
                event = new ComboColorPopupClosedEvent(this.kdcbc);
            }
            ((ComboColorPopupClosedListener)listeners[i]).popupClosed(event);
        }
    }

    private void fireViewPicClicked(Color currentColor) {
        EventListener[] listeners = this.kdcbc.getListeners(ComboColorViewPicClickListener.class);
        ComboColorViewPicClickEvent event = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (null == event) {
                event = new ComboColorViewPicClickEvent(this.kdcbc, currentColor);
            }
            ((ComboColorViewPicClickListener)listeners[i]).clicked(event);
        }
    }

    private class ExtendedLineBorder
    extends LineBorder {
        private boolean paintTrigger;

        public ExtendedLineBorder(Color color) {
            super(color);
            this.paintTrigger = false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.paintTrigger) {
                super.paintBorder(c, g, x, y, width, height);
            }
        }

        public void setPaintTrigger(boolean paintTrigger) {
            this.paintTrigger = paintTrigger;
        }
    }

    private class ViewPicColorBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -9103755129009605938L;
        private boolean paintTrigger = false;

        private ViewPicColorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.paintTrigger) {
                Color oldColor = g.getColor();
                int x2 = x + width - 1;
                int y2 = y + height - 1;
                g.setColor(Color.DARK_GRAY);
                g.drawLine(x, y2, x2, y2);
                g.drawLine(x2, y, x2, y2);
                g.setColor(oldColor);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return this.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public void setPaintTrigger(boolean paintTrigger) {
            this.paintTrigger = paintTrigger;
        }
    }

    private class KeyDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 1624989026541782864L;

        private KeyDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KingdeeComboColorUI.this.setPopupVisible(true);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                return;
            }
            KingdeeComboColorUI.this.showBorderForViewPic();
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2 && e.getSource() == KingdeeComboColorUI.this.kdcbc) {
                KingdeeComboColorUI.this.fireViewPicClicked(KingdeeComboColorUI.this.kdcbc.getColor());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                return;
            }
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 1) {
                KingdeeComboColorUI.this.popDownList();
            } else if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2 && e.getSource().equals(KingdeeComboColorUI.this.arrowButton)) {
                KingdeeComboColorUI.this.popDownList();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                return;
            }
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2) {
                KingdeeComboColorUI.this.showBorderForViewPic();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                return;
            }
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2 && !KingdeeComboColorUI.this.isPopupVisible()) {
                KingdeeComboColorUI.this.clearBorderForViewPic();
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("viewType")) {
                KingdeeComboColorUI.this.installWithDifferentView(KingdeeComboColorUI.this.kdcbc);
            } else if (name.equals("pictureForViewPic")) {
                KingdeeComboColorUI.this.initViewPicIcon(KingdeeComboColorUI.this.kdcbc);
            } else if (name.equals("selectedColor") || name.equals("selectionModel")) {
                KingdeeComboColorUI.this.setDisplayColor();
            } else if (name.equals("enabled")) {
                KingdeeComboColorUI.this.arrowButton.setEnabled(KingdeeComboColorUI.this.kdcbc.isEnabled());
                KingdeeComboColorUI.this.labelPicture.setEnabled(KingdeeComboColorUI.this.kdcbc.isEnabled());
            }
        }
    }

    private class ColorPanelLayout
    implements LayoutManager {
        private ColorPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            int pictureHeight = 12;
            int colorHeight = 3;
            int pureBorder = 2;
            int picBorder = 1;
            Insets insets = parent.getInsets();
            Dimension parentDim = parent.getSize();
            int x = insets.left;
            int y = insets.top;
            int w = parentDim.width - insets.left - insets.right;
            int h = parentDim.height - insets.top - insets.bottom;
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2) {
                w -= Math.min(picBorder * 2, w);
                h -= Math.min(picBorder * 2, h);
                int pH = h * pictureHeight / (pictureHeight + colorHeight);
                int cH = h - pH;
                KingdeeComboColorUI.this.labelPicture.setBounds(x += picBorder, y += picBorder, w, pH);
                KingdeeComboColorUI.this.labelColor.setBounds(x, y + pH, w, cH);
            } else if (KingdeeComboColorUI.this.kdcbc.getViewType() == 1) {
                w -= Math.min(pureBorder * 2, w);
                h -= Math.min(pureBorder * 2, h);
                KingdeeComboColorUI.this.labelColor.setBounds(x += pureBorder, y += pureBorder, w, h);
            }
        }
    }

    private class ComboColorLayout
    implements LayoutManager {
        private static final int pureHeight = 21;
        private static final int pureWidth = 100;
        private static final int pureArrowWidth = 18;
        private static final int pureBorderWidth = 2;
        private static final int picHeight = 21;
        private static final int picWidth = 35;
        private static final int picArrowWidth = 15;
        private static final int picBorderWidth = 1;

        private ComboColorLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2) {
                w = 35;
                h = 21;
            } else if (KingdeeComboColorUI.this.kdcbc.getViewType() == 1) {
                w = 100;
                h = 21;
            }
            return new Dimension(w, h);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (KingdeeComboColorUI.this.kdcbc.getViewType() == 2) {
                this.layoutComponents(parent, 35, 21, 15, 1);
            } else if (KingdeeComboColorUI.this.kdcbc.getViewType() == 1) {
                this.layoutComponents(parent, 0, 0, 18, 2);
            }
        }

        private void layoutComponents(Container parent, int expWidth, int expHeight, int arrowWidth, int borderWidth) {
            Dimension parentDim = parent.getSize();
            if (expWidth == 0) {
                expWidth = parentDim.width;
            }
            if (expHeight == 0) {
                expHeight = parentDim.height;
            }
            int x = (parentDim.width - expWidth) / 2 + borderWidth;
            int y = (parentDim.height - expHeight) / 2 + borderWidth;
            int w = expWidth - arrowWidth - borderWidth * 2;
            int h = expHeight - borderWidth * 2;
            KingdeeComboColorUI.this.panelColor.setBounds(x, y, w, h);
            x += w;
            w = arrowWidth;
            KingdeeComboColorUI.this.arrowButton.setBounds(x, y, w, h);
        }
    }

    private class DownListKeyHandler
    extends KeyAdapter {
        private DownListKeyHandler() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                return;
            }
            if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                KingdeeComboColorUI.this.clearBorderForViewPic();
                KingdeeComboColorUI.this.setPopupVisible(false);
            }
        }
    }

    private class DownListMouseHandler
    extends MouseAdapter {
        private DownListMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (KingdeeComboColorUI.this.kdcbc.isEnabled()) {
                KingdeeComboColorUI.this.clearBorderForViewPic();
                KingdeeComboColorUI.this.setPopupVisible(false);
            }
        }
    }
}

