/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.CtrlFocusTraversalPolicy;
import com.kingdee.bos.ctrl.swing.DatePickerDownList;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.DateTimeValueChangeEvent;
import com.kingdee.bos.ctrl.swing.model.IDateTimeModel;
import com.kingdee.bos.ctrl.swing.model.KDSpinnerDateModel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.PaintUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class KingdeeDatePickerDownListUI
extends ComponentUI {
    private LayoutManager layout = null;
    private DatePickerDownList c = null;
    private JSpinner yearSpinner = null;
    private KDComboBox monthCombo = null;
    private KDSpinner timeSpinner = null;
    private KDCheckBox nullBox = null;
    private KDWorkButton todayBu = null;
    private KDLabel thisDay = null;
    private KDPopupMenu toThisDay = null;
    private KDButton okButton = null;
    private KDPanel focusHelper = null;
    private KDButton cancelButton = null;
    private PropertyChangeListener propertyChangeListener = null;
    private static String[] months = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static Dimension zeroDim = new Dimension(0, 0);
    private static boolean dayFocused = false;
    private boolean sundayFirst = true;
    private static int rowInterval = 6;
    private static int columnInterval = 3;
    private static Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension compPreferredSize = new Dimension(343, 228);
    private static String[] weeks = new String[]{LanguageManager.getLangMessage((String)"Sunday", KDDatePicker.class, (String)"Sun"), LanguageManager.getLangMessage((String)"Monday", KDDatePicker.class, (String)"Mon"), LanguageManager.getLangMessage((String)"Tuesday", KDDatePicker.class, (String)"Tue"), LanguageManager.getLangMessage((String)"Wednesday", KDDatePicker.class, (String)"Wed"), LanguageManager.getLangMessage((String)"Thursday", KDDatePicker.class, (String)"Thu"), LanguageManager.getLangMessage((String)"Friday", KDDatePicker.class, (String)"Fri"), LanguageManager.getLangMessage((String)"Saturday", KDDatePicker.class, (String)"Sat")};
    private static int dayAreaX = 6;
    private int dayAreaY = 35;
    private int dayAreaInnerY = 7;
    private Calendar calendar = null;
    private Dimension dayAreaDim = null;
    private Dimension dayAreaInnerDim = null;
    private static int dayAreaInsets_top = 5;
    private boolean isDecorateBu = false;
    private boolean isTimeEditorEnabled = false;
    private boolean isNullValueEnabled = false;
    private static final int CHECKBOX = 0;
    private static final int TODAY_COMMAND = 1;
    private int selectedIndex = -1;
    private Rectangle selectedRect = null;
    private Integer maxYearInt = null;
    private Integer minYearInt = null;
    private YearMonthChangeListener yearMonthChangeListener = null;
    private ButtonHandler buttonHandler = null;
    private ButtonHandler todayHandler = null;
    private MouseHandler mouseHandler = null;
    private EditorDataChangeListener editorDataChangeListener = null;
    private TimeChangeListener timeChangeListener = null;
    private FocusListener downListFocusHandler = null;
    private Action upAction = null;
    private Action downAction = null;
    private Action leftAction = null;
    private Action rightAction = null;
    private Action pageDownAction = null;
    private Action pageUpAction = null;
    private Action ctrlPageDownAction = null;
    private Action ctrlPageUpAction = null;
    private int selectedYear = 2004;
    private int selectedMonth = 1;
    private int selectedDay = 1;
    private int selectedWeek = 1;
    private int todayYear = 2004;
    private int todayMonth = 1;
    private int todayDay = 1;
    private DayRectInfo dayRectInfo = null;
    private Color topColorA = null;
    private Color topColorB = null;
    private Color topColorC = null;
    private Color botColorA = null;
    private Color botColorB = null;
    private Color botColorC = null;
    private Color dayAreaBackground = null;
    private Color dayAreaBorder = null;
    private Color borderColor = null;
    private Color otherDayTextColor = null;
    private Color fg = null;
    private Color wfg = null;
    private Image currentDateIcon = null;
    private Image pitchonIcon = null;
    private static boolean DEBUG = true;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeDatePickerDownListUI();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension dim = this.getPreferredSize(c);
        dim.width += dim.width + c.getInsets().left + c.getInsets().right + 20;
        dim.height += dim.height + c.getInsets().top + c.getInsets().right + 20;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return compPreferredSize;
    }

    private IDateTimeModel getModel() {
        return this.c.getModel();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (DatePickerDownList)c;
        this.createLayout();
        c.setLayout(this.layout);
        this.installComponents(this.c);
        this.installDefaults(this.c);
        this.installListeners(this.c);
        this.installKeyboardActions(this.c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paingSelfBackground(g, c);
        g.translate(dayAreaX, this.dayAreaY);
        g.setColor(this.dayAreaBackground);
        g.fillRect(0, 0, this.dayAreaDim.width, this.dayAreaDim.height);
        g.setColor(this.dayAreaBorder);
        g.drawRect(0, 0, this.dayAreaDim.width, this.dayAreaDim.height);
        g.translate(-dayAreaX, -this.dayAreaY);
        g.translate(dayAreaX, this.dayAreaY);
        g.setColor(c.getForeground());
        this.paintWeekArea(g, c);
        g.translate(-dayAreaX, -this.dayAreaY);
        g.translate(dayAreaX, this.dayAreaInnerY);
        this.paintDayArea(g, c);
        g.translate(-dayAreaX, -this.dayAreaInnerY);
    }

    public void paingSelfBackground(Graphics g, JComponent c) {
        if (!c.isOpaque()) {
            return;
        }
        Color old = g.getColor();
        g.setColor(c.getBackground());
        g.fill3DRect(0, 0, c.getWidth(), c.getHeight(), true);
        PaintUtil.drawRectangle(g, c.getWidth(), c.getHeight(), this.topColorA, this.topColorB, this.topColorC, this.botColorA, this.botColorB, this.botColorC);
        g.setColor(old);
    }

    protected void paintWeekArea(Graphics g, JComponent c) {
        int temp;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int fmH = fm.getHeight();
        int fmW = fm.stringWidth(weeks[0]);
        g.drawLine(0, fmH + dayAreaInsets_top, this.dayAreaDim.width, fmH + dayAreaInsets_top);
        int weekCellWidth = this.dayAreaDim.width / 7;
        int temp0 = weekCellWidth - fmW;
        int n = temp = temp0 > 2 ? temp0 / 2 : 0;
        if (this.isSundayFirst()) {
            for (int i = 0; i <= 6; ++i) {
                int x = i * weekCellWidth + temp;
                int y = fmH;
                if (i == 0 || i == 6) {
                    g.drawString(weeks[i], x, y);
                    continue;
                }
                g.drawString(weeks[i], x, y);
            }
        } else {
            for (int i = 0; i <= 6; ++i) {
                int x = i * weekCellWidth + temp;
                int y = fmH;
                g.drawString(weeks[i < 6 ? i + 1 : 0], x, y);
            }
        }
    }

    protected void paintDayArea(Graphics g, JComponent c) {
        if (this.dayRectInfo == null) {
            return;
        }
        if (this.selectedDay != -1) {
            this.selectedIndex = this.dayRectInfo.getIndexByDay(this.selectedDay);
            this.selectedRect = this.dayRectInfo.getRectangle(this.selectedIndex);
            if (this.selectedRect != null) {
                g.setColor(Color.BLUE);
                if (this.pitchonIcon != null) {
                    if (dayFocused) {
                        BasicStroke str = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{2.0f, 4.0f, 2.0f, 4.0f}, 1.0f);
                        ((Graphics2D)g).setStroke(str);
                        ((Graphics2D)g).drawRoundRect(this.selectedRect.x + 9, this.selectedRect.y + 5, this.selectedRect.width - 13, this.selectedRect.height - 5, 20, 20);
                    }
                    g.drawImage(this.pitchonIcon, this.selectedRect.x + 5, this.selectedRect.y + 5, this.selectedRect.width - 5, this.selectedRect.height - 5, c);
                } else {
                    g.draw3DRect(this.selectedRect.x + 5, this.selectedRect.y + 5, this.selectedRect.width - 5, this.selectedRect.height - 5, true);
                }
            }
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fmH = fm.getHeight();
        int weekCellWidth = this.dayAreaDim.width / 7;
        int fmW = fm.stringWidth("\u4e00");
        int temp0 = weekCellWidth - fmW;
        int temp = temp0 > 2 ? temp0 / 2 : 0;
        Color oldColor = g.getColor();
        for (int row = 0; row <= 5; ++row) {
            for (int column = 0; column <= 6; ++column) {
                int index = row * 7 + column;
                Rectangle rec = this.dayRectInfo.getRect(index);
                String text = this.dayRectInfo.getText(index);
                Color color = this.dayRectInfo.getColor(index);
                if (!this.isSundayFirst()) {
                    if ((column == 5 || column == 6) && this.dayRectInfo.isTheMoth(index)) {
                        color = this.wfg;
                    }
                } else if ((column == 0 || column == 6) && this.dayRectInfo.isTheMoth(index)) {
                    color = this.wfg;
                }
                g.setColor(color);
                if (this.isCurrentDay(index, row)) {
                    g.drawImage(this.currentDateIcon, rec.x + 5, rec.y + 5, rec.width - 5, rec.height - 5, c);
                }
                if (rec.y == 0) {
                    g.drawString(text, rec.x + temp, rec.y + fmH);
                    continue;
                }
                g.drawString(text, rec.x + temp, rec.y + fmH);
            }
        }
        g.setColor(oldColor);
    }

    public void setSundayFirst(boolean sundayFirst) {
        this.sundayFirst = sundayFirst;
        this.calculateDayInfo(new Integer(this.selectedYear), new Integer(this.selectedMonth - 1));
    }

    public boolean isSundayFirst() {
        return this.sundayFirst;
    }

    public boolean isCurrentDay(int index, int row) {
        if (this.selectedDay != -1) {
            this.selectedIndex = this.dayRectInfo.getIndexByDay(this.selectedDay);
            this.selectedRect = this.dayRectInfo.getRectangle(this.selectedIndex);
            if (this.selectedRect != null && this.selectedIndex == index) {
                return false;
            }
        }
        int tmpYear = this.selectedYear;
        int tmpMonth = this.selectedMonth;
        String sTmpDay = this.dayRectInfo.getText(index);
        if (sTmpDay == null || sTmpDay.equals("")) {
            return false;
        }
        int tmpDay = Integer.parseInt(sTmpDay);
        if (this.dayRectInfo.isNow(index)) {
            return tmpYear == this.todayYear && tmpMonth == this.todayMonth && tmpDay == this.todayDay;
        }
        if (row == 0) {
            int[] prevYearMonth = this.getPrevYearMonth(this.selectedYear, this.selectedMonth);
            tmpYear = prevYearMonth[0];
            tmpMonth = prevYearMonth[1];
            return tmpYear == this.todayYear && tmpMonth == this.todayMonth && tmpDay == this.todayDay;
        }
        if (row > 3) {
            int[] nextYearMonth = this.getNextYearMonth(this.selectedYear, this.selectedMonth);
            tmpYear = nextYearMonth[0];
            tmpMonth = nextYearMonth[1];
            return tmpYear == this.todayYear && tmpMonth == this.todayMonth && tmpDay == this.todayDay;
        }
        return false;
    }

    public int[] getPrevYearMonth(int year, int month) {
        int[] yearMonth = new int[2];
        int tmpMonth = month - 1;
        if (tmpMonth < 1) {
            yearMonth[0] = year - 1;
            yearMonth[1] = 12;
        } else {
            yearMonth[0] = year;
            yearMonth[1] = tmpMonth;
        }
        return yearMonth;
    }

    public int[] getNextYearMonth(int year, int month) {
        int[] yearMonth = new int[2];
        int tmpMonth = month + 1;
        if (tmpMonth > 12) {
            yearMonth[0] = year + 1;
            yearMonth[1] = 1;
        } else {
            yearMonth[0] = year;
            yearMonth[1] = tmpMonth;
        }
        return yearMonth;
    }

    public boolean isCurrentDay(int year, int month, int day) {
        if (year != this.todayYear || month != this.todayMonth || day != this.todayDay) {
            return false;
        }
        if (this.selectedDay != -1) {
            this.selectedIndex = this.dayRectInfo.getIndexByDay(this.selectedDay);
            this.selectedRect = this.dayRectInfo.getRectangle(this.selectedIndex);
            return this.selectedRect == null;
        }
        return true;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallKeyboardActions((DatePickerDownList)c);
        this.unInstallListeners((DatePickerDownList)c);
        this.unInstallDefaults((DatePickerDownList)c);
        this.unInstallComponents((DatePickerDownList)c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void createLayout() {
        if (this.layout == null) {
            this.layout = new DownLayout();
        }
    }

    protected KDWorkButton createTodayButton() {
        String str = LanguageManager.getLangMessage((String)"ToTodayAndConfirm", KDDatePicker.class, (String)"Today(T)");
        KDWorkButton today = new KDWorkButton(str);
        today.setAssistPopup(this.toThisDay);
        return today;
    }

    public void removeAllRollOverEffect() {
        this.okButton.getModel().setRollover(false);
        this.cancelButton.getModel().setRollover(false);
        this.todayBu.getModel().setRollover(false);
    }

    protected void installComponents(DatePickerDownList c) {
        FontMetrics fms;
        Insets is;
        int yearSpinnerH = 0;
        Component[] orderComps = new Component[7];
        if (this.yearSpinner == null) {
            SpinnerNumberModel numberModel = new SpinnerNumberModel(2004, 1000, 3000, 1);
            this.yearSpinner = new KDSpinner(numberModel);
            this.yearSpinner.setPreferredSize(new Dimension(75, 19));
            JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.yearSpinner);
            DecimalFormat decFormat = numberEditor.getFormat();
            decFormat.setDecimalSeparatorAlwaysShown(false);
            decFormat.setGroupingUsed(false);
            decFormat.setMaximumIntegerDigits(4);
            decFormat.setMaximumFractionDigits(0);
            JFormattedTextField tempFtf = numberEditor.getTextField();
            NumberFormatter numFormatter = (NumberFormatter)tempFtf.getFormatter();
            numFormatter.setAllowsInvalid(false);
            numFormatter.setOverwriteMode(true);
            ((DefaultFormatterFactory)tempFtf.getFormatterFactory()).setEditFormatter(numFormatter);
            tempFtf.setFormatterFactory(tempFtf.getFormatterFactory());
            this.yearSpinner.setEditor(numberEditor);
            c.add((Component)this.yearSpinner, "year");
            yearSpinnerH = this.yearSpinner.getPreferredSize().height;
            this.dayAreaY = this.yearSpinner.getPreferredSize().height + KingdeeDatePickerDownListUI.insets.top + rowInterval;
            tempFtf.setName("\u5e74 \u63a7\u4ef60  ");
            orderComps[0] = tempFtf;
        }
        if (this.monthCombo == null) {
            this.monthCombo = new KDComboBox(months);
            ((JLabel)((Object)this.monthCombo.getRenderer())).setHorizontalAlignment(4);
            this.monthCombo.setPreferredSize(new Dimension(75, 19));
            c.add((Component)this.monthCombo, "month");
            this.monthCombo.setName("\u6708\u63a7\u4ef61  ");
            orderComps[1] = this.monthCombo;
        }
        if (this.timeSpinner == null) {
            KDSpinnerDateModel dateModel = new KDSpinnerDateModel();
            this.timeSpinner = new KDSpinner(dateModel);
            this.timeSpinner.setPreferredSize(new Dimension(75, 19));
            JSpinner.DateEditor spiDateEditor = (JSpinner.DateEditor)this.timeSpinner.getEditor();
            DateFormatter formatter = (DateFormatter)((JSpinner.DateEditor)this.timeSpinner.getEditor()).getTextField().getFormatter();
            if (this.getModel().isMillisecondEnable()) {
                spiDateEditor.getFormat().applyPattern("HH:mm:ss:SSS");
                spiDateEditor.getFormat().setLenient(false);
            } else {
                spiDateEditor.getFormat().applyPattern("HH:mm:ss");
                spiDateEditor.getFormat().setLenient(false);
            }
            formatter.setOverwriteMode(false);
            JFormattedTextField.AbstractFormatterFactory factory = spiDateEditor.getTextField().getFormatterFactory();
            ((DefaultFormatterFactory)factory).setDefaultFormatter(formatter);
            spiDateEditor.getTextField().setFormatterFactory(factory);
            this.timeSpinner.setEditor(spiDateEditor);
            c.add((Component)this.timeSpinner, "time");
            this.isTimeEditorEnabled = c.isTimeEditorEnabled();
            this.timeSpinner.setVisible(this.isTimeEditorEnabled);
            this.timeSpinner.setName("\u65f6\u95f4\u63a7\u4ef62  ");
            orderComps[2] = spiDateEditor.getTextField();
        }
        if (this.nullBox == null) {
            this.nullBox = new KDCheckBox(LanguageManager.getLangMessage((String)"nullValue", KDDatePicker.class, (String)"\u7a7a\u503c"));
            this.nullBox.setSelected(false);
            this.nullBox.setPreferredSize(new Dimension(60, 19));
            this.nullBox.setHorizontalAlignment(4);
            c.add((Component)this.nullBox, "nullvalue");
            this.isNullValueEnabled = c.isNullValueEnabled();
            this.nullBox.setVisible(this.isNullValueEnabled);
            this.nullBox.setName("\u662f\u5426\u7a7a\u503c3  ");
            orderComps[3] = this.nullBox;
        }
        c.setName("DatePiceDownList4  ");
        if (this.toThisDay == null) {
            this.toThisDay = new KDPopupMenu();
            KDMenuItem menuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"ToToday", KDDatePicker.class, (String)"Go To Today"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date todayValue = new Date(System.currentTimeMillis());
                    KingdeeDatePickerDownListUI.this.c.setValue(todayValue);
                    KingdeeDatePickerDownListUI.this.c.repaint();
                }
            });
            this.toThisDay.add(menuItem);
            menuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"ToThisMonth", KDDatePicker.class, (String)"To this month"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date todayValue = new Date(System.currentTimeMillis());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(todayValue);
                    cal.set(5, 1);
                    KingdeeDatePickerDownListUI.this.c.setValue(cal.getTime());
                    KingdeeDatePickerDownListUI.this.c.repaint();
                }
            });
            this.toThisDay.add(menuItem);
            menuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"ToLastMonth", KDDatePicker.class, (String)"To last month"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date todayValue = new Date(System.currentTimeMillis());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(todayValue);
                    cal.set(2, cal.get(2) - 1);
                    cal.set(5, 1);
                    KingdeeDatePickerDownListUI.this.c.setValue(cal.getTime());
                    KingdeeDatePickerDownListUI.this.c.repaint();
                }
            });
            this.toThisDay.add(menuItem);
            menuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"ToTheMonthBeforeLastMonth", KDDatePicker.class, (String)"To the month before last month"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date todayValue = new Date(System.currentTimeMillis());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(todayValue);
                    cal.set(2, cal.get(2) - 2);
                    cal.set(5, 1);
                    KingdeeDatePickerDownListUI.this.c.setValue(cal.getTime());
                    KingdeeDatePickerDownListUI.this.c.repaint();
                }
            });
            this.toThisDay.add(menuItem);
            menuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"ToThisYear", KDDatePicker.class, (String)"To this year"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Date todayValue = new Date(System.currentTimeMillis());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(todayValue);
                    cal.set(2, 0);
                    cal.set(5, 1);
                    KingdeeDatePickerDownListUI.this.c.setValue(cal.getTime());
                    KingdeeDatePickerDownListUI.this.c.repaint();
                }
            });
            this.toThisDay.add(menuItem);
            PopupListener popupListener = new PopupListener(this.toThisDay);
            c.addMouseListener(popupListener);
        }
        if (this.okButton == null) {
            this.okButton = new KDButton(LanguageManager.getLangMessage((String)"Confirm", KDDatePicker.class, (String)"OK"));
            is = this.okButton.getInsets();
            this.okButton.setCustomInsets(new Insets(is.top - 2, is.left - 6, is.bottom - 2, is.right - 6));
            this.okButton.setActionCommand("okButton");
            this.okButton.setPreferredSize(new Dimension(60, 19));
            c.add((Component)this.okButton, "ok");
            c.putClientProperty("DownList.DefaultButton", this.okButton);
            this.okButton.setName("\u786e\u5b9a6  ");
            orderComps[5] = this.okButton;
        }
        if (this.cancelButton == null) {
            this.cancelButton = new KDButton(LanguageManager.getLangMessage((String)"Cancel", KDDatePicker.class, (String)"Cancel"));
            is = this.cancelButton.getInsets();
            this.cancelButton.setCustomInsets(new Insets(is.top - 2, is.left - 6, is.bottom - 2, is.right - 6));
            this.cancelButton.setActionCommand("cancelButton");
            this.cancelButton.setPreferredSize(new Dimension(60, 19));
            c.add((Component)this.cancelButton, "cancel");
            this.cancelButton.setName("\u53d6\u6d887  ");
            orderComps[6] = this.cancelButton;
        }
        this.todayBu = this.createTodayButton();
        this.todayBu.setActionCommand("today");
        this.todayBu.setPreferredSize(new Dimension(this.todayBu.getPreferredSize().width, 21));
        c.add((Component)this.todayBu, "today");
        this.todayBu.setName("\u4eca\u59295  ");
        c.getActionMap().put("MnemonicKey", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                KingdeeDatePickerDownListUI.this.todayBu.putClientProperty("IsInArrowScope", Boolean.FALSE);
                KingdeeDatePickerDownListUI.this.todayBu.doClick();
            }
        });
        c.getInputMap(1).put(KeyStroke.getKeyStroke(84, 0), "MnemonicKey");
        if (this.thisDay == null) {
            DateFormat format = CtrlFormatUtilities.getDateFormat();
            if (format != null) {
                this.thisDay = new KDLabel(format.format(this.getModel().getValue()));
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getModel().getValue());
                this.thisDay = Locale.getDefault().getLanguage() == "en" ? new KDLabel(new Integer(cal.get(2) + 1).toString() + "/" + new Integer(cal.get(5)).toString() + "/" + new Integer(cal.get(1)).toString()) : new KDLabel(new Integer(cal.get(1)).toString() + "-" + new Integer(cal.get(2) + 1).toString() + "-" + new Integer(cal.get(5)).toString());
            }
            c.add((Component)this.thisDay, "thisDay");
        }
        if (this.focusHelper == null) {
            this.focusHelper = new KDPanel();
            orderComps[4] = this.focusHelper;
            c.add((Component)this.focusHelper, "focusHelper");
        }
        int aw = KingdeeDatePickerDownListUI.compPreferredSize.width - KingdeeDatePickerDownListUI.insets.left - KingdeeDatePickerDownListUI.insets.right;
        int ah = KingdeeDatePickerDownListUI.compPreferredSize.height - KingdeeDatePickerDownListUI.insets.top - KingdeeDatePickerDownListUI.insets.bottom - 2 * rowInterval - yearSpinnerH - this.okButton.getPreferredSize().height;
        this.dayAreaDim = new Dimension(aw, ah);
        Font font = this.okButton.getFont();
        int fm = 18;
        if (font != null && (fms = this.okButton.getFontMetrics(font)) != null) {
            fm = fms.getHeight();
        }
        ah = ah - dayAreaInsets_top - fm;
        this.dayAreaInnerDim = new Dimension(aw, ah);
        this.dayAreaInnerY = this.dayAreaY + dayAreaInsets_top + fm;
        CtrlFocusTraversalPolicy ctrlFocusPolicy = new CtrlFocusTraversalPolicy();
        ctrlFocusPolicy.setOrderComponents(orderComps);
        c.setFocusTraversalPolicy(ctrlFocusPolicy);
        c.setFocusCycleRoot(true);
    }

    protected void installDefaults(DatePickerDownList c) {
        Color bg = UIManager.getColor("DatePickerDownList.background");
        if (bg == null) {
            bg = Color.decode("#CFCFC0");
        }
        c.setBackground(bg);
        this.fg = UIManager.getColor("DatePickerDownList.foreground");
        if (this.fg == null) {
            this.fg = Color.decode("#000000");
        }
        this.wfg = UIManager.getColor("DatePickerDownList.weekendTextColor");
        if (this.wfg == null) {
            this.wfg = Color.decode("#000EBE");
        }
        this.borderColor = UIManager.getColor("DatePickerDownList.borderColor");
        if (this.borderColor == null) {
            this.borderColor = Color.decode("#828272");
        }
        this.topColorA = UIManager.getColor("DatePickerDownList.topColorA");
        if (this.topColorA == null) {
            this.topColorA = Color.decode("#DFDED4");
        }
        this.topColorB = UIManager.getColor("DatePickerDownList.topColorB");
        if (this.topColorB == null) {
            this.topColorB = Color.decode("#D9DBCD");
        }
        this.topColorC = UIManager.getColor("DatePickerDownList.topColorC");
        if (this.topColorC == null) {
            this.topColorC = Color.decode("#D3D3C5");
        }
        this.botColorA = UIManager.getColor("DatePickerDownList.botColorA");
        if (this.botColorA == null) {
            this.botColorA = Color.decode("#C9C9B9");
        }
        this.botColorB = UIManager.getColor("DatePickerDownList.botColorB");
        if (this.botColorB == null) {
            this.botColorB = Color.decode("#BFBFAF");
        }
        this.botColorC = UIManager.getColor("DatePickerDownList.botColorC");
        if (this.botColorC == null) {
            this.botColorC = Color.decode("#B5B5A5");
        }
        this.otherDayTextColor = UIManager.getColor("DatePickerDownList.otherDayTextColor");
        if (this.otherDayTextColor == null) {
            this.otherDayTextColor = Color.decode("#7B7B7B");
        }
        this.dayAreaBackground = UIManager.getColor("DatePickerDownList.dayAreaBackground");
        if (this.dayAreaBackground == null) {
            this.dayAreaBackground = Color.decode("#FFFFFF");
        }
        this.dayAreaBorder = UIManager.getColor("DatePickerDownList.dayAreaBorder");
        if (this.dayAreaBorder == null) {
            this.dayAreaBorder = Color.decode("#A6A693");
        }
        c.setBorder(new KingdeeBorders.CommonEditorBorder(this.borderColor, this.borderColor, this.borderColor));
        ImageIcon tempCurrIcon = (ImageIcon)UIManager.getIcon("DatePickerDownList.currentDateIcon");
        if (tempCurrIcon != null) {
            this.currentDateIcon = tempCurrIcon.getImage();
        }
        if ((tempCurrIcon = (ImageIcon)UIManager.getIcon("DatePickerDownList.pichonIcon")) != null) {
            this.pitchonIcon = tempCurrIcon.getImage();
        }
        tempCurrIcon = null;
        c.setPreferredSize(compPreferredSize);
        Object obj = c.getValue();
        this.calendar = Calendar.getInstance();
        if (obj != null && obj instanceof Date) {
            this.calendar.setTime(new Date(((Date)obj).getTime()));
        } else {
            this.calendar.setTime(new Date(System.currentTimeMillis()));
        }
        Calendar tempCa = Calendar.getInstance();
        tempCa.setTime(new Date(System.currentTimeMillis()));
        this.todayYear = tempCa.get(1);
        this.todayMonth = tempCa.get(2) + 1;
        this.todayDay = tempCa.get(5);
        this.selectedYear = this.calendar.get(1);
        this.selectedMonth = this.calendar.get(2) + 1;
        this.yearSpinner.setValue(new Integer(this.selectedYear));
        this.monthCombo.setSelectedItem(String.valueOf(this.selectedMonth));
        this.timeSpinner.setValue(this.calendar.getTime());
        if (this.dayRectInfo == null) {
            this.dayRectInfo = new DayRectInfo();
        }
        this.calculateDayInfo(new Integer(this.selectedYear), new Integer(this.selectedMonth - 1));
        this.selectedDay = this.calendar.get(5);
        this.selectedWeek = this.calendar.get(4) - 1;
        this.selectedIndex = this.dayRectInfo.getIndexByDay(this.selectedDay);
        this.isDecorateBu = c.isDecorateButton();
        tempCa = null;
    }

    protected void unInstallListeners(DatePickerDownList c) {
        if (this.downListFocusHandler != null) {
            c.removeFocusListener(this.downListFocusHandler);
            this.downListFocusHandler = null;
        }
        if (this.yearMonthChangeListener != null) {
            this.yearSpinner.removeChangeListener(this.yearMonthChangeListener);
            this.monthCombo.removeItemListener(this.yearMonthChangeListener);
            this.yearMonthChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            c.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.buttonHandler != null) {
            this.nullBox.removeActionListener(this.buttonHandler);
            this.buttonHandler = null;
        }
        if (this.mouseHandler != null) {
            c.removeMouseListener(this.mouseHandler);
            this.mouseHandler = null;
        }
        if (this.timeChangeListener != null) {
            this.timeSpinner.removeChangeListener(this.timeChangeListener);
            this.timeChangeListener = null;
        }
        if (this.editorDataChangeListener != null) {
            c.removeDataChangeListener(this.editorDataChangeListener);
            this.editorDataChangeListener = null;
        }
    }

    protected void unInstallKeyboardActions(DatePickerDownList c) {
        this.pageDownAction = null;
        this.pageUpAction = null;
    }

    protected void unInstallComponents(DatePickerDownList c) {
        c.setLayout(null);
        c.removeAll();
        this.yearSpinner = null;
        this.monthCombo = null;
        this.timeSpinner = null;
        this.nullBox = null;
    }

    protected void unInstallDefaults(DatePickerDownList c) {
        this.topColorA = null;
        this.topColorB = null;
        this.topColorC = null;
        this.botColorA = null;
        this.botColorB = null;
        this.botColorC = null;
        this.borderColor = null;
        this.dayAreaBackground = null;
        this.otherDayTextColor = null;
        this.currentDateIcon = null;
        this.pitchonIcon = null;
    }

    protected void installListeners(DatePickerDownList c) {
        if (this.downListFocusHandler == null) {
            this.downListFocusHandler = new FocusHandler();
            this.focusHelper.addFocusListener(this.downListFocusHandler);
        }
        if (this.yearMonthChangeListener == null) {
            this.yearMonthChangeListener = new YearMonthChangeListener();
            this.yearSpinner.addChangeListener(this.yearMonthChangeListener);
            this.monthCombo.addItemListener(this.yearMonthChangeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new DLPropertyChangeListener();
            c.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.buttonHandler == null) {
            this.buttonHandler = new ButtonHandler(0);
            this.nullBox.addActionListener(this.buttonHandler);
        }
        if (this.todayHandler == null) {
            this.todayHandler = new ButtonHandler(1);
            this.todayBu.addActionListener(this.todayHandler);
        }
        if (this.mouseHandler == null) {
            this.mouseHandler = new MouseHandler();
            c.addMouseListener(this.mouseHandler);
        }
        if (this.timeChangeListener == null) {
            this.timeChangeListener = new TimeChangeListener();
            this.timeSpinner.addChangeListener(this.timeChangeListener);
        }
        if (this.editorDataChangeListener == null) {
            this.editorDataChangeListener = new EditorDataChangeListener();
            c.addDataChangeListener(this.editorDataChangeListener);
        }
    }

    protected void installKeyboardActions(DatePickerDownList c) {
        if (this.upAction == null) {
            this.upAction = new UpDownLeftRightActionHandler(38);
        }
        if (this.downAction == null) {
            this.downAction = new UpDownLeftRightActionHandler(40);
        }
        if (this.leftAction == null) {
            this.leftAction = new UpDownLeftRightActionHandler(37);
        }
        if (this.rightAction == null) {
            this.rightAction = new UpDownLeftRightActionHandler(39);
        }
        if (this.pageDownAction == null) {
            this.pageDownAction = new UpDownLeftRightActionHandler(34);
        }
        if (this.pageUpAction == null) {
            this.pageUpAction = new UpDownLeftRightActionHandler(33);
        }
        if (this.ctrlPageDownAction == null) {
            this.ctrlPageDownAction = new UpDownLeftRightActionHandler(2);
        }
        if (this.ctrlPageUpAction == null) {
            this.ctrlPageUpAction = new UpDownLeftRightActionHandler(0);
        }
        InputMap inputMap = this.getInputMap();
        String upOprtStr = "upoprtdate";
        String downOprtStr = "downoprtdate";
        String leftOprtStr = "leftoprtdate";
        String rightOprtStr = "rightoprtdate";
        String pageDownStr = "pageDownStr";
        String pageUpStr = "pageUpStr";
        String ctrlPageDownStr = "ctrlPageDownStr";
        String ctrlPageUpStr = "ctrlPageUpStr";
        inputMap.put(KeyStroke.getKeyStroke(38, 0), upOprtStr);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), downOprtStr);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), leftOprtStr);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), rightOprtStr);
        inputMap.put(KeyStroke.getKeyStroke(34, 0), pageDownStr);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), pageUpStr);
        inputMap.put(KeyStroke.getKeyStroke(34, 2), ctrlPageDownStr);
        inputMap.put(KeyStroke.getKeyStroke(33, 2), ctrlPageUpStr);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(upOprtStr, this.upAction);
        actionMap.put(downOprtStr, this.downAction);
        actionMap.put(leftOprtStr, this.leftAction);
        actionMap.put(rightOprtStr, this.rightAction);
        actionMap.put(pageDownStr, this.pageDownAction);
        actionMap.put(pageUpStr, this.pageUpAction);
        actionMap.put(ctrlPageDownStr, this.ctrlPageDownAction);
        actionMap.put(ctrlPageUpStr, this.ctrlPageUpAction);
    }

    private InputMap getInputMap() {
        return this.c.getInputMap(1);
    }

    private ActionMap getActionMap() {
        return this.c.getActionMap();
    }

    protected void calculateDayInfo(Integer year, Integer month) {
        if (year == null) {
            year = (Integer)this.yearSpinner.getValue();
        }
        if (month == null) {
            int tempInt = 1;
            try {
                tempInt = Integer.parseInt((String)this.monthCombo.getSelectedItem());
            }
            catch (Exception exception) {
                // empty catch block
            }
            month = new Integer(tempInt - 1);
        }
        GregorianCalendar calendar = new GregorianCalendar(year, month, 1);
        calendar.setLenient(false);
        int day_of_week = calendar.get(7);
        int days = this.getDaysOfMonth(year, month + 1);
        int preDays = 0;
        preDays = month == 0 ? this.getDaysOfMonth(year - 1, 12) : this.getDaysOfMonth(year, month);
        this.selectedMonth = month + 1;
        this.selectedWeek = !this.isSundayFirst() ? (day_of_week == 1 ? 6 : day_of_week - 2) : day_of_week - 1;
        this.selectedYear = year;
        this.calendar.set(1, this.selectedYear);
        this.calendar.set(2, month);
        if (this.dayRectInfo == null) {
            this.dayRectInfo = new DayRectInfo();
        }
        this.dayRectInfo.calcutateRect(this.dayAreaInnerDim.width, this.dayAreaInnerDim.height);
        this.dayRectInfo.calculateDay(this.selectedWeek, days, preDays);
        if (this.selectedDay > days) {
            this.selectedDay = days;
        }
        this.c.repaint();
    }

    private int getDaysOfMonth(int y, int m) {
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        if (m == 2) {
            GregorianCalendar gc = new GregorianCalendar(y, m, 1);
            if (gc.isLeapYear(y)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    protected void doButtonAction(int type, ActionEvent e) {
        switch (type) {
            case 0: {
                if (this.nullBox.isSelected()) {
                    this.c.getModel().setEmptyValue(true);
                    break;
                }
                this.c.getModel().setEmptyValue(false);
                break;
            }
            case 1: {
                this.setTodayTime();
                break;
            }
        }
    }

    private void setTodayTime() {
        Date todayValue = new Date(System.currentTimeMillis());
        this.c.setValue(todayValue);
        this.c.repaint();
        this.okButton.doClick();
    }

    public void addActionListener(ActionListener l) {
        if (this.okButton != null) {
            this.okButton.addActionListener(l);
        }
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.okButton != null) {
            this.okButton.removeActionListener(l);
        }
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(l);
        }
    }

    protected void setDecorateButtonState(boolean b) {
        if (this.okButton != null) {
            this.okButton.setVisible(b);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(b);
        }
        this.isDecorateBu = b;
    }

    protected boolean isDecorateButton() {
        return this.isDecorateBu;
    }

    public void doFocus() {
        this.focusHelper.requestFocusInWindow();
    }

    protected void setValue(int f, Date value) {
        Calendar tempC = Calendar.getInstance();
        tempC.setTime(value);
        int v = -1;
        int tempV = -1;
        switch (f) {
            case 0: {
                v = tempC.get(1);
                tempV = this.calendar.get(1);
                if (v == tempV) break;
                this.calendar.set(1, v);
                this.yearSpinner.setValue(new Integer(v));
                break;
            }
            case 1: {
                v = tempC.get(2);
                tempV = this.calendar.get(2);
                if (v == tempV) break;
                this.calendar.set(2, v);
                this.monthCombo.setSelectedItem(String.valueOf(v + 1));
                break;
            }
            case 2: {
                v = tempC.get(5);
                tempV = this.calendar.get(5);
                if (v != tempV) {
                    this.calendar.set(5, v);
                }
                if (v == this.selectedDay) break;
                this.selectedDay = v;
                break;
            }
            case 8: {
                if (this.calendar == null) {
                    this.calendar = Calendar.getInstance();
                }
                this.setValue(0, value);
                this.setValue(1, value);
                this.setValue(2, value);
                this.setValue(4, value);
                this.calendar.setTime(tempC.getTime());
                break;
            }
            default: {
                if (tempC.equals(this.calendar)) break;
                this.timeSpinner.setValue(tempC.getTime());
                this.calendar.setTime(tempC.getTime());
            }
        }
    }

    protected void setMaxDateValue(Object newMax) {
        if (!(newMax instanceof Date) && newMax != null) {
            throw new IllegalArgumentException("newMax must be java.util.Date class type.");
        }
        if (newMax != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)newMax);
            int tempInt = this.maxYearInt != null ? this.maxYearInt : -100;
            int calInt = cal.get(1);
            if (tempInt != calInt) {
                this.maxYearInt = new Integer(calInt);
                ((SpinnerNumberModel)this.yearSpinner.getModel()).setMaximum(this.maxYearInt);
            }
        } else if (this.maxYearInt != null) {
            this.maxYearInt = null;
            ((SpinnerNumberModel)this.yearSpinner.getModel()).setMaximum(this.maxYearInt);
        }
    }

    protected void setMinDateValue(Object newMin) {
        if (!(newMin instanceof Date) && newMin != null) {
            throw new IllegalArgumentException("newMax must be java.util.Date class type.");
        }
        if (newMin != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)newMin);
            int tempInt = this.minYearInt != null ? this.minYearInt : -100;
            int calInt = cal.get(1);
            if (tempInt != calInt) {
                this.minYearInt = new Integer(calInt);
                ((SpinnerNumberModel)this.yearSpinner.getModel()).setMinimum(new Integer(0));
            }
        } else if (this.minYearInt != null) {
            this.minYearInt = null;
            ((SpinnerNumberModel)this.yearSpinner.getModel()).setMinimum(new Integer(0));
        }
    }

    protected void setTimeEditorEnabled(boolean b) {
        this.isTimeEditorEnabled = b;
        if (this.timeSpinner != null) {
            this.timeSpinner.setVisible(b);
        }
    }

    protected boolean isTimeEditorEnabled() {
        return this.isTimeEditorEnabled;
    }

    protected void setNullValueEnabled(boolean b) {
        if (this.nullBox != null) {
            this.nullBox.setVisible(b);
        }
    }

    protected boolean isNullValueEnabled() {
        if (this.nullBox != null) {
            return this.nullBox.isVisible();
        }
        return false;
    }

    public void commitComfirm() {
        this.calendar.set(5, this.selectedDay);
        this.getModel().setDay(this.selectedDay);
    }

    public boolean mouseSelectedDay(int x, int y) {
        int ix = x - dayAreaX;
        int iy = y - this.dayAreaInnerY;
        boolean b = false;
        if (ix >= 0 && y >= 0 && x <= dayAreaX + this.dayAreaDim.width && y <= this.dayAreaY + this.dayAreaDim.height) {
            this.selectedIndex = this.dayRectInfo.contains(ix, iy);
            this.selectedDay = this.dayRectInfo.getDayByIndex(this.selectedIndex);
            if (this.selectedDay == -1) {
                return b;
            }
            if (this.selectedIndex < 7) {
                if (this.selectedDay > 7) {
                    Calendar cal = Calendar.getInstance();
                    int preYear = (Integer)this.yearSpinner.getValue();
                    int preMonth = Integer.parseInt((String)this.monthCombo.getSelectedItem()) - 2;
                    if (preMonth == -1) {
                        preMonth = 11;
                        --preYear;
                    }
                    cal.set(preYear, preMonth, this.selectedDay, 0, 0, 0);
                    this.getModel().setValue(cal.getTime());
                    b = true;
                } else {
                    this.calendar.set(5, this.selectedDay);
                    this.getModel().setDay(this.selectedDay);
                    b = true;
                }
            } else if (this.selectedIndex > 27) {
                if (this.selectedDay < 8) {
                    Calendar cal = Calendar.getInstance();
                    int nextYear = (Integer)this.yearSpinner.getValue();
                    int nextMonth = Integer.parseInt((String)this.monthCombo.getSelectedItem());
                    if (nextMonth == 13) {
                        nextMonth = 0;
                        ++nextYear;
                    }
                    cal.set(nextYear, nextMonth, this.selectedDay, 0, 0, 0);
                    this.getModel().setValue(cal.getTime());
                    b = true;
                } else {
                    this.calendar.set(5, this.selectedDay);
                    this.getModel().setDay(this.selectedDay);
                    b = true;
                }
            } else {
                this.calendar.set(5, this.selectedDay);
                this.getModel().setDay(this.selectedDay);
                b = true;
            }
            this.c.repaint();
        }
        return b;
    }

    public void reSetSpinnerFormat() throws ParseException {
        if (this.getModel().isMillisecondEnable()) {
            ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getFormat().applyPattern("HH:mm:ss:SSS");
            ((JFormattedTextField)this.timeSpinner.getEditor().getComponent(0)).commitEdit();
        } else {
            ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getFormat().applyPattern("HH:mm:ss");
            ((JFormattedTextField)this.timeSpinner.getEditor().getComponent(0)).commitEdit();
        }
    }

    private void logs(String info) {
        if (DEBUG) {
            SwingLogUtil.info((String)info);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        KDPopupMenu popup;

        PopupListener(KDPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class UpDownLeftRightActionHandler
    extends AbstractAction {
        private static final long serialVersionUID = -6030069074452880423L;
        int direct = -1;

        public UpDownLeftRightActionHandler(int pDirect) {
            this.direct = pDirect;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            switch (this.direct) {
                case 38: {
                    this.upOprt();
                    break;
                }
                case 40: {
                    this.downOprt();
                    break;
                }
                case 37: {
                    this.leftOprt();
                    break;
                }
                case 39: {
                    this.rightOprt();
                    break;
                }
                case 34: {
                    this.pageDownOprt();
                    break;
                }
                case 33: {
                    this.pageUpOprt();
                    break;
                }
                case 2: {
                    this.ctrlPageDownOprt();
                    break;
                }
                case 0: {
                    this.ctrlPageUpOprt();
                    break;
                }
                default: {
                    SwingLogUtil.info((String)"default ");
                }
            }
        }

        private void pageDownOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(2, 1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("page Down oprt");
        }

        private void pageUpOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(2, -1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("page Up oprt");
        }

        private void ctrlPageDownOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(1, 1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("ctrl page Down oprt");
        }

        private void ctrlPageUpOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(1, -1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("ctrl page Up oprt");
        }

        private void upOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(6, -7);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("up oprt");
        }

        private void downOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(6, 7);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("down oprt");
        }

        private void leftOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(6, -1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("left oprt");
        }

        private void rightOprt() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KingdeeDatePickerDownListUI.this.c.getModel().getValue());
            calendar.add(6, 1);
            KingdeeDatePickerDownListUI.this.selectedDay = calendar.get(5);
            KingdeeDatePickerDownListUI.this.c.getModel().setValue(calendar.getTime());
            KingdeeDatePickerDownListUI.this.c.repaint();
            KingdeeDatePickerDownListUI.this.logs("right oprt");
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            dayFocused = true;
            KingdeeDatePickerDownListUI.this.c.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            dayFocused = false;
            KingdeeDatePickerDownListUI.this.c.repaint();
        }
    }

    private class EditorDataChangeListener
    implements DataChangeListener {
        private EditorDataChangeListener() {
        }

        @Override
        public void dataChanged(DataChangeEvent e) {
            Object obj = e.getNewValue();
            if (obj instanceof Date) {
                int field = -1;
                if (e instanceof DateTimeValueChangeEvent) {
                    field = ((DateTimeValueChangeEvent)e).getFieldType();
                }
                KingdeeDatePickerDownListUI.this.setValue(field, (Date)obj);
            }
        }
    }

    private class TimeChangeListener
    implements ChangeListener {
        private TimeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner sp = (JSpinner)e.getSource();
            Date d = (Date)sp.getValue();
            Calendar tempCa = Calendar.getInstance();
            tempCa.setTime(d);
            KingdeeDatePickerDownListUI.this.calendar.set(11, tempCa.get(11));
            KingdeeDatePickerDownListUI.this.calendar.set(12, tempCa.get(12));
            KingdeeDatePickerDownListUI.this.calendar.set(13, tempCa.get(13));
            KingdeeDatePickerDownListUI.this.calendar.set(14, tempCa.get(14));
            KingdeeDatePickerDownListUI.this.getModel().setValue(KingdeeDatePickerDownListUI.this.calendar.getTime());
            tempCa = null;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() != 16) {
                return;
            }
            KingdeeDatePickerDownListUI.this.focusHelper.requestFocusInWindow();
            int x = e.getX();
            int y = e.getY();
            KingdeeDatePickerDownListUI.this.mouseSelectedDay(x, y);
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private int type = -1;

        public ButtonHandler(int ty) {
            this.type = ty;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KingdeeDatePickerDownListUI.this.doButtonAction(this.type, e);
        }
    }

    private class DLPropertyChangeListener
    implements PropertyChangeListener {
        private DLPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object v = e.getNewValue();
            if (name.equals("isDecorateButton")) {
                KingdeeDatePickerDownListUI.this.setDecorateButtonState((Boolean)v);
                KingdeeDatePickerDownListUI.this.c.repaint();
            } else if (name.equals("timeEditorEnabled")) {
                KingdeeDatePickerDownListUI.this.setTimeEditorEnabled((Boolean)v);
            } else if (name.equals("nullValueEnabled")) {
                KingdeeDatePickerDownListUI.this.setNullValueEnabled((Boolean)v);
            } else if (name.equals("minDateValue")) {
                KingdeeDatePickerDownListUI.this.setMinDateValue(v);
            } else if (name.equals("maxDateValue")) {
                KingdeeDatePickerDownListUI.this.setMaxDateValue(v);
            }
        }
    }

    private class DayRectInfo
    implements Serializable {
        private static final long serialVersionUID = -4869638959043910458L;
        private Rectangle[] rectArray = null;
        private String[] dayArray = null;
        private int w = -1;
        private int h = -1;
        private int week = -1;
        private int days = -1;
        private int preDays = -1;
        private int[] negPlusIndex = new int[42];

        public DayRectInfo() {
            this(-1, -1);
        }

        public DayRectInfo(int w, int h) {
            this.rectArray = new Rectangle[42];
            this.dayArray = new String[42];
            for (int i = 0; i < 42; ++i) {
                this.negPlusIndex[i] = 0;
            }
            if (w > 0 && h > 0) {
                this.calcutateRect(w, h);
            }
        }

        public Rectangle getRect(int index) {
            if (index < 0 || index > 42) {
                return null;
            }
            return this.rectArray[index];
        }

        public int getIndexByDay(int day) {
            int len = this.dayArray.length;
            if (len < 0 || len > 42) {
                return -1;
            }
            for (int i = 0; i < 42; ++i) {
                String str = this.dayArray[i];
                if (!str.equals(String.valueOf(day)) || this.negPlusIndex[i] < 0) continue;
                return i;
            }
            return -1;
        }

        public int getDayByIndex(int index) {
            String days = this.getText(index);
            try {
                return Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public String getText(int index) {
            if (index < 0 || index > 42) {
                return "E";
            }
            return this.dayArray[index];
        }

        public Color getColor(int index) {
            if (index < 0 || index > 42) {
                return Color.red;
            }
            if (this.negPlusIndex[index] == -1) {
                return KingdeeDatePickerDownListUI.this.otherDayTextColor;
            }
            return Color.black;
        }

        public boolean isTheMoth(int index) {
            if (index < 0 || index > 42) {
                return false;
            }
            return this.negPlusIndex[index] != -1;
        }

        public int toRight(int index) {
            if (index == 41) {
                return index;
            }
            return index + 1;
        }

        public int toLeft(int index) {
            if (index == 0) {
                return index;
            }
            return index - 1;
        }

        public int toBottom(int index) {
            if ((index += 7) > 41) {
                return index - 7;
            }
            return index;
        }

        public int toTop(int index) {
            if ((index -= 7) < 0) {
                return index + 7;
            }
            return index;
        }

        public boolean isNow(int index) {
            if (index < 0 || index > 42) {
                return false;
            }
            return this.negPlusIndex[index] != -1;
        }

        public int contains(int x, int y) {
            if (this.rectArray.length != 42) {
                return -1;
            }
            int tempIndex = -1;
            for (int i = 0; i < 42; ++i) {
                int tx = this.rectArray[i].x;
                int ty = this.rectArray[i].y;
                int tw = this.rectArray[i].width;
                int th = this.rectArray[i].height;
                if (x < tx || x >= tx + tw || y < ty || y >= ty + th) continue;
                tempIndex = i;
                break;
            }
            return tempIndex;
        }

        public Rectangle getRectangle(int index) {
            int len = this.rectArray.length;
            if (len != 42 || index < 0 || index >= 42 || !this.isNow(index)) {
                return null;
            }
            return this.rectArray[index];
        }

        public Rectangle getRectangle(int x, int y) {
            int index = this.contains(x, y);
            if (index == -1) {
                return null;
            }
            return this.getRectangle(index);
        }

        public void calcutateRect(int w, int h) {
            if (this.w == w && this.h == h) {
                return;
            }
            this.w = w;
            this.h = h;
            int cellWidth = w / 7;
            int cellHeight = h / 6;
            for (int row = 0; row <= 5; ++row) {
                for (int column = 0; column <= 6; ++column) {
                    int x = column * cellWidth;
                    int y = row * cellHeight;
                    this.rectArray[row * 7 + column] = new Rectangle(x, y, cellWidth, cellHeight);
                }
            }
        }

        public void calculateDay(int week, int days, int preDays) {
            if (week < 0 || days < 28 || days > 31 || preDays < 28 || preDays > 31) {
                StringBuffer sb = new StringBuffer();
                sb.append("argument is illegal:(week=").append(week).append(",days=").append(days).append(",preDays=").append(preDays).append(").");
                throw new IllegalArgumentException(sb.toString());
            }
            if (this.week == week && this.days == days && this.preDays == preDays) {
                return;
            }
            this.week = week;
            this.days = days;
            this.preDays = preDays;
            for (int i = week - 1; i >= 0; --i) {
                this.dayArray[i] = String.valueOf(preDays);
                this.negPlusIndex[i] = -1;
                --preDays;
            }
            int dayIndex = 1;
            boolean endB = false;
            int endRow = 10;
            for (int row = 0; row <= 5; ++row) {
                for (int column = 0; column <= 6; ++column) {
                    if (row == 0) {
                        if (column < week) continue;
                        this.dayArray[column] = String.valueOf(dayIndex);
                        this.negPlusIndex[column] = 1;
                        ++dayIndex;
                        continue;
                    }
                    if (dayIndex > days) {
                        dayIndex = 1;
                        endB = true;
                        endRow = row;
                        if (column == 0) {
                            --endRow;
                        }
                    }
                    this.negPlusIndex[row * 7 + column] = endB ? -1 : 1;
                    this.dayArray[row * 7 + column] = endRow < row ? "" : String.valueOf(dayIndex);
                    ++dayIndex;
                }
            }
        }
    }

    private class YearMonthChangeListener
    implements ChangeListener,
    ItemListener {
        private YearMonthChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object value;
            Object obj = e.getSource();
            if (obj != null && obj instanceof JSpinner && (value = ((JSpinner)obj).getValue()) instanceof Integer) {
                this.valueChange((Integer)value, null);
                KingdeeDatePickerDownListUI.this.getModel().setYear((Integer)value);
                KingdeeDatePickerDownListUI.this.getModel().setMonth(Integer.parseInt((String)KingdeeDatePickerDownListUI.this.monthCombo.getModel().getSelectedItem()) - 1);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj;
            int t = e.getStateChange();
            if (t == 1 && (obj = e.getSource()) != null && obj instanceof JComboBox) {
                Integer val = Integer.valueOf(((JComboBox)obj).getSelectedItem().toString());
                this.valueChange(null, new Integer(val - 1));
                KingdeeDatePickerDownListUI.this.calendar.set(5, KingdeeDatePickerDownListUI.this.selectedDay);
                KingdeeDatePickerDownListUI.this.calendar.set(2, val - 1);
                KingdeeDatePickerDownListUI.this.getModel().setDay(KingdeeDatePickerDownListUI.this.selectedDay);
                KingdeeDatePickerDownListUI.this.getModel().setMonth(val - 1);
            }
        }

        private void valueChange(Integer year, Integer month) {
            KingdeeDatePickerDownListUI.this.calculateDayInfo(year, month);
        }
    }

    class DownLayout
    implements LayoutManager {
        private Component yearC = null;
        private Component monthC = null;
        private Component timeC = null;
        private Component checkC = null;
        private Component okBu = null;
        private Component cancelBu = null;
        private Component todayBu = null;
        private Component thisDay = null;
        private Component focusHelper = null;

        DownLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("year")) {
                this.yearC = comp;
                return;
            }
            if (name.equals("month")) {
                this.monthC = comp;
                return;
            }
            if (name.equals("time")) {
                this.timeC = comp;
                return;
            }
            if (name.equals("nullvalue")) {
                this.checkC = comp;
                return;
            }
            if (name.equals("ok")) {
                this.okBu = comp;
                return;
            }
            if (name.equals("cancel")) {
                this.cancelBu = comp;
                return;
            }
            if (name.equals("today")) {
                this.todayBu = comp;
                return;
            }
            if (name.equals("thisDay")) {
                this.thisDay = comp;
                return;
            }
            if (name.equals("focusHelper")) {
                this.focusHelper = comp;
                return;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroDim : c.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            if (count <= 0) {
                return;
            }
            boolean isUndecorateBu = KingdeeDatePickerDownListUI.this.isDecorateButton();
            boolean isTimeEnabled = KingdeeDatePickerDownListUI.this.isTimeEditorEnabled();
            Dimension parentPreDim = compPreferredSize;
            Dimension yearDim = this.preferredSize(this.yearC);
            Dimension monthDim = this.preferredSize(this.monthC);
            Dimension timeDim = this.preferredSize(this.timeC);
            Dimension nullDim = this.preferredSize(this.checkC);
            Dimension okDim = this.preferredSize(this.okBu);
            Dimension cancelDim = this.preferredSize(this.cancelBu);
            Dimension todayDim = this.preferredSize(this.todayBu);
            Dimension thisDayDim = this.preferredSize(this.thisDay);
            Point yearP = new Point();
            yearP.x = insets.left;
            yearP.y = insets.top;
            Point monthP = new Point();
            monthP.x = yearP.x + yearDim.width + columnInterval;
            monthP.y = insets.top;
            Point timeP = new Point();
            timeP.x = monthP.x + monthDim.width + columnInterval;
            timeP.y = insets.top;
            Point nullP = new Point();
            nullP.x = parentPreDim.width - insets.right - nullDim.width;
            nullP.y = insets.top;
            Point cancelP = new Point();
            cancelP.x = parentPreDim.width - insets.right - cancelDim.width;
            cancelP.y = parentPreDim.height - insets.bottom - cancelDim.height;
            Point okP = new Point();
            okP.x = cancelP.x - columnInterval - okDim.width;
            okP.y = cancelP.y;
            Point todayP = new Point();
            todayP.x = insets.left;
            todayP.y = cancelP.y;
            dayAreaX = yearP.x;
            KingdeeDatePickerDownListUI.this.dayAreaY = yearP.y + yearDim.height + rowInterval;
            Rectangle yearRec = new Rectangle(yearP.x, yearP.y, yearDim.width, yearDim.height);
            Rectangle monthRec = new Rectangle(monthP.x, monthP.y, monthDim.width, monthDim.height);
            Rectangle timeRec = new Rectangle(timeP.x, timeP.y, timeDim.width, timeDim.height);
            Rectangle nullRec = new Rectangle(nullP.x, nullP.y, nullDim.width, nullDim.height);
            Rectangle cancelRec = new Rectangle(cancelP.x, cancelP.y, cancelDim.width, cancelDim.height);
            Rectangle okRec = new Rectangle(okP.x, okP.y, okDim.width, okDim.height);
            this.yearC.setBounds(yearRec.x, yearRec.y, yearRec.width, yearRec.height);
            this.monthC.setBounds(monthRec.x, monthRec.y, monthRec.width, monthRec.height);
            this.focusHelper.setBounds(0, 0, 1, 1);
            if (isTimeEnabled) {
                this.timeC.setBounds(timeRec.x, timeRec.y, timeRec.width, timeRec.height);
            }
            if (this.checkC != null && this.checkC.isVisible()) {
                this.checkC.setBounds(nullRec.x, nullRec.y, nullRec.width, nullRec.height);
            }
            if (isUndecorateBu) {
                this.okBu.setBounds(okRec.x, okRec.y, okRec.width, okRec.height);
                this.cancelBu.setBounds(cancelRec.x, cancelRec.y, cancelRec.width, cancelRec.height);
                this.todayBu.setBounds(todayP.x, todayP.y, todayDim.width, todayDim.height);
                this.thisDay.setBounds(todayP.x + todayDim.width + 2, todayP.y + 2, thisDayDim.width, thisDayDim.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.yearC) {
                this.yearC = null;
                return;
            }
            if (comp == this.monthC) {
                this.monthC = null;
                return;
            }
            if (comp == this.timeC) {
                this.timeC = null;
                return;
            }
            if (comp == this.checkC) {
                this.checkC = null;
                return;
            }
            if (comp == this.cancelBu) {
                this.cancelBu = null;
                return;
            }
            if (comp == this.okBu) {
                this.okBu = null;
                return;
            }
            if (comp == this.todayBu) {
                this.todayBu = null;
                return;
            }
        }
    }
}

