/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.plaf.ImageArrowButton;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.InternationalFormatter;

public class KingdeeSpinnerUI
extends BasicSpinnerUI {
    private static ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private boolean required = false;
    private PropertyChangeHandler proListener;
    private JComponent editor;
    private JFormattedTextField tf;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeSpinnerUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.configEditor();
        Color customBackground = this.spinner instanceof KDSpinner ? ((KDSpinner)this.spinner).getCustomBackground() : this.spinner.getBackground();
        if (this.spinner.isEnabled()) {
            this.editor.setOpaque(false);
            this.tf.setOpaque(false);
            if (this.tf.isEditable()) {
                if (this.required) {
                    this.tf.setForeground(UIManager.getColor("TextField.requiredForeground"));
                    if (customBackground != null) {
                        this.spinner.setBackground(customBackground);
                    } else {
                        this.spinner.setBackground(UIManager.getColor("TextField.requiredBackground"));
                    }
                } else if (this.spinner instanceof KDSpinner && ((KDSpinner)this.spinner).getAccessAuthority() != 0) {
                    this.tf.setForeground(UIManager.getColor("TextField.readonlyForeground"));
                    if (customBackground != null) {
                        this.spinner.setBackground(customBackground);
                    } else {
                        this.spinner.setBackground(UIManager.getColor("TextField.readonlyBackground"));
                    }
                } else {
                    this.tf.setForeground(UIManager.getColor("TextField.foreground"));
                    if (customBackground != null) {
                        this.spinner.setBackground(customBackground);
                    } else {
                        this.spinner.setBackground(UIManager.getColor("TextField.background"));
                    }
                }
            } else {
                if (this.spinner instanceof KDSpinner && ((KDSpinner)this.spinner).getAccessAuthority() == 0) {
                    this.tf.setForeground(UIManager.getColor("TextField.foreground"));
                }
                if (customBackground != null) {
                    this.spinner.setBackground(customBackground);
                } else {
                    this.spinner.setBackground(UIManager.getColor("TextField.background"));
                }
            }
        } else {
            this.tf.setForeground(UIManager.getColor("TextField.disableForeground"));
            if (customBackground != null) {
                this.editor.setOpaque(false);
                this.tf.setOpaque(false);
                this.spinner.setBackground(customBackground);
            } else {
                this.spinner.setBackground(UIManager.getColor("TextField.disableBackground"));
            }
        }
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this.proListener == null) {
            this.proListener = new PropertyChangeHandler();
        }
        this.spinner.addPropertyChangeListener(this.proListener);
    }

    @Override
    public void uninstallListeners() {
        if (this.proListener != null) {
            this.spinner.removePropertyChangeListener(this.proListener);
        }
        this.tf.removeFocusListener(nextButtonHandler);
        this.tf.removeFocusListener(previousButtonHandler);
        super.uninstallListeners();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.spinner.setBackground(Color.decode("#E7EDF2"));
        this.editor = this.spinner.getEditor();
        this.tf = ((JSpinner.DefaultEditor)this.editor).getTextField();
        this.tf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.tf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
        this.tf.addFocusListener(nextButtonHandler);
        this.tf.addFocusListener(previousButtonHandler);
    }

    private void configEditor() {
        JComponent comp = this.spinner.getEditor();
        if (this.editor == comp) {
            return;
        }
        this.editor = comp;
        this.tf = ((JSpinner.DefaultEditor)this.editor).getTextField();
        this.tf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.tf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
        this.tf.addFocusListener(nextButtonHandler);
        this.tf.addFocusListener(previousButtonHandler);
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    @Override
    protected Component createNextButton() {
        SpinnerArrowButton b = new SpinnerArrowButton(1, this.spinner);
        b.addActionListener(nextButtonHandler);
        b.addMouseListener(nextButtonHandler);
        b.setFocusable(false);
        return b;
    }

    @Override
    protected Component createPreviousButton() {
        SpinnerArrowButton b = new SpinnerArrowButton(5, this.spinner);
        b.addActionListener(previousButtonHandler);
        b.addMouseListener(previousButtonHandler);
        b.setFocusable(false);
        return b;
    }

    protected static class SpinnerFocusListener
    implements FocusListener {
        protected SpinnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("required") && evt.getNewValue() != evt.getOldValue()) {
                KingdeeSpinnerUI.this.required = (Boolean)evt.getNewValue();
            }
        }
    }

    static class SpinnerArrowButton
    extends ImageArrowButton {
        private JSpinner spinner;
        private static final long serialVersionUID = -208608088310862532L;
        private boolean isRollover = false;

        public SpinnerArrowButton(int direction, JSpinner spinner) {
            super(direction);
            this.spinner = spinner;
        }

        private void setRollover(boolean rollover) {
            if (this.isRollover == rollover) {
                return;
            }
            this.isRollover = rollover;
            this.repaint();
        }

        @Override
        public void paintTriangle(Graphics g, int x, int y, boolean isEnabled) {
            Image arrowNorth = ((ImageIcon)UIManager.get("ImageArrowButton.northIcon")).getImage();
            Image arrowSouth = ((ImageIcon)UIManager.get("ImageArrowButton.southIcon")).getImage();
            Image arrowWest = ((ImageIcon)UIManager.get("ImageArrowButton.westIcon")).getImage();
            Image arrowNorth2 = ((ImageIcon)UIManager.get("ImageArrowButton.northIcon2")).getImage();
            Image arrowSouth2 = ((ImageIcon)UIManager.get("ImageArrowButton.southIcon2")).getImage();
            Image arrowWest2 = ((ImageIcon)UIManager.get("ImageArrowButton.westIcon2")).getImage();
            int access = -1;
            if (this.spinner instanceof KDSpinner) {
                access = ((KDSpinner)this.spinner).getAccessAuthority();
            }
            Image arrowNorthDisable = ((ImageIcon)UIManager.get("ImageArrowButton.disableNorthIcon")).getImage();
            Image arrowSouthDisable = ((ImageIcon)UIManager.get("ImageArrowButton.disableSouthIcon")).getImage();
            Image triangle = arrowNorth;
            switch (this.direction) {
                case 1: {
                    if (access == 1) {
                        triangle = arrowNorthDisable;
                        break;
                    }
                    if (isEnabled) {
                        triangle = this.isRollover ? arrowNorth2 : arrowNorth;
                        break;
                    }
                    triangle = arrowNorthDisable;
                    break;
                }
                case 5: {
                    if (access == 1) {
                        triangle = arrowSouthDisable;
                        break;
                    }
                    if (isEnabled) {
                        triangle = this.isRollover ? arrowSouth2 : arrowSouth;
                        break;
                    }
                    triangle = arrowSouthDisable;
                    break;
                }
                case 7: {
                    triangle = this.isRollover ? arrowWest2 : arrowWest;
                }
            }
            g.drawImage(triangle, x, y, this);
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = this.isEnabled();
            g.setColor(Color.WHITE);
            g.fillRect(1, 1, w - 2, h - 2);
            if (isPressed) {
                g.translate(1, 1);
            }
            this.paintTriangle(g, 0, 0, isEnabled);
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                c = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            Dimension zeroSize = new Dimension(0, 0);
            return c == null ? zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = null;
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int nextY = buttonInsets.top;
            int nextHeight = (height + 1) / 2 - nextY;
            int previousY = buttonInsets.top + nextHeight + 1;
            int previousHeight = height - previousY - buttonInsets.bottom;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    FocusListener {
        private static final long serialVersionUID = -484253509241984451L;
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSpinner spinner = this.spinner;
            if (!(e.getSource() instanceof Timer)) {
                spinner = this.eventToSpinner(e);
            }
            if (spinner != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(spinner);
                    spinner.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)spinner.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? spinner.getNextValue() : spinner.getPreviousValue();
                    if (value != null) {
                        spinner.setValue(value);
                        this.select(spinner);
                    }
                }
                catch (IllegalArgumentException iae) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
                catch (ParseException pe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
            }
        }

        private void select(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    for (int counter = 0; counter < fields.length; ++counter) {
                        int calendarField;
                        if (!(fields[counter] instanceof DateFormat.Field) || (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) == -1) continue;
                        return calendarField;
                    }
                }
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
            }
            this.spinner = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SpinnerArrowButton arrowButton = (SpinnerArrowButton)e.getSource();
            arrowButton.setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SpinnerArrowButton arrowButton = (SpinnerArrowButton)e.getSource();
            arrowButton.setRollover(false);
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
            }
        }
    }
}

