/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class MultiLangAreaEditor
implements ComboBoxEditor,
FocusListener {
    protected KDTextAreaCtrl editor;
    private Object oldValue;
    private DocumentListener change = new ChangeHandler();
    protected EventListenerList eventlist = new EventListenerList();

    public MultiLangAreaEditor() {
        this.editor = new BorderlessTextArea();
        Document doc = this.editor.getDocument();
        doc.addDocumentListener(this.change);
    }

    @Override
    public Component getEditorComponent() {
        return this.editor;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.editor.setText(anObject.toString());
            this.oldValue = anObject;
        } else {
            this.editor.setText("");
        }
    }

    @Override
    public Object getItem() {
        Object newValue = this.editor.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> cls = this.oldValue.getClass();
            try {
                Method method = cls.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.editor.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newValue;
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void addActionListener(ActionListener l) {
    }

    @Override
    public void removeActionListener(ActionListener l) {
    }

    public boolean hasFocus() {
        return this.editor.hasFocus();
    }

    public void addFocusListener(FocusListener l) {
        this.editor.getTextComponent().addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.editor.getTextComponent().removeFocusListener(l);
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.eventlist.add(DataChangeListener.class, l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.eventlist.remove(DataChangeListener.class, l);
    }

    protected void fireChange() {
        DataChangeEvent changeEvent = null;
        Object[] listeners = this.eventlist.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new DataChangeEvent(this, this.editor.getText(), null);
            }
            ((DataChangeListener)listeners[i + 1]).dataChanged(changeEvent);
        }
    }

    protected class ChangeHandler
    implements DocumentListener {
        protected ChangeHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MultiLangAreaEditor.this.fireChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MultiLangAreaEditor.this.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MultiLangAreaEditor.this.fireChange();
        }
    }

    public static class UIResource
    extends MultiLangAreaEditor
    implements javax.swing.plaf.UIResource {
    }

    static class MulitLangAreaEditorLayout
    extends ScrollPaneLayout {
        private static final long serialVersionUID = -7268256019590544976L;

        MulitLangAreaEditorLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            Rectangle vsbR = null;
            if (this.vsb != null) {
                vsbR = this.vsb.getBounds();
                Rectangle upperRightR = new Rectangle(vsbR.x, vsbR.y, vsbR.width, vsbR.width);
                if (this.upperRight != null) {
                    this.upperRight.setBounds(upperRightR);
                }
                vsbR.y += vsbR.width;
                vsbR.height -= vsbR.width;
                this.vsb.setBounds(vsbR);
            }
        }
    }

    static class BorderlessTextArea
    extends KDTextAreaCtrl {
        private static final long serialVersionUID = -4730637508045008413L;

        public BorderlessTextArea() {
            super(4);
            this.setBorder(null);
            this.setLayout(new MulitLangAreaEditorLayout());
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
        }
    }
}

