/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class SpecialBorder {

    public class CtrlToggleButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -310505084064174720L;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color old = g.getColor();
            g.setColor(old);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class CircularBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3907505436706407360L;
        Color colLine = UIManager.getColor("Panel.background");
        int len = 8;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color old = g.getColor();
            g.setColor(this.colLine);
            g.fillRect(0, 0, 8, 8);
            g.setColor(Color.decode("#EAF2ED"));
            g.fillArc(0, 0, 16, 16, 90, 90);
            g.setColor(Color.decode("#B4B4AB"));
            g.drawArc(0, 0, 16, 16, 90, 90);
            g.setColor(this.colLine);
            g.fillRect(0, h - this.len, 8, 8);
            g.setColor(Color.white);
            g.fillArc(0, h - 2 * this.len - 1, 16, 16, 180, 90);
            g.setColor(Color.decode("#B4B4AB"));
            g.drawArc(0, h - 2 * this.len - 1, 16, 16, 180, 90);
            g.setColor(Color.decode("#B4B4AB"));
            g.drawLine(x + this.len, 0, w - 1, 0);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(this.len - 1, h - 1, w - 1, h - 1);
            g.setColor(old);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class AroundLineBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -8942311455093768963L;
        public static final int LINE_TOP = 1;
        public static final int LINE_BOTTOM = 2;
        public static final int LINE_LEFT = 4;
        public static final int LINE_RIGHT = 8;
        private int linePosition = 3;
        private Color colTop = null;
        private Color colBottom = null;
        private Color colLeft = null;
        private Color colRight = null;

        public AroundLineBorder() {
            this(0, Color.decode("#B4B4AB"), Color.decode("#B4B4AB"), Color.decode("#FFFFFF"), Color.decode("#FFFFFF"));
        }

        public AroundLineBorder(int pPosition) {
            this(pPosition, Color.decode("#B4B4AB"), Color.decode("#B4B4AB"), Color.decode("#FFFFFF"), Color.decode("#FFFFFF"));
        }

        public AroundLineBorder(int pPosition, Color pColTop, Color pColBottom, Color pColLeft, Color pColRight) {
            this.linePosition = pPosition;
            this.colTop = pColTop;
            this.colBottom = pColBottom;
            this.colLeft = pColLeft;
            this.colRight = pColRight;
        }

        public void setLinePosition(int pPosition) {
            this.linePosition = pPosition;
        }

        public void setRightColor(Color pCol) {
            if (pCol != null) {
                this.colRight = pCol;
            }
        }

        public void setLeftColor(Color pCol) {
            if (pCol != null) {
                this.colLeft = pCol;
            }
        }

        public void setTopColor(Color pCol) {
            if (pCol != null) {
                this.colTop = pCol;
            }
        }

        public void setBottomColor(Color pCol) {
            if (pCol != null) {
                this.colBottom = pCol;
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color old = g.getColor();
            switch (this.linePosition) {
                case 1: {
                    g.setColor(this.colTop);
                    g.drawLine(x, y, w - 1, x);
                    break;
                }
                case 2: {
                    g.setColor(this.colBottom);
                    g.drawLine(x, h - 1, w - 1, h - 1);
                    break;
                }
                case 4: {
                    g.setColor(this.colLeft);
                    g.drawLine(x, y, x, h - 1);
                    break;
                }
                case 8: {
                    g.setColor(this.colRight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    break;
                }
                case 3: {
                    g.setColor(this.colTop);
                    g.drawLine(x, y, w - 1, x);
                    g.setColor(this.colBottom);
                    g.drawLine(x, h - 1, w - 1, h - 1);
                    break;
                }
                case 5: {
                    g.setColor(this.colTop);
                    g.drawLine(x, y, w - 1, x);
                    g.setColor(this.colLeft);
                    g.drawLine(x, y, x, h - 1);
                    break;
                }
                case 9: {
                    g.setColor(this.colTop);
                    g.drawLine(x, y, w - 1, x);
                    g.setColor(this.colRight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    break;
                }
                case 6: {
                    g.setColor(this.colBottom);
                    g.drawLine(x, h - 1, w - 1, h - 1);
                    g.setColor(this.colLeft);
                    g.drawLine(x, y, x, h - 1);
                    break;
                }
                case 10: {
                    g.setColor(this.colBottom);
                    g.drawLine(x, h - 1, w - 1, h - 1);
                    g.setColor(this.colRight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    break;
                }
                case 12: {
                    g.setColor(this.colLeft);
                    g.drawLine(x, y, x, h - 1);
                    g.setColor(this.colRight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    break;
                }
                default: {
                    g.setColor(this.colTop);
                    g.drawLine(0, 0, w - 1, 0);
                    g.setColor(this.colBottom);
                    g.drawLine(0, h - 1, w - 1, h - 1);
                    g.setColor(this.colLeft);
                    g.drawLine(0, 0, 0, h - 1);
                    g.setColor(this.colRight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                }
            }
            g.setColor(old);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class RemainderLineBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 6826746836819282210L;
        Color colLine = Color.decode("#B4B4AB");

        public RemainderLineBorder() {
        }

        public RemainderLineBorder(Color pCol) {
            this.colLine = pCol;
        }

        public void setLineColor(Color pCol) {
            if (pCol != null) {
                this.colLine = pCol;
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color old = g.getColor();
            if (c instanceof JList) {
                JList list = (JList)c;
                Insets insets = list.getInsets();
                int vC = list.getModel().getSize();
                int y0 = vC * list.getFixedCellHeight() + insets.top;
                g.setColor(this.colLine);
                g.drawLine(w - 1, y0, w - 1, h - 1);
                g.setColor(old);
            } else {
                g.setColor(this.colLine);
                g.drawLine(w - 1, 0, w - 1, h - 8);
                g.setColor(old);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 0;
            insets.bottom = 0;
            insets.left = 0;
            insets.top = 0;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }
}

