/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import javax.ejb.EJBException;

public final class BatchActionUtil {
    public static final String IGNORE_CHECKITEM = "IGNORE_CHECKITEMID_SET";

    public static int resolveActionResults(BatchActionResults batchResults, BatchExecuteResult executeResult, List selectionEntry, List todoList, ActionLevelEnum actionLevel) {
        return BatchActionUtil.resolveActionResults(null, batchResults, executeResult, selectionEntry, todoList, actionLevel);
    }

    public static int resolveActionResults(Context ctx, BatchActionResults batchResults, BatchExecuteResult executeResult, List selectionEntry, List todoList, ActionLevelEnum actionLevel) {
        int countSuccess = 0;
        Throwable[] exceptions = executeResult.getExceptions();
        int size = selectionEntry.size();
        int idxOfToDoList = -1;
        boolean isHead = actionLevel.equals(ActionLevelEnum.HEAD);
        int idxOfExp = 0;
        for (int idxOfEntry = 0; idxOfEntry < size && idxOfExp < exceptions.length; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            String key = isHead ? entry.getId() : entry.getEntryId();
            idxOfToDoList = todoList.indexOf(key);
            if (idxOfToDoList <= -1) continue;
            ActionResult result = batchResults.getActionResult(key);
            if (exceptions[idxOfExp] != null) {
                entry.setResult(ActionResultEnum.ERROR);
                entry.setResultMsg(BatchActionUtil.getExceptionMsg(ctx, exceptions[idxOfExp]));
            } else if (result != null && result.getException() != null) {
                Throwable t;
                entry.setResult(ActionResultEnum.ERROR);
                entry.setResultMsg(BatchActionUtil.getExceptionMsg(ctx, result.getException()));
                exceptions[idxOfExp] = t = BatchActionUtil.drillAException(result.getException());
                result.setException((Exception)t);
            } else if (result != null) {
                entry.setActionResult(result);
                if (result.getResult().equals(ActionResultEnum.SUCCESS)) {
                    BatchActionResults realResults;
                    String[] ids;
                    Object exeResult;
                    ++countSuccess;
                    if (key.equals("NEWID") && (exeResult = executeResult.getBatchResult()) instanceof BatchActionResults && (ids = (realResults = (BatchActionResults)exeResult).getToDoIdsArray()).length > 0) {
                        entry.setId(ids[0]);
                    }
                } else if (result.getMessage() != null) {
                    exceptions[idxOfExp] = new ActionCommonException(null, result.getMessage());
                }
            } else {
                entry.setResult(ActionResultEnum.SUCCESS);
                ++countSuccess;
                if (key.equals("NEWID")) {
                    Object[] exeResults = executeResult.getReturnValues();
                    if (exeResults.length > 0 && exeResults[0] != null) {
                        entry.setId(exeResults[0].toString());
                    } else {
                        BatchActionResults realResults;
                        String[] ids;
                        Object exeResult = executeResult.getBatchResult();
                        if (exeResult instanceof BatchActionResults && (ids = (realResults = (BatchActionResults)exeResult).getToDoIdsArray()).length > 0) {
                            entry.setId(ids[0]);
                        }
                    }
                }
            }
            ++idxOfExp;
        }
        return countSuccess;
    }

    public static String getExceptionMsg(Context ctx, Throwable exception) {
        if (exception instanceof CanNotDeleteException || exception instanceof AlreadyBindProcessInstanceException) {
            return ExceptionMessageUtility.getMessage((Throwable)exception);
        }
        if (exception instanceof ObjectNotFoundException) {
            return ResourceUtils.getMessage(ctx, "com.kingdee.eas.framework.BatchActionResource", "BILL_NOT_FOUND");
        }
        if (exception instanceof InvocationTargetException && ((InvocationTargetException)exception).getTargetException() != null && !(((InvocationTargetException)exception).getTargetException() instanceof RuntimeException)) {
            Throwable e = BatchActionUtil.drillAException(exception);
            if (e != null) {
                return ExceptionMessageUtility.getMessage((Throwable)e);
            }
            return ExceptionMessageUtility.getMessage((Throwable)((InvocationTargetException)exception).getTargetException());
        }
        if ((exception instanceof BOSException || exception instanceof InvocationTargetException) && exception.getCause() != null) {
            Throwable exp = BatchActionUtil.drillAException(exception);
            if (exp != null) {
                return ExceptionMessageUtility.getMessage((Throwable)exp);
            }
            String causeStack = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                MyPrintStream ps = new MyPrintStream(os);
                exception.printStackTrace(ps);
                causeStack = ps.toString() + " [Client -- String Serialize]";
            }
            catch (UnsupportedEncodingException e) {
                causeStack = " [Client -- String Serialize]";
            }
            return causeStack;
        }
        return ExceptionMessageUtility.getMessage((Throwable)exception);
    }

    private static Throwable drillAException(Throwable exception) {
        Throwable e;
        if (exception instanceof EASBizException) {
            return exception;
        }
        for (e = exception.getCause(); e != null && e.getCause() != null; e = e.getCause()) {
        }
        if (e instanceof EJBException) {
            e = ((EJBException)e).getCausedByException();
        }
        if (e instanceof UndeclaredThrowableException) {
            e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
        }
        if (e instanceof InvocationTargetException) {
            return BatchActionUtil.drillAException(e);
        }
        return e;
    }

    public static IObjectCollection getCollectionInstance(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo mainEO = BatchActionUtil.getEntityInfo(ctx, bosType);
        String clzCollectionName = mainEO.getObjectCollectionClassRuntime();
        try {
            Class<?> clzCollection = Class.forName(clzCollectionName);
            return (IObjectCollection)clzCollection.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        return mainEO;
    }

    private static class MyPrintStream
    extends PrintStream {
        private ByteArrayOutputStream os = null;

        public MyPrintStream(ByteArrayOutputStream os) throws UnsupportedEncodingException {
            super((OutputStream)os, false, "UTF8");
            os.reset();
            this.os = os;
        }

        private MyPrintStream() {
            super((OutputStream)null);
        }

        public String toString() {
            try {
                return this.os.toString("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }
}

