/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.client.servicebinding.IActionService;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.batch.BatchExecutor;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ForceExitException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.IBatchExecuteParamsProvide;
import com.kingdee.eas.framework.batchaction.IBatchExecutor;
import com.kingdee.eas.framework.batchaction.IPrepareRequestContext;
import com.kingdee.eas.framework.batchaction.ISupportBatchAction;
import com.kingdee.eas.framework.batchaction.ISupportObjContext;
import com.kingdee.eas.framework.batchaction.service.ActionProxyFactory;
import com.kingdee.eas.framework.batchaction.service.BatchActionManager;
import com.kingdee.eas.framework.batchaction.service.BatchExecuteParams;
import com.kingdee.eas.framework.batchaction.service.BatchExecutorFactory;
import com.kingdee.eas.framework.batchaction.service.BatchResultResolver;
import com.kingdee.eas.framework.batchaction.service.IBatchResultResolver;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.permission.PermissionServiceHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.Uuid;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class ActionProxy
extends ItemAction
implements InvocationHandler {
    private static Logger logger = Logger.getLogger(ActionProxy.class);
    static final Class[] STRING_TYPE = new Class[]{String.class};
    static final Class[] PK_TYPE = new Class[]{IObjectPK.class};
    protected ItemAction action;
    private String actionMethod;
    private ActionLevelEnum level;
    private BatchActionManager actionManager;
    private boolean isSupportObjContext = false;
    private Map serviceContext;
    private Map services;
    private Map globalServices;
    private String matchName;
    private BatchActionEnum bizAction;
    private Map typeMap = new HashMap(10);
    private ISupportBatchAction iBatch = null;
    private String actionName;
    private List buttons;
    private ActionProxy secondAction;
    private IBatchResultResolver batchResultResolver;
    protected static final String KEY_OperationDataType = "KEY_OperationDataType";

    void setSecondAction(ActionProxy secondAction) {
        this.secondAction = secondAction;
    }

    ActionProxy getSecondAction() {
        return this.secondAction;
    }

    public ActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        this(action, actionMethod, bizAction.getActionLevel(), bizAction);
    }

    List getButtons() {
        return this.buttons;
    }

    public ActionProxy(ItemAction action, String actionMethod, ActionLevelEnum level, BatchActionEnum bizAction) {
        this.action = action;
        this.actionMethod = actionMethod;
        this.level = level;
        this.bizAction = bizAction;
        this.init();
    }

    public void setActionMethod(String actionMethod) {
        this.actionMethod = actionMethod;
    }

    public BatchActionManager getActionManager() {
        return this.actionManager;
    }

    public BatchActionEnum getBizAction() {
        return this.bizAction;
    }

    protected void init() {
        if (this.action.getUIObject() instanceof ISupportObjContext) {
            this.isSupportObjContext = true;
        }
        if (this.action.getUIObject() instanceof ISupportBatchAction) {
            this.iBatch = (ISupportBatchAction)this.action.getUIObject();
        }
        this.uiObj = this.action.getUIObject();
        String clzName = this.action.getClass().getName();
        int idx = clzName.lastIndexOf(36);
        this.actionName = idx > -1 ? clzName.substring(idx + 1) : ((idx = clzName.lastIndexOf(46)) > -1 ? clzName.substring(idx + 1) : clzName);
        this.buttons = new ArrayList();
    }

    protected boolean beforeAction() {
        if ("ADDNEW".equals(this.getUIObject().getOprtState()) && !this.bizAction.equals(BatchActionEnum.SAVE) && !this.bizAction.equals(BatchActionEnum.SUBMIT)) {
            MsgBox.showWarning((String)ResourceUtils.getMessage(null, "com.kingdee.eas.framework.BatchActionResource", "SAVE_FIRST"));
            return false;
        }
        if (this.actionManager.getTableSelectionHelper().hasSelectedRows(this.level)) {
            return true;
        }
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        return false;
    }

    protected final int doAction(Context mainContext, BatchSelectionEntries selectionEntry) {
        try {
            BatchExecuteResult executeResult = null;
            BatchActionResults batchResults = null;
            try {
                if (this.doActionPerformed(selectionEntry) && selectionEntry.getToDoIdList().size() > 0) {
                    IBizCtrl iBizInterface = this.getBizInterface(mainContext);
                    BatchExecuteParams batchParams = this.getUIObject() instanceof IBatchExecuteParamsProvide ? ((IBatchExecuteParamsProvide)this.getUIObject()).provide(selectionEntry) : this.initBatchExecuteParams(iBizInterface, selectionEntry);
                    if (batchParams == null) {
                        return 0;
                    }
                    if (this.getUIObject() instanceof IPrepareRequestContext) {
                        RequestContext request = ((IPrepareRequestContext)this.getUIObject()).prepareRequestContext(this.bizAction, (IItemAction)this.action);
                        request.setUserPK((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
                        request.setUserName(SysContext.getSysContext().getUserName());
                        if (SysContext.getSysContext().getDcName() != null) {
                            request.setDcName(SysContext.getSysContext().getDcName());
                        }
                        batchParams.setRequestContext(request);
                    }
                    IBatchExecutor iBatchExecutor = this.getBatchExecutor(mainContext);
                    executeResult = iBatchExecutor.execute(batchParams);
                    batchResults = (BatchActionResults)executeResult.getBatchResult();
                }
                if (batchResults != null && this.iBatch != null && batchResults.hasException(null)) {
                    selectionEntry.setBatchResults(batchResults);
                    this.iBatch.handleBatchException(this, selectionEntry);
                }
            }
            catch (EASBizException e) {
                if (batchResults != null && this.iBatch != null) {
                    batchResults.setBizException(e);
                    selectionEntry.setBatchResults(batchResults);
                    this.iBatch.handleBatchException(this, selectionEntry);
                }
                this.handleBatchException(e, selectionEntry.getToDoIdArray());
            }
            catch (Exception e) {
                throw e;
            }
            return this.resolveResult(selectionEntry, executeResult);
        }
        catch (Exception e) {
            this.action.getUIObject().handUIException((Throwable)e);
            return 0;
        }
    }

    protected IBatchExecutor getBatchExecutor(Context mainContext) throws BOSException {
        return BatchExecutorFactory.getRemoteInstanceWithObjectContext(mainContext);
    }

    public int reDoActionPerformed(BatchSelectionEntries selectionEntry, BatchActionResults batchResults) {
        Context mainContext = null;
        if (this.isSupportObjContext) {
            mainContext = ((ISupportObjContext)this.action.getUIObject()).getMainContext();
            mainContext.put((Object)"IGNORE_CHECKITEMID_SET", (Object)batchResults.getIgnoreCheckItems());
        }
        return this.doAction(mainContext, selectionEntry);
    }

    protected void handleBatchException(EASBizException e, String[] toDoArray) throws BOSException, EASBizException, Exception {
        throw e;
    }

    protected int resolveResult(BatchSelectionEntries selectionEntry, BatchExecuteResult executeResult) throws Exception {
        for (int i = 0; executeResult != null && i < executeResult.getExceptions().length; ++i) {
            logger.info((Object)"Batch Result Exception_____", executeResult.getExceptions()[i]);
        }
        return this.getBatchResultResolver().resolveResult(this, executeResult, selectionEntry, selectionEntry.getToDoIdList());
    }

    protected int resolveResult(BatchSelectionEntries selectionEntry, BatchExecuteResult executeResult, List lockList) throws Exception {
        return this.getBatchResultResolver().resolveResult(this, executeResult, selectionEntry, this.getToDoList(selectionEntry.getEntries(), lockList));
    }

    private IBizCtrl getBizInterface(Context mainContext) throws BOSException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        Method method = null;
        boolean isObjCtx = false;
        if (this.actionManager.getClzIBizFactory(this.level) == null) {
            throw new IllegalArgumentException("The bisiness interface factory must be setted in.");
        }
        if (this.isSupportObjContext && mainContext != null) {
            try {
                method = this.actionManager.getClzIBizFactory(this.level).getMethod("getRemoteInstanceWithObjectContext", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method != null) {
            isObjCtx = true;
        } else {
            method = this.actionManager.getClzIBizFactory(this.level).getMethod("getRemoteInstance", null);
        }
        if (isObjCtx) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = mainContext;
        } else {
            objectArray = null;
        }
        IBizCtrl iBizInterface = (IBizCtrl)method.invoke(null, objectArray);
        return iBizInterface;
    }

    private List getToDoList(List selectionEntry, List lockList) {
        if (this.level.equals(ActionLevelEnum.HEAD)) {
            return lockList;
        }
        ArrayList<String> todoList = new ArrayList<String>(selectionEntry.size());
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (entry.getResult() == ActionResultEnum.ERROR) continue;
            todoList.add(entry.getEntryId());
        }
        return todoList;
    }

    protected BatchExecutor initBatchExecutor(IBizCtrl iBizInterface, List selectionEntry) {
        BatchExecutor executor;
        block3: {
            Object[] paramType;
            boolean isHead;
            block2: {
                executor = null;
                isHead = this.getLevel().equals(ActionLevelEnum.HEAD);
                paramType = this.getAppropriateParamType(iBizInterface);
                if (!Arrays.equals(paramType, PK_TYPE)) break block2;
                executor = new BatchExecutor(iBizInterface, this.actionMethod, PK_TYPE);
                int size = selectionEntry.size();
                for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                    BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
                    if (entry.getResult() == ActionResultEnum.ERROR) continue;
                    executor.newParamsEntry().add((Object)new ObjectUuidPK(BOSUuid.read((String)(isHead ? entry.getId() : entry.getEntryId()))));
                }
                break block3;
            }
            if (!Arrays.equals(paramType, STRING_TYPE)) break block3;
            executor = new BatchExecutor(iBizInterface, this.actionMethod, STRING_TYPE);
            int size = selectionEntry.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
                if (entry.getResult() == ActionResultEnum.ERROR) continue;
                executor.newParamsEntry().add((Object)(isHead ? entry.getId() : entry.getEntryId()));
            }
        }
        return executor;
    }

    protected BatchExecuteParams initBatchExecuteParams(IBizCtrl iBizInterface, BatchSelectionEntries selectionEntry) {
        BatchExecuteParams batchParams;
        block3: {
            boolean isHead;
            Object[] paramType;
            block2: {
                paramType = this.getAppropriateParamType(iBizInterface);
                isHead = this.getLevel().equals(ActionLevelEnum.HEAD);
                batchParams = new BatchExecuteParams(this.bizAction, this.actionManager.getClzIBizFactory(this.level), this.actionMethod, (Class[])paramType, selectionEntry, this.actionManager.getContextType(), iBizInterface.getType());
                if (!Arrays.equals(paramType, PK_TYPE)) break block2;
                int size = selectionEntry.size();
                for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                    BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                    if (entry.getResult() == ActionResultEnum.ERROR) continue;
                    batchParams.newParamsEntry().add((Object)new ObjectUuidPK(BOSUuid.read((String)(isHead ? entry.getId() : entry.getEntryId()))));
                }
                break block3;
            }
            if (!Arrays.equals(paramType, STRING_TYPE)) break block3;
            int size = selectionEntry.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
                if (entry.getResult() == ActionResultEnum.ERROR) continue;
                batchParams.newParamsEntry().add((Object)(isHead ? entry.getId() : entry.getEntryId()));
            }
        }
        return batchParams;
    }

    protected boolean isParamTypeHas(IBizCtrl iBizInterface, Class[] paramType) {
        if (!this.typeMap.containsKey(paramType)) {
            try {
                Method method = iBizInterface.getClass().getMethod(this.actionMethod, paramType);
                if (method != null) {
                    this.typeMap.put(paramType, true);
                    return true;
                }
                this.typeMap.put(paramType, false);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                this.typeMap.put(paramType, false);
            }
        } else {
            return (Boolean)this.typeMap.get(paramType);
        }
        return false;
    }

    protected Class[] getAppropriateParamType(IBizCtrl iBizInterface) {
        if (this.isParamTypeHas(iBizInterface, PK_TYPE)) {
            return PK_TYPE;
        }
        if (this.isParamTypeHas(iBizInterface, STRING_TYPE)) {
            return STRING_TYPE;
        }
        throw new IllegalArgumentException("You must define the interface method parameter in String or IObjectPK type.");
    }

    protected void afterAction(BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
    }

    public void setVisible(boolean newValue) {
        this.action.setVisible(newValue);
    }

    public boolean isVisible() {
        return this.action.isVisible();
    }

    public boolean isDaemonRun() {
        return this.action.isDaemonRun();
    }

    public void setDaemonRun(boolean isDaemonRun) {
        this.action.setDaemonRun(isDaemonRun);
    }

    public int getItemKind() {
        return this.action.getItemKind();
    }

    public void setItemKind(int i) {
        this.action.setItemKind(i);
    }

    public void setUIObject(IUIObject uiObj) {
        this.action.setUIObject(uiObj);
    }

    public IUIObject getUIObject() {
        return this.action.getUIObject();
    }

    public void setItemLogicKey(String logicKey) {
        this.action.setItemLogicKey(logicKey);
    }

    public String getItemLogicKey() {
        return this.action.getItemLogicKey();
    }

    public String getExtendProperty(String key) {
        return this.action.getExtendProperty(key);
    }

    public void setExtendProperty(String key, String value) {
        this.action.setExtendProperty(key, value);
    }

    public void setBindWorkFlow(boolean bindWorkFlow) {
        this.action.setBindWorkFlow(bindWorkFlow);
    }

    public boolean isBindWorkFlow() {
        return this.action.isBindWorkFlow();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.actionManager.getContextType().equals((Object)ContextTypeEnum.INMAINTAINING)) {
            ActionData data = new ActionData();
            this.doActionPerformed(e, data);
            this.refresh(data);
        } else {
            this.doInDaemon(e, this.actionName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doActionPerformed(ActionEvent e, ActionData data) {
        boolean isExcute = true;
        if (this.action == null) {
            return;
        }
        isExcute = this.action.beforeActionPerformed((CoreUIObject)this.uiObj, this.actionName, e);
        if (!isExcute) {
            return;
        }
        String actionName = this.action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        UIActionMonitor.startAction((String)this.action.getUIObject().getMetaDataPK().getFullName(), (String)actionName);
        LowTimer timer = new LowTimer();
        try {
            if (this.action.getExtendProperty("Mutex") != null) {
                Uuid uuid = Uuid.create();
                this.action.putValue("NetUuid", (Object)uuid);
            }
            if (this.beforeAction()) {
                this.processAction(e, actionName, data);
            }
        }
        finally {
            if (this.action != null && e != null) {
                this.action.finallyActionPerformed((CoreUIObject)this.uiObj, actionName, e);
            }
            this.action.putValue("NetUuid", null);
            UIActionMonitor.endAction((String)this.action.getUIObject().getMetaDataPK().getFullName(), (String)actionName, (long)timer.msValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doDameonActionPerformed(ActionEvent e, ActionData data) {
        String actionName = this.action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        UIActionMonitor.startAction((String)this.action.getUIObject().getMetaDataPK().getFullName(), (String)actionName);
        LowTimer timer = new LowTimer();
        try {
            this.processAction(e, actionName, data);
        }
        finally {
            UIActionMonitor.endAction((String)this.action.getUIObject().getMetaDataPK().getFullName(), (String)actionName, (long)timer.msValue());
        }
    }

    public void refresh(ActionData data) {
        if (data.countSuccess > 0 || ActionProxyFactory.moveActionSet.contains(this.bizAction)) {
            try {
                this.getActionManager().getTableSelectionHelper().refresh(this.bizAction, data.selectionEntry, data.countSuccess);
            }
            catch (Exception e1) {
                if (this.uiObj instanceof CoreUI) {
                    ((CoreUI)this.uiObj).handUIException((Throwable)e1);
                }
                e1.printStackTrace();
            }
        }
    }

    private void processAction(ActionEvent e, String actionName, ActionData data) {
        Context mainContext = null;
        try {
            BatchSelectionEntries selectionEntry;
            if (this.isSupportObjContext) {
                mainContext = ((ISupportObjContext)this.action.getUIObject()).getMainContext();
                if (mainContext == null && "ActionSave".equals(actionName)) {
                    MsgBox.showWarning((String)ResourceUtils.getMessage(null, "com.kingdee.eas.framework.BatchActionResource", "CANNOTSAVEFORCU"));
                    return;
                }
                if (mainContext != null) {
                    mainContext.remove((Object)"IGNORE_CHECKITEMID_SET");
                }
            }
            if ((selectionEntry = this.actionManager.getTableSelectionHelper().getSelectedIDs(mainContext, this.level)) != null && this.getUIObject().getUIContext().containsKey("RISKSelectIDs")) {
                List idList = (List)this.getUIObject().getUIContext().get("RISKSelectIDs");
                HashSet idSet = new HashSet(idList);
                for (int i = selectionEntry.size() - 1; i >= 0; --i) {
                    BatchSelectionEntry entry = selectionEntry.get(i);
                    if (idSet.contains(entry.getId())) continue;
                    selectionEntry.getEntries().remove(entry);
                }
            }
            if (this.iBatch != null && !this.iBatch.beforeAction(this.bizAction, selectionEntry, e)) {
                return;
            }
            int countSuccess = 0;
            countSuccess = this.bizAction.isOnlyClient() ? this.doActionOnlyInClient(mainContext, selectionEntry) : this.doAction(mainContext, selectionEntry);
            if (this.iBatch != null) {
                this.iBatch.afterAction(this.bizAction, selectionEntry, countSuccess);
            }
            this.afterAction(selectionEntry, countSuccess);
            if (this.action != null && e != null) {
                this.action.afterActionPerformed((CoreUIObject)this.uiObj, actionName, e);
            }
            data.countSuccess = countSuccess;
            data.selectionEntry = selectionEntry;
        }
        catch (Exception exp) {
            this.action.getUIObject().handUIException((Throwable)exp);
        }
    }

    private void doInDaemon(final ActionEvent e, final String actionName, final ActionProxy action) {
        final ActionEvent evt = e;
        final MonitorInfo info = new MonitorInfo(action.getUIObject().getUITitle() + "-->" + this.getValue("ShortDescription"), null, (Object)action.getUIObject(), true);
        boolean isExcute = true;
        if (action == null) {
            return;
        }
        isExcute = action.beforeActionPerformed((CoreUIObject)this.uiObj, actionName, e);
        if (!isExcute) {
            return;
        }
        if (action.getExtendProperty("Mutex") != null) {
            Uuid uuid = Uuid.create();
            action.putValue("NetUuid", uuid);
        }
        if (this.beforeAction()) {
            SwingWorker worker = new SwingWorker(){
                ActionData data = new ActionData();

                public Object construct() {
                    ActionProxy.this.doDameonActionPerformed(evt, this.data);
                    return action.getUIObject();
                }

                public void finished() {
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    if (action != null && e != null) {
                        action.finallyActionPerformed((CoreUIObject)ActionProxy.this.uiObj, actionName, e);
                    }
                    action.putValue("NetUuid", null);
                    action.refresh(this.data);
                }
            };
            info.setWorker(worker);
            ThreadPool.addActionThread((MonitorInfo)info);
            ThreadPool.setBackgroundRunButtonEnabled((boolean)true);
        } else {
            action.putValue("NetUuid", null);
        }
    }

    public void addService(IBindService service) {
        this.action.addService(service);
    }

    public void removeServices(IBindService service) {
        this.action.removeServices(service);
    }

    public void clearServices() {
        this.action.clearServices();
    }

    public ItemAction getItemAction() {
        return this.action.getItemAction();
    }

    public Map getServices() {
        return this.action.getServices();
    }

    public boolean isEnabled() {
        return this.action.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.action.setEnabled(b);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.action.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.action.removePropertyChangeListener(listener);
    }

    public Object getValue(String key) {
        return this.action.getValue(key);
    }

    public void putValue(String key, Object value) {
        this.action.putValue(key, value);
    }

    public void setActionManager(BatchActionManager actionManager) {
        this.actionManager = actionManager;
        this.putValue(KEY_OperationDataType, actionManager.getOperationDataType());
    }

    public void setServiceContext(Map serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void bindTo(AbstractButton button) {
        IItemAction proxy = this.actionManager.getProxy(this);
        String text = button.getText();
        if (text == null || text.length() == 0) {
            text = (String)this.action.getValue("ShortDescription");
        }
        Icon icon = button.getIcon();
        String toolTip = button.getToolTipText();
        int mnemonic = button.getMnemonic();
        boolean isVisible = button.isVisible();
        if (proxy != null) {
            ActionListener[] listeners = button.getActionListeners();
            if (listeners != null && listeners.length > 0) {
                for (int i = 0; i < listeners.length; ++i) {
                    button.removeActionListener(listeners[i]);
                }
            }
            button.setAction((Action)proxy);
            button.setText(text);
            button.setToolTipText(toolTip);
            button.setMnemonic(mnemonic);
            button.setVisible(isVisible);
            button.setIcon(icon);
            this.buttons.add(button);
        }
    }

    public ActionLevelEnum getLevel() {
        return this.level;
    }

    public String getActionMethod() {
        return this.actionMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.matchName != null && method.getName().equals("equals")) {
            if (args[0] instanceof IItemAction) {
                IItemAction action = (IItemAction)args[0];
                return action.getItemAction().equals(action);
            }
            return method.invoke((Object)this.action, args);
        }
        if (!method.getName().startsWith(this.matchName)) {
            return method.invoke((Object)this.action, args);
        }
        Object result = null;
        if (this.serviceContext != null) {
            this.serviceContext.put("ACTION", this.action);
        }
        this.initServices(this.action);
        if (this.services != null) {
            this.beforeServices();
        }
        try {
            logger.info((Object)"this is Action DynamicProxy handler by ActionHandler[BEFORE PointCut]");
            result = method.invoke((Object)this, args);
            if (this.services != null) {
                if (this.action instanceof ItemAction) {
                    if (this.action != null && !this.action.isInvokeFailed()) {
                        this.afterServices();
                    }
                } else {
                    this.afterServices();
                }
            }
            logger.info((Object)"this is Action DynamicProxy handler by ActionHandler[AFTER PointCut]");
        }
        catch (ForceExitException forceExitException) {
        }
        finally {
            if (this.services != null) {
                this.finalServices();
            }
            this.serviceContext.remove("ACTION");
            logger.info((Object)"this is Action DynamicProxy handler by ActionHandler[FINAL PointCut]");
        }
        return result;
    }

    public void setMatchName(String matchName) {
        this.matchName = matchName;
    }

    private void initServices(Object target) {
        if (this.services == null) {
            IActionService itemAction;
            this.services = new HashMap();
            if (target instanceof IActionService && (itemAction = (IActionService)target).getServices() != null) {
                for (String key : itemAction.getServices().keySet()) {
                    if (key.equals("com.kingdee.eas.framework.client.service.PermissionService") || key.equals("com.kingdee.eas.framework.client.service.NetFunctionService")) continue;
                    this.services.put(key, itemAction.getServices().get(key));
                }
            }
            this.globalServices = (Map)this.serviceContext.get("GlobalService");
            if (this.services != null && this.globalServices != null) {
                this.services.putAll(this.globalServices);
            }
        }
    }

    private void beforeServices() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.beforeActionPerformed(this.serviceContext);
        }
    }

    private void afterServices() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.afterActionPerformed(this.serviceContext);
        }
    }

    private void finalServices() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.finalActionPerformed(this.serviceContext);
        }
    }

    public boolean isSupportObjContext() {
        return this.isSupportObjContext;
    }

    private int doActionOnlyInClient(Context mainContext, BatchSelectionEntries selectionEntry) {
        try {
            PermissionServiceHelper.getInstance().doPermissionService(this, selectionEntry, this.uiObj.getMetaDataPK(), (IMetaDataPK)new MetaDataPK(this.actionName));
            this.doActionPerformed(selectionEntry);
            int countSuccess = this.getBatchResultResolver().resolveResult(this, selectionEntry.getEntries());
            return countSuccess;
        }
        catch (Exception e) {
            this.action.getUIObject().handUIException((Throwable)e);
            return 0;
        }
    }

    protected boolean doActionPerformed(BatchSelectionEntries selectionEntry) throws Exception {
        if (this.iBatch != null) {
            this.iBatch.doActionPerformed(this.bizAction, selectionEntry);
        }
        return this.hasToDo(selectionEntry);
    }

    private boolean hasToDo(BatchSelectionEntries selectionEntry) {
        if (selectionEntry == null || selectionEntry.size() == 0) {
            return false;
        }
        int size = selectionEntry.size();
        int error = 0;
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = selectionEntry.get(idxOfEntry);
            if (entry == null || entry.getResult() == null || !entry.getResult().equals(ActionResultEnum.ERROR)) continue;
            ++error;
        }
        return error < size;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public IBatchResultResolver getBatchResultResolver() {
        if (this.batchResultResolver == null) {
            this.batchResultResolver = BatchResultResolver.getInstance();
        }
        return this.batchResultResolver;
    }

    public void setBatchResultResolver(IBatchResultResolver batchResultResolver) {
        this.batchResultResolver = batchResultResolver;
    }

    static class ActionData {
        BatchSelectionEntries selectionEntry;
        int countSuccess = 0;

        ActionData() {
        }
    }
}

