/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.batchaction.ISupportBatchAction;
import com.kingdee.eas.framework.batchaction.service.AbstractTableSelectionHelper;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableSelectionHelper
extends AbstractTableSelectionHelper {
    static Logger logger = Logger.getLogger(TableSelectionHelper.class);
    private String idColName;
    private String orgIdColName;
    private String numberColName;
    private IMetaDataPK mainQueryPK;
    private ListUI uiObj;
    private Map<String, String> col2query;

    public void setTableProperty(ListUI uiObj, IMetaDataPK mainQueryPK, KDTable table, String idColName, String entryIdColName, String numberColName, String entrySeqColName, String orgIdColName) {
        this.uiObj = uiObj;
        this.mainQueryPK = mainQueryPK;
        this.tblMain = table;
        this.idColName = idColName;
        this.entryIdColName = entryIdColName;
        this.numberColName = numberColName;
        this.entrySeqColName = entrySeqColName;
        this.orgIdColName = orgIdColName;
    }

    @Override
    protected BatchSelectionEntry getSelectionEntry(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntry entry = new BatchSelectionEntry();
        entry.setId((String)this.getCellValue(row.getCell(this.idColName)));
        entry.setNumber((String)this.getCellValue(row.getCell(this.numberColName)));
        if (actionLevel.equals(ActionLevelEnum.ENTRY)) {
            String entryId = (String)this.getCellValue(row.getCell(this.entryIdColName));
            if (entryId == null) {
                return null;
            }
            entry.setEntryId(entryId);
            entry.setSeq((Integer)this.getCellValue(row.getCell(this.entrySeqColName)));
        }
        entry.setRowNum(row.getRowIndex());
        entry.setOrgId((String)this.getCellValue(row.getCell(this.orgIdColName)));
        return entry;
    }

    private String getQueryName(String colName) {
        if (this.col2query != null && this.col2query.containsKey(colName)) {
            return this.col2query.get(colName);
        }
        return colName;
    }

    @Override
    protected BatchSelectionEntries getSelectedAllIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        if (this.uiObj == null || this.uiObj.getMainQuery() == null) {
            throw new RuntimeException("listui or listui mainQuery is null");
        }
        EntityViewInfo view = (EntityViewInfo)this.uiObj.getMainQuery().clone();
        this.setDefaultSort(view, actionLevel);
        boolean isHead = actionLevel.equals(ActionLevelEnum.HEAD);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(this.getQueryName(this.idColName)));
        selectors.add(new SelectorItemInfo(this.getQueryName(this.numberColName)));
        if (actionLevel.equals(ActionLevelEnum.ENTRY)) {
            selectors.add(new SelectorItemInfo(this.getQueryName(this.entryIdColName)));
            selectors.add(new SelectorItemInfo(this.getQueryName(this.entrySeqColName)));
        }
        selectors.add(new SelectorItemInfo(this.getQueryName(this.orgIdColName)));
        view.setSelector(selectors);
        view.setAppendSelectors(false);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)this.mainQueryPK, (Context)this.uiObj.getListUIMainOrgContext());
        queryExecutor.setObjectView(view);
        queryExecutor.option().isAutoIgnoreDuplicatedRow = isHead;
        queryExecutor.option().isIgnorePermissionCheck = false;
        IRowSet rs = queryExecutor.executeQuery();
        HashSet<String> keySet = new HashSet<String>();
        if (rs != null && rs.size() > 0) {
            try {
                int size = rs.size();
                BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, size);
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (isHead) {
                        if (keySet.contains(id)) continue;
                        keySet.add(id);
                        results.add(new BatchSelectionEntry(id, rs.getString(2), rs.getString(3)));
                        continue;
                    }
                    results.add(new BatchSelectionEntry(id, rs.getString(3), rs.getString(2), rs.getInt(4), rs.getString(5)));
                }
                return results;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("getSelectedAllIDs(): The results of fetchDatasByFields not match Id and OrgId.");
            }
        }
        return null;
    }

    private void setDefaultSort(EntityViewInfo view, ActionLevelEnum actionLevel) {
        if (!(this.uiObj instanceof CoreBillListUI)) {
            return;
        }
        String seqPropName = ((CoreBillListUI)this.uiObj).getEntriesName() + ".seq";
        if (view.getSorter() != null && view.getSorter().size() > 0) {
            SorterItemCollection sorters = view.getSorter();
            boolean hasNumberSorter = false;
            boolean hasSeqSorter = false;
            int size = sorters.size();
            for (int i = 0; i < size; ++i) {
                if (sorters.get(i).getPropertyName().equals("number")) {
                    hasNumberSorter = true;
                    continue;
                }
                if (!sorters.get(i).getPropertyName().equals(seqPropName)) continue;
                hasSeqSorter = true;
            }
            if (!hasNumberSorter) {
                SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
                aSorterItemInfo.setSortType(SortType.DESCEND);
                view.getSorter().add(aSorterItemInfo);
            }
            if (actionLevel.equals(ActionLevelEnum.ENTRY) && !hasSeqSorter) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo(seqPropName);
                bSorterItemInfo.setSortType(SortType.ASCEND);
                view.getSorter().add(bSorterItemInfo);
            }
        } else {
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
            aSorterItemInfo.setSortType(SortType.DESCEND);
            view.getSorter().add(aSorterItemInfo);
            if (actionLevel.equals(ActionLevelEnum.ENTRY)) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo(seqPropName);
                bSorterItemInfo.setSortType(SortType.ASCEND);
                view.getSorter().add(bSorterItemInfo);
            }
        }
    }

    public TableSelectionHelper(ListUI uiObj) {
        this.uiObj = uiObj;
        if (uiObj instanceof ISupportBatchAction) {
            this.iSupportBatchAction = (ISupportBatchAction)uiObj;
        }
    }

    public void setColMapQueryName(Map<String, String> col2query) {
        this.col2query = col2query;
    }

    private void removeRowsOnResults(List selections, int countSuccess) throws Exception {
        if (selections != null && selections.size() > 0 && countSuccess > 0) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selections.get(0);
            if (entry.getRowNum() == -1) {
                this.uiObj.refreshList();
            } else {
                ArrayList<BatchSelectionEntry> successList = new ArrayList<BatchSelectionEntry>(selections.size());
                int size = selections.size();
                for (int idx = 0; idx < size; ++idx) {
                    entry = (BatchSelectionEntry)selections.get(idx);
                    if (!entry.getResult().equals(ActionResultEnum.SUCCESS)) continue;
                    successList.add(entry);
                }
                if (successList.size() == 0) {
                    return;
                }
                entry = (BatchSelectionEntry)successList.get(0);
                int min = this.getMin(entry.getRowNum(), entry.getId());
                int max = this.getMax(entry.getRowNum(), entry.getId());
                SelectionBlock selBlock = new SelectionBlock(min, max);
                ArrayList<SelectionBlock> blocks = new ArrayList<SelectionBlock>();
                int size2 = successList.size();
                for (int idx = 1; idx < size2; ++idx) {
                    entry = (BatchSelectionEntry)successList.get(idx);
                    if (selBlock.isInclude(entry.getRowNum())) continue;
                    if (entry.getRowNum() == selBlock.getMax() + 1) {
                        selBlock.setMax(entry.getRowNum());
                        continue;
                    }
                    blocks.add(selBlock);
                    min = this.getMin(entry.getRowNum(), entry.getId());
                    max = this.getMax(entry.getRowNum(), entry.getId());
                    if (selBlock.isInclude(min)) {
                        selBlock.setMax(max);
                        continue;
                    }
                    selBlock = new SelectionBlock(entry.getRowNum(), entry.getRowNum());
                }
                if (!blocks.contains(selBlock)) {
                    max = this.getMax(entry.getRowNum(), entry.getId());
                    selBlock.setMax(max);
                    blocks.add(selBlock);
                }
                int count = 0;
                if (blocks.size() > 1 || ((SelectionBlock)blocks.get(0)).getCount() > 1) {
                    this.uiObj.refreshList();
                    return;
                }
                size2 = blocks.size();
                for (int idx = size2 - 1; idx >= 0; --idx) {
                    selBlock = (SelectionBlock)blocks.get(idx);
                    selBlock.shrink(count);
                    this.removeRows(selBlock);
                    count = selBlock.getCount();
                }
            }
        }
    }

    @Override
    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
        if (countSuccess == 0) {
            return;
        }
        if (!this.needToSelectRow) {
            if (this.iSupportBatchAction != null) {
                this.iSupportBatchAction.refresh(bizAction, selectionEntries, countSuccess);
            }
            return;
        }
        int curIndex = 0;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            curIndex = selectBlock.getTop();
        }
        if (bizAction.equals(BatchActionEnum.DELETE)) {
            this.removeRowsOnResults(selectionEntries.getEntries(), countSuccess);
        } else {
            this.uiObj.refreshList();
        }
        this.tblMain.getSelectManager().select(curIndex, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(curIndex);
    }

    private void removeRows(SelectionBlock selBlock) {
        int min = selBlock.getMin();
        for (int rowNum = selBlock.getMax(); rowNum >= min; --rowNum) {
            this.tblMain.removeRow(rowNum);
        }
    }

    private int getMin(int rowNum, String id) {
        --rowNum;
        while (rowNum > -1 && this.tblMain.getCell(rowNum, this.idColName).getValue().toString().equals(id)) {
            --rowNum;
        }
        return rowNum > 0 ? rowNum + 1 : 0;
    }

    private int getMax(int rowNum, String id) {
        ++rowNum;
        while (rowNum < this.tblMain.getRowCount() && this.tblMain.getCell(rowNum, this.idColName) != null && this.tblMain.getCell(rowNum, this.idColName).getValue().toString().equals(id)) {
            ++rowNum;
        }
        return rowNum - 1;
    }

    protected void selectFirstRow() {
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public IObjectPK getOrgPK(ItemAction action) {
        if (this.tblMain == null) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.orgIdColName);
            if (cell == null) {
                MsgBox.showError((String)"TableSelectionHelper: the main orgunit column name is not right.");
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return new ObjectStringPK(keyValue.toString());
            }
        }
        return null;
    }

    public String getOrgIdColName() {
        return this.orgIdColName;
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    @Override
    protected BatchSelectionEntries getSelectedMultiIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, selectRows.length);
        HashSet<Object> keySet = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            BatchSelectionEntry entry;
            IRow row = this.tblMain.getRow(selectRows[i]);
            if (actionLevel.equals(ActionLevelEnum.HEAD)) {
                Object id = this.getCellValue(row.getCell(this.idColName));
                if (keySet.contains(id)) continue;
                keySet.add(id);
            }
            if ((entry = this.getSelectionEntry(row, actionLevel)) == null) continue;
            results.add(entry);
        }
        return results;
    }

    @Override
    public String getSelectedID() {
        return null;
    }

    static class SelectionBlock {
        private int min;
        private int max;

        public SelectionBlock(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public boolean isInclude(int value) {
            return value >= this.min && value <= this.max;
        }

        public int getCount() {
            return this.max - this.min + 1;
        }

        public void shrink(int value) {
            this.max -= value;
            this.min -= value;
        }
    }
}

