/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.common.bireport.DimensionSet;
import com.kingdee.bos.bi.model.common.bireport.layout.BIReportLayout;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.BIReportMDXUtils;
import com.kingdee.bos.bi.model.rt.bireport.BIReportModelCache;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMemberFactory;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSetFactory;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BIReportModel
implements Serializable {
    private String reportId;
    private String reportName;
    private int modelType;
    private String refModelId;
    private String refModelName;
    private AppModelView apv;
    private AppModel apm;
    private BIReportLayout layout;
    private String schema;
    private String discription;
    private static final String CUBE_NAME = "bimodelTest";
    private static final long serialVersionUID = 5944679684083967275L;
    private static final Logger log = LogUtil.getPackageLogger(BIReportModel.class);
    final BIReportModelCache cache = new BIReportModelCache();

    public void setAppModel(AppModel apm) {
        this.apm = apm;
    }

    public AppModel getAppModel() {
        return this.apm;
    }

    public void setAppModelView(AppModelView apv) {
        this.apv = apv;
    }

    public AppModelView getAppModelView() {
        return this.apv;
    }

    public void setLayout(BIReportLayout layout) {
        this.layout = layout;
    }

    public BIReportLayout getLayout() {
        return this.layout;
    }

    public String getDiscription() {
        return this.discription;
    }

    public void setDiscription(String discription) {
        this.discription = discription;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getRefModelId() {
        return this.refModelId;
    }

    public void setRefModelId(String refModelId) {
        this.refModelId = refModelId;
    }

    public String getRefModelName() {
        return this.refModelName;
    }

    public void setRefModelName(String refModelName) {
        this.refModelName = refModelName;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<AnalysisReport name=\"").append(this.getReportName()).append("\">");
        sb.append(this.layout.toXML());
        sb.append("</AnalysisReport>");
        return sb.toString();
    }

    public String toMDX(Context ctx) {
        StringBuffer sb = new StringBuffer();
        ArrayList lstCalMember = new ArrayList();
        sb.append("select ");
        sb.append(this.layout.getRowAxis().toMDX(ctx));
        this.layout.getRowAxis().getCalMembers(ctx, lstCalMember);
        sb.append(" on rows,");
        sb.append(this.layout.getColAxis().toMDX(ctx));
        this.layout.getColAxis().getCalMembers(ctx, lstCalMember);
        sb.append(" on columns ");
        sb.append(" from bimodelTest");
        String mdxSlicer = this.layout.getSlicer().toMDX(ctx);
        this.layout.getSlicer().getCalMembers(ctx, lstCalMember);
        if (!StringUtil.isEmpty(mdxSlicer)) {
            sb.append(" where (" + mdxSlicer + ")");
        }
        HashSet lstSets = new HashSet();
        this.layout.getRowAxis().getSets(ctx, lstSets);
        this.layout.getColAxis().getSets(ctx, lstSets);
        try {
            BIReportMDXUtils.findRefAggCalMamberFromCalMember(ctx, lstCalMember, this.getAppModel().getId());
            BIReportMDXUtils.findRefSetFromCalMember(ctx, lstCalMember, this.getAppModel().getId(), lstSets);
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        Set resultSet = BIReportMDXUtils.sortSet(ctx, lstSets, this.getAppModel().getId());
        String mdx = "";
        boolean hasSet = false;
        if (!resultSet.isEmpty()) {
            mdx = mdx + this.handleSet(resultSet, ctx);
            hasSet = true;
        }
        if (!lstCalMember.isEmpty()) {
            mdx = mdx + " " + this.handleCalMember(hasSet, lstCalMember, ctx);
        }
        log.info((Object)(mdx + " " + sb.toString()));
        return mdx + " " + sb.toString();
    }

    private String handleSet(Set lstSet, Context ctx) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = lstSet.iterator();
        while (it.hasNext()) {
            if (first) {
                sb.append("with ");
                first = false;
            } else {
                sb.append(" ");
            }
            DimensionSet dimSet = (DimensionSet)it.next();
            NamedSet cm = NamedSetFactory.fromDB(dimSet, this.getAppModel().getId(), ctx);
            sb.append("set ").append(dimSet.toMDX(ctx)).append(" as ").append(cm.toMDX(ctx));
        }
        return sb.toString();
    }

    private String handleCalMember(boolean hasSet, List lstCalMember, Context ctx) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> $added = new HashMap<String, String>();
        if (!lstCalMember.isEmpty() && !hasSet) {
            sb.append("with ");
        }
        int n = lstCalMember.size();
        for (int i = 0; i < n; ++i) {
            DimensionMember dimMember = (DimensionMember)lstCalMember.get(i);
            CalMember cm = CalMemberFactory.fromDB(dimMember, ctx);
            String $key = cm.getDimensionType().getName() + "#" + cm.getNumber();
            if ($added.containsKey($key)) continue;
            $added.put($key, $key);
            sb.append(" ").append(cm.toMDX());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BIReportModel fromID(String id, Context ctx) throws SQLException {
        BIReportModel rptDef = new BIReportModel();
        rptDef.setReportId(id);
        StringBuffer sb = new StringBuffer();
        sb.append("select A.FID,A.FName,A.FModelType,A.FModelID,B.FName as FModelName, A.FSchema,A.FDiscription  from T_BI_BIReport A left join T_BI_Appmodel B on A.FModelID = B.FID where A.FID='" + id + "'");
        Connection cn = null;
        RDRowSet rowset = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            rowset = DBUtil.executeQuery(sb.toString(), cn);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (rowset.next()) {
            Object disc;
            Object schema;
            Object modelName;
            Object modelId;
            rptDef.setReportId(rowset.getString("FID"));
            rptDef.setReportName(rowset.getString("FName"));
            Object type = rowset.getObject("FModelType");
            if (type != null) {
                rptDef.setModelType(((Number)type).intValue());
            }
            if ((modelId = rowset.getObject("FModelID")) != null) {
                rptDef.setRefModelId((String)modelId);
            }
            if ((modelName = rowset.getObject("FModelName")) != null) {
                rptDef.setRefModelName((String)modelName);
            }
            if ((schema = rowset.getObject("FSchema")) != null) {
                rptDef.setSchema((String)schema);
                Document doc = null;
                try {
                    doc = DocumentHelper.parseText((String)((String)schema));
                }
                catch (DocumentException e1) {
                    e1.printStackTrace();
                }
                Element e = (Element)doc.selectSingleNode("/AnalysisReport/Layout");
                AppModelView apv = AppModelView.fromDB((String)modelId, ctx);
                rptDef.setAppModelView(apv);
                AppModel apm = new AppModel(apv, ctx);
                rptDef.setAppModel(apm);
                BIReportLayout layout = BIReportLayout.fromElement(e, ctx, apm);
                rptDef.setLayout(layout);
            }
            if ((disc = rowset.getObject("FDiscription")) != null) {
                rptDef.setDiscription((String)disc);
            }
        }
        return rptDef;
    }
}

