/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.bireport.ICellElement;
import com.kingdee.bos.bi.model.common.bireport.IOLAPSet;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;

public class DimensionSet
implements Serializable,
IOLAPSet,
ICellElement,
Comparable {
    private String name;
    private String alias;
    private String expr;
    private boolean inner;
    private Dimension dim;
    private int level = 100;
    private static final long serialVersionUID = 4110886111980445433L;

    public DimensionSet(Dimension dim, String name, String alias) {
        this.dim = dim;
        this.name = name;
        this.alias = alias;
    }

    public void decreaseLevel() {
        --this.level;
    }

    public DimensionSet setLevel(int level) {
        this.level = level;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.alias;
    }

    public DimensionType getDimensionType() {
        return this.dim.getDimensionDef().getDimensionType();
    }

    public Dimension getDim() {
        return this.dim;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String toMDX(Context ctx) {
        return "[" + this.alias + "]";
    }

    @Override
    public String getType() {
        return "set";
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Item type=\"" + this.getType() + "\"");
        sb.append(" inner=\"" + (this.inner ? "true" : "false") + "\">");
        sb.append("<name>");
        sb.append("<![CDATA[" + this.name + "]]>");
        sb.append("</name>");
        sb.append("<alias>");
        sb.append("<![CDATA[" + this.alias + "]]>");
        sb.append("</alias>");
        sb.append("<expr>");
        sb.append("<![CDATA[" + this.expr + "]]>");
        sb.append("</expr>");
        sb.append("</Item>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DimensionSet load(Context ctx, String appId, Dimension dim, String alias) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set where ");
        sb.append("FAppModelID ='").append(appId).append("' and FDimension ='").append(dim.getDimensionDef().getType()).append("' ");
        sb.append("and FSetName='").append(alias).append("'");
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            RDRowSet rs = DBUtil.executeQuery(sb.toString(), cn);
            if (rs.next()) {
                String setType = rs.getString("FSetType");
                DimensionSet dimensionSet = new DimensionSet(dim, setType, alias);
                return dimensionSet;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionSet) {
            DimensionSet anotherSet = (DimensionSet)obj;
            try {
                return StringUtil.equalsIgnoreCase(anotherSet.getAlias(), this.getAlias()) && StringUtil.equalsIgnoreCase(anotherSet.getType(), this.getType()) && StringUtil.equalsIgnoreCase(anotherSet.getDim().getAppModel().getId(), this.getDim().getAppModel().getId()) && StringUtil.equalsIgnoreCase(anotherSet.getDimensionType().getName(), this.getDimensionType().getName());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getAlias().hashCode();
        }
        catch (Exception e) {
            return super.hashCode();
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof DimensionSet) {
            int v = this.getLevel() - ((DimensionSet)obj).getLevel();
            return v == 0 ? 1 : v;
        }
        return 1;
    }
}

