/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.layout;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.layout.IOLAPAxis;
import com.kingdee.bos.bi.model.common.bireport.layout.RowSet;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Axis
implements Serializable,
IOLAPAxis {
    private Map props = new HashMap();
    private List dimensions;
    private List rowSets;
    private boolean isRow;
    private static final long serialVersionUID = -6947950215996477596L;

    public Axis(boolean isRow, List dimensions, List rowSets, boolean nonEmpty) {
        this.isRow = isRow;
        this.dimensions = dimensions;
        this.rowSets = rowSets;
        this.setNonEmpty(nonEmpty);
    }

    public Axis(boolean isRow, List dimensions, List rowSets, Map props) {
        this.isRow = isRow;
        this.dimensions = dimensions;
        this.rowSets = rowSets;
        this.props = props;
    }

    public void setDimensions(List dimensions) {
        this.dimensions = dimensions;
    }

    public void setRowSets(List rowSets) {
        this.rowSets = rowSets;
    }

    public List getRowSets() {
        return this.rowSets;
    }

    public List getDimensions() {
        return this.dimensions;
    }

    public void setProps(String key, String value) {
        this.props.put(key, value);
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.props.put("NonEmpty", new Boolean(nonEmpty).toString());
    }

    public boolean isNonEmpty() {
        return StringUtil.toBoolean((String)this.props.get("NonEmpty"));
    }

    public String toXML() {
        int i;
        StringBuffer sb = new StringBuffer();
        String axis = "Row";
        if (!this.isRow) {
            axis = "Col";
        }
        sb.append("<" + axis + " NonEmpty=\"" + (this.isNonEmpty() ? "true" : "false") + "\">");
        int len = this.dimensions.size();
        for (i = 0; i < len; ++i) {
            sb.append("<Dim name=\"" + this.dimensions.get(i) + "\"/>");
        }
        len = this.rowSets.size();
        for (i = 0; i < len; ++i) {
            RowSet rs = (RowSet)this.rowSets.get(i);
            sb.append(rs.toXML());
        }
        sb.append("</" + axis + ">");
        return sb.toString();
    }

    public static Axis fromElement(Element e, boolean isRow, Context ctx, AppModel apm) throws SQLException {
        ArrayList<DimensionType> dimensions = new ArrayList<DimensionType>();
        List lstDimNods = e.selectNodes("Dim");
        int len = lstDimNods.size();
        for (int i = 0; i < len; ++i) {
            Element el = (Element)lstDimNods.get(i);
            dimensions.add(DimensionType.getObj(ctx, el.attributeValue("name")));
        }
        ArrayList<RowSet> rowSets = new ArrayList<RowSet>();
        List lstRSNodes = e.selectNodes("RowSet");
        int len2 = lstRSNodes.size();
        for (int i = 0; i < len2; ++i) {
            Element el = (Element)lstRSNodes.get(i);
            rowSets.add(RowSet.fromElement(el, ctx, apm));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        int len3 = e.attributeCount();
        for (int i = 0; i < len3; ++i) {
            Attribute attr = e.attribute(i);
            props.put(attr.getName(), attr.getValue());
        }
        return new Axis(isRow, dimensions, rowSets, props);
    }

    @Override
    public String toMDX(Context ctx) {
        StringBuffer sb = new StringBuffer();
        if (this.isNonEmpty()) {
            sb.append(" non empty ");
        }
        sb.append("{");
        int len = this.rowSets.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            RowSet rs = (RowSet)this.rowSets.get(i);
            sb.append("{");
            sb.append(rs.toMDX(false, ctx));
            sb.append("}");
        }
        sb.append("}");
        if (this.isNonEmpty()) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void getCalMembers(Context ctx, List lstRet) {
        int len = this.rowSets.size();
        for (int i = 0; i < len; ++i) {
            RowSet rs = (RowSet)this.rowSets.get(i);
            rs.getCalMembers(ctx, lstRet);
        }
    }

    public void getSets(Context ctx, Set lstRet) {
        int len = this.rowSets.size();
        for (int i = 0; i < len; ++i) {
            RowSet rs = (RowSet)this.rowSets.get(i);
            rs.getSets(ctx, lstRet);
        }
    }
}

