/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine;

import com.kingdee.bos.bi.model.common.formularengine.IFuncExecutor;
import com.kingdee.bos.bi.model.common.formularengine.IVarValueProvider;
import com.kingdee.bos.bi.model.common.formularengine.exception.CycleRefersException;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.exception.NonValueException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ICompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormularEngine {
    private InnerValueProvider _innerValueProvider;

    public void setVarValueProvider(IVarValueProvider valueProvider) {
        this._innerValueProvider = new InnerValueProvider(valueProvider);
    }

    public Variant calculate(AbstractExpr expr) throws FormulaComputingException {
        expr.computing(this._innerValueProvider);
        return expr.getReturnValue();
    }

    private static class InnerValueProvider
    implements IVarValueProvider,
    IFuncExecutor {
        private IVarValueProvider _valueProvider;
        private Map _refered = new HashMap();

        public InnerValueProvider(IVarValueProvider valueProvider) {
            this._valueProvider = valueProvider;
        }

        @Override
        public Variant getValue(String key) throws FormulaComputingException {
            AbstractExpr expr = this.getFormula(key);
            if (expr == null) {
                Variant value = this._valueProvider.getValue(key);
                if (value == null) {
                    throw new NonValueException(key);
                }
                return value;
            }
            if (expr.isReturnValueUnsure()) {
                if (this._refered.containsKey(key)) {
                    HashSet<String> cycVars = new HashSet<String>();
                    cycVars.add(key);
                    this.pickCycVar(expr, cycVars);
                    throw new CycleRefersException(cycVars);
                }
                this._refered.put(key, expr);
                expr.computing(this);
                this._refered.remove(key);
            }
            return expr.getReturnValue();
        }

        @Override
        public AbstractExpr getFormula(String key) {
            return this._valueProvider.getFormula(key);
        }

        private void pickCycVar(AbstractExpr expr, Set cycVars) {
            String var;
            if (expr instanceof ICompositeExpr) {
                this.pickCycVar(((ICompositeExpr)((Object)expr)).getLeftExpr(), cycVars);
                this.pickCycVar(((ICompositeExpr)((Object)expr)).getRightExpr(), cycVars);
            } else if (expr instanceof VarExpr && this._refered.containsKey(var = ((VarExpr)expr).getVarName())) {
                if (cycVars.contains(var)) {
                    return;
                }
                cycVars.add(var);
                this.pickCycVar((AbstractExpr)this._refered.get(var), cycVars);
            }
        }

        @Override
        public Variant exec(String funcName, Variant[] paramValues) throws FormulaComputingException {
            if (!(this._valueProvider instanceof IFuncExecutor)) {
                throw new UnsupportedOperationException("\u96c6\u6210\u4f7f\u7528\u8005\u672a\u63d0\u4f9b\u51fd\u6570\u6267\u884c\u529f\u80fd\u3002");
            }
            return ((IFuncExecutor)((Object)this._valueProvider)).exec(funcName, paramValues);
        }
    }
}

