/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.appmodel;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.appmodel.DimRefModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.FormulaParamModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralDRDetailModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralDRDetailXmlModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.GeneralSchemeModel;
import com.kingdee.bos.bi.model.common.mm.appmodel.OtherModel;
import com.kingdee.bos.bi.model.common.mm.general.GeneralDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom2.JDOMException;

public class AppModelUtil {
    public static boolean checkIsExistDimRef(IManagementFacade facade, String appModelId) throws SQLException {
        String sql = "select FDimViewID from T_BI_AM_DimRef where FAMID = '" + appModelId + "'";
        RDRowSet rs = facade.executeQuery(sql);
        return rs.getRowCount() > 0;
    }

    public static Map loadAppAggregate(Connection con, String appId) throws SQLException {
        HashMap<String, String> aggMap = new HashMap<String, String>();
        String sql = "select FPropertyName,FPropertyValue from T_BI_ENT_Properties where FObjectType=? and FObjectId=?";
        RDRowSet rs = DBUtil.executeQuery("select FPropertyName,FPropertyValue from T_BI_ENT_Properties where FObjectType=? and FObjectId=?", new Object[]{"commonAppModel", appId}, con);
        while (rs.next()) {
            aggMap.put(rs.getString("FPropertyName"), rs.getString("FPropertyValue"));
        }
        return aggMap;
    }

    public static OtherModel loadOtherModel(IManagementFacade facade, String id) throws SQLException {
        OtherModel otherModel = new OtherModel();
        String sql = "select FDiscription,FType,FDBCenterId from T_BI_AppModel where fid='" + id + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            otherModel.setAppModelId(id);
            otherModel.setDescription(rs.getString("FDiscription"));
            otherModel.setToDBCenterId(rs.getString("FDBCenterId"));
        }
        FormulaParamModel paramModel = FormulaParamModel.getFormulaParamModel(facade, id);
        otherModel.setFormulaParamModel(paramModel);
        HashMap<String, String> aggMap = new HashMap<String, String>();
        String sql2 = "select FPropertyName,FPropertyValue from T_BI_ENT_Properties where FObjectType='commonAppModel' and FObjectId='" + id + "'";
        RDRowSet rs2 = facade.executeQuery(sql2);
        while (rs2.next()) {
            aggMap.put(rs2.getString("FPropertyName"), rs2.getString("FPropertyValue"));
        }
        otherModel.setAggeMap(aggMap);
        return otherModel;
    }

    public static int[] saveOtherModel(IManagementFacade facade, OtherModel model) throws SQLException {
        Map agg = model.getAggeMap();
        FormulaParamModel paramModel = model.getFormulaParamModel();
        int size = (paramModel == null ? 0 : 1) + agg.size() + 2;
        String[] sqls = new String[size];
        int i = 0;
        String appModelId = model.getAppModelId() == null ? "" : model.getAppModelId();
        String description = model.getDescription() == null ? "" : model.getDescription();
        String toDBCenterId = model.getToDBCenterId() == null ? "" : model.getToDBCenterId();
        sqls[i++] = "UPDATE T_BI_AppModel SET FDiscription='" + description + "',FDBCenterId='" + toDBCenterId + "' WHERE FID='" + appModelId + "'";
        sqls[i++] = "DELETE FROM T_BI_ENT_Properties where FObjectId='" + appModelId + "'";
        if (paramModel != null) {
            sqls[i++] = "insert into T_BI_ENT_Properties(FObjectType,FObjectId,FPropertyName,FPropertyValue,FPropertyGroup) values ('formulaParam','" + appModelId + "','" + "unpassedVoucher" + "','" + paramModel.getUnpassedVoucher() + "','')";
        }
        boolean isAgg = false;
        String dimType = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : agg.entrySet()) {
            dimType = (String)entry2.getKey();
            isAgg = StringUtil.toBoolean((String)entry2.getValue());
            sqls[i++] = "insert into T_BI_ENT_Properties(FObjectType,FObjectId,FPropertyName,FPropertyValue,FPropertyGroup) values ('commonAppModel','" + appModelId + "','" + dimType + "','" + isAgg + "','')";
        }
        return facade.executeBatch(sqls);
    }

    public static String loadDescription(IManagementFacade facade, String id) throws SQLException {
        String sql = "select FDiscription from T_BI_AppModel where fid='" + id + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            return rs.getString("FDiscription");
        }
        return null;
    }

    public static List loadDimRefList(IManagementFacade facade, String id) throws SQLException {
        ArrayList<DimRefModel> dimRefList = new ArrayList<DimRefModel>();
        String sql = "select FAMID,FDimType,FDimViewID,FDimAlias from T_BI_AM_DimRef where FAMID='" + id + "'";
        RDRowSet rs = facade.executeQuery(sql);
        DimRefModel m = null;
        while (rs.next()) {
            m = new DimRefModel();
            m.setFAMID(rs.getString("FAMID"));
            m.setFDimType(rs.getString("FDimType"));
            m.setFDimViewID(rs.getString("FDimViewID"));
            m.setFDimAlias(rs.getString("FDimAlias"));
            dimRefList.add(m);
        }
        return dimRefList;
    }

    public static List loadDimTypeList(IManagementFacade facade) throws SQLException {
        Vector result = new Vector();
        List financeDims = AppModelUtil.getGeneralDimTypes();
        StringBuffer financeSql = new StringBuffer();
        financeSql.append("select FType,FID,FName from T_BI_MM_List where FUseFlag=1 and FType in ( ");
        ComboBoxObject dim2 = null;
        for (ComboBoxObject dim2 : financeDims) {
            financeSql.append("'").append(dim2.getCode()).append("',");
        }
        financeSql.deleteCharAt(financeSql.length() - 1);
        financeSql.append(") order by FType ");
        RDRowSet rsf = facade.executeQuery(financeSql.toString());
        HashMap mapf = new HashMap();
        ComboBoxObject objf = null;
        String typef = null;
        while (rsf.next()) {
            typef = rsf.getString("FType");
            if (mapf.get(typef) == null) {
                mapf.put(typef, new Vector());
            }
            objf = new ComboBoxObject();
            objf.setCode(rsf.getString("FID"));
            objf.setName(rsf.getString("FName"));
            ((List)mapf.get(typef)).add(objf);
        }
        for (ComboBoxObject dim2 : financeDims) {
            dim2.setIteams((Vector)mapf.get(dim2.getCode()));
        }
        result.addAll(financeDims);
        Vector<ComboBoxObject> generalDims = new Vector<ComboBoxObject>();
        StringBuffer generalSql = new StringBuffer();
        generalSql.append("select C.FNumber dimNumber,C.FName dimName,C.FType dimType,L.FID viewId ,L.FName viewName ");
        generalSql.append("from  T_BI_MM_CUSTOM C , T_BI_CSTM_List L ");
        generalSql.append("where C.FID=L.FCSTMID and L.FUseFlag=1 order by C.FType,C.FLastUpdateTime desc ");
        RDRowSet rsg = facade.executeQuery(generalSql.toString());
        HashMap mapg = new HashMap();
        ComboBoxObject objg = null;
        String typeg = null;
        String dimType = null;
        while (rsg.next()) {
            typeg = rsg.getString("dimNumber");
            if (mapg.get(typeg) == null) {
                Vector children = new Vector();
                mapg.put(typeg, children);
                dimType = "time".equals(rsg.getString("dimType")) ? "type.nonMeasure.timeDimension." : "type.nonMeasure.commonDimension.";
                generalDims.add(new ComboBoxObject(typeg, rsg.getString("dimName"), dimType, children));
            }
            objg = new ComboBoxObject();
            objg.setCode(rsg.getString("viewId"));
            objg.setName(rsg.getString("viewName"));
            objg.setInfo(rsg.getString("dimType"));
            ((Vector)mapg.get(typeg)).add(objg);
        }
        result.addAll(generalDims);
        return result;
    }

    public static List loadGeneralSchemeList(IManagementFacade facade, String amid) throws SQLException, JDOMException, IOException {
        Vector<GeneralSchemeModel> schemeList = new Vector<GeneralSchemeModel>();
        StringBuffer sb = new StringBuffer();
        sb.append("select S.FAMID,S.FSchemaID,S.FSchemaName, D.FType,D.FOrder,D.FParameters ");
        sb.append("from T_BI_AM_DR_Schema S ,T_BI_AM_DR_Detail D ");
        sb.append("where S.FSchemaID=D.FSchemaID and S.FAMID='").append(amid).append("' ");
        GeneralSchemeModel sm = null;
        GeneralDRDetailModel dm = null;
        RDRowSet rs = facade.executeQuery(sb.toString());
        while (rs.next()) {
            sm = new GeneralSchemeModel();
            sm.setFAMID(rs.getString("FAMID"));
            sm.setFSchemeID(rs.getString("FSchemaID"));
            sm.setFSchemeName(rs.getString("FSchemaName"));
            sm.setType(rs.getString("FType"));
            dm = new GeneralDRDetailModel();
            dm.setFSchemaID(rs.getString("FSchemaID"));
            dm.setFType(rs.getString("FType"));
            dm.setFOrder(rs.getInt("FOrder"));
            dm.setFParameters(GeneralDRDetailXmlModel.toModel(rs.getString("FParameters")));
            sm.setDataRuleModel(dm);
            schemeList.add(sm);
        }
        return schemeList;
    }

    public static GeneralDRDetailXmlModel getSQLDataRuleDetail(Connection con, String schemeId) throws SQLException, JDOMException, IOException {
        String sql = "select FSchemaID,FType,FOrder,FParameters from T_BI_AM_DR_Detail where FSchemaID='" + schemeId + "'";
        RDRowSet rs = DBUtil.executeQuery(sql, con);
        if (rs.next()) {
            return GeneralDRDetailXmlModel.toModel(rs.getString("FParameters"));
        }
        return null;
    }

    public static List getFianceDimTypes() {
        ArrayList<ComboBoxObject> list = new ArrayList<ComboBoxObject>();
        list.add(new ComboBoxObject("org", "\u7ec4\u7ec7\u7ef4\u5ea6"));
        list.add(new ComboBoxObject("metric", "\u6307\u6807\u7ef4\u5ea6"));
        list.add(new ComboBoxObject("year", "\u5e74\u7ef4\u5ea6"));
        list.add(new ComboBoxObject("period", "\u8d22\u52a1\u671f\u95f4\u7ef4\u5ea6"));
        list.add(new ComboBoxObject("measure", "\u5ea6\u91cf\u7ef4\u5ea6"));
        return list;
    }

    public static List getGeneralDimTypes() {
        ArrayList<ComboBoxObject> result = new ArrayList<ComboBoxObject>();
        result.add(new ComboBoxObject("measure", "\u5ea6\u91cf\u7ef4\u5ea6", "type.measure.member."));
        result.add(new ComboBoxObject("org", "\u7ec4\u7ec7\u7ef4\u5ea6", "type.nonMeasure.commonDimension."));
        return result;
    }

    public static int[] saveDimRef(IManagementFacade facade, String famid, List dimRefList) throws SQLException {
        String[] sqls = new String[dimRefList.size() + 1];
        sqls[0] = "delete from T_BI_AM_DimRef where FAMID='" + famid + "'";
        DimRefModel m = null;
        int n = dimRefList.size();
        for (int i = 0; i < n; ++i) {
            m = (DimRefModel)dimRefList.get(i);
            sqls[i + 1] = "INSERT INTO T_BI_AM_DimRef(FAMID,FDimType,FDimViewID,FDimAlias) VALUES('" + famid + "','" + m.getFDimType() + "','" + m.getFDimViewID() + "','" + m.getFDimAlias() + "')";
        }
        return facade.executeBatch(sqls);
    }

    public static int[] removeAllSchemeAndDetail(IManagementFacade facade, String famid) throws SQLException {
        String[] sqls = new String[]{"delete from T_BI_AM_DR_Detail  where FSchemaID in (select FSchemaID from T_BI_AM_DR_Schema where FAMID='" + famid + "')", "delete from T_BI_AM_DR_Schema  where FAMID='" + famid + "'"};
        return facade.executeBatch(sqls);
    }

    public static ComboBoxObject getCustomDefineDimTypeAndDimId(IManagementFacade facade, String dimNumber) throws SQLException {
        ComboBoxObject result = new ComboBoxObject();
        String sql = "select FID,FName,FType,FNumber from T_BI_MM_CUSTOM where FNumber='" + dimNumber + "'";
        RDRowSet rs = facade.executeQuery(sql);
        if (rs.next()) {
            result.setInfo(rs.getString("FType"));
            result.setCode(rs.getString("FNumber"));
            result.setName(rs.getString("FName"));
        }
        return result;
    }

    public static TimeModel getTimeModel(IManagementFacade facade, String viewId, String dimId) throws SQLException {
        return TimeModel.load(facade, viewId, dimId);
    }

    public static GeneralDimensionNode getGeneralDimensionNode(IManagementFacade facade, String viewId, String dimNumber) throws BIModelRemoteException, SQLException {
        return GeneralDimensionNode.load(facade, viewId, dimNumber);
    }

    public static void saveScheme(IManagementFacade facade, GeneralSchemeModel sm) throws SQLException, IOException {
        String[] sqls = new String[]{"delete from T_BI_AM_DR_Schema where FAMID='" + sm.getFAMID() + "' and FSchemaID='" + sm.getFSchemeID() + "'", "delete from T_BI_AM_DR_Detail where FSchemaID='" + sm.getFSchemeID() + "'", "INSERT INTO T_BI_AM_DR_Schema Values('" + sm.getFAMID() + "','" + sm.getFSchemeID() + "','" + sm.getFSchemeName() + "')"};
        facade.executeBatch(sqls);
        GeneralDRDetailModel drdetail = sm.getDataRuleModel();
        GeneralDRDetailXmlModel xmlModel = drdetail.getFParameters();
        String xml = GeneralDRDetailXmlModel.toXML(xmlModel);
        String sql = "INSERT INTO T_BI_AM_DR_Detail Values(?,?,0,?)";
        Object[] objs = new Object[]{drdetail.getFSchemaID(), drdetail.getFType(), xml};
        facade.executeUpdate(sql, objs);
    }

    public static List getDBCenterList(IManagementFacade facade) throws SQLException, DBCenterException {
        return facade.getDBCenterList();
    }

    public static List getMeasureMembers(IManagementFacade facade, String measureViewId) throws SQLException {
        Vector<ComboBoxObject> result = new Vector<ComboBoxObject>();
        String sql = "select FNumber,FName from T_BI_MM_Measure where FViewID='" + measureViewId + "'";
        RDRowSet rs = facade.executeQuery(sql);
        while (rs.next()) {
            result.add(new ComboBoxObject(rs.getString("FNumber"), rs.getString("FName"), "type.measure.member."));
        }
        return result;
    }
}

