/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.general.importscheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimModel;
import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeDataProvider;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SchemeUtil {
    private static final Logger log = LogUtil.getPackageLogger(SchemeUtil.class);

    public static List getDefColumnListFromEAS(String dimNumber, IManagementFacade facade) throws BIModelRemoteException, SQLException {
        int i;
        Vector<Column> result = new Vector<Column>();
        String sql = " SELECT * FROM " + CustomDimUtil.getTableName("general", dimNumber);
        List list = facade.getColumnsFromEAS(sql);
        Map map = ((GeneralDimModel)CustomDimUtil.load("general", dimNumber, facade)).getColumnsMap();
        Column column2 = null;
        String caption = null;
        for (Column column2 : list) {
            caption = (String)map.get(column2.getName());
            if (caption == null) continue;
            column2.setCaption(caption);
            if (StringUtil.equalsIgnoreCase(column2.getName(), "FNumber") || StringUtil.equalsIgnoreCase(column2.getName(), "FParentNumber") || StringUtil.equalsIgnoreCase(column2.getName(), "FName")) {
                result.add(0, column2);
                continue;
            }
            result.add(column2);
        }
        List top3List = result.subList(0, 3);
        Column[] top3 = new Column[3];
        int n = top3List.size();
        for (i = 0; i < n; ++i) {
            column2 = (Column)top3List.get(i);
            if (StringUtil.equalsIgnoreCase(column2.getName(), "FNumber")) {
                top3[0] = column2;
                continue;
            }
            if (StringUtil.equalsIgnoreCase(column2.getName(), "FParentNumber")) {
                top3[1] = column2;
                continue;
            }
            if (!StringUtil.equalsIgnoreCase(column2.getName(), "FName")) continue;
            top3[2] = column2;
        }
        i = 3;
        while (i-- > 0) {
            result.remove(0);
        }
        for (n = top3.length - 1; n >= 0; --n) {
            result.add(0, top3[n]);
        }
        return result;
    }

    public static List getSrcColumnListFromEntity0(IManagementFacade facade, String pkName) throws BOSException, SQLException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)pkName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)facade.getContext(), (IMetaDataPK)pk);
        PropertyCollection collection = SchemeUtil.getEntityPropertyCollection(entity);
        DataTableInfo entityTable = entity.getTable();
        String sql = "select * from " + entityTable.getName();
        List list = facade.getColumnsFromEAS(sql);
        list.add(0, Column.BLANK_COLUMN);
        Map map = SchemeUtil.getSrcColumnMapFromEntity(collection);
        Column column2 = null;
        for (Column column2 : list) {
            column2.setCaption((String)map.get(column2.getName()));
        }
        return list;
    }

    public static List getSrcColumnListFromEntity(IManagementFacade facade, String pkName) throws BOSException, SQLException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)pkName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)facade.getContext(), (IMetaDataPK)pk);
        PropertyCollection collection = SchemeUtil.getEntityPropertyCollection(entity);
        IDataProvider entityExecutor = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        entityExecutor.setObjectView(SchemeDataProvider.getEntityView(collection, null, null));
        List list = null;
        String msg = null;
        String sql = null;
        try {
            sql = entityExecutor.getSQL();
        }
        catch (BOSException e) {
            msg = "\u53d6\u5c5e\u6027\u5217\u8868\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\uff1a" + pkName + "\u7684\u5b9a\u4e49\uff1a" + (Object)((Object)e);
            log.error((Object)msg, (Throwable)e);
            throw new BOSException(msg);
        }
        try {
            if (msg == null) {
                list = facade.getColumnsFromEAS(sql);
            }
        }
        catch (Exception e) {
            msg = "\u6267\u884cSQL\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\uff1a" + pkName + "\u8868\u662f\u5426\u5b58\u5728\uff1a" + e;
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg);
        }
        list.add(0, Column.BLANK_COLUMN);
        Map map = SchemeUtil.getSrcColumnMapFromEntity(collection);
        Column column2 = null;
        for (Column column2 : list) {
            column2.setCaption((String)map.get(column2.getName()));
        }
        return list;
    }

    public static Map getSrcColumnMapFromEntity(PropertyCollection collection) {
        HashMap<String, String> map = new HashMap<String, String>();
        PropertyInfo propertyInfo2 = null;
        String name = null;
        String caption = null;
        for (PropertyInfo propertyInfo2 : collection) {
            name = propertyInfo2.getName();
            caption = propertyInfo2.getAlias();
            map.put(name.toUpperCase(), caption);
        }
        return map;
    }

    public static List getSrcColumnList(PropertyCollection collection) {
        Vector<Column> srcColumnList = new Vector<Column>();
        srcColumnList.add(Column.BLANK_COLUMN);
        PropertyInfo propertyInfo = null;
        Column srcColumn = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            srcColumn = new Column();
            propertyInfo = (PropertyInfo)it.next();
            srcColumn.setName(propertyInfo.getName());
            srcColumn.setCaption(propertyInfo.getAlias());
            ColumnInfo columnInfo = propertyInfo.getMappingField();
            if (propertyInfo.getName().equalsIgnoreCase("createTime")) {
                System.out.print("");
            }
            if (propertyInfo.getName().equalsIgnoreCase("creator")) {
                System.out.print("");
            }
            String type = propertyInfo.getString("dataType");
            int length = propertyInfo.getInt("length");
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)propertyInfo;
                type = SchemeUtil.getPropertyType(ownProp);
                length = propertyInfo.getInt("length");
                if (length == 0 && columnInfo != null) {
                    length = columnInfo.getLength();
                }
            } else {
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)propertyInfo;
                RelationshipInfo relation = lnkProp.getRelationship();
                EntityObjectInfo obj = relation.getSupplierObject();
                PropertyInfo otherProp = relation.getClientProperty();
                ColumnInfo otherColumnInfo = otherProp.getMappingField();
                if (otherColumnInfo != null) {
                    type = otherColumnInfo.getTypeName() == null ? SQLType.VARCHAR.toString() : otherColumnInfo.getTypeName().toString();
                    length = otherColumnInfo.getLength() == 0 ? otherProp.getInt("length") : otherColumnInfo.getLength();
                } else if (otherProp instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)otherProp;
                    type = SchemeUtil.getPropertyType(ownProp);
                    length = otherProp.getInt("length");
                }
            }
            srcColumn.setLength(length);
            srcColumn.setType(type);
            srcColumnList.add(srcColumn);
        }
        return srcColumnList;
    }

    private static String getPropertyType(OwnPropertyInfo prop) {
        SQLType sqlType = SQLType.NVARCHAR;
        DataType dataType = prop.getDataType();
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            sqlType = SQLType.INT;
        } else if (dataType.equals((Object)DataType.BOSUUID)) {
            sqlType = SQLType.VARCHAR;
        } else if (dataType.equals((Object)DataType.BYTE)) {
            sqlType = SQLType.BINARY;
        } else if (dataType.equals((Object)DataType.CHAR)) {
            sqlType = prop.isMultilingual() ? SQLType.NCHAR : SQLType.CHAR;
        } else if (dataType.equals((Object)DataType.DATE)) {
            sqlType = SQLType.DATETIME;
        } else if (dataType.equals((Object)DataType.DECIMAL)) {
            sqlType = SQLType.NUMERIC;
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            sqlType = SQLType.NUMERIC;
        } else if (dataType.equals((Object)DataType.ENUM)) {
            if (prop.getEnumType() == null) {
                sqlType = SQLType.VARCHAR;
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.STRING)) {
                sqlType = SQLType.VARCHAR;
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.DOUBLE) || prop.getEnumType().getDataType().equals((Object)BizEnumValueType.FLOAT)) {
                sqlType = SQLType.NUMERIC;
            } else if (prop.getEnumType().getDataType().equals((Object)BizEnumValueType.INTEGER) || prop.getEnumType().getDataType().equals((Object)BizEnumValueType.LONG)) {
                sqlType = SQLType.INT;
            }
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            sqlType = SQLType.NUMERIC;
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            sqlType = SQLType.INT;
        } else if (dataType.equals((Object)DataType.LONG)) {
            sqlType = SQLType.INT;
        } else if (dataType.equals((Object)DataType.SHORT)) {
            sqlType = SQLType.INT;
        } else if (dataType.equals((Object)DataType.STRING)) {
            sqlType = prop.isMultilingual() ? SQLType.NVARCHAR : SQLType.NVARCHAR;
        } else if (dataType.equals((Object)DataType.TIME)) {
            sqlType = SQLType.DATETIME;
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            sqlType = SQLType.DATETIME;
        } else if (dataType.equals((Object)DataType.UUID)) {
            sqlType = SQLType.CHAR;
        } else if (dataType.equals((Object)DataType.BYTEARRAY)) {
            sqlType = prop.isMultilingual() ? SQLType.NCLOB : SQLType.CLOB;
        }
        return sqlType.getName();
    }

    public static PropertyCollection getEntityPropertyCollection(EntityObjectInfo entityObjectInfo) {
        return entityObjectInfo.getInheritedNoDuplicatedPropertiesRuntime();
    }

    private static void doEntityPropertyCollection(EntityObjectInfo baseEntityObjectInfo, PropertyCollection collection) {
        if (baseEntityObjectInfo == null) {
            return;
        }
        SchemeUtil.doEntityPropertyCollection(baseEntityObjectInfo.getBaseEntity(), collection);
        PropertyCollection collection2 = baseEntityObjectInfo.getProperties();
        Iterator it = collection2.iterator();
        while (it.hasNext()) {
            collection.add((PropertyInfo)it.next());
        }
    }

    public static List getSrcColumnListFromDBTableName(IManagementFacade facade, String dbCenterId, String tableName) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ").append(tableName);
        return facade.getColumnsFromDBCenter(dbCenterId, sb.toString());
    }

    public static List getSrcColumnListFromSQL(IManagementFacade facade, String dbCenterId, String sql) throws SQLException {
        return facade.getColumnsFromDBCenter(dbCenterId, sql);
    }

    public static List getSrcColumnListFromQuery0(IManagementFacade facade, String pkName) throws BOSException, SQLException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)pkName);
        IQueryExecutor exec = SchemeDataProvider.getQueryExecutor(pk);
        QueryInfo query = MetaDataLoader.getQuery((Context)facade.getContext(), (IMetaDataPK)pk);
        List list = facade.getColumnsFromEAS(exec.getSQL());
        list.add(0, Column.BLANK_COLUMN);
        Map map = SchemeUtil.getSrcColumnMapFromQuery(query.getUnits());
        Column column2 = null;
        for (Column column2 : list) {
            column2.setCaption((String)map.get(column2.getName()));
        }
        return list;
    }

    public static List getSrcColumnListFromQuery(IManagementFacade facade, String pkName) throws BOSException, SQLException {
        QueryInfo query = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK(pkName));
        List list = facade.getColumnsFromEAS(facade.getQueryMetaDataSQL(pkName));
        list.add(0, Column.BLANK_COLUMN);
        Map map = SchemeUtil.getSrcColumnMapFromQuery(query.getUnits());
        Column column2 = null;
        for (Column column2 : list) {
            column2.setCaption((String)map.get(column2.getName()));
        }
        return list;
    }

    private static Map getSrcColumnMapFromQuery(PropertyUnitCollection propertyCollection) {
        HashMap<String, String> map = new HashMap<String, String>();
        PropertyUnitInfo property2 = null;
        String name = null;
        String caption = null;
        for (PropertyUnitInfo property2 : propertyCollection) {
            if (!property2.getBoolean("isSelector")) continue;
            name = property2.getName();
            caption = property2.getDisplayName();
            map.put(name.toUpperCase(), caption);
        }
        return map;
    }

    public static List getSrcColumnList(PropertyUnitCollection propertyUnitCollection) {
        Vector<Column> srcColumnList = new Vector<Column>();
        srcColumnList.add(Column.BLANK_COLUMN);
        PropertyUnitInfo info = null;
        Column srcColumn = null;
        int n = propertyUnitCollection.size();
        for (int i = 0; i < n; ++i) {
            info = propertyUnitCollection.get(i);
            if (!info.getBoolean("isSelector")) continue;
            srcColumn = new Column();
            srcColumn.setName(info.getName());
            srcColumn.setCaption(info.getDisplayName());
            int length = 0;
            PropertyRefCollection refCollection = info.getPropertyRefs();
            PropertyRefInfo refInfo2 = null;
            for (PropertyRefInfo refInfo2 : refCollection) {
            }
            try {
                srcColumn.setType(info.getReturnType().getName());
                srcColumn.setLength(length);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            srcColumnList.add(srcColumn);
        }
        return srcColumnList;
    }

    public static boolean isRequiredField(String field) {
        if (StringUtil.isEmpty(field)) {
            return false;
        }
        return StringUtil.equalsIgnoreCase(field, "FNumber") || StringUtil.equalsIgnoreCase(field, "FName") || StringUtil.equalsIgnoreCase(field, "FOriginalId");
    }

    public static String objectToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return TimeUtil.getTime((Date)obj);
        }
        return obj.toString();
    }
}

